/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.objectstorage.model.StorageTier;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MultipartUpload
extends ExplicitlySetBmcModel {
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="bucket")
    private final String bucket;
    @JsonProperty(value="object")
    private final String object;
    @JsonProperty(value="uploadId")
    private final String uploadId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="storageTier")
    private final StorageTier storageTier;

    @Deprecated
    @ConstructorProperties(value={"namespace", "bucket", "object", "uploadId", "timeCreated", "storageTier"})
    public MultipartUpload(String namespace, String bucket, String object, String uploadId, Date timeCreated, StorageTier storageTier) {
        this.namespace = namespace;
        this.bucket = bucket;
        this.object = object;
        this.uploadId = uploadId;
        this.timeCreated = timeCreated;
        this.storageTier = storageTier;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getObject() {
        return this.object;
    }

    public String getUploadId() {
        return this.uploadId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public StorageTier getStorageTier() {
        return this.storageTier;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MultipartUpload(");
        sb.append("super=").append(super.toString());
        sb.append("namespace=").append(String.valueOf(this.namespace));
        sb.append(", bucket=").append(String.valueOf(this.bucket));
        sb.append(", object=").append(String.valueOf(this.object));
        sb.append(", uploadId=").append(String.valueOf(this.uploadId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", storageTier=").append(String.valueOf((Object)this.storageTier));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MultipartUpload)) {
            return false;
        }
        MultipartUpload other = (MultipartUpload)((Object)o);
        return Objects.equals(this.namespace, other.namespace) && Objects.equals(this.bucket, other.bucket) && Objects.equals(this.object, other.object) && Objects.equals(this.uploadId, other.uploadId) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.storageTier, (Object)other.storageTier) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.bucket == null ? 43 : this.bucket.hashCode());
        result = result * 59 + (this.object == null ? 43 : this.object.hashCode());
        result = result * 59 + (this.uploadId == null ? 43 : this.uploadId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.storageTier == null ? 43 : this.storageTier.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="bucket")
        private String bucket;
        @JsonProperty(value="object")
        private String object;
        @JsonProperty(value="uploadId")
        private String uploadId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="storageTier")
        private StorageTier storageTier;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder bucket(String bucket) {
            this.bucket = bucket;
            this.__explicitlySet__.add("bucket");
            return this;
        }

        public Builder object(String object) {
            this.object = object;
            this.__explicitlySet__.add("object");
            return this;
        }

        public Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            this.__explicitlySet__.add("uploadId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder storageTier(StorageTier storageTier) {
            this.storageTier = storageTier;
            this.__explicitlySet__.add("storageTier");
            return this;
        }

        public MultipartUpload build() {
            MultipartUpload model = new MultipartUpload(this.namespace, this.bucket, this.object, this.uploadId, this.timeCreated, this.storageTier);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MultipartUpload model) {
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("bucket")) {
                this.bucket(model.getBucket());
            }
            if (model.wasPropertyExplicitlySet("object")) {
                this.object(model.getObject());
            }
            if (model.wasPropertyExplicitlySet("uploadId")) {
                this.uploadId(model.getUploadId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("storageTier")) {
                this.storageTier(model.getStorageTier());
            }
            return this;
        }
    }
}

