/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class KubernetesNetworkConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="podsCidr")
    private final String podsCidr;
    @JsonProperty(value="servicesCidr")
    private final String servicesCidr;

    @Deprecated
    @ConstructorProperties(value={"podsCidr", "servicesCidr"})
    public KubernetesNetworkConfig(String podsCidr, String servicesCidr) {
        this.podsCidr = podsCidr;
        this.servicesCidr = servicesCidr;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPodsCidr() {
        return this.podsCidr;
    }

    public String getServicesCidr() {
        return this.servicesCidr;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("KubernetesNetworkConfig(");
        sb.append("super=").append(super.toString());
        sb.append("podsCidr=").append(String.valueOf(this.podsCidr));
        sb.append(", servicesCidr=").append(String.valueOf(this.servicesCidr));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KubernetesNetworkConfig)) {
            return false;
        }
        KubernetesNetworkConfig other = (KubernetesNetworkConfig)((Object)o);
        return Objects.equals(this.podsCidr, other.podsCidr) && Objects.equals(this.servicesCidr, other.servicesCidr) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.podsCidr == null ? 43 : this.podsCidr.hashCode());
        result = result * 59 + (this.servicesCidr == null ? 43 : this.servicesCidr.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="podsCidr")
        private String podsCidr;
        @JsonProperty(value="servicesCidr")
        private String servicesCidr;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder podsCidr(String podsCidr) {
            this.podsCidr = podsCidr;
            this.__explicitlySet__.add("podsCidr");
            return this;
        }

        public Builder servicesCidr(String servicesCidr) {
            this.servicesCidr = servicesCidr;
            this.__explicitlySet__.add("servicesCidr");
            return this;
        }

        public KubernetesNetworkConfig build() {
            KubernetesNetworkConfig model = new KubernetesNetworkConfig(this.podsCidr, this.servicesCidr);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(KubernetesNetworkConfig model) {
            if (model.wasPropertyExplicitlySet("podsCidr")) {
                this.podsCidr(model.getPodsCidr());
            }
            if (model.wasPropertyExplicitlySet("servicesCidr")) {
                this.servicesCidr(model.getServicesCidr());
            }
            return this;
        }
    }
}

