/*
 * Decompiled with CFR 0.152.
 */
package jakarta.faces.view;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIImportConstants;
import jakarta.faces.component.UIViewAction;
import jakarta.faces.component.UIViewParameter;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ViewMetadata {
    public abstract String getViewId();

    public abstract UIViewRoot createMetadataView(FacesContext var1);

    public static Collection<UIViewParameter> getViewParameters(UIViewRoot root) {
        return ViewMetadata.getMetadataChildren(root, UIViewParameter.class);
    }

    public static Collection<UIViewAction> getViewActions(UIViewRoot root) {
        return ViewMetadata.getMetadataChildren(root, UIViewAction.class);
    }

    public static Collection<UIImportConstants> getImportConstants(UIViewRoot root) {
        return ViewMetadata.getMetadataChildren(root, UIImportConstants.class);
    }

    public static boolean hasMetadata(UIViewRoot root) {
        return ViewMetadata.getMetadataFacet(root).map(m -> m.getChildCount() > 0).orElse(false);
    }

    private static <C extends UIComponent> List<C> getMetadataChildren(UIViewRoot root, Class<C> type) {
        return ViewMetadata.getMetadataFacet(root).map(m -> m.getChildren()).orElseGet(Collections::emptyList).stream().filter(c -> type.isInstance(c)).collect(Collectors.toList());
    }

    private static Optional<UIComponent> getMetadataFacet(UIViewRoot root) {
        return Optional.ofNullable(root.getFacet("jakarta_faces_metadata"));
    }
}

