/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.graph;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JScrollPane;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.java.graph.DependencyGraphScene;
import org.netbeans.modules.java.graph.EdgeWidget;
import org.netbeans.modules.java.graph.GraphEdge;
import org.netbeans.modules.java.graph.GraphNode;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.java.graph.NodeWidget;

class FruchtermanReingoldLayout<I extends GraphNodeImplementation>
extends SceneLayout {
    private double forceConstant;
    private double temp;
    private int iterations = 700;
    private final int magicSizeMultiplier = 10;
    private final int magicSizeConstant = 200;
    private Rectangle bounds;
    protected int m_fidx;
    private static final double MIN = 1.0E-6;
    private static final double ALPHA = 0.1;
    private DependencyGraphScene<I> scene;
    private JScrollPane panel;

    FruchtermanReingoldLayout(DependencyGraphScene<I> scene, JScrollPane panel) {
        super(scene);
        this.scene = scene;
        this.init();
        this.panel = panel;
    }

    public void performLayout() {
        this.performLayout(true);
    }

    private void performLayout(boolean finish) {
        for (int i = 0; i < this.iterations; ++i) {
            int repeats = 0;
            while (true) {
                NodeWidget w;
                for (GraphNode n : this.scene.getNodes()) {
                    w = this.getWidget(n);
                    if (w.isFixed()) continue;
                    this.calcRepulsion(w);
                }
                for (GraphEdge e : this.scene.getEdges()) {
                    this.calcAttraction(e);
                }
                for (GraphNode n : this.scene.getNodes()) {
                    w = this.getWidget(n);
                    if (w.isFixed()) continue;
                    this.calcPositions(w);
                }
                if (this.areAllFixed() || repeats > 2) break;
                ++repeats;
            }
            this.doRelayoutNonFixed();
            this.resetFixed();
            this.cool(i);
        }
        if (finish) {
            this.finish();
        }
    }

    public void rePerformLayout(int iters) {
        int nds = this.scene.getNodes().size();
        this.iterations = iters;
        this.bounds = this.scene.getBounds();
        if (this.bounds == null) {
            return;
        }
        this.temp = this.bounds.getWidth() / 1000.0;
        this.forceConstant = 1.75 * Math.sqrt(this.bounds.getHeight() * this.bounds.getWidth() / (double)nds);
        this.performLayout(false);
    }

    private void init() {
        int nds = this.scene.getNodes().size();
        this.bounds = new Rectangle(200 + 10 * nds, 200 + 10 * nds);
        this.temp = this.bounds.getWidth() / 10.0;
        this.forceConstant = 1.75 * Math.sqrt(this.bounds.getHeight() * this.bounds.getWidth() / (double)nds);
        GraphNode<I> rn = this.scene.getRootGraphNode();
        NodeWidget rw = this.getWidget(rn);
        rw.locX = this.bounds.getCenterX();
        rw.locY = this.bounds.getCenterY();
        rw.setFixed(true);
        this.layoutCirculary(this.scene.getNodes(), rn);
    }

    private void finish() {
        for (GraphNode n : this.scene.getNodes()) {
            NodeWidget w = this.getWidget(n);
            Widget wid = this.scene.findWidget(n);
            Point point = new Point();
            point.setLocation(w.locX, w.locY);
            if (this.scene.isAnimated()) {
                this.scene.getSceneAnimator().animatePreferredLocation(wid, point);
                continue;
            }
            wid.setPreferredLocation(point);
        }
    }

    private void calcPositions(NodeWidget w) {
        double deltaLength = Math.max(1.0E-6, Math.sqrt(w.dispX * w.dispX + w.dispY * w.dispY));
        double xDisp = w.dispX / deltaLength * Math.min(deltaLength, this.temp);
        double yDisp = w.dispY / deltaLength * Math.min(deltaLength, this.temp);
        w.locX += xDisp;
        w.locY += yDisp;
        if (this.isThereFreeSpaceNonFixedSpace(w)) {
            w.setFixed(true);
        }
    }

    public void calcAttraction(GraphEdge e) {
        NodeWidget w1 = this.getWidget((GraphNode)this.scene.getEdgeSource(e));
        NodeWidget w2 = this.getWidget((GraphNode)this.scene.getEdgeTarget(e));
        assert (w1 != null && w2 != null) : "wrong edge=" + e;
        double xDelta = w1.locX - w2.locX;
        double yDelta = w1.locX - w2.locY;
        double deltaLength = Math.max(1.0E-6, Math.sqrt(xDelta * xDelta + yDelta * yDelta));
        double force = deltaLength * deltaLength / this.forceConstant;
        double xDisp = xDelta / deltaLength * force;
        double yDisp = yDelta / deltaLength * force;
        w1.dispX -= xDisp;
        w1.dispY -= yDisp;
        w2.dispX += xDisp;
        w2.dispY += yDisp;
    }

    public void calcRepulsion(NodeWidget w1) {
        w1.dispX = 0.0;
        w1.dispY = 0.0;
        for (GraphNode n2 : this.scene.getNodes()) {
            NodeWidget w2 = this.getWidget(n2);
            if (w1 == w2) continue;
            double xDelta = w1.locX - w2.locX;
            double yDelta = w1.locY - w2.locY;
            double deltaLength = Math.max(1.0E-6, Math.sqrt(xDelta * xDelta + yDelta * yDelta));
            double force = this.forceConstant * this.forceConstant / deltaLength;
            w1.dispX += xDelta / deltaLength * force;
            w1.dispY += yDelta / deltaLength * force;
        }
    }

    private void cool(int iter) {
        this.temp *= 1.0 - (double)iter / (double)this.iterations;
    }

    private void layoutCirculary(Collection<GraphNode<I>> nodes, GraphNode<I> masterNode) {
        Point masterPoint = new Point();
        NodeWidget master = this.getWidget(masterNode);
        masterPoint.setLocation(master.locX, master.locY);
        double thetaStep = 0.6283185307179586;
        double r = 150.0;
        double theta = 0.0;
        Iterator<GraphNode<I>> it = nodes.iterator();
        NodeWidget nw = this.getWidget(it.next());
        while (true) {
            AffineTransform tr;
            Point2D d2point;
            Point point;
            if (this.isThereFreeSpace(point = new Point((int)(d2point = (tr = AffineTransform.getRotateInstance(theta)).transform(new Point2D.Double(0.0, r), null)).getX() + masterPoint.x, (int)d2point.getY() + masterPoint.y), nw)) {
                nw.locX = point.getX();
                nw.locY = point.getY();
                nw.dispX = 0.0;
                nw.dispY = 0.0;
                if (it.hasNext()) {
                    nw = this.getWidget(it.next());
                } else {
                    return;
                }
            }
            if (!((theta += thetaStep) > 5.969026041820607)) continue;
            r += 90.0;
            theta -= Math.PI * 2;
            thetaStep = thetaStep * 3.0 / 4.0;
        }
    }

    private boolean isThereFreeSpace(Point pnt, NodeWidget widget) {
        if (this.scene != null && widget != null) {
            Rectangle bnds = widget.getBounds();
            if (bnds == null) {
                return true;
            }
            bnds = new Rectangle(pnt.x, pnt.y, bnds.width, bnds.height);
            for (GraphNode nd : this.scene.getNodes()) {
                NodeWidget nw = this.getWidget(nd);
                Rectangle bnds2 = nw.getBounds();
                if (bnds2 == null) {
                    return true;
                }
                Point point = new Point();
                point.setLocation(nw.locX, nw.locY);
                if (!bnds.intersects(bnds2 = new Rectangle(point, bnds2.getSize()))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areAllFixed() {
        for (GraphNode nd : this.scene.getNodes()) {
            if (this.getWidget(nd).isFixed()) continue;
            return false;
        }
        return true;
    }

    private void resetFixed() {
        for (GraphNode nd : this.scene.getNodes()) {
            this.getWidget(nd).setFixed(false);
        }
        this.getWidget(this.scene.getRootGraphNode()).setFixed(true);
    }

    private boolean isThereFreeSpaceNonFixedSpace(NodeWidget w) {
        Rectangle bnds = w.getBounds();
        if (bnds == null) {
            return true;
        }
        Point pnt = new Point();
        pnt.setLocation(w.locX, w.locY);
        bnds = new Rectangle(pnt, bnds.getSize());
        for (GraphNode nd : this.scene.getNodes()) {
            NodeWidget nw = this.getWidget(nd);
            Rectangle bnds2 = this.scene.findWidget(nd).getBounds();
            if (bnds2 == null) {
                return true;
            }
            Point point = new Point();
            point.setLocation(nw.locX, nw.locY);
            bnds2 = new Rectangle(point, bnds2.getSize());
            if (!nw.isFixed() || !bnds.intersects(bnds2)) continue;
            return false;
        }
        return true;
    }

    private void doRelayoutNonFixed() {
        for (GraphNode node : this.scene.getNodes()) {
            NodeWidget w = this.getWidget(node);
            if (w.isFixed()) continue;
            this.relayoutNonFixed(w);
        }
    }

    private void relayoutNonFixed(NodeWidget w) {
        Point masterPoint = new Point();
        masterPoint.setLocation(w.locX, w.locY);
        double thetaStep = 0.6283185307179586;
        double r = 30.0;
        double theta = 0.0;
        w.setFixed(false);
        for (int i = 0; i < 48; ++i) {
            AffineTransform tr = AffineTransform.getRotateInstance(theta);
            Point2D d2point = tr.transform(new Point2D.Double(0.0, r), null);
            Point point = new Point((int)d2point.getX() + masterPoint.x, (int)d2point.getY() + masterPoint.y);
            w.locX = point.getX();
            w.locY = point.getY();
            if (this.isThereFreeSpaceNonFixedSpace(w)) {
                w.setFixed(true);
                return;
            }
            if (!((theta += thetaStep) > 5.969026041820607)) continue;
            r += 30.0;
            theta -= Math.PI * 2;
            thetaStep = thetaStep * 3.0 / 4.0;
        }
    }

    private NodeWidget getWidget(GraphNode n) {
        return (NodeWidget)this.scene.findWidget(n);
    }

    private EdgeWidget getWidget(GraphEdge e) {
        return (EdgeWidget)this.scene.findWidget(e);
    }
}

