/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.netbeans.validation.localization.LocalizationSupport;

final class DisallowCharactersValidator
extends StringValidator {
    private char[] chars;

    public DisallowCharactersValidator(char[] chars) {
        this.chars = new char[chars.length];
        System.arraycopy(chars, 0, this.chars, 0, chars.length);
    }

    private String asString() {
        return "'" + new String(this.chars) + "' ";
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        for (char c : this.chars) {
            for (char cc : model.toCharArray()) {
                if (cc != c) continue;
                problems.append(LocalizationSupport.getMessage(DisallowCharactersValidator.class, "DISALLOWED_CHARS", this.asString(), compName));
                return;
            }
        }
    }
}

