/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.jvm.PoolConstant;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class TreeDiffer
extends TreeScanner {
    private JCTree parameter;
    private boolean result;
    private Map<Symbol, Symbol> equiv = new HashMap<Symbol, Symbol>();
    final Types types;

    public TreeDiffer(Types types, Collection<? extends Symbol> symbols, Collection<? extends Symbol> otherSymbols) {
        this.equiv = TreeDiffer.equiv(symbols, otherSymbols);
        this.types = types;
    }

    private static Map<Symbol, Symbol> equiv(Collection<? extends Symbol> symbols, Collection<? extends Symbol> otherSymbols) {
        HashMap<Symbol, Symbol> result = new HashMap<Symbol, Symbol>();
        Iterator<? extends Symbol> it = otherSymbols.iterator();
        for (Symbol symbol : symbols) {
            if (!it.hasNext()) break;
            result.put(symbol, it.next());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scan(JCTree tree, JCTree parameter) {
        if (tree == null || parameter == null) {
            return tree == null && parameter == null;
        }
        tree = TreeInfo.skipParens(tree);
        parameter = TreeInfo.skipParens(parameter);
        if (tree.type != null && tree.type.constValue() != null && parameter.type != null && parameter.type.constValue() != null) {
            return Objects.equals(tree.type.constValue(), parameter.type.constValue());
        }
        if (tree.getTag() != parameter.getTag()) {
            return false;
        }
        JCTree prevParameter = this.parameter;
        boolean prevResult = this.result;
        try {
            this.parameter = parameter;
            tree.accept(this);
            boolean bl = this.result;
            return bl;
        }
        finally {
            this.parameter = prevParameter;
            this.result = prevResult;
        }
    }

    private boolean scan(Iterable<? extends JCTree> xs, Iterable<? extends JCTree> ys) {
        if (xs == null || ys == null) {
            return xs == null && ys == null;
        }
        Iterator<? extends JCTree> x = xs.iterator();
        Iterator<? extends JCTree> y = ys.iterator();
        while (x.hasNext() && y.hasNext()) {
            if (this.scan(x.next(), y.next())) continue;
            return false;
        }
        return !x.hasNext() && !y.hasNext();
    }

    private boolean scanDimAnnotations(List<List<JCTree.JCAnnotation>> xs, List<List<JCTree.JCAnnotation>> ys) {
        if (xs == null || ys == null) {
            return xs == null && ys == null;
        }
        Iterator<List<JCTree.JCAnnotation>> x = xs.iterator();
        Iterator<List<JCTree.JCAnnotation>> y = ys.iterator();
        while (x.hasNext() && y.hasNext()) {
            if (this.scan((Iterable<? extends JCTree>)x.next(), (Iterable<? extends JCTree>)y.next())) continue;
            return false;
        }
        return !x.hasNext() && !y.hasNext();
    }

    @Override
    public void visitIdent(JCTree.JCIdent tree) {
        JCTree.JCIdent that = (JCTree.JCIdent)this.parameter;
        Symbol symbol = tree.sym;
        Symbol otherSymbol = that.sym;
        if (symbol != null && otherSymbol != null && Objects.equals(this.equiv.get(symbol), otherSymbol)) {
            this.result = true;
            return;
        }
        this.result = this.scanSymbol(symbol, otherSymbol);
    }

    private boolean scanSymbol(Symbol symbol, Symbol otherSymbol) {
        if (symbol instanceof PoolConstant.Dynamic) {
            PoolConstant.Dynamic dms = (PoolConstant.Dynamic)((Object)symbol);
            if (otherSymbol instanceof PoolConstant.Dynamic) {
                PoolConstant.Dynamic other_dms = (PoolConstant.Dynamic)((Object)otherSymbol);
                return dms.bsmKey(this.types).equals(other_dms.bsmKey(this.types));
            }
        }
        return symbol == otherSymbol;
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess tree) {
        JCTree.JCFieldAccess that = (JCTree.JCFieldAccess)this.parameter;
        this.result = this.scan(tree.selected, that.selected) && this.scanSymbol(tree.sym, that.sym);
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType tree) {
        JCTree.JCAnnotatedType that = (JCTree.JCAnnotatedType)this.parameter;
        this.result = this.scan(tree.annotations, that.annotations) && this.scan(tree.underlyingType, that.underlyingType);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation tree) {
        JCTree.JCAnnotation that = (JCTree.JCAnnotation)this.parameter;
        this.result = this.scan(tree.annotationType, that.annotationType) && this.scan(tree.args, that.args);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation tree) {
        JCTree.JCMethodInvocation that = (JCTree.JCMethodInvocation)this.parameter;
        this.result = this.scan(tree.typeargs, that.typeargs) && this.scan(tree.meth, that.meth) && this.scan(tree.args, that.args) && tree.polyKind == that.polyKind;
    }

    @Override
    public void visitAssert(JCTree.JCAssert tree) {
        JCTree.JCAssert that = (JCTree.JCAssert)this.parameter;
        this.result = this.scan(tree.cond, that.cond) && this.scan(tree.detail, that.detail);
    }

    @Override
    public void visitAssign(JCTree.JCAssign tree) {
        JCTree.JCAssign that = (JCTree.JCAssign)this.parameter;
        this.result = this.scan(tree.lhs, that.lhs) && this.scan(tree.rhs, that.rhs);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp tree) {
        JCTree.JCAssignOp that = (JCTree.JCAssignOp)this.parameter;
        this.result = this.scan(tree.lhs, that.lhs) && this.scan(tree.rhs, that.rhs) && tree.operator == that.operator;
    }

    @Override
    public void visitBinary(JCTree.JCBinary tree) {
        JCTree.JCBinary that = (JCTree.JCBinary)this.parameter;
        this.result = this.scan(tree.lhs, that.lhs) && this.scan(tree.rhs, that.rhs) && tree.operator == that.operator;
    }

    @Override
    public void visitBindingPattern(JCTree.JCBindingPattern tree) {
        JCTree.JCBindingPattern that = (JCTree.JCBindingPattern)this.parameter;
        this.result = this.scan(tree.var, that.var);
        if (!this.result) {
            return;
        }
    }

    @Override
    public void visitRecordPattern(JCTree.JCRecordPattern tree) {
        JCTree.JCRecordPattern that = (JCTree.JCRecordPattern)this.parameter;
        this.result = this.scan(tree.deconstructor, that.deconstructor) && this.scan(tree.nested, that.nested);
    }

    @Override
    public void visitBlock(JCTree.JCBlock tree) {
        JCTree.JCBlock that = (JCTree.JCBlock)this.parameter;
        this.result = tree.flags == that.flags && this.scan(tree.stats, that.stats);
    }

    @Override
    public void visitBreak(JCTree.JCBreak tree) {
        JCTree.JCBreak that = (JCTree.JCBreak)this.parameter;
        this.result = tree.label == that.label;
    }

    @Override
    public void visitYield(JCTree.JCYield tree) {
        JCTree.JCYield that = (JCTree.JCYield)this.parameter;
        this.result = this.scan(tree.value, that.value);
    }

    @Override
    public void visitCase(JCTree.JCCase tree) {
        JCTree.JCCase that = (JCTree.JCCase)this.parameter;
        this.result = this.scan(tree.labels, that.labels) && this.scan(tree.guard, that.guard) && this.scan(tree.stats, that.stats);
    }

    @Override
    public void visitConstantCaseLabel(JCTree.JCConstantCaseLabel tree) {
        JCTree.JCConstantCaseLabel that = (JCTree.JCConstantCaseLabel)this.parameter;
        this.result = this.scan(tree.expr, that.expr);
    }

    @Override
    public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel tree) {
        JCTree.JCPatternCaseLabel that = (JCTree.JCPatternCaseLabel)this.parameter;
        this.result = this.scan(tree.pat, that.pat);
    }

    @Override
    public void visitDefaultCaseLabel(JCTree.JCDefaultCaseLabel tree) {
        this.result = true;
    }

    @Override
    public void visitCatch(JCTree.JCCatch tree) {
        JCTree.JCCatch that = (JCTree.JCCatch)this.parameter;
        this.result = this.scan(tree.param, that.param) && this.scan(tree.body, that.body);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl tree) {
        this.result = false;
    }

    @Override
    public void visitConditional(JCTree.JCConditional tree) {
        JCTree.JCConditional that = (JCTree.JCConditional)this.parameter;
        this.result = this.scan(tree.cond, that.cond) && this.scan(tree.truepart, that.truepart) && this.scan(tree.falsepart, that.falsepart);
    }

    @Override
    public void visitContinue(JCTree.JCContinue tree) {
        JCTree.JCContinue that = (JCTree.JCContinue)this.parameter;
        this.result = tree.label == that.label;
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop tree) {
        JCTree.JCDoWhileLoop that = (JCTree.JCDoWhileLoop)this.parameter;
        this.result = this.scan(tree.body, that.body) && this.scan(tree.cond, that.cond);
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous tree) {
        JCTree.JCErroneous that = (JCTree.JCErroneous)this.parameter;
        this.result = this.scan(tree.errs, that.errs);
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement tree) {
        JCTree.JCExpressionStatement that = (JCTree.JCExpressionStatement)this.parameter;
        this.result = this.scan(tree.expr, that.expr);
    }

    @Override
    public void visitExports(JCTree.JCExports tree) {
        JCTree.JCExports that = (JCTree.JCExports)this.parameter;
        this.result = this.scan(tree.qualid, that.qualid) && this.scan(tree.moduleNames, that.moduleNames);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop tree) {
        JCTree.JCForLoop that = (JCTree.JCForLoop)this.parameter;
        this.result = this.scan(tree.init, that.init) && this.scan(tree.cond, that.cond) && this.scan(tree.step, that.step) && this.scan(tree.body, that.body);
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop tree) {
        JCTree.JCEnhancedForLoop that = (JCTree.JCEnhancedForLoop)this.parameter;
        this.result = this.scan(tree.var, that.var) && this.scan(tree.expr, that.expr) && this.scan(tree.body, that.body);
    }

    @Override
    public void visitIf(JCTree.JCIf tree) {
        JCTree.JCIf that = (JCTree.JCIf)this.parameter;
        this.result = this.scan(tree.cond, that.cond) && this.scan(tree.thenpart, that.thenpart) && this.scan(tree.elsepart, that.elsepart);
    }

    @Override
    public void visitImport(JCTree.JCImport tree) {
        JCTree.JCImport that = (JCTree.JCImport)this.parameter;
        this.result = tree.staticImport == that.staticImport && this.scan(tree.qualid, that.qualid);
    }

    @Override
    public void visitModuleImport(JCTree.JCModuleImport tree) {
        JCTree.JCModuleImport that = (JCTree.JCModuleImport)this.parameter;
        this.result = this.scan(tree.module, that.module);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess tree) {
        JCTree.JCArrayAccess that = (JCTree.JCArrayAccess)this.parameter;
        this.result = this.scan(tree.indexed, that.indexed) && this.scan(tree.index, that.index);
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement tree) {
        JCTree.JCLabeledStatement that = (JCTree.JCLabeledStatement)this.parameter;
        this.result = tree.label == that.label && this.scan(tree.body, that.body);
    }

    @Override
    public void visitLambda(JCTree.JCLambda tree) {
        JCTree.JCLambda that = (JCTree.JCLambda)this.parameter;
        this.result = this.scan(tree.params, that.params) && this.scan(tree.body, that.body) && tree.paramKind == that.paramKind;
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr tree) {
        JCTree.LetExpr that = (JCTree.LetExpr)this.parameter;
        this.result = this.scan(tree.defs, that.defs) && this.scan(tree.expr, that.expr);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral tree) {
        JCTree.JCLiteral that = (JCTree.JCLiteral)this.parameter;
        this.result = tree.typetag == that.typetag && Objects.equals(tree.value, that.value);
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl tree) {
        JCTree.JCMethodDecl that = (JCTree.JCMethodDecl)this.parameter;
        this.result = this.scan(tree.mods, that.mods) && tree.name == that.name && this.scan(tree.restype, that.restype) && this.scan(tree.typarams, that.typarams) && this.scan(tree.recvparam, that.recvparam) && this.scan(tree.params, that.params) && this.scan(tree.thrown, that.thrown) && this.scan(tree.body, that.body) && this.scan(tree.defaultValue, that.defaultValue);
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers tree) {
        JCTree.JCModifiers that = (JCTree.JCModifiers)this.parameter;
        this.result = tree.flags == that.flags && this.scan(tree.annotations, that.annotations);
    }

    @Override
    public void visitModuleDef(JCTree.JCModuleDecl tree) {
        JCTree.JCModuleDecl that = (JCTree.JCModuleDecl)this.parameter;
        this.result = this.scan(tree.mods, that.mods) && this.scan(tree.qualId, that.qualId) && this.scan(tree.directives, that.directives);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray tree) {
        JCTree.JCNewArray that = (JCTree.JCNewArray)this.parameter;
        this.result = this.scan(tree.elemtype, that.elemtype) && this.scan(tree.dims, that.dims) && this.scan(tree.annotations, that.annotations) && this.scanDimAnnotations(tree.dimAnnotations, that.dimAnnotations) && this.scan(tree.elems, that.elems);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass tree) {
        JCTree.JCNewClass that = (JCTree.JCNewClass)this.parameter;
        this.result = this.scan(tree.encl, that.encl) && this.scan(tree.typeargs, that.typeargs) && this.scan(tree.clazz, that.clazz) && this.scan(tree.args, that.args) && this.scan(tree.def, that.def) && tree.constructor == that.constructor;
    }

    @Override
    public void visitOpens(JCTree.JCOpens tree) {
        JCTree.JCOpens that = (JCTree.JCOpens)this.parameter;
        this.result = this.scan(tree.qualid, that.qualid) && this.scan(tree.moduleNames, that.moduleNames);
    }

    @Override
    public void visitPackageDef(JCTree.JCPackageDecl tree) {
        JCTree.JCPackageDecl that = (JCTree.JCPackageDecl)this.parameter;
        this.result = this.scan(tree.annotations, that.annotations) && this.scan(tree.pid, that.pid) && tree.packge == that.packge;
    }

    @Override
    public void visitProvides(JCTree.JCProvides tree) {
        JCTree.JCProvides that = (JCTree.JCProvides)this.parameter;
        this.result = this.scan(tree.serviceName, that.serviceName) && this.scan(tree.implNames, that.implNames);
    }

    @Override
    public void visitReference(JCTree.JCMemberReference tree) {
        JCTree.JCMemberReference that = (JCTree.JCMemberReference)this.parameter;
        this.result = tree.mode == that.mode && tree.kind == that.kind && tree.name == that.name && this.scan(tree.expr, that.expr) && this.scan(tree.typeargs, that.typeargs);
    }

    @Override
    public void visitRequires(JCTree.JCRequires tree) {
        JCTree.JCRequires that = (JCTree.JCRequires)this.parameter;
        this.result = tree.isTransitive == that.isTransitive && tree.isStaticPhase == that.isStaticPhase && this.scan(tree.moduleName, that.moduleName);
    }

    @Override
    public void visitReturn(JCTree.JCReturn tree) {
        JCTree.JCReturn that = (JCTree.JCReturn)this.parameter;
        this.result = this.scan(tree.expr, that.expr);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch tree) {
        JCTree.JCSwitch that = (JCTree.JCSwitch)this.parameter;
        this.result = this.scan(tree.selector, that.selector) && this.scan(tree.cases, that.cases);
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
        JCTree.JCSwitchExpression that = (JCTree.JCSwitchExpression)this.parameter;
        this.result = this.scan(tree.selector, that.selector) && this.scan(tree.cases, that.cases);
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized tree) {
        JCTree.JCSynchronized that = (JCTree.JCSynchronized)this.parameter;
        this.result = this.scan(tree.lock, that.lock) && this.scan(tree.body, that.body);
    }

    @Override
    public void visitThrow(JCTree.JCThrow tree) {
        JCTree.JCThrow that = (JCTree.JCThrow)this.parameter;
        this.result = this.scan(tree.expr, that.expr);
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit tree) {
        JCTree.JCCompilationUnit that = (JCTree.JCCompilationUnit)this.parameter;
        this.result = this.scan(tree.defs, that.defs) && tree.modle == that.modle && tree.packge == that.packge;
    }

    @Override
    public void visitTry(JCTree.JCTry tree) {
        JCTree.JCTry that = (JCTree.JCTry)this.parameter;
        this.result = this.scan(tree.body, that.body) && this.scan(tree.catchers, that.catchers) && this.scan(tree.finalizer, that.finalizer) && this.scan(tree.resources, that.resources);
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply tree) {
        JCTree.JCTypeApply that = (JCTree.JCTypeApply)this.parameter;
        this.result = this.scan(tree.clazz, that.clazz) && this.scan(tree.arguments, that.arguments);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree tree) {
        JCTree.JCArrayTypeTree that = (JCTree.JCArrayTypeTree)this.parameter;
        this.result = this.scan(tree.elemtype, that.elemtype);
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind tree) {
        JCTree.TypeBoundKind that = (JCTree.TypeBoundKind)this.parameter;
        this.result = tree.kind == that.kind;
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast tree) {
        JCTree.JCTypeCast that = (JCTree.JCTypeCast)this.parameter;
        this.result = this.scan(tree.clazz, that.clazz) && this.scan(tree.expr, that.expr);
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree tree) {
        JCTree.JCPrimitiveTypeTree that = (JCTree.JCPrimitiveTypeTree)this.parameter;
        this.result = tree.typetag == that.typetag;
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection tree) {
        JCTree.JCTypeIntersection that = (JCTree.JCTypeIntersection)this.parameter;
        this.result = this.scan(tree.bounds, that.bounds);
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter tree) {
        JCTree.JCTypeParameter that = (JCTree.JCTypeParameter)this.parameter;
        this.result = tree.name == that.name && this.scan(tree.bounds, that.bounds) && this.scan(tree.annotations, that.annotations);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf tree) {
        JCTree.JCInstanceOf that = (JCTree.JCInstanceOf)this.parameter;
        this.result = this.scan(tree.expr, that.expr) && this.scan(tree.pattern, that.pattern);
    }

    @Override
    public void visitTypeUnion(JCTree.JCTypeUnion tree) {
        JCTree.JCTypeUnion that = (JCTree.JCTypeUnion)this.parameter;
        this.result = this.scan(tree.alternatives, that.alternatives);
    }

    @Override
    public void visitUnary(JCTree.JCUnary tree) {
        JCTree.JCUnary that = (JCTree.JCUnary)this.parameter;
        this.result = this.scan(tree.arg, that.arg) && tree.operator == that.operator;
    }

    @Override
    public void visitUses(JCTree.JCUses tree) {
        JCTree.JCUses that = (JCTree.JCUses)this.parameter;
        this.result = this.scan(tree.qualid, that.qualid);
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl tree) {
        JCTree.JCVariableDecl that = (JCTree.JCVariableDecl)this.parameter;
        boolean bl = this.result = this.scan(tree.mods, that.mods) && this.scan(tree.nameexpr, that.nameexpr) && this.scan(tree.vartype, that.vartype) && this.scan(tree.init, that.init);
        if (tree.sym.owner.type.hasTag(TypeTag.CLASS)) {
            this.result &= tree.name == that.name;
        }
        if (this.result) {
            this.equiv.put(tree.sym, that.sym);
        }
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop tree) {
        JCTree.JCWhileLoop that = (JCTree.JCWhileLoop)this.parameter;
        this.result = this.scan(tree.cond, that.cond) && this.scan(tree.body, that.body);
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard tree) {
        JCTree.JCWildcard that = (JCTree.JCWildcard)this.parameter;
        this.result = this.scan(tree.kind, that.kind) && this.scan(tree.inner, that.inner);
    }
}

