/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.jf.dexlib2.writer.io.DexDataStore;

public class MemoryDataStore
implements DexDataStore {
    private byte[] buf;
    private int size = 0;

    public MemoryDataStore() {
        this(0);
    }

    public MemoryDataStore(int initialCapacity) {
        this.buf = new byte[initialCapacity];
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getData() {
        return Arrays.copyOf(this.buf, this.size);
    }

    @Override
    @Nonnull
    public OutputStream outputAt(final int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        return new OutputStream(){
            private int position;
            {
                this.position = offset;
            }

            @Override
            public void write(int b) throws IOException {
                MemoryDataStore.this.growBufferIfNeeded(this.position + 1);
                ((MemoryDataStore)MemoryDataStore.this).buf[this.position++] = (byte)b;
            }

            @Override
            public void write(byte[] b) throws IOException {
                MemoryDataStore.this.growBufferIfNeeded(this.position + b.length);
                System.arraycopy(b, 0, MemoryDataStore.this.buf, this.position, b.length);
                this.position += b.length;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                MemoryDataStore.this.growBufferIfNeeded(this.position + len);
                System.arraycopy(b, off, MemoryDataStore.this.buf, this.position, len);
                this.position += len;
            }
        };
    }

    private void growBufferIfNeeded(int minSize) {
        if (minSize > this.size) {
            if (minSize > this.buf.length) {
                int newSize = this.getNewBufferSize(this.buf.length, minSize);
                if (newSize < minSize) {
                    throw new IndexOutOfBoundsException();
                }
                this.buf = Arrays.copyOf(this.buf, newSize);
            }
            this.size = minSize;
        }
    }

    protected int getNewBufferSize(int currentSize, int newMinSize) {
        int MIN_GROWTH_STEP = 262144;
        return Math.max(newMinSize + (newMinSize >> 2), currentSize + 262144);
    }

    @Override
    @Nonnull
    public InputStream readAt(final int offset) {
        if (offset < 0) {
            throw new IllegalArgumentException();
        }
        return new InputStream(){
            private int position;
            private int mark;
            {
                this.position = offset;
                this.mark = offset;
            }

            @Override
            public int read() throws IOException {
                if (this.position >= MemoryDataStore.this.size) {
                    return -1;
                }
                return MemoryDataStore.this.buf[this.position++];
            }

            @Override
            public int read(byte[] b) throws IOException {
                int readLength = Math.min(b.length, MemoryDataStore.this.size - this.position);
                if (readLength <= 0) {
                    if (this.position >= MemoryDataStore.this.size) {
                        return -1;
                    }
                    return 0;
                }
                System.arraycopy(MemoryDataStore.this.buf, this.position, b, 0, readLength);
                this.position += readLength;
                return readLength;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int readLength = Math.min(len, MemoryDataStore.this.size - this.position);
                if (readLength <= 0) {
                    if (this.position >= MemoryDataStore.this.size) {
                        return -1;
                    }
                    return 0;
                }
                System.arraycopy(MemoryDataStore.this.buf, this.position, b, off, readLength);
                this.position += readLength;
                return readLength;
            }

            @Override
            public long skip(long n) throws IOException {
                int skipLength = (int)Math.max(0L, Math.min(n, (long)(MemoryDataStore.this.size - this.position)));
                this.position += skipLength;
                return skipLength;
            }

            @Override
            public int available() throws IOException {
                return Math.max(0, MemoryDataStore.this.size - this.position);
            }

            @Override
            public void mark(int i) {
                this.mark = this.position;
            }

            @Override
            public void reset() throws IOException {
                this.position = this.mark;
            }

            @Override
            public boolean markSupported() {
                return true;
            }
        };
    }

    @Override
    public void close() throws IOException {
    }
}

