/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import java.lang.ref.WeakReference;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ObjectPool<T> {
    private final ConcurrentLinkedQueue<WeakReference<T>> pool = new ConcurrentLinkedQueue();
    private final Creator<T> creator;

    public ObjectPool(Creator<T> creator) {
        this.creator = creator;
    }

    public T get() {
        WeakReference<T> wNode;
        Object node;
        do {
            if ((wNode = this.pool.poll()) != null) continue;
            return this.creator.create();
        } while ((node = wNode.get()) == null);
        return node;
    }

    public void put(T node) {
        this.pool.add(new WeakReference<T>(node));
    }

    public static interface Creator<T> {
        public T create();
    }
}

