/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.data.BlindData;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.PrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.i2cp.I2CPMessageException;
import net.i2p.data.i2cp.I2CPMessageImpl;
import net.i2p.data.i2cp.SessionId;

public class BlindingInfoMessage
extends I2CPMessageImpl {
    public static final int MESSAGE_TYPE = 42;
    private SessionId _sessionId;
    private int _endpointType;
    private int _authType;
    private SigType _blindType;
    private long _expiration;
    private Hash _hash;
    private String _host;
    private Destination _dest;
    private SigningPublicKey _pubkey;
    private PrivateKey _privkey;
    private String _secret;
    private BlindData _blindData;
    private static final int FLAG_AUTH = 15;
    private static final int FLAG_SECRET = 16;
    public static final int TYPE_HASH = 0;
    public static final int TYPE_HOST = 1;
    public static final int TYPE_DEST = 2;
    public static final int TYPE_KEY = 3;

    public BlindingInfoMessage() {
    }

    public BlindingInfoMessage(BlindData bd, SessionId id) {
        this(id, bd.getExpiration(), bd.getAuthType(), bd.getBlindedSigType(), bd.getAuthPrivKey(), bd.getSecret());
        Destination dest = bd.getDestination();
        if (dest != null) {
            this._dest = dest;
            this._hash = dest.calculateHash();
            this._pubkey = dest.getSigningPublicKey();
            this._endpointType = 2;
        } else if (bd.getUnblindedPubKey() != null) {
            this._pubkey = bd.getUnblindedPubKey();
            this._endpointType = 3;
        } else {
            throw new IllegalArgumentException();
        }
        this._blindData = bd;
    }

    @Deprecated
    public BlindingInfoMessage(Hash h, SessionId id, int expiration, int authType, SigType blindType, PrivateKey privKey, String secret) {
        this(id, expiration, authType, blindType, privKey, secret);
        if (h == null || h.getData() == null) {
            throw new IllegalArgumentException();
        }
        this._hash = h;
        this._endpointType = 0;
    }

    @Deprecated
    public BlindingInfoMessage(String h, SessionId id, int expiration, int authType, SigType blindType, PrivateKey privKey, String secret) {
        this(id, expiration, authType, blindType, privKey, secret);
        if (h == null) {
            throw new IllegalArgumentException();
        }
        this._host = h;
        this._endpointType = 1;
    }

    public BlindingInfoMessage(Destination d, SessionId id, int expiration, int authType, SigType blindType, PrivateKey privKey, String secret) {
        this(id, expiration, authType, blindType, privKey, secret);
        if (d == null || d.getSigningPublicKey() == null) {
            throw new IllegalArgumentException();
        }
        this._dest = d;
        this._hash = d.calculateHash();
        this._pubkey = d.getSigningPublicKey();
        this._endpointType = 2;
    }

    public BlindingInfoMessage(SigningPublicKey s, SessionId id, int expiration, int authType, SigType blindType, PrivateKey privKey, String secret) {
        this(id, expiration, authType, blindType, privKey, secret);
        if (s == null || s.getData() == null) {
            throw new IllegalArgumentException();
        }
        this._pubkey = s;
        this._endpointType = 3;
    }

    private BlindingInfoMessage(SessionId id, long expiration, int authType, SigType blindType, PrivateKey privKey, String secret) {
        if (id == null || blindType == null) {
            throw new IllegalArgumentException();
        }
        if (authType != 0 && authType != 1 && authType != 3) {
            throw new IllegalArgumentException("Bad auth type");
        }
        if (authType == 0 && privKey != null) {
            throw new IllegalArgumentException("no key required");
        }
        if (authType != 0 && privKey == null) {
            throw new IllegalArgumentException("key required");
        }
        if (privKey != null && privKey.getType() != EncType.ECIES_X25519) {
            throw new IllegalArgumentException("Bad privkey type");
        }
        this._sessionId = id;
        this._authType = authType;
        this._blindType = blindType;
        this._expiration = expiration;
        if (expiration > 0L && expiration < Integer.MAX_VALUE) {
            this._expiration += I2PAppContext.getGlobalContext().clock().now();
        }
        this._privkey = privKey;
        this._secret = secret;
    }

    public SessionId getSessionId() {
        return this._sessionId;
    }

    @Override
    public SessionId sessionId() {
        return this._sessionId;
    }

    public long getTimeout() {
        return this._expiration;
    }

    public int getAuthType() {
        return this._authType;
    }

    public int getEndpointType() {
        return this._endpointType;
    }

    public Hash getHash() {
        return this._hash;
    }

    public String getHostname() {
        return this._host;
    }

    public String getDestination() {
        return this._host;
    }

    public SigningPublicKey getSigningPublicKey() {
        return this._pubkey;
    }

    public PrivateKey getPrivateKey() {
        return this._privkey;
    }

    public String getSecret() {
        return this._secret;
    }

    public BlindData getBlindData() {
        if (this._blindData != null) {
            return this._blindData;
        }
        if (this._endpointType == 2) {
            this._blindData = new BlindData(I2PAppContext.getGlobalContext(), this._dest, this._blindType, this._secret, this._authType, this._privkey);
        } else if (this._endpointType == 3) {
            this._blindData = new BlindData(I2PAppContext.getGlobalContext(), this._pubkey, this._blindType, this._secret, this._authType, this._privkey);
        }
        if (this._blindData != null) {
            this._blindData.setDate(I2PAppContext.getGlobalContext().clock().now());
            this._blindData.setExpiration(this._expiration);
        }
        return this._blindData;
    }

    @Override
    protected void doReadMessage(InputStream in, int size) throws I2CPMessageException, IOException {
        try {
            this._sessionId = new SessionId();
            this._sessionId.readBytes(in);
            int flags = in.read();
            this._authType = flags & 0xF;
            boolean hasSecret = (flags & 0x10) != 0;
            this._endpointType = in.read();
            int bt = (int)DataHelper.readLong(in, 2);
            this._blindType = SigType.getByCode(bt);
            if (this._blindType == null) {
                throw new I2CPMessageException("unsupported sig type " + bt);
            }
            this._expiration = DataHelper.readLong(in, 4) * 1000L;
            if (this._endpointType == 0) {
                this._hash = Hash.create(in);
            } else if (this._endpointType == 1) {
                this._host = DataHelper.readString(in);
                if (this._host.length() == 0) {
                    throw new I2CPMessageException("bad host");
                }
            } else if (this._endpointType == 2) {
                this._dest = Destination.create(in);
            } else if (this._endpointType == 3) {
                int st = (int)DataHelper.readLong(in, 2);
                SigType sigt = SigType.getByCode(st);
                if (sigt == null) {
                    throw new I2CPMessageException("unsupported sig type " + st);
                }
                int len = sigt.getPubkeyLen();
                byte[] key = new byte[len];
                DataHelper.read(in, key);
                this._pubkey = new SigningPublicKey(sigt, key);
            } else {
                throw new I2CPMessageException("bad type");
            }
            if (this._authType == 1 || this._authType == 3) {
                byte[] key = new byte[32];
                DataHelper.read(in, key);
                this._privkey = new PrivateKey(EncType.ECIES_X25519, key);
            } else if (this._authType != 0) {
                throw new I2CPMessageException("bad auth type " + this._authType);
            }
            if (hasSecret) {
                this._secret = DataHelper.readString(in);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("bad data", dfe);
        }
    }

    @Override
    protected byte[] doWriteMessage() throws I2CPMessageException, IOException {
        if (this._endpointType == 0) {
            if (this._hash == null) {
                throw new I2CPMessageException("Unable to write out the message as there is not enough data");
            }
        } else if (this._endpointType == 1) {
            if (this._host == null) {
                throw new I2CPMessageException("Unable to write out the message as there is not enough data");
            }
        } else if (this._endpointType == 2) {
            if (this._dest == null) {
                throw new I2CPMessageException("Unable to write out the message as there is not enough data");
            }
        } else if (this._endpointType == 3) {
            if (this._pubkey == null) {
                throw new I2CPMessageException("Unable to write out the message as there is not enough data");
            }
        } else {
            throw new I2CPMessageException("bad type");
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream(512);
        try {
            this._sessionId.writeBytes(os);
            byte flags = (byte)(this._authType & 0xF);
            if (this._secret != null) {
                flags = (byte)(flags | 0x10);
            }
            os.write(flags);
            os.write((byte)this._endpointType);
            DataHelper.writeLong(os, 2, this._blindType.getCode());
            DataHelper.writeLong(os, 4, this._expiration / 1000L);
            if (this._endpointType == 0) {
                this._hash.writeBytes(os);
            } else if (this._endpointType == 1) {
                DataHelper.writeString(os, this._host);
            } else if (this._endpointType == 2) {
                this._dest.writeBytes(os);
            } else {
                DataHelper.writeLong(os, 2, this._pubkey.getType().getCode());
                os.write(this._pubkey.getData());
            }
            if (this._privkey != null) {
                os.write(this._privkey.getData());
            }
            if (this._secret != null) {
                DataHelper.writeString(os, this._secret);
            }
        }
        catch (DataFormatException dfe) {
            throw new I2CPMessageException("bad data", dfe);
        }
        return os.toByteArray();
    }

    @Override
    public int getType() {
        return 42;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[BlindingInfoMessage: ");
        buf.append("\n\tSession: ").append(this._sessionId);
        buf.append("\n\tTimeout: ").append(this._expiration);
        buf.append("\n\tAuthTyp: ").append(this._authType);
        if (this._endpointType == 0) {
            buf.append("\n\tHash: ").append(this._hash.toBase32());
        } else if (this._endpointType == 1) {
            buf.append("\n\tHost: ").append(this._host);
        } else if (this._endpointType == 2) {
            buf.append("\n\tDest: ").append(this._dest);
        } else if (this._endpointType == 3) {
            buf.append("\n\tKey: ").append(this._pubkey);
        }
        if (this._privkey != null) {
            buf.append("\n\tPriv Key: ").append(this._privkey);
        }
        if (this._secret != null) {
            buf.append("\n\tSecret: ").append(this._secret);
        }
        buf.append("]");
        return buf.toString();
    }
}

