/*
    MathArrayExtensions - More methods for MathArray
    
    See the header file MathArray for the compact 'superset' of
    methods.
    
    Copyright (C) 1995, Adam Fedor
    
    $Id: MathArrayExtensions.h,v 1.6 1996/04/03 16:21:04 adam Exp $
*/

#ifndef _MathArrayExtensions_INCLUDE_
#define _MathArrayExtensions_INCLUDE_

#include <MathArray/MathArray.h>

#ifndef StatusCheckNotification
#define STATUS_CHECK_NOTIFICATION @"StatusCheckNotification"
#endif

@interface MathArray (ArrayOperators)
- maExponent:value;
- maMultiply:factor;
- maDivide:divisor;
- maAdd:value;
- maSubtract:value;
- maMod:value;

- maMinimum:value;
- maMaximum:value;
- maNot;
- maEqual:value;
- maNotEqual:value;
- maLessOrEqual:value;
- maLess:value;
- maGreaterOrEqual:value;
- maGreater:value;
- maAnd:value;
- maOr:value;
- maXor:value;

- maMatrixMultiply:(MathArray *)otherArray;

@end

@interface MathArray (ArrayFunctions)
- maAbs;
- maArcCos;
- maArcSin;
- maArcTan;
- maCos;
- maExp;
- maLogBase10;
- maNaturalLog;
- maTan;
- maSin;
- maSqrt;

- maInvert;
- maTranspose;
- maFFt:(int)direction;
- maShift:(int *)positions;

+ (void) setRandomSeed: (int)seed;
- maRandomUniformMin: (double)min toMax: (double)max;
- maRandomNormalMean: (double)mean deviation: (double)dev;

- (id <NSNumber,ComplexNumber>)maMinimumValue;
- (id <NSNumber,ComplexNumber>)maMaximumValue;
- (id <NSNumber,ComplexNumber>)maTotal;
- maWhere;

@end

@interface MathArray (ComplexExtensions)
+ (MathArray *)maComplexArrayWithReal:(MathArray *)realArray 
	imaginary:(MathArray *)imagArray;

- (BOOL)isComplex;
- maReal;
- maImaginary;
- maMagnitude;
- maPhase;

- maConjugate;

@end

#endif /* _MathArrayExtensions_INCLUDE_ */
