/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.util.ArrayList;
import java.util.Collections;
import org.w3c.css.util.Warning;

public final class Warnings {
    private ArrayList<Warning> warningData = new ArrayList(16);
    private int ignoredWarningCount = 0;
    private int warningLevel = 0;

    public Warnings() {
    }

    public Warnings(int level) {
        this.warningLevel = level;
    }

    public int getWarningLevel() {
        return this.warningLevel;
    }

    public void setWarningLevel(int warningLevel) {
        this.warningLevel = warningLevel;
    }

    public final void addWarning(Warning warn) {
        if (warn.getLevel() > this.warningLevel) {
            ++this.ignoredWarningCount;
        } else {
            this.warningData.add(warn);
        }
    }

    public final void addWarnings(Warnings warnings) {
        this.warningData.addAll(warnings.warningData);
    }

    public final int getWarningCount() {
        return this.warningData.size();
    }

    public final int getIgnoredWarningCount() {
        return this.ignoredWarningCount;
    }

    public final Warning[] getWarnings() {
        Warning[] out = new Warning[this.warningData.size()];
        this.warningData.toArray(out);
        return out;
    }

    public final void sort() {
        Collections.sort(this.warningData);
    }

    public final Warning getWarningAt(int index) {
        return this.warningData.get(index);
    }
}

