/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.servlet;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.validator.routines.EmailValidator;
import org.w3c.css.css.DocumentParser;
import org.w3c.css.css.StyleReport;
import org.w3c.css.css.StyleReportFactory;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.css.StyleSheetParser;
import org.w3c.css.css.TagSoupStyleSheetHandler;
import org.w3c.css.error.ErrorReport;
import org.w3c.css.error.ErrorReportFactory;
import org.w3c.css.index.IndexGenerator;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.Errors;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.Codecs;
import org.w3c.css.util.CssVersion;
import org.w3c.css.util.FakeFile;
import org.w3c.css.util.HTTPURL;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.www.mime.MimeType;
import org.w3c.www.mime.MimeTypeFormatException;

public final class CssValidator
extends HttpServlet {
    static final String texthtml = "text/html";
    static final String applxhtml = "application/xhtml+xml";
    static final String textplain = "text/plain";
    static final String textcss = "text/css";
    static final String textunknown = "text/unknown";
    static final String soap12 = "application/soap+xml";
    static final String json = "application/json";
    static final String opt_file = "file";
    static final String opt_text = "text";
    static final String opt_textcharset = "textcharset";
    static final String opt_lang = "lang";
    static final String opt_output = "output";
    static final String opt_warning = "warning";
    static final String opt_error = "error";
    static final String opt_profile = "profile";
    static final String opt_usermedium = "usermedium";
    static final String opt_vextwarning = "vextwarning";
    static final String opt_type = "type";
    public static final String server_name = "Jigsaw/2.3.0 W3C_CSS_Validator_JFouffa/2.0 (See <http://validator.w3.org/services>)";
    static final String headers_name = "X-W3C-Validator-";

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        Util.servlet = true;
        String pval = config.getInitParameter("debug");
        if (pval != null && !pval.isEmpty()) {
            Util.onDebug = pval.equals("true");
            System.err.println("RUN IN DEBUG MODE: " + Util.onDebug);
        } else if (Util.onDebug) {
            System.err.println("RUN IN DEBUG MODE but activated outside the servlet");
        }
        pval = config.getInitParameter("import");
        if (pval != null && !pval.isEmpty() && pval.equals("false")) {
            Util.importSecurity = true;
        }
        if ((pval = config.getInitParameter("entitysize")) != null && !pval.isEmpty()) {
            try {
                Util.maxEntitySize = Long.parseLong(pval);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        new Thread(){

            @Override
            public void run() {
                IndexGenerator.generatesIndex(true);
            }
        }.start();
    }

    private PrintWriter getLocalPrintWriter(OutputStream os, String encoding) throws IOException {
        if (encoding != null) {
            return new PrintWriter(new OutputStreamWriter(os, encoding));
        }
        return new PrintWriter(new OutputStreamWriter(os, "UTF-8"));
    }

    private void processVendorExtensionParameter(String vendorExtensionParameter, ApplContext context) {
        if (vendorExtensionParameter == null || vendorExtensionParameter.isEmpty()) {
            vendorExtensionParameter = this.getServletConfig().getInitParameter("vendorExtensionsAsWarnings");
        }
        context.setTreatVendorExtensionsAsWarnings(Boolean.valueOf(vendorExtensionParameter));
        context.setTreatCssHacksAsWarnings(Boolean.valueOf(vendorExtensionParameter));
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block42: {
            String credential;
            boolean errorReport = true;
            int warningLevel = 2;
            StyleSheetParser parser = null;
            String lang = null;
            try {
                lang = req.getParameter(opt_lang);
            }
            catch (Exception e) {
                lang = null;
            }
            lang = lang == null || lang.isEmpty() ? req.getHeader("Accept-Language") : lang + ',' + req.getHeader("Accept-Language");
            ApplContext ac = new ApplContext(lang);
            ac.setLink(req.getQueryString());
            ac.setContentEncoding(req.getHeader("Accept-Charset"));
            String output = req.getParameter(opt_output);
            String uri = null;
            try {
                uri = req.getParameter("uri");
            }
            catch (Exception ex) {
                this.handleError(res, ac, output, "No file", new IOException("Invalid escape sequence in URI"), false);
            }
            String text = null;
            try {
                text = req.getParameter(opt_text);
            }
            catch (Exception ex) {
                this.handleError(res, ac, output, "Invalid text", new IOException("Invalid escape sequence in URI"), false);
            }
            String warning = req.getParameter(opt_warning);
            String error = req.getParameter(opt_error);
            String profile = req.getParameter(opt_profile);
            String usermedium = req.getParameter(opt_usermedium);
            String type = req.getParameter(opt_type);
            ServletInputStream in = req.getInputStream();
            if (type == null) {
                type = "none";
            }
            if ((credential = req.getHeader("Authorization")) != null && credential.length() > 1) {
                ac.setCredential(credential);
            }
            ac.setCssVersionAndProfile(profile);
            if (ac.getCssVersion() != CssVersion.CSS1) {
                if (usermedium == null || usermedium.isEmpty()) {
                    usermedium = "all";
                }
                ac.setMedium(usermedium);
            }
            if (req.getParameter("debug") != null) {
                Util.onDebug = req.getParameter("debug").equals("true");
                if (Util.onDebug) {
                    System.err.println("SWITCH DEBUG MODE REQUEST");
                }
            } else {
                Util.onDebug = false;
            }
            uri = Util.suppressWhiteSpace(uri);
            if (output == null) {
                output = texthtml;
            }
            if (Util.onDebug) {
                System.err.println("[DEBUG] version is : " + ac.getCssVersionString() + " profile is " + ac.getProfileString() + " medium is " + usermedium);
            }
            if (uri == null && text == null) {
                this.handleError(res, ac, output, "No file", new IOException(ac.getMsg().getServletString("invalid-request")), false);
                return;
            }
            in.close();
            if (warning != null) {
                if (warning.equals("no")) {
                    warningLevel = -1;
                } else {
                    try {
                        warningLevel = Integer.parseInt(warning);
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
                ac.setWarningLevel(warningLevel);
            }
            if (error != null && error.equals("no")) {
                errorReport = false;
            }
            this.processVendorExtensionParameter(req.getParameter(opt_vextwarning), ac);
            Util.verbose("\nServlet request ");
            if (uri != null) {
                Util.verbose("Source file : " + uri);
            } else {
                Util.verbose("TEXTAREA Input");
            }
            if (uri != null) {
                EmailValidator ev = EmailValidator.getInstance();
                if (ev.isValid(uri)) {
                    this.handleScam(ac, uri, res, output, warningLevel, errorReport);
                } else {
                    try {
                        uri = HTTPURL.getURL(uri).toString();
                        uri = uri.replaceAll(" ", "%20");
                        if (Util.checkURI(uri)) {
                            DocumentParser URLparser = new DocumentParser(ac, uri);
                            this.handleRequest(ac, res, uri, URLparser.getStyleSheet(), output, warningLevel, errorReport);
                            break block42;
                        }
                        res.setHeader("Rejected", "Requested URI Forbidden by Rule");
                        this.handleError(res, ac, output, "Forbidden", new IOException("URI Forbidden by rule"), false);
                    }
                    catch (ProtocolException pex) {
                        if (Util.onDebug) {
                            pex.printStackTrace();
                        }
                        res.setHeader("WWW-Authenticate", pex.getMessage());
                        res.sendError(401);
                    }
                    catch (Exception e) {
                        this.handleError(res, ac, output, uri, e, true);
                    }
                }
            } else if (text != null) {
                String fileName = "TextArea";
                Util.verbose("- " + fileName + " Data -");
                Util.verbose(text);
                Util.verbose("- End of " + fileName + " Data");
                EmailValidator ev = EmailValidator.getInstance();
                if (ev.isValid(text)) {
                    this.handleScam(ac, text, res, output, warningLevel, errorReport);
                } else {
                    ByteArrayInputStream is = new ByteArrayInputStream(text.getBytes());
                    fileName = "file://localhost/" + fileName;
                    try {
                        if ("css".equals(type) || "none".equals(type) && this.isCSS(text)) {
                            parser = new StyleSheetParser(ac);
                            parser.parseStyleElement(ac, is, null, usermedium, new URL(fileName), 0);
                            this.handleRequest(ac, res, fileName, parser.getStyleSheet(), output, warningLevel, errorReport);
                        } else {
                            TagSoupStyleSheetHandler handler = new TagSoupStyleSheetHandler(null, ac);
                            handler.parse(is, fileName);
                            this.handleRequest(ac, res, fileName, handler.getStyleSheet(), output, warningLevel, errorReport);
                        }
                    }
                    catch (ProtocolException pex) {
                        if (Util.onDebug) {
                            pex.printStackTrace();
                        }
                        res.setHeader("WWW-Authenticate", pex.getMessage());
                        res.sendError(401);
                    }
                    catch (Exception e) {
                        this.handleError(res, ac, output, fileName, e, false);
                    }
                }
            }
        }
        Util.verbose("CssValidator: Request terminated.\n");
    }

    private boolean isCSS(String text) {
        try {
            text = text.toLowerCase();
            int p = text.indexOf("<style");
            return p == -1 || p > text.indexOf("</style>");
        }
        catch (Exception e) {
            System.err.println("error: " + e.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Object old;
        String lang = null;
        try {
            lang = req.getParameter(opt_lang);
        }
        catch (Exception e) {
            lang = null;
        }
        boolean errorReport = true;
        int warningLevel = 2;
        StyleSheetParser parser = null;
        FakeFile file = null;
        String text = null;
        Charset textcharset = null;
        String output = null;
        String warning = null;
        String error = null;
        String profile = "none";
        String usermedium = "all";
        String vendorExtensionAsWarnings = null;
        String inputType = "none";
        ServletInputStream in = req.getInputStream();
        byte[] buf = new byte[2048];
        byte[] general = new byte[65536];
        int count = 0;
        if (req.getParameter("debug") != null) {
            Util.onDebug = req.getParameter("debug").equals("true");
            if (Util.onDebug) {
                System.err.println("SWITCH DEBUG MODE REQUEST");
            }
        } else {
            Util.onDebug = false;
        }
        Util.verbose("\nCssValidator: Servlet request ");
        Util.verbose("Content-length : " + req.getContentLength());
        if (req.getContentType().trim().startsWith("multipart/form-data")) {
            Util.verbose("Content-type : multipart/form-data");
        }
        try {
            int len;
            while ((len = in.readLine(buf, 0, buf.length)) != -1) {
                if (len >= 2 && buf[len - 1] == 10 && buf[len - 2] == 13) {
                    buf[--len - 1] = 10;
                }
                if (len != 0 && buf[len - 1] == 13) {
                    buf[len - 1] = 10;
                }
                if (general.length < count + len) {
                    old = general;
                    general = new byte[((byte[])old).length * 2];
                    System.arraycopy(old, 0, general, 0, ((Object)old).length);
                }
                System.arraycopy(buf, 0, general, count, len);
                count += len;
            }
        }
        finally {
            in.close();
        }
        try {
            buf = new byte[count];
            System.arraycopy(general, 0, buf, 0, count);
            old = Codecs.mpFormDataDecode(buf, req.getContentType()).iterator();
            while (old.hasNext()) {
                Pair pair = (Pair)old.next();
                switch ((String)pair.getKey()) {
                    case "file": {
                        file = (FakeFile)pair.getValue();
                        break;
                    }
                    case "text": {
                        text = (String)pair.getValue();
                        break;
                    }
                    case "textcharset": {
                        textcharset = (Charset)pair.getValue();
                        break;
                    }
                    case "lang": {
                        lang = (String)pair.getValue();
                        break;
                    }
                    case "output": {
                        output = (String)pair.getValue();
                        break;
                    }
                    case "warning": {
                        warning = (String)pair.getValue();
                        break;
                    }
                    case "error": {
                        error = (String)pair.getValue();
                        break;
                    }
                    case "profile": {
                        profile = (String)pair.getValue();
                        break;
                    }
                    case "usermedium": {
                        usermedium = (String)pair.getValue();
                        break;
                    }
                    case "vextwarning": {
                        vendorExtensionAsWarnings = (String)pair.getValue();
                        break;
                    }
                    case "type": {
                        inputType = (String)pair.getValue();
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Oups! Error in Util/Codecs.java?!?");
            e.printStackTrace();
        }
        lang = lang == null || lang.isEmpty() ? req.getHeader("Accept-Language") : lang + ',' + req.getHeader("Accept-Language");
        ApplContext ac = new ApplContext(lang);
        ac.setLink(req.getQueryString());
        if (output == null) {
            output = texthtml;
        }
        if (warning != null) {
            if (warning.equals("no")) {
                warningLevel = -1;
            } else {
                try {
                    warningLevel = Integer.parseInt(warning);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            ac.setWarningLevel(warningLevel);
        }
        if (error != null && error.equals("no")) {
            errorReport = false;
        }
        this.processVendorExtensionParameter(vendorExtensionAsWarnings, ac);
        ac.setCssVersionAndProfile(profile);
        if (ac.getCssVersion() == CssVersion.CSS1) {
            if (usermedium != null && !"all".equals(usermedium)) {
                ac.setMedium(usermedium);
            }
        } else {
            if (usermedium == null || usermedium.isEmpty()) {
                usermedium = "all";
            }
            ac.setMedium(usermedium);
        }
        String fileName = "";
        InputStream is = null;
        boolean isCSS = false;
        if (file != null) {
            isCSS = file.getContentType().equals(textcss);
            if (file.getSize() == 0) {
                file.write("\n".getBytes(), 0, 1);
                isCSS = true;
            }
            ac.setFakeFile(file);
            fileName = file.getName();
            Util.verbose("File : " + fileName);
        } else {
            EmailValidator ev = EmailValidator.getInstance();
            if (ev.isValid(text)) {
                this.handleScam(ac, text, res, output, warningLevel, errorReport);
                return;
            }
            ac.setFakeText(text, textcharset);
            fileName = "TextArea";
            Util.verbose("- " + fileName + " Data -");
            Util.verbose(text);
            Util.verbose("- End of " + fileName + " Data");
            switch (inputType) {
                case "css": {
                    isCSS = true;
                    break;
                }
                case "html": {
                    isCSS = false;
                    break;
                }
                default: {
                    isCSS = this.isCSS(text);
                }
            }
        }
        fileName = "file://localhost/" + fileName;
        try {
            URL u = new URL(fileName);
            is = ac.getFakeInputStream(u);
            ac.setFakeURL(fileName);
            if (isCSS) {
                parser = new StyleSheetParser(ac);
                parser.parseStyleElement(ac, is, textcharset, null, ac.getMedium(), new URL(fileName), 0);
                this.handleRequest(ac, res, fileName, parser.getStyleSheet(), output, warningLevel, errorReport);
            } else {
                TagSoupStyleSheetHandler handler = new TagSoupStyleSheetHandler(null, ac);
                handler.parse(is, fileName);
                this.handleRequest(ac, res, fileName, handler.getStyleSheet(), output, warningLevel, errorReport);
            }
        }
        catch (ProtocolException pex) {
            if (Util.onDebug) {
                // empty if block
            }
            res.setHeader("WWW-Authenticate", pex.getMessage());
            res.sendError(401);
        }
        catch (Exception e) {
            this.handleError(res, ac, output, fileName, e, false);
        }
        Util.verbose("CssValidator: Request terminated.\n");
    }

    private void handleScam(ApplContext ac, String uri, HttpServletResponse res, String output, int warningLevel, boolean errorReport) throws IOException {
        String fileName = "email";
        ByteArrayInputStream is = new ByteArrayInputStream("".getBytes());
        fileName = "file://" + fileName;
        try {
            TagSoupStyleSheetHandler handler = new TagSoupStyleSheetHandler(null, ac);
            handler.parse(is, fileName);
            Errors e = new Errors();
            e.addError(new CssError(new InvalidParamException("email", uri, ac)));
            handler.getStyleSheet().addErrors(e);
            this.handleRequest(ac, res, fileName, handler.getStyleSheet(), output, warningLevel, errorReport);
        }
        catch (Exception e) {
            this.handleError(res, ac, output, fileName, e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(ApplContext ac, HttpServletResponse res, String title, StyleSheet styleSheet, String output, int warningLevel, boolean errorReport) throws Exception {
        String outformat;
        this.buildHeader(ac, res, output);
        if (styleSheet == null) {
            throw new IOException(ac.getMsg().getServletString("process") + " " + title);
        }
        switch (output) {
            case "text/html": {
                outformat = "text/xml".equals(ac.getInput()) ? "xhtml" : "html";
                break;
            }
            case "application/soap+xml": {
                outformat = soap12;
                break;
            }
            case "application/json": {
                outformat = "json";
                break;
            }
            case "text/plain": {
                outformat = opt_text;
                break;
            }
            default: {
                outformat = output;
            }
        }
        styleSheet.findConflicts(ac);
        StyleReport style = StyleReportFactory.getStyleReport(ac, title, styleSheet, outformat, warningLevel);
        if (!errorReport) {
            style.desactivateError();
        }
        PrintWriter out = this.getLocalPrintWriter(res.getOutputStream(), ac.getContentEncoding());
        int nb_errors = styleSheet.getErrors().getErrorCount();
        res.setHeader("X-W3C-Validator-Errors", String.valueOf(nb_errors));
        res.setHeader("X-W3C-Validator-Status", nb_errors == 0 ? "Valid" : "Invalid");
        try {
            style.print(out);
        }
        finally {
            out.close();
        }
    }

    private void buildHeader(ApplContext ac, HttpServletResponse res, String output) {
        res.setHeader("Pragma", "no-cache");
        res.setHeader("Cache-Control", "no-cache");
        if (output == null) {
            output = new String(texthtml);
        }
        MimeType outputMt = null;
        if (output.equals(texthtml) || output.equals("html")) {
            outputMt = MimeType.TEXT_HTML.getClone();
        } else if (output.equals(applxhtml) || output.equals("xhtml")) {
            outputMt = MimeType.APPLICATION_XHTML_XML.getClone();
        } else if (output.equals(soap12) || output.equals("soap12")) {
            try {
                outputMt = new MimeType(soap12);
            }
            catch (MimeTypeFormatException e) {
                outputMt = MimeType.TEXT_PLAIN.getClone();
            }
        } else if (output.equals("ucn")) {
            outputMt = MimeType.APPLICATION_XML.getClone();
        } else if (output.equals("json")) {
            try {
                outputMt = new MimeType(json);
            }
            catch (MimeTypeFormatException e) {
                outputMt = MimeType.TEXT_PLAIN.getClone();
            }
        } else {
            outputMt = MimeType.TEXT_PLAIN.getClone();
        }
        if (ac != null) {
            if (output.equals("soap12")) {
                ac.setContentEncoding(null);
            }
            if (ac.getContentEncoding() != null) {
                outputMt.setParameter("charset", ac.getContentEncoding());
            }
            res.setContentType(outputMt.toString());
            if (ac.getContentLanguage() != null) {
                res.setHeader("Content-Language", ac.getContentLanguage());
            } else {
                res.setHeader("Content-Language", "en");
            }
        } else {
            res.setHeader("Content-Language", "en");
            res.setHeader("charset", "UTF-8");
        }
        res.setHeader("Vary", "Accept-Language");
        res.setHeader("Access-Control-Allow-Origin", "*");
        res.setHeader("Access-Control-Allow-Headers", "content-type,accept-charset");
        res.setHeader("Access-Control-Allow-Methods", "GET, HEAD, POST, OPTIONS");
        res.setHeader("Access-Control-Max-Age", "600");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleError(HttpServletResponse res, ApplContext ac, String output, String title, Exception e, boolean validURI) throws IOException {
        System.err.println("[ERROR VALIDATOR] " + title);
        System.err.println(e.toString());
        e.printStackTrace();
        this.buildHeader(ac, res, output);
        res.setStatus(500);
        validURI = e instanceof UnknownHostException || e instanceof FileNotFoundException && (e.getMessage().indexOf("Not Found") != -1 || e.getMessage().indexOf("Service Unavailable") != -1);
        PrintWriter out = this.getLocalPrintWriter(res.getOutputStream(), ac.getContentEncoding());
        ErrorReport error = ErrorReportFactory.getErrorReport(ac, title, output, e, validURI);
        res.setHeader("X-W3C-Validator-Status", "Abort");
        try {
            error.print(out);
        }
        finally {
            out.close();
        }
    }
}

