/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import org.pushingpixels.flamingo.api.common.AbstractCommandButton;
import org.pushingpixels.flamingo.api.common.CommandButtonDisplayState;
import org.pushingpixels.flamingo.api.ribbon.AbstractRibbonBand;
import org.pushingpixels.flamingo.api.ribbon.JRibbonComponent;
import org.pushingpixels.flamingo.api.ribbon.RibbonElementPriority;
import org.pushingpixels.flamingo.api.ribbon.resize.IconRibbonBandResizePolicy;
import org.pushingpixels.flamingo.api.ribbon.resize.RibbonBandResizePolicy;
import org.pushingpixels.flamingo.internal.ui.ribbon.AbstractBandControlPanelUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.BasicRibbonBandUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.JBandControlPanel;
import org.pushingpixels.flamingo.internal.ui.ribbon.JRibbonGallery;

public class BasicBandControlPanelUI
extends AbstractBandControlPanelUI {
    private JSeparator[] groupSeparators;
    private JLabel[] groupLabels;
    protected ChangeListener changeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicBandControlPanelUI();
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new ControlPanelLayout();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                BasicBandControlPanelUI.this.syncGroupHeaders();
                BasicBandControlPanelUI.this.controlPanel.revalidate();
            }
        };
        ((JBandControlPanel)this.controlPanel).addChangeListener(this.changeListener);
    }

    @Override
    protected void uninstallListeners() {
        ((JBandControlPanel)this.controlPanel).removeChangeListener(this.changeListener);
        this.changeListener = null;
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.syncGroupHeaders();
    }

    @Override
    protected void uninstallComponents() {
        if (this.groupSeparators != null) {
            for (JComponent jComponent : this.groupSeparators) {
                this.controlPanel.remove(jComponent);
            }
        }
        if (this.groupLabels != null) {
            for (JComponent jComponent : this.groupLabels) {
                if (jComponent == null) continue;
                this.controlPanel.remove(jComponent);
            }
        }
        super.uninstallComponents();
    }

    protected void syncGroupHeaders() {
        int n;
        JComponent jComponent;
        int n2;
        int n3;
        JComponent[] jComponentArray;
        if (this.groupSeparators != null) {
            jComponentArray = this.groupSeparators;
            n3 = jComponentArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                jComponent = jComponentArray[n2];
                this.controlPanel.remove(jComponent);
            }
        }
        if (this.groupLabels != null) {
            jComponentArray = this.groupLabels;
            n3 = jComponentArray.length;
            for (n2 = 0; n2 < n3; ++n2) {
                jComponent = jComponentArray[n2];
                if (jComponent == null) continue;
                this.controlPanel.remove(jComponent);
            }
        }
        if ((n = ((JBandControlPanel)this.controlPanel).getControlPanelGroupCount()) > 1) {
            this.groupSeparators = new JSeparator[n - 1];
            for (n3 = 0; n3 < n - 1; ++n3) {
                this.groupSeparators[n3] = new JSeparator(1);
                this.controlPanel.add(this.groupSeparators[n3]);
            }
        }
        if (n > 0) {
            this.groupLabels = new JLabel[n];
            for (n3 = 0; n3 < n; ++n3) {
                String string = ((JBandControlPanel)this.controlPanel).getControlPanelGroupTitle(n3);
                if (string == null) continue;
                this.groupLabels[n3] = new JLabel(string);
                this.controlPanel.add(this.groupLabels[n3]);
            }
        }
    }

    private class ControlPanelLayout
    implements LayoutManager {
        private ControlPanelLayout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = BasicBandControlPanelUI.this.dummy.getPreferredSize().height;
            int n2 = BasicBandControlPanelUI.this.getLayoutGap() * 3 / 4;
            int n3 = n - 2 * n2;
            switch (n3 % 3) {
                case 1: {
                    n += 2;
                    break;
                }
                case 2: {
                    ++n;
                }
            }
            Insets insets = container.getInsets();
            return new Dimension(container.getWidth(), n + insets.top + insets.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            AbstractRibbonBand abstractRibbonBand = ((JBandControlPanel)container).getRibbonBand();
            RibbonBandResizePolicy ribbonBandResizePolicy = abstractRibbonBand.getCurrentResizePolicy();
            if (ribbonBandResizePolicy == null) {
                return;
            }
            boolean bl = container.getComponentOrientation().isLeftToRight();
            Insets insets = container.getInsets();
            int n = BasicBandControlPanelUI.this.getLayoutGap();
            int n2 = bl ? insets.left + n / 2 : container.getWidth() - insets.right - n / 2;
            int n3 = container.getHeight() - insets.top - insets.bottom;
            if (SwingUtilities.getAncestorOfClass(BasicRibbonBandUI.CollapsedButtonPopupPanel.class, container) != null) {
                List<RibbonBandResizePolicy> list = abstractRibbonBand.getResizePolicies();
                list.get(0).install(n3, n);
            } else {
                if (ribbonBandResizePolicy instanceof IconRibbonBandResizePolicy) {
                    return;
                }
                ribbonBandResizePolicy.install(n3, n);
            }
            int n4 = 0;
            for (JBandControlPanel.ControlPanelGroup controlPanelGroup : ((JBandControlPanel)BasicBandControlPanelUI.this.controlPanel).getControlPanelGroups()) {
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                if (n4 > 0) {
                    n10 = ((BasicBandControlPanelUI)BasicBandControlPanelUI.this).groupSeparators[n4 - 1].getPreferredSize().width;
                    n9 = bl ? n2 - n + (n - n10) / 2 : n2 + n / 2 - (n - n10) / 2;
                    BasicBandControlPanelUI.this.groupSeparators[n4 - 1].setBounds(n9, insets.top, n10, n3);
                }
                n10 = 0;
                n9 = controlPanelGroup.isCoreContent();
                if (n9 != 0) {
                    int n11;
                    int n12;
                    Object object;
                    int n13 = n3 / 3;
                    int n14 = controlPanelGroup.getGroupTitle() != null ? 1 : 0;
                    n8 = 0;
                    if (n14 != 0) {
                        object = BasicBandControlPanelUI.this.groupLabels[n4];
                        int n15 = ((JComponent)object).getPreferredSize().width;
                        int n16 = Math.min(n13 - n / 4, ((JComponent)object).getPreferredSize().height);
                        n12 = n13 - n16;
                        int n17 = n11 = n16 > 0 ? ((JComponent)object).getBaseline(n15, n16) : 0;
                        if (bl) {
                            ((Component)object).setBounds(n2 + n, insets.top + n12 - n16 + n11, n15, n16);
                        } else {
                            ((Component)object).setBounds(n2 - n - n15, insets.top + n12 - n16 + n11, n15, n16);
                        }
                        n8 = n + n15;
                    }
                    object = controlPanelGroup.getRibbonComps();
                    Map<JRibbonComponent, Integer> map = controlPanelGroup.getRibbonCompsRowSpans();
                    ArrayList<JRibbonComponent> arrayList = new ArrayList<JRibbonComponent>();
                    n11 = n12 = n14 != 0 ? 1 : 0;
                    for (int i = 0; i < object.size(); ++i) {
                        JRibbonComponent jRibbonComponent = (JRibbonComponent)object.get(i);
                        n7 = jRibbonComponent.getPreferredSize().width;
                        n6 = map.get(jRibbonComponent);
                        n5 = n11 + n6;
                        if (n5 > 3) {
                            if (bl) {
                                if (n10 != 0) {
                                    n2 += n;
                                }
                                n2 += n8;
                            } else {
                                if (n10 != 0) {
                                    n2 -= n;
                                }
                                n2 -= n8;
                            }
                            n10 = 1;
                            n8 = 0;
                            n11 = n12;
                            arrayList.clear();
                        }
                        int n18 = Math.min(n6 * n13 - n / 4, jRibbonComponent.getPreferredSize().height);
                        int n19 = n6 * n13 - n18;
                        int n20 = n11 * n13 + insets.top;
                        if (bl) {
                            jRibbonComponent.setBounds(n2, n20 + n19, n7, n18);
                        } else {
                            jRibbonComponent.setBounds(n2 - n7, n20 + n19, n7, n18);
                        }
                        n8 = Math.max(n8, n7);
                        arrayList.add(jRibbonComponent);
                        jRibbonComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", n11 == 0);
                        jRibbonComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", n11 > 0 && n11 < 2);
                        jRibbonComponent.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", n11 == 2);
                        for (JRibbonComponent jRibbonComponent2 : arrayList) {
                            Rectangle rectangle = jRibbonComponent2.getBounds();
                            if (bl) {
                                jRibbonComponent2.setBounds(rectangle.x, rectangle.y, n8, rectangle.height);
                            } else {
                                jRibbonComponent2.setBounds(rectangle.x + rectangle.width - n8, rectangle.y, n8, rectangle.height);
                            }
                            jRibbonComponent2.doLayout();
                        }
                        n11 += n6;
                    }
                    if (n11 > 0 && n11 <= 3) {
                        if (bl) {
                            if (n10 != 0) {
                                n2 += n;
                            }
                            n2 += n8;
                        } else {
                            if (n10 != 0) {
                                n2 -= n;
                            }
                            n2 -= n8;
                        }
                        n10 = 1;
                    }
                } else {
                    for (RibbonElementPriority ribbonElementPriority : RibbonElementPriority.values()) {
                        for (JRibbonGallery jRibbonGallery : controlPanelGroup.getRibbonGalleries(ribbonElementPriority)) {
                            int n21 = jRibbonGallery.getPreferredWidth(jRibbonGallery.getDisplayPriority(), n3);
                            if (bl) {
                                jRibbonGallery.setBounds(n2, insets.top, n21, n3);
                                if (n10 != 0) {
                                    n2 += n;
                                }
                                n2 += n21;
                            } else {
                                jRibbonGallery.setBounds(n2 - n21, insets.top, n21, n3);
                                if (n10 != 0) {
                                    n2 -= n;
                                }
                                n2 -= n21;
                            }
                            n10 = 1;
                        }
                    }
                    HashMap hashMap = new HashMap();
                    for (RibbonElementPriority ribbonElementPriority : RibbonElementPriority.values()) {
                        for (AbstractCommandButton abstractCommandButton : controlPanelGroup.getRibbonButtons(ribbonElementPriority)) {
                            CommandButtonDisplayState commandButtonDisplayState = abstractCommandButton.getDisplayState();
                            if (hashMap.get(commandButtonDisplayState) == null) {
                                hashMap.put(commandButtonDisplayState, new ArrayList());
                            }
                            ((List)hashMap.get(commandButtonDisplayState)).add(abstractCommandButton);
                        }
                    }
                    List list = (List)hashMap.get(CommandButtonDisplayState.BIG);
                    if (list != null) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            AbstractCommandButton abstractCommandButton = (AbstractCommandButton)iterator.next();
                            int n22 = abstractCommandButton.getPreferredSize().width;
                            if (n10 != 0) {
                                n2 = bl ? (n2 += n) : (n2 -= n);
                            }
                            if (bl) {
                                abstractCommandButton.setBounds(n2, insets.top, n22, n3);
                            } else {
                                abstractCommandButton.setBounds(n2 - n22, insets.top, n22, n3);
                            }
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", Boolean.FALSE);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", Boolean.FALSE);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", Boolean.FALSE);
                            n2 = bl ? (n2 += n22) : (n2 -= n22);
                            n10 = 1;
                        }
                    }
                    n8 = n * 3 / 4;
                    int n23 = (n3 - 2 * n8) / 3;
                    int n24 = 0;
                    int n25 = 0;
                    List list2 = (List)hashMap.get(CommandButtonDisplayState.MEDIUM);
                    if (list2 != null) {
                        for (AbstractCommandButton abstractCommandButton : list2) {
                            int n26 = abstractCommandButton.getPreferredSize().width;
                            n25 = Math.max(n25, n26);
                            if (n10 != 0 && n24 == 0) {
                                n2 = bl ? (n2 += n) : (n2 -= n);
                            }
                            n7 = (n23 + n8) * n24;
                            n6 = (n23 + n8) * (n24 + 1) - n8;
                            if (bl) {
                                abstractCommandButton.setBounds(n2, insets.top + n7, n26, n6 - n7);
                            } else {
                                abstractCommandButton.setBounds(n2 - n26, insets.top + n7, n26, n6 - n7);
                            }
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", n24 == 0);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", n24 == 1);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", n24 == 2);
                            if (++n24 != 3) continue;
                            n24 = 0;
                            n2 = bl ? (n2 += n25) : (n2 -= n25);
                            n10 = 1;
                            n25 = 0;
                        }
                    }
                    if (n25 > 0) {
                        n2 = bl ? (n2 += n25) : (n2 -= n25);
                        n10 = 1;
                    }
                    n24 = 0;
                    n25 = 0;
                    List list3 = (List)hashMap.get(CommandButtonDisplayState.SMALL);
                    if (list3 != null) {
                        for (AbstractCommandButton abstractCommandButton : list3) {
                            n7 = abstractCommandButton.getPreferredSize().width;
                            n25 = Math.max(n25, n7);
                            if (n10 != 0 && n24 == 0) {
                                n2 = bl ? (n2 += n) : (n2 -= n);
                            }
                            n6 = (n23 + n8) * n24;
                            n5 = (n23 + n8) * (n24 + 1) - n8;
                            if (bl) {
                                abstractCommandButton.setBounds(n2, insets.top + n6, n7, n5 - n6);
                            } else {
                                abstractCommandButton.setBounds(n2 - n7, insets.top + n6, n7, n5 - n6);
                            }
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.topRow", n24 == 0);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.midRow", n24 == 1);
                            abstractCommandButton.putClientProperty("flamingo.internal.ribbonBandControlPanel.bottomRow", n24 == 2);
                            if (++n24 != 3) continue;
                            n24 = 0;
                            n2 = bl ? (n2 += n25) : (n2 -= n25);
                            n10 = 1;
                            n25 = 0;
                        }
                    }
                    if (n24 < 3 && n25 > 0) {
                        n2 = bl ? (n2 += n25) : (n2 -= n25);
                        n10 = 1;
                    }
                }
                n2 = bl ? (n2 += n * 3 / 2) : (n2 -= n * 3 / 2);
                ++n4;
            }
        }
    }
}

