/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.label.GoodsLabel;
import net.sf.freecol.client.gui.label.UnitLabel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.CollectionUtils;

public abstract class ReportUnitPanel
extends ReportPanel {
    private static final Comparator<Location> locationComparator = new Comparator<Location>(){

        @Override
        public int compare(Location l1, Location l2) {
            return l1.getId().compareTo(l2.getId());
        }
    };
    private static final Comparator<AbstractUnit> auComparator = Comparator.comparingInt(AbstractUnit::getNumber).reversed();
    private final Map<Location, List<Unit>> where = new HashMap<Location, List<Unit>>();
    private final List<AbstractUnit> reportables = new ArrayList<AbstractUnit>();
    private final List<AbstractUnit> reportableREF = new ArrayList<AbstractUnit>();
    private final List<Location> orderedLocations = new ArrayList<Location>();
    private boolean showColonies = false;

    protected ReportUnitPanel(FreeColClient freeColClient, String key, boolean showColonies) {
        super(freeColClient, key);
        this.reportPanel.setLayout(new MigLayout("fillx, wrap 12", "", ""));
        this.showColonies = showColonies;
        this.gatherData();
        this.display();
    }

    private final void gatherData() {
        Player player = this.getMyPlayer();
        for (Unit unit : CollectionUtils.transform(player.getUnits(), u -> this.isReportable((Unit)u))) {
            CollectionUtils.appendToMapList(this.where, unit.getLocation().up(), unit);
            AbstractUnit au = CollectionUtils.find(this.reportables, AbstractUnit.matcher(unit));
            if (au == null) {
                this.reportables.add(new AbstractUnit(unit.getType(), unit.getRole().getId(), 1));
                continue;
            }
            au.addToNumber(1);
        }
        this.reportables.sort(auComparator);
        List<AbstractUnit> refUnits = player.getREFUnits();
        if (refUnits != null) {
            for (AbstractUnit au : refUnits) {
                if (!this.isReportableREF(au)) continue;
                this.reportableREF.add(au);
            }
        }
        this.reportableREF.sort(auComparator);
        this.orderedLocations.addAll(CollectionUtils.transform(this.where.keySet(), l -> !(l instanceof Colony) && !(l instanceof Europe), Function.identity(), locationComparator));
        Europe europe = player.getEurope();
        if (europe != null) {
            this.orderedLocations.add(0, europe);
        }
        List<Colony> colonies = player.getSortedColonies(this.getClientOptions().getColonyComparator());
        this.orderedLocations.addAll(0, colonies);
    }

    private final void display() {
        Player player = this.getMyPlayer();
        if (!this.reportableREF.isEmpty()) {
            Nation refNation = player.getNation().getREFNation();
            this.reportPanel.add((Component)new JLabel(Messages.getName(refNation)), "span, split 2");
            this.reportPanel.add((Component)new JSeparator(0), "growx");
            for (AbstractUnit au : this.reportableREF) {
                this.reportPanel.add((Component)this.createUnitTypeLabel(au), "sg");
            }
        }
        this.reportPanel.add((Component)Utility.localizedLabel(player.getForcesLabel()), "newline, span, split 2");
        this.reportPanel.add((Component)new JSeparator(0), "growx");
        for (AbstractUnit au : this.reportables) {
            if (au.getNumber() <= 0) continue;
            this.reportPanel.add((Component)this.createUnitTypeLabel(au), "sg");
        }
        for (Location loc : this.orderedLocations) {
            List<Unit> present = this.where.get(loc);
            present = present == null ? Collections.emptyList() : CollectionUtils.sort(present, Unit.typeRoleComparator);
            if (!this.showColonies && present.isEmpty()) continue;
            String locName = Messages.message(loc.getLocationLabelFor(player));
            JButton button = Utility.getLinkButton(locName, null, loc.getId());
            button.addActionListener(this);
            this.reportPanel.add((Component)button, "newline, span, split 2");
            this.reportPanel.add((Component)new JSeparator(0), "growx");
            if (present.isEmpty()) {
                this.reportPanel.add((Component)Utility.localizedLabel("none"), "sg");
                continue;
            }
            FreeColClient fcc = this.getFreeColClient();
            for (Unit u : CollectionUtils.sort(present, Unit.typeRoleComparator)) {
                JButton unitButton = this.getUnitButton(u);
                if (u.isCarrier()) {
                    this.reportPanel.add((Component)unitButton, "newline, sg");
                    for (Goods goods : u.getGoodsList()) {
                        GoodsLabel goodsLabel = new GoodsLabel(fcc, goods);
                        this.reportPanel.add(goodsLabel);
                    }
                    for (Unit unitLoaded : u.getUnitList()) {
                        UnitLabel unitLoadedLabel = new UnitLabel(fcc, unitLoaded, true);
                        this.reportPanel.add(unitLoadedLabel);
                    }
                    continue;
                }
                this.reportPanel.add((Component)unitButton, "sg");
            }
        }
        this.revalidate();
        this.repaint();
    }

    private JButton getUnitButton(Unit unit) {
        ImageIcon icon = new ImageIcon(this.getImageLibrary().getScaledUnitImage(unit));
        JButton button = Utility.getLinkButton("", icon, unit.getLocation().up().getId());
        button.addActionListener(this);
        Object tip = StringTemplate.label("\n").addStringTemplate(unit.getLabel());
        if (unit.getDestination() != null) {
            ((StringTemplate)tip).addStringTemplate(unit.getDestinationLabel());
        }
        Utility.localizeToolTip((JComponent)button, tip);
        return button;
    }

    protected abstract boolean isReportable(Unit var1);

    protected abstract boolean isReportable(UnitType var1, Role var2);

    protected abstract boolean isReportableREF(AbstractUnit var1);
}

