/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.EPUBProfile;
import com.adobe.epubcheck.api.FeatureReport;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.MappingDocumentChecker;
import com.adobe.epubcheck.ocf.OCFCheckerState;
import com.adobe.epubcheck.ocf.OCFContainer;
import com.adobe.epubcheck.ocf.OCFContainerFileChecker;
import com.adobe.epubcheck.ocf.OCFEncryptionFileChecker;
import com.adobe.epubcheck.ocf.OCFExtensionChecker;
import com.adobe.epubcheck.ocf.OCFFilenameChecker;
import com.adobe.epubcheck.ocf.OCFMetaFile;
import com.adobe.epubcheck.ocf.OCFMetaFileChecker;
import com.adobe.epubcheck.ocf.OCFResource;
import com.adobe.epubcheck.ocf.OCFZipChecker;
import com.adobe.epubcheck.ocf.OCFZipResources;
import com.adobe.epubcheck.ocf.PackageDocumentPeeker;
import com.adobe.epubcheck.opf.OPFChecker;
import com.adobe.epubcheck.opf.OPFChecker30;
import com.adobe.epubcheck.opf.OPFHandler;
import com.adobe.epubcheck.opf.OPFHandler30;
import com.adobe.epubcheck.opf.OPFItem;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.CheckUtil;
import com.adobe.epubcheck.util.EPUBVersion;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.vocab.EpubCheckVocab;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import io.mola.galimatias.URL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.w3c.epubcheck.constants.MIMEType;
import org.w3c.epubcheck.core.AbstractChecker;
import org.w3c.epubcheck.core.Checker;
import org.w3c.epubcheck.core.CheckerFactory;
import org.w3c.epubcheck.util.text.UnicodeUtils;

public final class OCFChecker
extends AbstractChecker {
    public OCFChecker(ValidationContext context) {
        super(context);
        Preconditions.checkArgument((boolean)MIMEType.EPUB.is(context.mimeType));
    }

    @Override
    public void check() {
        OCFCheckerState state = new OCFCheckerState(this.context);
        this.checkZipFile();
        if (!this.checkContainerStructure(state)) {
            return;
        }
        OCFContainer container = state.getContainer();
        this.checkMimetypeFile(state);
        if (!this.checkContainerFile(state)) {
            return;
        }
        List<URL> packageDocs = state.getPackageDocuments();
        if (!this.checkDeclaredPackageDocuments(state)) {
            return;
        }
        final EPUBVersion validationVersion = this.checkPublicationVersion(state);
        state.setVersion(validationVersion);
        state.setProfile(this.checkPublicationProfile(state, validationVersion));
        if (validationVersion == EPUBVersion.VERSION_2 && packageDocs.size() > 1) {
            this.report.message(MessageId.PKG_013, OCFMetaFile.CONTAINER.asLocation(container), new Object[0]);
        }
        if (validationVersion == EPUBVersion.VERSION_3 && packageDocs.size() > 1) {
            state.addProperty(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.MULTIPLE_RENDITION));
            if (!OCFMetaFile.METADATA.isPresent(container)) {
                this.report.message(MessageId.RSC_019, EPUBLocation.of(this.context), new Object[0]);
            }
            if (state.getMappingDocument().isPresent()) {
                new MappingDocumentChecker(state.context().mimetype("application/xhtml+xml").url(state.getMappingDocument().get()).addProperty(EpubCheckVocab.VOCAB.get(EpubCheckVocab.PROPERTIES.RENDITION_MAPPING)).build()).check();
            }
        }
        this.checkEncryptionFile(state);
        this.checkOtherMetaFiles(state);
        container = state.getContainer();
        LinkedList<OPFHandler> opfHandlers = new LinkedList<OPFHandler>();
        for (URL packageDoc : packageDocs) {
            ValidationContext.ValidationContextBuilder opfContext = state.context().url(packageDoc).mimetype(MIMEType.PACKAGE_DOC.toString()).featureReport(new FeatureReport());
            opfContext.container(container);
            opfContext.pubTypes(state.getPublicationTypes(packageDoc));
            Checker opfChecker = CheckerFactory.newChecker(opfContext.build());
            assert (opfChecker instanceof OPFChecker);
            opfChecker.check();
            opfHandlers.add(((OPFChecker)opfChecker).getOPFHandler());
        }
        block1: for (final URL resource : container.getResources()) {
            String path = resource.path().substring(1);
            if (!(path.startsWith("META-INF/") || path.startsWith("META-INF\\") || path.equals("mimetype") || state.isDeclared(resource) || Iterables.tryFind(opfHandlers, (Predicate)new Predicate<OPFHandler>(){

                public boolean apply(OPFHandler opfHandler) {
                    return opfHandler.getItemByURL(resource).isPresent() || validationVersion == EPUBVersion.VERSION_3 && ((OPFHandler30)opfHandler).getLinkedResources().hasResource(resource);
                }
            }).isPresent())) {
                this.report.message(MessageId.OPF_003, EPUBLocation.of(this.context), path);
            }
            if (!state.isObfuscated(resource)) continue;
            for (OPFHandler opf : opfHandlers) {
                Optional<OPFItem> item = opf.getItemByURL(resource);
                if (!item.isPresent()) continue;
                if (OPFChecker30.isBlessedFontType(((OPFItem)item.get()).getMimeType())) continue block1;
                this.report.message(MessageId.PKG_026, state.getObfuscationLocation(resource), ((OPFItem)item.get()).getMimeType(), opf.getPath());
                continue block1;
            }
        }
        this.checkFileExtension(state);
    }

    private boolean checkContainerFile(OCFCheckerState state) {
        OCFContainer container = state.getContainer();
        if (!OCFMetaFile.CONTAINER.isPresent(container)) {
            if (this.report.getFatalErrorCount() == 0) {
                this.report.message(MessageId.RSC_002, EPUBLocation.of(this.context), new Object[0]);
            }
            return false;
        }
        ValidationContext containerFileContext = state.context().url(OCFMetaFile.CONTAINER.asURL(container)).mimetype("application/xml").build();
        OCFContainerFileChecker containerFileChecker = new OCFContainerFileChecker(containerFileContext, state);
        containerFileChecker.check();
        return true;
    }

    private boolean checkContainerStructure(OCFCheckerState state) {
        try {
            OCFZipResources resourcesProvider = new OCFZipResources(this.context.url);
            HashSet<String> normalizedPaths = new HashSet<String>();
            LinkedList<String> filePaths = new LinkedList<String>();
            LinkedList<String> directoryPaths = new LinkedList<String>();
            for (OCFResource resource : resourcesProvider) {
                Preconditions.checkNotNull((Object)resource.getPath());
                Preconditions.checkNotNull(resource.getProperties());
                if (resource.isDirectory()) {
                    directoryPaths.add(resource.getPath());
                    continue;
                }
                filePaths.add(resource.getPath());
                String normalizedPath = UnicodeUtils.canonicalCaseFold(resource.getPath());
                if (normalizedPaths.contains(normalizedPath)) {
                    this.context.report.message(MessageId.OPF_060, EPUBLocation.of(this.context), resource.getPath());
                } else {
                    normalizedPaths.add(normalizedPath);
                }
                new OCFFilenameChecker(resource.getPath(), state.context().build()).check();
                this.reportFeatures(resource);
                state.addResource(resource);
            }
            for (String directoryPath : directoryPaths) {
                boolean hasContents = false;
                for (String filePath : filePaths) {
                    if (!filePath.startsWith(directoryPath)) continue;
                    hasContents = true;
                    break;
                }
                if (hasContents) continue;
                this.report.message(MessageId.PKG_014, EPUBLocation.of(this.context), directoryPath);
            }
            return true;
        }
        catch (Exception e) {
            switch (e.getMessage()) {
                case "invalid CEN header (bad entry name)": 
                case "MALFORMED": {
                    this.report.message(MessageId.PKG_027, EPUBLocation.of(this.context), e.getLocalizedMessage());
                    break;
                }
                default: {
                    this.report.message(MessageId.PKG_008, EPUBLocation.of(this.context), e.getLocalizedMessage());
                }
            }
            return false;
        }
    }

    private boolean checkDeclaredPackageDocuments(OCFCheckerState state) {
        List<URL> packageDocs = state.getPackageDocuments();
        OCFContainer container = state.getContainer();
        if (packageDocs.isEmpty()) {
            this.report.message(MessageId.RSC_003, OCFMetaFile.CONTAINER.asLocation(container), new Object[0]);
            return false;
        }
        if (packageDocs.size() > 1) {
            this.report.info(null, FeatureEnum.EPUB_RENDITIONS_COUNT, Integer.toString(packageDocs.size()));
        }
        boolean isPrimary = true;
        for (URL packageDoc : packageDocs) {
            if (!container.contains(packageDoc)) {
                this.report.message(MessageId.OPF_002, OCFMetaFile.CONTAINER.asLocation(container), packageDoc);
                return false;
            }
            ValidationContext packageDocContext = state.context().url(packageDoc).mimetype("").build();
            PackageDocumentPeeker peeker = new PackageDocumentPeeker(packageDocContext, state);
            peeker.peek();
            if (!state.getError().isEmpty()) {
                this.context.report.message(MessageId.OPF_001, EPUBLocation.of(packageDocContext), state.getError());
                if (isPrimary) {
                    return false;
                }
            } else if (state.getPublicationVersion(packageDoc) == EPUBVersion.Unknown) {
                this.context.report.message(MessageId.OPF_001, EPUBLocation.of(packageDocContext), "Version not found");
            }
            isPrimary = false;
        }
        return true;
    }

    private void checkEncryptionFile(OCFCheckerState state) {
        OCFContainer container = state.getContainer();
        if (OCFMetaFile.ENCRYPTION.isPresent(container)) {
            this.report.info(null, FeatureEnum.HAS_ENCRYPTION, OCFMetaFile.ENCRYPTION.asPath());
            ValidationContext encryptionFileContext = state.context().url(OCFMetaFile.ENCRYPTION.asURL(container)).mimetype("application/xml").build();
            OCFEncryptionFileChecker checker = new OCFEncryptionFileChecker(encryptionFileContext, state);
            checker.check();
        }
    }

    private void checkZipFile() {
        File packageFile = new File(this.context.path);
        if (packageFile.isFile()) {
            new OCFZipChecker(this.context).check();
        }
    }

    private void checkFileExtension(OCFCheckerState state) {
        File packageFile = new File(this.context.path);
        if (packageFile.isFile()) {
            new OCFExtensionChecker(state.context().build()).check();
        }
    }

    private void checkMimetypeFile(OCFCheckerState state) {
        OCFContainer container = state.getContainer();
        if (OCFMetaFile.MIMETYPE.isPresent(container)) {
            try (InputStream is = container.openStream(OCFMetaFile.MIMETYPE.asURL(container));){
                StringBuilder sb = new StringBuilder(2048);
                if (!CheckUtil.checkTrailingSpaces(is, sb)) {
                    this.report.message(MessageId.PKG_007, OCFMetaFile.MIMETYPE.asLocation(container), new Object[0]);
                }
                if (sb.length() != 0) {
                    this.report.info(null, FeatureEnum.FORMAT_NAME, sb.toString().trim());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void checkOtherMetaFiles(OCFCheckerState state) {
        assert (state.getContainer() != null);
        OCFContainer container = state.getContainer();
        if (OCFMetaFile.CONTAINER.isPresent(container)) {
            new OCFMetaFileChecker(state.context().url(OCFMetaFile.CONTAINER.asURL(container)).mimetype("application/xml").build()).check();
        }
        if (OCFMetaFile.METADATA.isPresent(container)) {
            new OCFMetaFileChecker(state.context().url(OCFMetaFile.METADATA.asURL(container)).mimetype("application/xml").build()).check();
        }
        if (OCFMetaFile.SIGNATURES.isPresent(container)) {
            new OCFMetaFileChecker(state.context().url(OCFMetaFile.SIGNATURES.asURL(container)).mimetype("application/xml").build()).check();
            this.report.info(null, FeatureEnum.HAS_SIGNATURES, OCFMetaFile.SIGNATURES.asPath());
        }
    }

    private EPUBProfile checkPublicationProfile(OCFCheckerState state, EPUBVersion validationVersion) {
        assert (state.getContainer() != null);
        assert (!state.getPackageDocuments().isEmpty());
        switch (validationVersion) {
            case VERSION_2: {
                if (this.context.profile != EPUBProfile.DEFAULT) {
                    this.report.message(MessageId.PKG_023, EPUBLocation.of(state.getPackageDocuments().get(0), state.getContainer()), new Object[0]);
                }
                return EPUBProfile.DEFAULT;
            }
            case VERSION_3: {
                EPUBProfile checkedProfile = this.context.profile.makeTypeCompatible(state.getPublicationTypes());
                if (checkedProfile != this.context.profile) {
                    this.report.message(MessageId.OPF_064, EPUBLocation.of(state.getPackageDocuments().get(0), state.getContainer()), new Object[]{checkedProfile.matchingType(), checkedProfile});
                }
                return checkedProfile;
            }
        }
        throw new IllegalStateException();
    }

    private EPUBVersion checkPublicationVersion(OCFCheckerState state) {
        Preconditions.checkState((!state.getPackageDocuments().isEmpty() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)state.getPublicationVersion().isPresent());
        EPUBVersion detectedVersion = state.getPublicationVersion().get();
        this.report.info(null, FeatureEnum.FORMAT_VERSION, detectedVersion.toString());
        if (this.context.version != detectedVersion && this.context.version != EPUBVersion.Unknown) {
            this.report.message(MessageId.PKG_001, EPUBLocation.of(state.getPackageDocuments().get(0), state.getContainer()), new Object[]{this.context.version, detectedVersion});
            return this.context.version;
        }
        return detectedVersion;
    }

    private void reportFeatures(OCFResource resource) {
        for (FeatureEnum feature : resource.getProperties().keySet()) {
            this.report.info(resource.getPath(), feature, resource.getProperties().get((Object)feature));
        }
    }
}

