/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.converter;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.expr.Exprs;
import com.googlecode.dex2jar.ir.expr.InvokeExpr;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class J2IRConverter
implements Opcodes {
    public static final com.googlecode.dex2jar.ir.expr.Value PLACEHOLDER = Exprs.nByte((byte)0);
    Map<Label, LabelStmt> map = new HashMap<Label, LabelStmt>();

    public static String[] toDescArray(Type[] ts) {
        String[] ds = new String[ts.length];
        int i = 0;
        while (i < ts.length) {
            ds[i] = ts[i].getDescriptor();
            ++i;
        }
        return ds;
    }

    LabelStmt getLabel(LabelNode labelNode) {
        Label label = labelNode.getLabel();
        LabelStmt ls = this.map.get(label);
        if (ls == null) {
            ls = Stmts.nLabel();
            this.map.put(label, ls);
        }
        return ls;
    }

    public IrMethod convert(String owner, MethodNode source) {
        Frame[] frames;
        IrMethod target = this.populate(owner, source);
        if (source.instructions.size() == 0) {
            return target;
        }
        for (TryCatchBlockNode tc : source.tryCatchBlocks) {
            target.traps.add(new Trap(this.getLabel(tc.start), this.getLabel(tc.end), new LabelStmt[]{this.getLabel(tc.handler)}, new String[]{tc.type}));
        }
        Analyzer an = new Analyzer((Interpreter)new BasicInterpreter());
        try {
            frames = an.analyze(owner, source);
        }
        catch (AnalyzerException ex) {
            throw new RuntimeException(ex);
        }
        final com.googlecode.dex2jar.ir.expr.Value[] values = new com.googlecode.dex2jar.ir.expr.Value[source.maxLocals + source.maxStack];
        int i = 0;
        while (i < values.length) {
            Local local = Exprs.nLocal((String)("a" + i));
            target.locals.add(local);
            values[i] = local;
            ++i;
        }
        int x = 0;
        final StmtList stmts = target.stmts;
        if (!target.isStatic) {
            stmts.add((Stmt)Stmts.nIdentity((com.googlecode.dex2jar.ir.expr.Value)values[x++], (com.googlecode.dex2jar.ir.expr.Value)Exprs.nThisRef((String)target.owner)));
        }
        int i2 = 0;
        while (i2 < target.args.length) {
            stmts.add((Stmt)Stmts.nIdentity((com.googlecode.dex2jar.ir.expr.Value)values[x++], (com.googlecode.dex2jar.ir.expr.Value)Exprs.nParameterRef((String)target.args[i2], (int)i2)));
            ++i2;
        }
        Local voidLocal = Exprs.nLocal((String)"ignore");
        target.locals.add(voidLocal);
        Frame fx = new Frame(source.maxLocals, source.maxStack){

            public XValue pop() throws IndexOutOfBoundsException {
                Value v = super.pop();
                int top = super.getStackSize();
                return new XValue(v.getSize(), values[top + super.getLocals()]);
            }

            public Value getStack(int i) throws IndexOutOfBoundsException {
                Value v = super.getStack(i);
                return new XValue(v.getSize(), values[i + super.getLocals()]);
            }

            public XValue getLocal(int i) throws IndexOutOfBoundsException {
                Value v = super.getLocal(i);
                return new XValue(v.getSize(), values[i]);
            }

            public void execute(AbstractInsnNode insn, Interpreter interpreter) throws AnalyzerException {
                switch (insn.getOpcode()) {
                    case 90: {
                        int stack = this.getStackSize() + this.getLocals();
                        com.googlecode.dex2jar.ir.expr.Value A = values[stack - 2];
                        com.googlecode.dex2jar.ir.expr.Value B = values[stack - 1];
                        com.googlecode.dex2jar.ir.expr.Value C = values[stack - 0];
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)C, (com.googlecode.dex2jar.ir.expr.Value)B));
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)B, (com.googlecode.dex2jar.ir.expr.Value)A));
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)A, (com.googlecode.dex2jar.ir.expr.Value)C));
                        return;
                    }
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: {
                        throw new RuntimeException("not support opcode" + insn.getOpcode());
                    }
                }
                super.execute(insn, interpreter);
            }

            public void setLocal(int i, Value value) throws IndexOutOfBoundsException {
                com.googlecode.dex2jar.ir.expr.Value v = ((XValue)value).value;
                if (v != PLACEHOLDER) {
                    stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)values[i], (com.googlecode.dex2jar.ir.expr.Value)v));
                }
            }

            public void push(Value v) throws IndexOutOfBoundsException {
                int top = super.getStackSize();
                stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)values[top + super.getLocals()], (com.googlecode.dex2jar.ir.expr.Value)((XValue)v).value));
                super.push(v);
            }

            public String toString() {
                return "[Frame]";
            }
        };
        Interpreter<XValue> interpreter = new Interpreter<XValue>(262144){

            public XValue newValue(Type type) {
                return new XValue(1, PLACEHOLDER);
            }

            public XValue newOperation(AbstractInsnNode insn) throws AnalyzerException {
                switch (insn.getOpcode()) {
                    case 1: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNull());
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)(insn.getOpcode() - 3)));
                    }
                    case 9: 
                    case 10: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nLong((long)(insn.getOpcode() - 9)));
                    }
                    case 11: 
                    case 12: 
                    case 13: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nFloat((float)(insn.getOpcode() - 11)));
                    }
                    case 14: 
                    case 15: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDouble((double)(insn.getOpcode() - 14)));
                    }
                    case 16: 
                    case 17: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)((IntInsnNode)insn).operand));
                    }
                    case 18: {
                        Object cst = ((LdcInsnNode)insn).cst;
                        if (cst instanceof Integer) {
                            return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)((Integer)cst)));
                        }
                        if (cst instanceof Float) {
                            return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nFloat((float)((Float)cst).floatValue()));
                        }
                        if (cst instanceof Long) {
                            return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nLong((long)((Long)cst)));
                        }
                        if (cst instanceof Double) {
                            return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDouble((double)((Double)cst)));
                        }
                        if (cst instanceof String) {
                            return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nString((String)((String)cst)));
                        }
                        if (cst instanceof Type) {
                            Type type = (Type)cst;
                            int sort = type.getSort();
                            if (sort == 10 || sort == 9) {
                                return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nType((String)type.getDescriptor()));
                            }
                            if (sort == 11) {
                                throw new UnsupportedOperationException("Not supported yet.");
                            }
                            throw new IllegalArgumentException("Illegal LDC constant " + cst);
                        }
                        if (cst instanceof Handle) {
                            throw new UnsupportedOperationException("Not supported yet.");
                        }
                        throw new IllegalArgumentException("Illegal LDC constant " + cst);
                    }
                    case 168: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                    case 178: {
                        FieldInsnNode fin = (FieldInsnNode)insn;
                        return new XValue(Type.getType((String)fin.desc).getSize(), (com.googlecode.dex2jar.ir.expr.Value)Exprs.nStaticField((String)("L" + fin.owner + ";"), (String)fin.name, (String)fin.desc));
                    }
                    case 187: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNew((String)("L" + ((TypeInsnNode)insn).desc + ";")));
                    }
                }
                throw new Error("Internal error.");
            }

            public XValue copyOperation(AbstractInsnNode insn, XValue value) throws AnalyzerException {
                return value;
            }

            public XValue unaryOperation(AbstractInsnNode insn, XValue value0) throws AnalyzerException {
                XValue value = value0;
                switch (insn.getOpcode()) {
                    case 116: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNeg((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"I"));
                    }
                    case 132: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)value.value, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)((IincInsnNode)insn).incr), (String)"I"));
                    }
                    case 136: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"J", (String)"I"));
                    }
                    case 139: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"F", (String)"I"));
                    }
                    case 142: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"D", (String)"I"));
                    }
                    case 145: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"I", (String)"B"));
                    }
                    case 146: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"I", (String)"C"));
                    }
                    case 147: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"I", (String)"S"));
                    }
                    case 118: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNeg((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"F"));
                    }
                    case 134: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"I", (String)"F"));
                    }
                    case 137: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"J", (String)"F"));
                    }
                    case 144: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"D", (String)"F"));
                    }
                    case 117: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNeg((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"J"));
                    }
                    case 133: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"I", (String)"J"));
                    }
                    case 140: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"F", (String)"J"));
                    }
                    case 143: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"D", (String)"J"));
                    }
                    case 119: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNeg((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"D"));
                    }
                    case 135: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"I", (String)"D"));
                    }
                    case 138: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"J", (String)"D"));
                    }
                    case 141: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)"F", (String)"D"));
                    }
                    case 153: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nEq((com.googlecode.dex2jar.ir.expr.Value)value.value, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 154: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nNe((com.googlecode.dex2jar.ir.expr.Value)value.value, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 155: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nLt((com.googlecode.dex2jar.ir.expr.Value)value.value, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 156: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nGe((com.googlecode.dex2jar.ir.expr.Value)value.value, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 157: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nGt((com.googlecode.dex2jar.ir.expr.Value)value.value, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 158: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nLe((com.googlecode.dex2jar.ir.expr.Value)value.value, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInt((int)0), (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 170: {
                        TableSwitchInsnNode ts = (TableSwitchInsnNode)insn;
                        LabelStmt[] targets = new LabelStmt[ts.labels.size()];
                        int i = 0;
                        while (i < ts.labels.size()) {
                            targets[i] = J2IRConverter.this.getLabel((LabelNode)ts.labels.get(i));
                            ++i;
                        }
                        stmts.add((Stmt)Stmts.nTableSwitch((com.googlecode.dex2jar.ir.expr.Value)value.value, (int)ts.min, (LabelStmt[])targets, (LabelStmt)J2IRConverter.this.getLabel(ts.dflt)));
                        return null;
                    }
                    case 171: {
                        LookupSwitchInsnNode ls = (LookupSwitchInsnNode)insn;
                        LabelStmt[] targets = new LabelStmt[ls.labels.size()];
                        int[] lookupValues = new int[ls.labels.size()];
                        int i = 0;
                        while (i < ls.labels.size()) {
                            targets[i] = J2IRConverter.this.getLabel((LabelNode)ls.labels.get(i));
                            lookupValues[i] = (Integer)ls.keys.get(i);
                            ++i;
                        }
                        stmts.add((Stmt)Stmts.nLookupSwitch((com.googlecode.dex2jar.ir.expr.Value)value.value, (int[])lookupValues, (LabelStmt[])targets, (LabelStmt)J2IRConverter.this.getLabel(ls.dflt)));
                        return null;
                    }
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: {
                        stmts.add((Stmt)Stmts.nReturn((com.googlecode.dex2jar.ir.expr.Value)value.value));
                        return null;
                    }
                    case 179: {
                        FieldInsnNode fin = (FieldInsnNode)insn;
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nStaticField((String)("L" + fin.owner + ";"), (String)fin.name, (String)fin.desc), (com.googlecode.dex2jar.ir.expr.Value)value.value));
                        return null;
                    }
                    case 180: {
                        FieldInsnNode fin = (FieldInsnNode)insn;
                        Type fieldType = Type.getType((String)fin.desc);
                        return new XValue(fieldType.getSize(), (com.googlecode.dex2jar.ir.expr.Value)Exprs.nField((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)("L" + fin.owner + ";"), (String)fin.name, (String)fin.desc));
                    }
                    case 188: {
                        switch (((IntInsnNode)insn).operand) {
                            case 4: {
                                return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"Z", (com.googlecode.dex2jar.ir.expr.Value)value.value));
                            }
                            case 5: {
                                return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"C", (com.googlecode.dex2jar.ir.expr.Value)value.value));
                            }
                            case 8: {
                                return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"B", (com.googlecode.dex2jar.ir.expr.Value)value.value));
                            }
                            case 9: {
                                return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"S", (com.googlecode.dex2jar.ir.expr.Value)value.value));
                            }
                            case 10: {
                                return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"I", (com.googlecode.dex2jar.ir.expr.Value)value.value));
                            }
                            case 6: {
                                return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"F", (com.googlecode.dex2jar.ir.expr.Value)value.value));
                            }
                            case 7: {
                                return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"D", (com.googlecode.dex2jar.ir.expr.Value)value.value));
                            }
                            case 11: {
                                return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)"D", (com.googlecode.dex2jar.ir.expr.Value)value.value));
                            }
                        }
                        throw new AnalyzerException(insn, "Invalid array type");
                    }
                    case 189: {
                        String desc = "L" + ((TypeInsnNode)insn).desc + ";";
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNewArray((String)desc, (com.googlecode.dex2jar.ir.expr.Value)value.value));
                    }
                    case 190: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nLength((com.googlecode.dex2jar.ir.expr.Value)value.value));
                    }
                    case 191: {
                        stmts.add((Stmt)Stmts.nThrow((com.googlecode.dex2jar.ir.expr.Value)value.value));
                        return null;
                    }
                    case 192: {
                        String desc = "L" + ((TypeInsnNode)insn).desc + ";";
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nCheckCast((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)desc));
                    }
                    case 193: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nInstanceOf((com.googlecode.dex2jar.ir.expr.Value)value.value, (String)("L" + ((TypeInsnNode)insn).desc + ";")));
                    }
                    case 194: {
                        stmts.add((Stmt)Stmts.nLock((com.googlecode.dex2jar.ir.expr.Value)value.value));
                        return null;
                    }
                    case 195: {
                        stmts.add((Stmt)Stmts.nUnLock((com.googlecode.dex2jar.ir.expr.Value)value.value));
                        return null;
                    }
                    case 198: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nEq((com.googlecode.dex2jar.ir.expr.Value)value.value, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNull(), (String)"L"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 199: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nNe((com.googlecode.dex2jar.ir.expr.Value)value.value, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nNull(), (String)"L"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                }
                throw new Error("Internal error.");
            }

            public XValue binaryOperation(AbstractInsnNode insn, XValue value10, XValue value20) throws AnalyzerException {
                XValue value1 = value10;
                XValue value2 = value20;
                switch (insn.getOpcode()) {
                    case 46: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 51: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"B"));
                    }
                    case 52: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"C"));
                    }
                    case 53: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"S"));
                    }
                    case 48: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"F"));
                    }
                    case 50: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"L"));
                    }
                    case 49: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"D"));
                    }
                    case 47: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 96: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 100: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nSub((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 104: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nMul((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 108: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDiv((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 112: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nRem((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 120: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nShl((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 122: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nShr((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 124: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nUshr((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 126: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAnd((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 128: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nOr((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 130: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nXor((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"));
                    }
                    case 98: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"F"));
                    }
                    case 102: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nSub((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"F"));
                    }
                    case 106: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nMul((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"F"));
                    }
                    case 110: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDiv((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"F"));
                    }
                    case 114: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nRem((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"F"));
                    }
                    case 97: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 101: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nSub((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 105: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nMul((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 109: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDiv((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 113: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nRem((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 121: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nShl((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 123: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nShr((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 125: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nUshr((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 127: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAnd((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 129: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nOr((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 131: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nXor((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"));
                    }
                    case 99: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nAdd((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"D"));
                    }
                    case 103: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nSub((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"D"));
                    }
                    case 107: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nMul((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"D"));
                    }
                    case 111: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDiv((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"D"));
                    }
                    case 115: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nRem((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"D"));
                    }
                    case 148: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nLCmp((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value));
                    }
                    case 149: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nFCmpl((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value));
                    }
                    case 150: {
                        return new XValue(1, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nFCmpg((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value));
                    }
                    case 151: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDCmpl((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value));
                    }
                    case 152: {
                        return new XValue(2, (com.googlecode.dex2jar.ir.expr.Value)Exprs.nDCmpg((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value));
                    }
                    case 159: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nEq((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 160: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nNe((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 161: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nLt((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 162: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nGe((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 163: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nGt((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 164: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nLe((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 165: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nEq((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"L"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 166: {
                        stmts.add((Stmt)Stmts.nIf((com.googlecode.dex2jar.ir.expr.Value)Exprs.nNe((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"L"), (LabelStmt)J2IRConverter.this.getLabel(((JumpInsnNode)insn).label)));
                        return null;
                    }
                    case 181: {
                        FieldInsnNode fin = (FieldInsnNode)insn;
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nField((com.googlecode.dex2jar.ir.expr.Value)value1.value, (String)("L" + fin.owner + ";"), (String)fin.name, (String)fin.desc), (com.googlecode.dex2jar.ir.expr.Value)value2.value));
                        return null;
                    }
                }
                throw new Error("Internal error.");
            }

            public XValue ternaryOperation(AbstractInsnNode insn, XValue value1, XValue value2, XValue value3) throws AnalyzerException {
                switch (insn.getOpcode()) {
                    case 79: {
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"I"), (com.googlecode.dex2jar.ir.expr.Value)value3.value));
                        break;
                    }
                    case 80: {
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"J"), (com.googlecode.dex2jar.ir.expr.Value)value3.value));
                        break;
                    }
                    case 81: {
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"F"), (com.googlecode.dex2jar.ir.expr.Value)value3.value));
                        break;
                    }
                    case 82: {
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"D"), (com.googlecode.dex2jar.ir.expr.Value)value3.value));
                        break;
                    }
                    case 83: {
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"L"), (com.googlecode.dex2jar.ir.expr.Value)value3.value));
                        break;
                    }
                    case 84: {
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"B"), (com.googlecode.dex2jar.ir.expr.Value)value3.value));
                        break;
                    }
                    case 85: {
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"C"), (com.googlecode.dex2jar.ir.expr.Value)value3.value));
                        break;
                    }
                    case 86: {
                        stmts.add((Stmt)Stmts.nAssign((com.googlecode.dex2jar.ir.expr.Value)Exprs.nArray((com.googlecode.dex2jar.ir.expr.Value)value1.value, (com.googlecode.dex2jar.ir.expr.Value)value2.value, (String)"S"), (com.googlecode.dex2jar.ir.expr.Value)value3.value));
                    }
                }
                return null;
            }

            public XValue naryOperation(AbstractInsnNode insn, List xvalues) throws AnalyzerException {
                com.googlecode.dex2jar.ir.expr.Value[] values = new com.googlecode.dex2jar.ir.expr.Value[xvalues.size()];
                int i = 0;
                while (i < xvalues.size()) {
                    values[i] = ((XValue)xvalues.get((int)i)).value;
                    ++i;
                }
                if (insn.getOpcode() == 197) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }
                MethodInsnNode mi = (MethodInsnNode)insn;
                InvokeExpr v = null;
                String ret = Type.getReturnType((String)mi.desc).getDescriptor();
                String owner = "L" + mi.owner + ";";
                String[] ps = J2IRConverter.toDescArray(Type.getArgumentTypes((String)mi.desc));
                switch (insn.getOpcode()) {
                    case 182: {
                        v = Exprs.nInvokeVirtual((com.googlecode.dex2jar.ir.expr.Value[])values, (String)owner, (String)mi.name, (String[])ps, (String)ret);
                        break;
                    }
                    case 183: {
                        v = Exprs.nInvokeSpecial((com.googlecode.dex2jar.ir.expr.Value[])values, (String)owner, (String)mi.name, (String[])ps, (String)ret);
                        break;
                    }
                    case 184: {
                        v = Exprs.nInvokeStatic((com.googlecode.dex2jar.ir.expr.Value[])values, (String)owner, (String)mi.name, (String[])ps, (String)ret);
                        break;
                    }
                    case 185: {
                        v = Exprs.nInvokeInterface((com.googlecode.dex2jar.ir.expr.Value[])values, (String)owner, (String)mi.name, (String[])ps, (String)ret);
                        break;
                    }
                    case 186: {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                }
                if ("V".equals(ret)) {
                    stmts.add((Stmt)Stmts.nVoidInvoke((com.googlecode.dex2jar.ir.expr.Value)v));
                    return null;
                }
                return new XValue(Type.getReturnType((String)mi.desc).getSize(), (com.googlecode.dex2jar.ir.expr.Value)v);
            }

            public XValue merge(XValue v, XValue w) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            public void returnOperation(AbstractInsnNode insn, XValue value, XValue expected) throws AnalyzerException {
                stmts.add((Stmt)Stmts.nReturn((com.googlecode.dex2jar.ir.expr.Value)value.value));
            }
        };
        AbstractInsnNode p = source.instructions.getFirst();
        while (p != null) {
            if (p.getType() == 8) {
                stmts.add((Stmt)this.getLabel((LabelNode)p));
            } else if (p.getOpcode() == 167) {
                stmts.add((Stmt)Stmts.nGoto((LabelStmt)this.getLabel(((JumpInsnNode)p).label)));
            } else if (p.getOpcode() == 177) {
                stmts.add((Stmt)Stmts.nReturnVoid());
            } else {
                fx.init(frames[source.instructions.indexOf(p)]);
                fx.setReturn(null);
                try {
                    fx.execute(p, (Interpreter)interpreter);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            p = p.getNext();
        }
        return target;
    }

    private IrMethod populate(String owner, MethodNode source) {
        IrMethod target = new IrMethod();
        target.name = source.name;
        target.owner = "L" + owner + ";";
        target.ret = Type.getReturnType((String)source.desc).getDescriptor();
        Type[] args = Type.getArgumentTypes((String)source.desc);
        String[] sArgs = new String[args.length];
        target.args = sArgs;
        int i = 0;
        while (i < args.length) {
            sArgs[i] = args[i].getDescriptor();
            ++i;
        }
        target.isStatic = (source.access & 8) != 0;
        return target;
    }

    static class XValue
    implements Value {
        public com.googlecode.dex2jar.ir.expr.Value value;
        int size;

        public XValue(int size, com.googlecode.dex2jar.ir.expr.Value value) {
            this.size = size;
            this.value = value;
        }

        public int getSize() {
            return this.size;
        }
    }
}

