"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "EuiText", {
  enumerable: true,
  get: function get() {
    return _text.EuiText;
  }
});
exports.OuiText = exports.TEXT_SIZES = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _common = require("../common");

var _text_color = require("./text_color");

var _text_align = require("./text_align");

var _text = require("../../eui_components/text/text");

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var textSizeToClassNameMap = {
  xs: 'ouiText--extraSmall',
  s: 'ouiText--small',
  m: 'ouiText--medium'
};
var TEXT_SIZES = (0, _common.keysOf)(textSizeToClassNameMap);
exports.TEXT_SIZES = TEXT_SIZES;

var OuiText = function OuiText(_ref) {
  var _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'm' : _ref$size,
      color = _ref.color,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      textAlign = _ref.textAlign,
      children = _ref.children,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["size", "color", "grow", "textAlign", "children", "className"]);
  var classes = (0, _classnames.default)('ouiText', textSizeToClassNameMap[size], className, {
    'ouiText--constrainedWidth': !grow
  });
  var optionallyAlteredText;

  if (color) {
    optionallyAlteredText = /*#__PURE__*/_react.default.createElement(_text_color.OuiTextColor, {
      color: color,
      component: "div"
    }, children);
  }

  if (textAlign) {
    optionallyAlteredText = /*#__PURE__*/_react.default.createElement(_text_align.OuiTextAlign, {
      textAlign: textAlign
    }, optionallyAlteredText || children);
  }

  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), optionallyAlteredText || children);
};
/* OUI -> EUI Aliases: Build-Time */


exports.OuiText = OuiText;
OuiText.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  textAlign: _propTypes.default.oneOf(["left", "right", "center"]),
  size: _propTypes.default.oneOf(["xs", "s", "m"]),

  /**
       * **`secondary` color is DEPRECATED, use `success` instead**
       */
  color: _propTypes.default.oneOf(["default", "subdued", "secondary", "success", "accent", "danger", "warning", "ghost"]),
  grow: _propTypes.default.bool
};
/* OUI -> EUI Aliases: Build-Time */