"use strict";
/*
 * Copyright 2020 Palantir Technologies, Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.refHandler = exports.getRef = exports.mergeRefs = exports.combineRefs = exports.setRef = exports.isRefCallback = exports.isRefObject = void 0;
function isRefObject(value) {
    return value != null && typeof value !== "function";
}
exports.isRefObject = isRefObject;
function isRefCallback(value) {
    return typeof value === "function";
}
exports.isRefCallback = isRefCallback;
/**
 * Assign the given ref to a target, either a React ref object or a callback which takes the ref as its first argument.
 */
function setRef(refTarget, ref) {
    if (isRefObject(refTarget)) {
        refTarget.current = ref;
    }
    else if (isRefCallback(refTarget)) {
        refTarget(ref);
    }
}
exports.setRef = setRef;
/** @deprecated use mergeRefs() instead */
function combineRefs(ref1, ref2) {
    return mergeRefs(ref1, ref2);
}
exports.combineRefs = combineRefs;
/**
 * Utility for merging refs into one singular callback ref.
 * If using in a functional component, would recomend using `useMemo` to preserve function identity.
 */
function mergeRefs() {
    var refs = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        refs[_i] = arguments[_i];
    }
    return function (value) {
        refs.forEach(function (ref) {
            setRef(ref, value);
        });
    };
}
exports.mergeRefs = mergeRefs;
function getRef(ref) {
    var _a;
    if (ref === null) {
        return null;
    }
    return (_a = ref.current) !== null && _a !== void 0 ? _a : ref;
}
exports.getRef = getRef;
/**
 * Creates a ref handler which assigns the ref returned by React for a mounted component to a field on the target object.
 * The target object is usually a component class.
 *
 * If provided, it will also update the given `refProp` with the value of the ref.
 */
function refHandler(refTargetParent, refTargetKey, refProp) {
    return function (ref) {
        refTargetParent[refTargetKey] = ref;
        setRef(refProp, ref);
    };
}
exports.refHandler = refHandler;
//# sourceMappingURL=refs.js.map