"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderArea = void 0;
var d3_shape_1 = require("d3-shape");
var curves_1 = require("../../../utils/curves");
var points_1 = require("./points");
var utils_1 = require("./utils");
function renderArea(shift, dataSeries, xScale, yScale, panel, color, curve, hasY0Accessors, xScaleOffset, seriesStyle, markSizeOptions, isStacked, pointStyleAccessor, hasFit) {
    if (isStacked === void 0) { isStacked = false; }
    var y1Fn = utils_1.getY1ScaledValueOrThrowFn(yScale);
    var y0Fn = utils_1.getY0ScaledValueOrThrowFn(yScale);
    var definedFn = utils_1.isYValueDefinedFn(yScale, xScale);
    var y1DatumAccessor = utils_1.getYDatumValueFn();
    var y0DatumAccessor = utils_1.getYDatumValueFn('y0');
    var pathGenerator = d3_shape_1.area()
        .x(function (_a) {
        var x = _a.x;
        return xScale.scaleOrThrow(x) - xScaleOffset;
    })
        .y1(y1Fn)
        .y0(y0Fn)
        .defined(function (datum) {
        return definedFn(datum, y1DatumAccessor) && (hasY0Accessors ? definedFn(datum, y0DatumAccessor) : true);
    })
        .curve(curves_1.getCurveFactory(curve));
    var clippedRanges = utils_1.getClippedRanges(dataSeries.data, xScale, xScaleOffset);
    var y1Line;
    try {
        y1Line = pathGenerator.lineY1()(dataSeries.data);
    }
    catch (_a) {
        y1Line = null;
    }
    var lines = [];
    if (y1Line) {
        lines.push(y1Line);
    }
    if (hasY0Accessors) {
        var y0Line = void 0;
        try {
            y0Line = pathGenerator.lineY0()(dataSeries.data);
        }
        catch (_b) {
            y0Line = null;
        }
        if (y0Line) {
            lines.push(y0Line);
        }
    }
    var _c = points_1.renderPoints(shift - xScaleOffset, dataSeries, xScale, yScale, panel, color, seriesStyle.point, hasY0Accessors, markSizeOptions, pointStyleAccessor, false), pointGeometries = _c.pointGeometries, indexedGeometryMap = _c.indexedGeometryMap;
    var areaPath;
    try {
        areaPath = pathGenerator(dataSeries.data) || '';
    }
    catch (_d) {
        areaPath = '';
    }
    var areaGeometry = {
        area: areaPath,
        lines: lines,
        points: pointGeometries,
        color: color,
        transform: {
            y: 0,
            x: shift,
        },
        seriesIdentifier: {
            key: dataSeries.key,
            specId: dataSeries.specId,
            yAccessor: dataSeries.yAccessor,
            splitAccessors: dataSeries.splitAccessors,
            seriesKeys: dataSeries.seriesKeys,
            smHorizontalAccessorValue: dataSeries.smHorizontalAccessorValue,
            smVerticalAccessorValue: dataSeries.smVerticalAccessorValue,
        },
        seriesAreaStyle: seriesStyle.area,
        seriesAreaLineStyle: seriesStyle.line,
        seriesPointStyle: seriesStyle.point,
        isStacked: isStacked,
        clippedRanges: clippedRanges,
        hideClippedRanges: !hasFit,
    };
    return {
        areaGeometry: areaGeometry,
        indexedGeometryMap: indexedGeometryMap,
    };
}
exports.renderArea = renderArea;
//# sourceMappingURL=area.js.map