/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.shaj;

import com.cenqua.shaj.Authenticator;
import com.cenqua.shaj.Shaj;
import com.cenqua.shaj.log.Log;

public class PAMAuthenticator
extends Authenticator {
    private static final Object GETGRENT_LOCK;

    private static native boolean isSupportedImpl(Log var0);

    private static native boolean checkPasswordImpl(String var0, String var1, String var2, Log var3);

    private static native boolean checkGroupMembershipImpl(String var0, String var1, Log var2);

    public static boolean isSupported() {
        return PAMAuthenticator.isSupported(Log.Factory.getInstance());
    }

    private static boolean isSupported(Log log) {
        if (!Shaj.sInitOkay) {
            return false;
        }
        return PAMAuthenticator.isSupportedImpl(log);
    }

    public boolean checkPassword(String domain, String username, String password, Log log) {
        return PAMAuthenticator.checkPAMPassword(domain, username, password, log);
    }

    public boolean checkGroupMembership(String domain, String username, String group, Log log) {
        return PAMAuthenticator.checkPAMGroupMembership(username, group, log);
    }

    public static boolean checkPAMPassword(String service, String username, String password, Log log) {
        if (service == null) {
            service = "other";
        }
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password cannot be null");
        }
        if (!Shaj.sInitOkay) {
            throw new IllegalStateException("native library not loaded");
        }
        return PAMAuthenticator.checkPasswordImpl(service, username, password, log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkPAMGroupMembership(String username, String group, Log log) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (group == null) {
            throw new IllegalArgumentException("group cannot be null");
        }
        if (!Shaj.sInitOkay) {
            throw new IllegalStateException("native library not loaded");
        }
        Object object = GETGRENT_LOCK;
        synchronized (object) {
            return PAMAuthenticator.checkGroupMembershipImpl(username, group, log);
        }
    }

    static {
        Shaj.init();
        GETGRENT_LOCK = new Object();
    }
}

