/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.searchdemo;

import java.text.BreakIterator;
import java.util.Locale;
import java.util.Vector;
import javax.help.search.SearchEngine;
import javax.help.search.SearchItem;
import javax.help.search.SearchQuery;
import sunw.demo.searchdemo.ClientSearchEngine;
import sunw.demo.searchdemo.Doc;
import sunw.demo.searchdemo.DocVector;
import sunw.demo.searchdemo.Word;
import sunw.demo.searchdemo.WordInventory;
import sunw.demo.searchdemo.WordVector;

public class ClientSearchQuery
extends SearchQuery
implements Runnable {
    private Thread thread = null;
    private ClientSearchEngine chs;
    private Vector params;
    public static int AND = 1;
    public static int OR = 2;
    public static int NOT = 3;
    public static int NEAR = 4;
    public static int LEFT_PAREN = 5;
    public static int RIGHT_PAREN = 6;
    public static int ADJ = 7;
    private static boolean debugFlag = false;

    public ClientSearchQuery(SearchEngine searchEngine) {
        super(searchEngine);
        if (searchEngine instanceof ClientSearchEngine) {
            this.chs = (ClientSearchEngine)searchEngine;
        }
    }

    public void startSearch(String string, Locale locale) throws IllegalArgumentException, IllegalStateException {
        ClientSearchQuery.debug("Starting Search");
        if (this.isActive()) {
            throw new IllegalStateException();
        }
        super.start(this.searchparams, locale);
        this.parseParams(string, locale);
        this.thread = new Thread((Runnable)this, "QueryThread");
        this.thread.start();
    }

    public void stopSearch(SearchQuery searchQuery) {
        ClientSearchQuery.debug("Stop Search");
        if (this.thread == null) {
            throw new IllegalArgumentException();
        }
        this.thread.stop();
        this.fireSearchFinished();
        this.thread = null;
    }

    private synchronized void parseParams(String string, Locale locale) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        this.params = new Vector();
        BreakIterator breakIterator = BreakIterator.getWordInstance(locale);
        breakIterator.setText(string);
        int n2 = breakIterator.first();
        int n3 = breakIterator.next();
        while (n3 != -1) {
            String string3 = new String(string.substring(n2, n3));
            string3 = string3.toLowerCase();
            if ((string3 = string3.trim()).length() != 0) {
                if (string3.compareTo("and") == 0 && !bl2) {
                    bl = false;
                    this.params.addElement(new Integer(AND));
                } else if (string3.compareTo("or") == 0 && !bl2) {
                    bl = false;
                    this.params.addElement(new Integer(OR));
                } else if (string3.compareTo("not") == 0 && !bl2) {
                    bl = false;
                    this.params.addElement(new Integer(NOT));
                } else if (string3.compareTo("near") == 0 && !bl2) {
                    bl = false;
                    this.params.addElement(new Integer(NEAR));
                } else if (string3.compareTo("adj") == 0 && !bl2) {
                    bl = false;
                    this.params.addElement(new Integer(ADJ));
                } else if (string3.compareTo("(") == 0 && !bl2) {
                    bl = false;
                    this.params.addElement(new Integer(LEFT_PAREN));
                } else if (string3.compareTo(")") == 0 && !bl2) {
                    bl = false;
                    this.params.addElement(new Integer(RIGHT_PAREN));
                } else if (string3.compareTo("\"") == 0) {
                    bl = false;
                    n = n2;
                    bl2 = true;
                } else if (string3.compareTo("*") == 0) {
                    bl = false;
                    if (string2 != null) {
                        this.params.removeElementAt(this.params.size() - 1);
                        string2 = string2 + string3;
                        this.params.addElement(string2);
                        bl = true;
                    }
                } else {
                    if (bl) {
                        if (bl2) {
                            this.params.addElement(new Integer(ADJ));
                        } else {
                            this.params.addElement(new Integer(NEAR));
                        }
                    }
                    if (bl2 && string3.endsWith("\"")) {
                        string3 = new String(string.substring(n2, n3 - 1));
                        bl2 = false;
                    }
                    bl = true;
                    string2 = string3;
                    this.params.addElement(string3);
                }
            }
            n2 = n3;
            n3 = breakIterator.next();
        }
    }

    public boolean isActive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    public void run() {
        int n;
        int n2;
        Word word;
        WordVector wordVector = this.chs.getWordVector();
        DocVector docVector = this.chs.getDocVector();
        ClientSearchQuery.debug("Threaded search");
        Vector vector = new Vector();
        int n3 = 0;
        for (int i = 0; i < this.params.size(); ++i) {
            Object e = this.params.elementAt(i);
            if (e instanceof Integer) {
                n3 = (Integer)e;
                continue;
            }
            word = wordVector.findWord((String)e);
            if (word == null) continue;
            if (n3 == AND) {
                vector = word.AndIntersection(vector);
                continue;
            }
            if (n3 == OR) {
                vector = word.OrIntersection(vector);
                continue;
            }
            if (n3 == NOT) {
                vector = word.NotIntersection(vector);
                continue;
            }
            if (n3 == NEAR) {
                vector = word.NearWord(vector, 20);
                continue;
            }
            if (n3 == ADJ) {
                vector = word.NearWord(vector, 1);
                continue;
            }
            if (n3 == LEFT_PAREN || n3 == RIGHT_PAREN) continue;
            vector = new Vector(20, 10);
            Vector vector2 = word.getWordInventory();
            n2 = vector2.size();
            for (int j = 0; j < n2; ++j) {
                vector.addElement(vector2.elementAt(j));
            }
        }
        n2 = docVector.size();
        for (n = 0; n < n2; ++n) {
            ((Doc)docVector.elementAt(n)).resetWeight();
        }
        n2 = vector.size();
        for (n = 0; n < n2; ++n) {
            WordInventory wordInventory = (WordInventory)vector.elementAt(n);
            short s = wordInventory.getDocId();
            ((Doc)docVector.elementAt(s)).addToWeight(wordInventory.getWeight());
        }
        Vector<Word> vector3 = new Vector<Word>();
        n2 = docVector.size();
        for (n = 0; n < n2; ++n) {
            Doc doc = (Doc)docVector.elementAt(n);
            if (doc.getWeight() <= 0) continue;
            word = new SearchItem(this.chs.getBase(), doc.getTitle(), Locale.getDefault().toString(), doc.getURLString(), (double)doc.getWeight(), 0, 0, null);
            vector3.addElement(word);
        }
        ClientSearchQuery.debug("returning hits");
        this.fireItemsFound(true, vector3);
        this.fireSearchFinished();
    }

    private static void debug(String string) {
        if (debugFlag) {
            System.out.println("ClientSearchEngine: " + string);
        }
    }
}

