from gssapi.raw.misc import GSSError

class ParameterReadError(GSSError): ...

class ParameterWriteError(GSSError): ...

class MalformedParameterError(GSSError): ...

class BadMechanismError(GSSError): ...

class BadNameError(GSSError): ...

class BadNameTypeError(GSSError): ...

class BadChannelBindingsError(GSSError): ...

class BadStatusError(GSSError): ...

class BadMICError(GSSError): ...

class MissingCredentialsError(GSSError): ...

class MissingContextError(GSSError): ...

class InvalidTokenError(GSSError): ...

class InvalidCredentialsError(GSSError): ...

class ExpiredCredentialsError(GSSError): ...

class ExpiredContextError(GSSError): ...

class BadQoPError(GSSError): ...

class UnauthorizedError(GSSError): ...

class OperationUnavailableError(GSSError): ...

class DuplicateCredentialsElementError(GSSError): ...

class MechanismNameRequiredError(GSSError): ...

class NameReadError(ParameterReadError, BadNameError): ...

class NameTypeReadError(ParameterReadError, BadNameTypeError): ...

class TokenReadError(ParameterReadError, InvalidTokenError): ...

class ContextReadError(ParameterReadError, MissingContextError): ...

class CredentialsReadError(ParameterReadError, MissingCredentialsError): ...

class ContextWriteError(ParameterWriteError, MissingContextError): ...

class CredentialsWriteError(ParameterWriteError, MissingCredentialsError): ...

class SupplementaryError(GSSError): ...

class DuplicateTokenError(SupplementaryError): ...

class ExpiredTokenError(SupplementaryError): ...

class TokenOutOfSequenceError(SupplementaryError): ...

class TokenTooLateError(TokenOutOfSequenceError): ...

class TokenTooEarlyError(TokenOutOfSequenceError): ...
