/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssValue;

public class CssRatio
extends CssValue {
    public static final int type = 13;
    BigDecimal w = null;
    BigDecimal h = null;
    CssValue gw = null;
    CssValue gh = null;

    @Override
    public final int getType() {
        return 13;
    }

    public CssRatio() {
    }

    public CssRatio(BigDecimal w, BigDecimal h) {
        this.w = w;
        this.h = h;
    }

    public CssRatio(BigDecimal w, CssValue gh) {
        this.w = w;
        if (gh.getRawType() == 5) {
            try {
                this.h = gh.getNumber().getBigDecimalValue();
            }
            catch (Exception ex) {
                this.gh = gh;
            }
        } else {
            this.gh = gh;
        }
    }

    public CssRatio(CssValue gw, BigDecimal h) {
        if (gw.getRawType() == 5) {
            try {
                this.w = gw.getNumber().getBigDecimalValue();
            }
            catch (Exception ex) {
                this.gw = gw;
            }
        } else {
            this.gw = gw;
        }
        this.h = h;
    }

    public CssRatio(CssValue gw, CssValue gh) {
        if (gw.getRawType() == 5) {
            try {
                this.w = gw.getNumber().getBigDecimalValue();
            }
            catch (Exception ex) {
                this.gw = gw;
            }
        } else {
            this.gw = gw;
        }
        if (gh.getRawType() == 5) {
            try {
                this.h = gh.getNumber().getBigDecimalValue();
            }
            catch (Exception ex) {
                this.gh = gh;
            }
        } else {
            this.gh = gh;
        }
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        int slash = s.indexOf(47);
        if (slash == -1) {
            throw new InvalidParamException("value", s, ac);
        }
        String sw = s.substring(0, slash).trim();
        String sh = s.substring(slash + 1).trim();
        try {
            this.w = new BigDecimal(sw);
        }
        catch (NumberFormatException nex) {
            throw new InvalidParamException("value", s, ac);
        }
        if (this.w.signum() != 1) {
            throw new InvalidParamException("strictly-positive", s, ac);
        }
        try {
            this.h = new BigDecimal(sh);
        }
        catch (NumberFormatException nex) {
            throw new InvalidParamException("value", s, ac);
        }
        if (this.h.signum() != 1) {
            throw new InvalidParamException("strictly-positive", s, ac);
        }
    }

    @Override
    public Object get() {
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.w != null) {
            sb.append(this.w.toPlainString());
        } else {
            sb.append(this.gw.toString()).append(' ');
        }
        sb.append('/');
        if (this.h != null) {
            sb.append(this.h.toPlainString());
        } else {
            sb.append(this.gh.toString());
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object value) {
        try {
            CssRatio other = (CssRatio)value;
            BigDecimal ratio = this.w.divide(this.h, RoundingMode.CEILING);
            BigDecimal other_ratio = other.w.divide(other.h, RoundingMode.CEILING);
            return ratio.compareTo(other_ratio) == 0;
        }
        catch (ClassCastException cce) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

