/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class ThurayaProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_EVENT = 20737;
    public static final int MSG_PERIODIC_REPORT = 28929;
    public static final int MSG_SETTING_RESPONSE = 33045;
    public static final int MSG_ACK = 39169;

    public ThurayaProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private static int checksum(ByteBuffer buf) {
        int crc = 0;
        while (buf.hasRemaining()) {
            crc += buf.get();
        }
        crc ^= 0xFFFFFFFF;
        return ++crc;
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, long id, int type) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeCharSequence((CharSequence)"#T", StandardCharsets.US_ASCII);
            response.writeShort(15);
            response.writeShort(39169);
            response.writeInt((int)id);
            response.writeShort(type);
            response.writeShort(1);
            response.writeShort(ThurayaProtocolDecoder.checksum(response.nioBuffer()));
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private void decodeLocation(ByteBuf buf, Position position) {
        position.setValid(true);
        DateBuilder dateBuilder = new DateBuilder();
        int date = buf.readInt();
        dateBuilder.setDay(date % 100);
        dateBuilder.setMonth((date /= 100) % 100);
        dateBuilder.setYear(date /= 100);
        int time = buf.readInt();
        dateBuilder.setSecond(time % 100);
        dateBuilder.setMinute((time /= 100) % 100);
        dateBuilder.setHour(time /= 100);
        position.setTime(dateBuilder.getDate());
        position.setLongitude((double)buf.readInt() / 1000000.0);
        position.setLatitude((double)buf.readInt() / 1000000.0);
        int data = buf.readUnsignedShort();
        int ignition = BitUtil.from(data, 12);
        if (ignition == 1) {
            position.set("ignition", true);
        } else if (ignition == 2) {
            position.set("ignition", false);
        }
        position.setCourse(BitUtil.to(data, 12));
        position.setSpeed(buf.readShort());
        position.set("rpm", buf.readShort());
        position.set("data", this.readString(buf));
    }

    private String decodeAlarm(int event) {
        return switch (event) {
            case 10 -> "vibration";
            case 11 -> "overspeed";
            case 12 -> "powerCut";
            case 13 -> "lowBattery";
            case 18 -> "gpsAntennaCut";
            case 20 -> "hardAcceleration";
            case 21 -> "hardBraking";
            default -> null;
        };
    }

    private String readString(ByteBuf buf) {
        int endIndex = buf.indexOf(buf.readerIndex(), buf.writerIndex(), (byte)0);
        CharSequence value = buf.readCharSequence(endIndex - buf.readerIndex(), StandardCharsets.US_ASCII);
        buf.readUnsignedByte();
        return value.toString();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        buf.readUnsignedShort();
        int type = buf.readUnsignedShort();
        long id = buf.readUnsignedInt();
        this.sendResponse(channel, remoteAddress, id, type);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, String.valueOf(id));
        if (deviceSession == null) {
            return null;
        }
        if (type == 20737) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            this.decodeLocation(buf, position);
            short event = buf.readUnsignedByte();
            position.set("alarm", this.decodeAlarm(event));
            position.set("event", Integer.valueOf(event));
            position.set("eventData", this.readString(buf));
            return position;
        }
        if (type == 28929) {
            LinkedList<Position> positions = new LinkedList<Position>();
            int count = buf.readUnsignedByte();
            for (int i = 0; i < count; ++i) {
                Position position = new Position(this.getProtocolName());
                position.setDeviceId(deviceSession.getDeviceId());
                this.decodeLocation(buf, position);
                positions.add(position);
            }
            return positions;
        }
        return null;
    }
}

