/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api.resource;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.traccar.BaseProtocol;
import org.traccar.ServerManager;
import org.traccar.api.ExtendedObjectResource;
import org.traccar.database.CommandsManager;
import org.traccar.helper.LogAction;
import org.traccar.helper.model.DeviceUtil;
import org.traccar.model.Command;
import org.traccar.model.Device;
import org.traccar.model.Group;
import org.traccar.model.Position;
import org.traccar.model.QueuedCommand;
import org.traccar.model.Typed;
import org.traccar.model.User;
import org.traccar.model.UserRestrictions;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

@Path(value="commands")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class CommandResource
extends ExtendedObjectResource<Command> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommandResource.class);
    @Inject
    private CommandsManager commandsManager;
    @Inject
    private ServerManager serverManager;

    public CommandResource() {
        super(Command.class);
    }

    private BaseProtocol getDeviceProtocol(long deviceId) throws StorageException {
        Position position = this.storage.getObject(Position.class, new Request((Columns)new Columns.All(), new Condition.LatestPositions(deviceId)));
        if (position != null) {
            return this.serverManager.getProtocol(position.getProtocol());
        }
        return null;
    }

    @GET
    @Path(value="send")
    public Collection<Command> get(@QueryParam(value="deviceId") long deviceId) throws StorageException {
        this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
        BaseProtocol protocol = this.getDeviceProtocol(deviceId);
        List commands = this.storage.getObjects(this.baseClass, new Request((Columns)new Columns.All(), Condition.merge(List.of(new Condition.Permission(User.class, this.getUserId(), this.baseClass), new Condition.Permission(Device.class, deviceId, this.baseClass)))));
        return commands.stream().filter(command -> {
            String type = command.getType();
            if (protocol != null) {
                return command.getTextChannel() && protocol.getSupportedTextCommands().contains(type) || !command.getTextChannel() && protocol.getSupportedDataCommands().contains(type);
            }
            return type.equals("custom");
        }).collect(Collectors.toList());
    }

    @POST
    @Path(value="send")
    public Response send(Command entity, @QueryParam(value="groupId") long groupId) throws Exception {
        if (entity.getId() > 0L) {
            this.permissionsService.checkPermission(this.baseClass, this.getUserId(), entity.getId());
            long deviceId = entity.getDeviceId();
            entity = (Command)this.storage.getObject(this.baseClass, new Request((Columns)new Columns.All(), new Condition.Equals("id", entity.getId())));
            entity.setDeviceId(deviceId);
        } else {
            this.permissionsService.checkRestriction(this.getUserId(), UserRestrictions::getLimitCommands);
        }
        if (groupId > 0L) {
            this.permissionsService.checkPermission(Group.class, this.getUserId(), groupId);
            Collection<Device> devices = DeviceUtil.getAccessibleDevices(this.storage, this.getUserId(), List.of(), List.of(Long.valueOf(groupId)));
            ArrayList<QueuedCommand> queuedCommands = new ArrayList<QueuedCommand>();
            for (Device device : devices) {
                Command command = QueuedCommand.fromCommand(entity).toCommand();
                command.setDeviceId(device.getId());
                QueuedCommand queuedCommand = this.commandsManager.sendCommand(command);
                if (queuedCommand == null) continue;
                queuedCommands.add(queuedCommand);
            }
            if (!queuedCommands.isEmpty()) {
                return Response.accepted(queuedCommands).build();
            }
        } else {
            this.permissionsService.checkPermission(Device.class, this.getUserId(), entity.getDeviceId());
            QueuedCommand queuedCommand = this.commandsManager.sendCommand(entity);
            if (queuedCommand != null) {
                return Response.accepted((Object)queuedCommand).build();
            }
        }
        LogAction.command(this.getUserId(), groupId, entity.getDeviceId(), entity.getType());
        return Response.ok((Object)entity).build();
    }

    @GET
    @Path(value="types")
    public Collection<Typed> get(@QueryParam(value="deviceId") long deviceId, @QueryParam(value="textChannel") boolean textChannel) throws StorageException {
        Field[] fields;
        if (deviceId != 0L) {
            this.permissionsService.checkPermission(Device.class, this.getUserId(), deviceId);
            BaseProtocol protocol = this.getDeviceProtocol(deviceId);
            if (protocol != null) {
                if (textChannel) {
                    return protocol.getSupportedTextCommands().stream().map(Typed::new).collect(Collectors.toList());
                }
                return protocol.getSupportedDataCommands().stream().map(Typed::new).collect(Collectors.toList());
            }
            return Collections.singletonList(new Typed("custom"));
        }
        ArrayList<Typed> result = new ArrayList<Typed>();
        for (Field field : fields = Command.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("TYPE_")) continue;
            try {
                result.add(new Typed(field.get(null).toString()));
            }
            catch (IllegalAccessException | IllegalArgumentException error) {
                LOGGER.warn("Get command types error", (Throwable)error);
            }
        }
        return result;
    }
}

