/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.auth;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.firebase.internal.NonNull;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public final class ActionCodeSettings {
    private final Map<String, Object> properties;

    private ActionCodeSettings(Builder builder) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.url) ? 1 : 0) != 0, (Object)"URL must not be null or empty");
        try {
            new URL(builder.url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Malformed URL string", e);
        }
        if (builder.androidInstallApp || !Strings.isNullOrEmpty((String)builder.androidMinimumVersion)) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)builder.androidPackageName) ? 1 : 0) != 0, (Object)"Android package name is required when specifying other Android settings");
        }
        ImmutableMap.Builder properties = ImmutableMap.builder().put((Object)"continueUrl", (Object)builder.url).put((Object)"canHandleCodeInApp", (Object)builder.handleCodeInApp);
        if (!Strings.isNullOrEmpty((String)builder.dynamicLinkDomain)) {
            properties.put((Object)"dynamicLinkDomain", (Object)builder.dynamicLinkDomain);
        }
        if (!Strings.isNullOrEmpty((String)builder.iosBundleId)) {
            properties.put((Object)"iOSBundleId", (Object)builder.iosBundleId);
        }
        if (!Strings.isNullOrEmpty((String)builder.androidPackageName)) {
            properties.put((Object)"androidPackageName", (Object)builder.androidPackageName);
            if (!Strings.isNullOrEmpty((String)builder.androidMinimumVersion)) {
                properties.put((Object)"androidMinimumVersion", (Object)builder.androidMinimumVersion);
            }
            if (builder.androidInstallApp) {
                properties.put((Object)"androidInstallApp", (Object)builder.androidInstallApp);
            }
        }
        this.properties = properties.build();
    }

    Map<String, Object> getProperties() {
        return this.properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String url;
        private boolean handleCodeInApp;
        private String dynamicLinkDomain;
        private String iosBundleId;
        private String androidPackageName;
        private String androidMinimumVersion;
        private boolean androidInstallApp;

        private Builder() {
        }

        public Builder setUrl(@NonNull String url) {
            this.url = url;
            return this;
        }

        public Builder setHandleCodeInApp(boolean handleCodeInApp) {
            this.handleCodeInApp = handleCodeInApp;
            return this;
        }

        public Builder setDynamicLinkDomain(String dynamicLinkDomain) {
            this.dynamicLinkDomain = dynamicLinkDomain;
            return this;
        }

        public Builder setIosBundleId(String iosBundleId) {
            this.iosBundleId = iosBundleId;
            return this;
        }

        public Builder setAndroidPackageName(String androidPackageName) {
            this.androidPackageName = androidPackageName;
            return this;
        }

        public Builder setAndroidMinimumVersion(String androidMinimumVersion) {
            this.androidMinimumVersion = androidMinimumVersion;
            return this;
        }

        public Builder setAndroidInstallApp(boolean androidInstallApp) {
            this.androidInstallApp = androidInstallApp;
            return this;
        }

        public ActionCodeSettings build() {
            return new ActionCodeSettings(this);
        }
    }
}

