/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.string.StringEncoder;
import jakarta.inject.Inject;
import org.traccar.BaseProtocol;
import org.traccar.PipelineBuilder;
import org.traccar.TrackerServer;
import org.traccar.config.Config;
import org.traccar.protocol.WondexFrameDecoder;
import org.traccar.protocol.WondexProtocolDecoder;
import org.traccar.protocol.WondexProtocolEncoder;

public class WondexProtocol
extends BaseProtocol {
    @Inject
    public WondexProtocol(Config config) {
        this.setSupportedDataCommands("getDeviceStatus", "getModemStatus", "rebootDevice", "positionSingle", "getVersion", "deviceIdentification");
        this.setTextCommandEncoder(new WondexProtocolEncoder(this));
        this.setSupportedTextCommands("getDeviceStatus", "getModemStatus", "rebootDevice", "positionSingle", "getVersion", "deviceIdentification");
        this.addServer(new TrackerServer(config, this.getName(), false){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new WondexFrameDecoder());
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new WondexProtocolEncoder(WondexProtocol.this));
                pipeline.addLast((ChannelHandler)new WondexProtocolDecoder(WondexProtocol.this));
            }
        });
        this.addServer(new TrackerServer(config, this.getName(), true){

            @Override
            protected void addProtocolHandlers(PipelineBuilder pipeline, Config config) {
                pipeline.addLast((ChannelHandler)new StringEncoder());
                pipeline.addLast((ChannelHandler)new WondexProtocolEncoder(WondexProtocol.this));
                pipeline.addLast((ChannelHandler)new WondexProtocolDecoder(WondexProtocol.this));
            }
        });
    }
}

