/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DataConverter;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GlobalstarProtocolDecoder
extends BaseHttpProtocolDecoder {
    private final DocumentBuilder documentBuilder;
    private final XPath xPath;
    private final XPathExpression messageExpression;

    public GlobalstarProtocolDecoder(Protocol protocol) {
        super(protocol);
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            builderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            builderFactory.setXIncludeAware(false);
            builderFactory.setExpandEntityReferences(false);
            this.documentBuilder = builderFactory.newDocumentBuilder();
            this.xPath = XPathFactory.newInstance().newXPath();
            this.messageExpression = this.xPath.compile("//stuMessages/stuMessage");
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendResponse(Channel channel, String messageId) throws TransformerException {
        Document document = this.documentBuilder.newDocument();
        Element rootElement = document.createElement("stuResponseMsg");
        rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        rootElement.setAttribute("xsi:noNamespaceSchemaLocation", "http://cody.glpconnect.com/XSD/StuResponse_Rev1_0.xsd");
        rootElement.setAttribute("deliveryTimeStamp", new SimpleDateFormat("dd/MM/yyyy hh:mm:ss z").format(new Date()));
        rootElement.setAttribute("messageID", "00000000000000000000000000000000");
        rootElement.setAttribute("correlationID", messageId);
        document.appendChild(rootElement);
        Element state = document.createElement("state");
        state.appendChild(document.createTextNode("pass"));
        rootElement.appendChild(state);
        Element stateMessage = document.createElement("stateMessage");
        stateMessage.appendChild(document.createTextNode("Store OK"));
        rootElement.appendChild(stateMessage);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        ByteBuf content = Unpooled.buffer();
        transformer.transform(new DOMSource(document), new StreamResult((OutputStream)new ByteBufOutputStream(content)));
        if (channel != null) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
            response.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes()).add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/xml");
            channel.writeAndFlush((Object)new NetworkMessage(response, channel.remoteAddress()));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        Document document = this.documentBuilder.parse((InputStream)new ByteBufferBackedInputStream(request.content().nioBuffer()));
        NodeList nodes = (NodeList)this.messageExpression.evaluate(document, XPathConstants.NODESET);
        LinkedList<Position> positions = new LinkedList<Position>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            int type;
            Node node = nodes.item(i);
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, this.xPath.evaluate("esn", node));
            if (deviceSession == null) continue;
            boolean atlas = "AtlasTrax".equalsIgnoreCase(this.getDeviceModel(deviceSession));
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setTime(new Date(Long.parseLong(this.xPath.evaluate("unixTime", node)) * 1000L));
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])DataConverter.parseHex(this.xPath.evaluate("payload", node).substring(2)));
            short flags = buf.readUnsignedByte();
            if (atlas) {
                type = BitUtil.to(flags, 1);
                position.setValid(true);
                position.set("in1", !BitUtil.check(flags, 1));
                position.set("in2", !BitUtil.check(flags, 2));
                position.set("charge", !BitUtil.check(flags, 3));
                if (BitUtil.check(flags, 4)) {
                    position.set("alarm", "vibration");
                }
                position.setCourse(BitUtil.from(flags, 5) * 45);
            } else {
                type = BitUtil.to(flags, 2);
                if (BitUtil.check(flags, 2)) {
                    position.set("batteryReplace", true);
                }
                position.setValid(!BitUtil.check(flags, 3));
            }
            double latitude = (double)buf.readUnsignedMedium() * 90.0 / 8388608.0;
            position.setLatitude(latitude > 90.0 ? latitude - 180.0 : latitude);
            double longitude = (double)buf.readUnsignedMedium() * 180.0 / 8388608.0;
            position.setLongitude(longitude > 180.0 ? longitude - 360.0 : longitude);
            short speed = 0;
            if (atlas) {
                speed = buf.readUnsignedByte();
                position.setSpeed(UnitsConverter.knotsFromKph(speed));
                position.set("batteryReplace", BitUtil.check(buf.readUnsignedByte(), 7));
            } else if (type == 0) {
                position.set("input", BitUtil.to(buf.readUnsignedByte(), 4));
                short other = buf.readUnsignedByte();
                if (BitUtil.check(other, 4)) {
                    position.set("alarm", "vibration");
                }
                position.set("motion", BitUtil.check(other, 6));
            }
            if (speed == 255) continue;
            positions.add(position);
        }
        this.sendResponse(channel, document.getFirstChild().getAttributes().getNamedItem("messageID").getNodeValue());
        return !positions.isEmpty() ? positions : null;
    }
}

