/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler.events;

import jakarta.inject.Inject;
import org.traccar.config.Config;
import org.traccar.config.Keys;
import org.traccar.handler.events.BaseEventHandler;
import org.traccar.model.Event;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class AlertEventHandler
extends BaseEventHandler {
    private final CacheManager cacheManager;
    private final boolean ignoreDuplicateAlerts;

    @Inject
    public AlertEventHandler(Config config, CacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.ignoreDuplicateAlerts = config.getBoolean(Keys.EVENT_IGNORE_DUPLICATE_ALERTS);
    }

    @Override
    public void analyzePosition(Position position, BaseEventHandler.Callback callback) {
        Object alarm = position.getAttributes().get("alarm");
        if (alarm != null) {
            Position lastPosition;
            boolean ignoreAlert = false;
            if (this.ignoreDuplicateAlerts && (lastPosition = this.cacheManager.getPosition(position.getDeviceId())) != null && alarm.equals(lastPosition.getAttributes().get("alarm"))) {
                ignoreAlert = true;
            }
            if (!ignoreAlert) {
                Event event = new Event("alarm", position);
                event.set("alarm", (String)alarm);
                callback.eventDetected(event);
            }
        }
    }
}

