/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.mlong;

import de.rub.nds.modifiablevariable.FileConfigurationException;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.integer.IntegerModificationFactory;
import de.rub.nds.modifiablevariable.mlong.LongAddModification;
import de.rub.nds.modifiablevariable.mlong.LongExplicitValueModification;
import de.rub.nds.modifiablevariable.mlong.LongSubtractModification;
import de.rub.nds.modifiablevariable.mlong.LongXorModification;
import de.rub.nds.modifiablevariable.util.RandomHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class LongModificationFactory {
    private static final int MODIFICATION_COUNT = 5;
    private static final int MAX_MODIFICATION_VALUE = 32000;
    private static List<VariableModification<Long>> modificationsFromFile;

    public static LongAddModification add(String summand) {
        return LongModificationFactory.add(new Long(summand));
    }

    public static LongAddModification add(Long summand) {
        return new LongAddModification(summand);
    }

    public static VariableModification<Long> sub(String subtrahend) {
        return LongModificationFactory.sub(new Long(subtrahend));
    }

    public static VariableModification<Long> sub(Long subtrahend) {
        return new LongSubtractModification(subtrahend);
    }

    public static VariableModification<Long> xor(String xor) {
        return LongModificationFactory.xor(new Long(xor));
    }

    public static VariableModification<Long> xor(Long xor) {
        return new LongXorModification(xor);
    }

    public static VariableModification<Long> explicitValue(String value) {
        return LongModificationFactory.explicitValue(new Long(value));
    }

    public static VariableModification<Long> explicitValue(Long value) {
        return new LongExplicitValueModification(value);
    }

    public static VariableModification<Long> explicitValueFromFile(int value) {
        List<VariableModification<Long>> modifications = LongModificationFactory.modificationsFromFile();
        int pos = value % modifications.size();
        return modifications.get(pos);
    }

    public static synchronized List<VariableModification<Long>> modificationsFromFile() {
        try {
            if (modificationsFromFile == null) {
                String line;
                modificationsFromFile = new LinkedList<VariableModification<Long>>();
                ClassLoader classLoader = IntegerModificationFactory.class.getClassLoader();
                InputStream is = classLoader.getResourceAsStream("de/rub/nds/modifiablevariable/explicit/integer.vec");
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((line = br.readLine()) != null) {
                    String value = line.trim().split(" ")[0];
                    modificationsFromFile.add(LongModificationFactory.explicitValue(value));
                }
            }
            return modificationsFromFile;
        }
        catch (IOException ex) {
            throw new FileConfigurationException("Modifiable variable file name could not have been found.", ex);
        }
    }

    public static VariableModification<Long> createRandomModification() {
        Random random = RandomHelper.getRandom();
        int r = random.nextInt(5);
        long modification = random.nextInt(32000);
        VariableModification vm = null;
        switch (r) {
            case 0: {
                vm = new LongAddModification(modification);
                return vm;
            }
            case 1: {
                vm = new LongSubtractModification(modification);
                return vm;
            }
            case 2: {
                vm = new LongXorModification(modification);
                return vm;
            }
            case 3: {
                vm = new LongExplicitValueModification(modification);
                return vm;
            }
            case 4: {
                vm = LongModificationFactory.explicitValueFromFile(random.nextInt(32000));
                return vm;
            }
        }
        return vm;
    }

    private LongModificationFactory() {
    }
}

