"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USE_NEW_HOME_PAGE = exports.SECTIONS = exports.PLUGIN_ID = exports.IMPORT_SAMPLE_DATA_APP_ID = exports.HOME_PAGE_ID = exports.HOME_CONTENT_AREAS = exports.HOME_APP_BASE_PATH = void 0;
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'home';
const HOME_APP_BASE_PATH = exports.HOME_APP_BASE_PATH = `/app/${PLUGIN_ID}`;
const USE_NEW_HOME_PAGE = exports.USE_NEW_HOME_PAGE = 'home:useNewHomePage';
const IMPORT_SAMPLE_DATA_APP_ID = exports.IMPORT_SAMPLE_DATA_APP_ID = 'import_sample_data';
const HOME_PAGE_ID = exports.HOME_PAGE_ID = 'osd_homepage';
let SECTIONS = exports.SECTIONS = /*#__PURE__*/function (SECTIONS) {
  SECTIONS["GET_STARTED"] = "get_started";
  SECTIONS["SERVICE_CARDS"] = "service_cards";
  SECTIONS["RECENTLY_VIEWED"] = "recently_viewed";
  return SECTIONS;
}({});
let HOME_CONTENT_AREAS = exports.HOME_CONTENT_AREAS = /*#__PURE__*/function (HOME_CONTENT_AREAS) {
  HOME_CONTENT_AREAS["GET_STARTED"] = "osd_homepage/get_started";
  HOME_CONTENT_AREAS["SERVICE_CARDS"] = "osd_homepage/service_cards";
  HOME_CONTENT_AREAS["RECENTLY_VIEWED"] = "osd_homepage/recently_viewed";
  return HOME_CONTENT_AREAS;
}({});