"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatIntelIocType = exports.IocLabel = exports.DEFAULT_RULE_UUID = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const DEFAULT_RULE_UUID = exports.DEFAULT_RULE_UUID = '25b9c01c-350d-4b95-bed1-836d04a4f324';
let ThreatIntelIocType = exports.ThreatIntelIocType = /*#__PURE__*/function (ThreatIntelIocType) {
  ThreatIntelIocType["Domain"] = "domain-name";
  ThreatIntelIocType["FileHash"] = "hashes";
  ThreatIntelIocType["IPV4"] = "ipv4-addr";
  ThreatIntelIocType["IPV6"] = "ipv6-addr";
  return ThreatIntelIocType;
}({});
const IocLabel = exports.IocLabel = {
  [ThreatIntelIocType.IPV4]: 'IPV4-Address',
  [ThreatIntelIocType.IPV6]: 'IPV6-Address',
  [ThreatIntelIocType.Domain]: 'Domains',
  [ThreatIntelIocType.FileHash]: 'File hash'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJERUZBVUxUX1JVTEVfVVVJRCIsImV4cG9ydHMiLCJUaHJlYXRJbnRlbElvY1R5cGUiLCJJb2NMYWJlbCIsIklQVjQiLCJJUFY2IiwiRG9tYWluIiwiRmlsZUhhc2giXSwic291cmNlcyI6WyJjb25zdGFudHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLypcbiAqIENvcHlyaWdodCBPcGVuU2VhcmNoIENvbnRyaWJ1dG9yc1xuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5leHBvcnQgY29uc3QgREVGQVVMVF9SVUxFX1VVSUQgPSAnMjViOWMwMWMtMzUwZC00Yjk1LWJlZDEtODM2ZDA0YTRmMzI0JztcblxuZXhwb3J0IGVudW0gVGhyZWF0SW50ZWxJb2NUeXBlIHtcbiAgRG9tYWluID0gJ2RvbWFpbi1uYW1lJyxcbiAgRmlsZUhhc2ggPSAnaGFzaGVzJyxcbiAgSVBWNCA9ICdpcHY0LWFkZHInLFxuICBJUFY2ID0gJ2lwdjYtYWRkcicsXG59XG5cbmV4cG9ydCBjb25zdCBJb2NMYWJlbDogeyBbayBpbiBUaHJlYXRJbnRlbElvY1R5cGVdOiBzdHJpbmcgfSA9IHtcbiAgW1RocmVhdEludGVsSW9jVHlwZS5JUFY0XTogJ0lQVjQtQWRkcmVzcycsXG4gIFtUaHJlYXRJbnRlbElvY1R5cGUuSVBWNl06ICdJUFY2LUFkZHJlc3MnLFxuICBbVGhyZWF0SW50ZWxJb2NUeXBlLkRvbWFpbl06ICdEb21haW5zJyxcbiAgW1RocmVhdEludGVsSW9jVHlwZS5GaWxlSGFzaF06ICdGaWxlIGhhc2gnLFxufTtcbiJdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBRU8sTUFBTUEsaUJBQWlCLEdBQUFDLE9BQUEsQ0FBQUQsaUJBQUEsR0FBRyxzQ0FBc0M7QUFBQyxJQUU1REUsa0JBQWtCLEdBQUFELE9BQUEsQ0FBQUMsa0JBQUEsMEJBQWxCQSxrQkFBa0I7RUFBbEJBLGtCQUFrQjtFQUFsQkEsa0JBQWtCO0VBQWxCQSxrQkFBa0I7RUFBbEJBLGtCQUFrQjtFQUFBLE9BQWxCQSxrQkFBa0I7QUFBQTtBQU92QixNQUFNQyxRQUErQyxHQUFBRixPQUFBLENBQUFFLFFBQUEsR0FBRztFQUM3RCxDQUFDRCxrQkFBa0IsQ0FBQ0UsSUFBSSxHQUFHLGNBQWM7RUFDekMsQ0FBQ0Ysa0JBQWtCLENBQUNHLElBQUksR0FBRyxjQUFjO0VBQ3pDLENBQUNILGtCQUFrQixDQUFDSSxNQUFNLEdBQUcsU0FBUztFQUN0QyxDQUFDSixrQkFBa0IsQ0FBQ0ssUUFBUSxHQUFHO0FBQ2pDLENBQUMifQ==