"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connectorRouter = void 0;
var _configSchema = require("@osd/config-schema");
var _constants = require("./constants");
var _connector_service = require("../services/connector_service");
var _utils = require("./utils");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const connectorRouter = router => {
  router.get({
    path: _constants.CONNECTOR_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, router.handleLegacyErrors(async (context, request, res) => {
    const payload = await _connector_service.ConnectorService.search({
      transport: await (0, _utils.getOpenSearchClientTransport)({
        dataSourceId: request.query.data_source_id,
        context
      }),
      from: 0,
      size: 10000
    });
    return res.ok({
      body: payload
    });
  }));
  router.get({
    path: _constants.INTERNAL_CONNECTOR_API_ENDPOINT,
    validate: {
      query: _configSchema.schema.object({
        data_source_id: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, router.handleLegacyErrors(async (context, request, res) => {
    const data = await _connector_service.ConnectorService.getUniqueInternalConnectorNames({
      transport: await (0, _utils.getOpenSearchClientTransport)({
        dataSourceId: request.query.data_source_id,
        context
      }),
      size: 10000
    });
    return res.ok({
      body: {
        data
      }
    });
  }));
};
exports.connectorRouter = connectorRouter;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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