"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = createISMCluster;
var _ismPlugin = _interopRequireDefault(require("./ismPlugin"));
var _constants = require("../../utils/constants");
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function createISMCluster(server) {
  const {
    customHeaders,
    ...rest
  } = server.config().get("opensearch");
  server.plugins.opensearch.createCluster(_constants.CLUSTER.ISM, {
    plugins: [_ismPlugin.default],
    customHeaders: {
      ...customHeaders,
      ..._constants.DEFAULT_HEADERS
    },
    ...rest
  });
}
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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