function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiPage } from './page';
import { OuiPageSideBar } from './page_side_bar';
import { OuiPageBody } from './page_body';
import { OuiPageHeader } from './page_header';
import { OuiPageContent, OuiPageContentBody } from './page_content';
import { OuiBottomBar } from '../bottom_bar';
import { useIsWithinBreakpoints } from '../../services';
import { OuiFlexGroup, OuiFlexItem } from '../flex';
export var TEMPLATES = ['default', 'centeredBody', 'centeredContent', 'empty'];
export var OuiPageTemplate = function OuiPageTemplate(_ref) {
  var _pageBodyProps2;

  var _ref$template = _ref.template,
      template = _ref$template === void 0 ? 'default' : _ref$template,
      _ref$restrictWidth = _ref.restrictWidth,
      restrictWidth = _ref$restrictWidth === void 0 ? true : _ref$restrictWidth,
      _ref$grow = _ref.grow,
      grow = _ref$grow === void 0 ? true : _ref$grow,
      _ref$paddingSize = _ref.paddingSize,
      paddingSize = _ref$paddingSize === void 0 ? 'l' : _ref$paddingSize,
      fullHeight = _ref.fullHeight,
      children = _ref.children,
      className = _ref.className,
      pageSideBar = _ref.pageSideBar,
      pageSideBarProps = _ref.pageSideBarProps,
      pageHeader = _ref.pageHeader,
      pageBodyProps = _ref.pageBodyProps,
      pageContentProps = _ref.pageContentProps,
      pageContentBodyProps = _ref.pageContentBodyProps,
      bottomBar = _ref.bottomBar,
      bottomBarProps = _ref.bottomBarProps,
      _ref$minHeight = _ref.minHeight,
      minHeight = _ref$minHeight === void 0 ? 460 : _ref$minHeight,
      rest = _objectWithoutProperties(_ref, ["template", "restrictWidth", "grow", "paddingSize", "fullHeight", "children", "className", "pageSideBar", "pageSideBarProps", "pageHeader", "pageBodyProps", "pageContentProps", "pageContentBodyProps", "bottomBar", "bottomBarProps", "minHeight"]);

  /**
   * Full height ~madness~ logic
   */
  var canFullHeight = useIsWithinBreakpoints(['m', 'l', 'xl']) && (template === 'default' || template === 'empty');
  var fullHeightClass = {
    'oui-fullHeight': fullHeight && canFullHeight
  };
  var yScrollClass = {
    'oui-yScroll': fullHeight && canFullHeight
  };

  if (canFullHeight && fullHeight) {
    var _pageBodyProps, _pageContentProps, _pageContentBodyProps;

    // By using flex group it will also fix the negative margin issues for nested flex groups
    children = /*#__PURE__*/React.createElement(OuiFlexGroup, {
      className: "oui-fullHeight",
      gutterSize: "none",
      direction: "column",
      responsive: false
    }, /*#__PURE__*/React.createElement(OuiFlexItem, {
      className: classNames({
        'oui-yScroll': fullHeight === true,
        'oui-fullHeight': fullHeight === 'noscroll'
      }),
      grow: true
    }, children));
    pageBodyProps = _objectSpread(_objectSpread({}, pageBodyProps), {}, {
      className: classNames(fullHeightClass, (_pageBodyProps = pageBodyProps) === null || _pageBodyProps === void 0 ? void 0 : _pageBodyProps.className)
    });
    pageContentProps = _objectSpread(_objectSpread({}, pageContentProps), {}, {
      className: classNames(yScrollClass, (_pageContentProps = pageContentProps) === null || _pageContentProps === void 0 ? void 0 : _pageContentProps.className)
    });
    pageContentBodyProps = _objectSpread(_objectSpread({}, pageContentBodyProps), {}, {
      className: classNames(fullHeightClass, (_pageContentBodyProps = pageContentBodyProps) === null || _pageContentBodyProps === void 0 ? void 0 : _pageContentBodyProps.className)
    });
  }

  var classes = classNames('ouiPageTemplate', fullHeightClass, className);

  var pageStyle = _objectSpread({
    minHeight: minHeight
  }, rest.style);
  /**
   * This seems very repetitious but it's the most readable, scalable, and maintainable
   */


  switch (template) {
    /**
     * CENTERED BODY
     * The panelled content is centered
     */
    case 'centeredBody':
      return pageSideBar ? /*#__PURE__*/React.createElement(OuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(OuiPageSideBar, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/React.createElement(OuiPageBody, _extends({
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(OuiPageHeader, _extends({
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(OuiPageContent, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/React.createElement(OuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : /*#__PURE__*/React.createElement(OuiPage, _extends({
        className: classes,
        paddingSize: paddingSize,
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(OuiPageBody, _extends({
        restrictWidth: restrictWidth
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(OuiPageHeader, _extends({
        paddingSize: "none",
        restrictWidth: false,
        bottomBorder: true
      }, pageHeader)), /*#__PURE__*/React.createElement(OuiPageBody, null, /*#__PURE__*/React.createElement(OuiPageContent, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/React.createElement(OuiPageContentBody, _extends({
        paddingSize: "none",
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))));

    /**
     * CENTERED CONTENT
     * The content inside the panel is centered
     */

    case 'centeredContent':
      return pageSideBar ? /*#__PURE__*/React.createElement(OuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(OuiPageSideBar, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/React.createElement(OuiPageBody, _extends({
        panelled: true,
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(OuiPageHeader, _extends({
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(OuiPageContent, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        hasShadow: false,
        color: "subdued",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/React.createElement(OuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : /*#__PURE__*/React.createElement(OuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(OuiPageBody, pageBodyProps, pageHeader && /*#__PURE__*/React.createElement(OuiPageHeader, _extends({
        paddingSize: paddingSize,
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(OuiPageContent, {
        role: null,
        borderRadius: "none",
        hasShadow: false,
        paddingSize: paddingSize,
        style: {
          display: 'flex'
        }
      }, /*#__PURE__*/React.createElement(OuiPageContent, _extends({
        verticalPosition: "center",
        horizontalPosition: "center",
        hasShadow: false,
        color: "subdued",
        paddingSize: paddingSize
      }, pageContentProps), /*#__PURE__*/React.createElement(OuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))));

    /**
     * EMPTY
     * No panelling at all
     */

    case 'empty':
      return pageSideBar ? /*#__PURE__*/React.createElement(OuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(OuiPageSideBar, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/React.createElement(OuiPageBody, _extends({
        paddingSize: paddingSize
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(OuiPageHeader, _extends({
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(OuiPageContent, _extends({
        hasBorder: false,
        hasShadow: false,
        paddingSize: 'none',
        color: 'transparent',
        borderRadius: 'none'
      }, pageContentProps), /*#__PURE__*/React.createElement(OuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children)))) : /*#__PURE__*/React.createElement(OuiPage, _extends({
        className: classes,
        paddingSize: paddingSize,
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(OuiPageBody, _extends({
        restrictWidth: restrictWidth
      }, pageBodyProps), pageHeader && /*#__PURE__*/React.createElement(OuiPageHeader, _extends({
        paddingSize: "none",
        restrictWidth: false,
        bottomBorder: true
      }, pageHeader)), /*#__PURE__*/React.createElement(OuiPageContent, _extends({
        hasBorder: false,
        hasShadow: false,
        paddingSize: 'none',
        color: 'transparent',
        borderRadius: 'none'
      }, pageContentProps), /*#__PURE__*/React.createElement(OuiPageContentBody, _extends({
        paddingSize: "none"
      }, pageContentBodyProps), children))));

    /**
     * DEFAULT
     * Typical layout with nothing "centered"
     */

    default:
      // Only the default template can display a bottom bar
      var bottomBarNode = bottomBar ? /*#__PURE__*/React.createElement(OuiBottomBar, _extends({
        paddingSize: paddingSize,
        position: canFullHeight && fullHeight ? 'static' : 'sticky' // Using uknown here because of the possible conflict with overriding props and position `sticky`

      }, bottomBarProps), /*#__PURE__*/React.createElement(OuiPageContentBody, {
        paddingSize: 'none',
        restrictWidth: restrictWidth
      }, bottomBar)) : undefined;
      return pageSideBar ? /*#__PURE__*/React.createElement(OuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(OuiPageSideBar, _extends({
        sticky: true,
        paddingSize: paddingSize
      }, pageSideBarProps), pageSideBar), /*#__PURE__*/React.createElement(OuiPageBody, _extends({
        panelled: true,
        paddingSize: "none"
      }, pageBodyProps), /*#__PURE__*/React.createElement(OuiPageBody, {
        component: "div",
        paddingSize: paddingSize,
        className: (_pageBodyProps2 = pageBodyProps) === null || _pageBodyProps2 === void 0 ? void 0 : _pageBodyProps2.className
      }, pageHeader && /*#__PURE__*/React.createElement(OuiPageHeader, _extends({
        bottomBorder: true,
        restrictWidth: restrictWidth
      }, pageHeader)), /*#__PURE__*/React.createElement(OuiPageContent, _extends({
        hasShadow: false,
        hasBorder: false,
        color: 'transparent',
        borderRadius: 'none',
        paddingSize: "none"
      }, pageContentProps), /*#__PURE__*/React.createElement(OuiPageContentBody, _extends({
        restrictWidth: restrictWidth
      }, pageContentBodyProps), children))), bottomBarNode)) : /*#__PURE__*/React.createElement(OuiPage, _extends({
        className: classes,
        paddingSize: "none",
        grow: grow
      }, rest, {
        style: pageStyle
      }), /*#__PURE__*/React.createElement(OuiPageBody, pageBodyProps, pageHeader && /*#__PURE__*/React.createElement(OuiPageHeader, _extends({
        restrictWidth: restrictWidth,
        paddingSize: paddingSize
      }, pageHeader)), /*#__PURE__*/React.createElement(OuiPageContent, _extends({
        hasBorder: pageHeader === undefined ? false : undefined,
        hasShadow: false,
        paddingSize: 'none',
        color: 'plain',
        borderRadius: 'none'
      }, pageContentProps), /*#__PURE__*/React.createElement(OuiPageContentBody, _extends({
        restrictWidth: restrictWidth,
        paddingSize: paddingSize
      }, pageContentBodyProps), children)), bottomBarNode));
  }
};
/* OUI -> EUI Aliases: Build-Time */

OuiPageTemplate.propTypes = {
  /**
     * Choose between 3 types of templates.
     * `default`: Typical layout with nothing centered
     * `centeredBody`: The panelled content is centered
     * `centeredContent`: The content inside the panel is centered
     * `empty`: Removes the panneling of the page content
     */
  template: PropTypes.any,

  /**
     * Padding size will not get applied to the over-arching #OuiPage,
     * but will propogate through all the components to keep them in sync
     */
  paddingSize: PropTypes.any,

  /**
     * Optionally include #OuiPageSideBar content.
     * The inclusion of this will affect the whole layout
     */
  pageSideBar: PropTypes.node,

  /**
     * Gets passed along to the #OuiPageSideBar component
     */
  pageSideBarProps: PropTypes.shape({
    /**
       * Adds `position: sticky` and affords for any fixed position headers
       */
    sticky: PropTypes.bool,

    /**
       * Adds padding around the children
       */
    paddingSize: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string
  }),

  /**
     * Optionally include an #OuiPageHeader by passing an object of its props
     */
  pageHeader: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Wrapped in an `H1` so choose appropriately.
       * A simple string is best
       */
    pageTitle: PropTypes.node,

    /**
       * Optional icon to place to the left of the title
       * @deprecated The `iconType` prop is deprecated and will be removed in the future.
       */
    iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "analyzeEvent", "annotation", "anomalyDetection", "apmApp", "apmTrace", "apps", "appSearchApp", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "chatLeft", "chatRight", "check", "checkInCircleEmpty", "checkInCircleFilled", "cheer", "classificationJob", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "color", "compute", "console", "consoleApp", "continuityAbove", "continuityAboveBelow", "continuityBelow", "continuityWithin", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "crossInCircleEmpty", "crossInCircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentation", "documentEdit", "documents", "dot", "download", "dockedBottom", "dockedDetached", "dockedLeft", "dockedRight", "dockedTakeover", "dockedTop", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "eql", "eraser", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "fold", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "frameNext", "framePrevious", "fullScreen", "fullScreenExit", "function", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexRuntime", "indexSettings", "inputOutput", "inspect", "integrationGeneral", "integrationObservability", "integrationSearch", "integrationSecurity", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "layers", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOpenSearch", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuDown", "menuLeft", "menuRight", "menuUp", "merge", "metricbeatApp", "metricsApp", "minimize", "minus", "minusInCircle", "minusInCircleFilled", "mobile", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "outlierDetectionJob", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "percent", "pin", "pinFilled", "pipelineApp", "play", "playFilled", "plus", "plusInCircle", "plusInCircleFilled", "polygon", "popout", "power", "push", "questionInCircle", "quote", "radius", "recentlyViewedApp", "redeploy", "refresh", "regressionJob", "reporter", "reportingApp", "returnKey", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "thumbsDown", "thumbsUp", "timeline", "timelionApp", "timeslider", "training", "trash", "upgradeAssistantApp", "uptimeApp", "undeploy", "unfold", "unlink", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visBuilder", "visBuilderSavedObject", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visQueryDQL", "visQueryPPL", "visQueryPromQL", "visQuerySQL", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wordWrap", "wordWrapDisabled", "workplaceSearchApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]),

    /**
       * Additional OuiIcon props to apply to the optional icon
       * @deprecated The `iconProps` prop is deprecated and will be removed in the future.
       */
    iconProps: PropTypes.any,

    /**
       * In-app navigation presented as large borderless tabs.
       * Accepts an array of `OuiTab` objects;
       * HELP: This is evaluating to `any[]` in the props table
       */
    tabs: PropTypes.arrayOf(PropTypes.shape({
      /**
         * Visible text of the tab
         */
      label: PropTypes.node.isRequired
    }).isRequired),

    /**
       * Any extras to apply to the outer tabs container.
       * Extends `OuiTabs`
       */
    tabsProps: PropTypes.shape({
      className: PropTypes.string,
      "aria-label": PropTypes.string,
      "data-test-subj": PropTypes.string,

      /**
           * ReactNode to render as this component's content
           */
      children: PropTypes.node
    }),

    /**
         * Position is dependent on existing with a `pageTitle` or `tabs`
         * Automatically get wrapped in a single paragraph tag inside an OuiText block
         */
    description: PropTypes.oneOfType([PropTypes.string.isRequired, PropTypes.node.isRequired]),

    /**
         * Set to false if you don't want the children to stack at small screen sizes.
         * Set to `reverse` to display the right side content first for the sack of hierarchy (like global time)
         */
    responsive: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["reverse"])]),

    /**
         * Vertical alignment of the left and right side content;
         * Default is `middle` for custom content, but `top` for when `pageTitle` or `tabs` are included
         */
    alignItems: PropTypes.any,

    /**
         * Pass custom an array of content to this side usually up to 3 buttons.
         * The first button should be primary, usually with `fill` and will be visually displayed as the last item,
         * but first in the tab order
         */
    rightSideItems: PropTypes.arrayOf(PropTypes.node.isRequired),

    /**
         * Additional OuiFlexGroup props to pass to the container of the `rightSideItems`
         */
    rightSideGroupProps: PropTypes.any,

    /**
         * Custom children will be rendered before the `tabs` unless no `pageTitle` is present, then it will be the last item
         */
    children: PropTypes.node,

    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1000px`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),

    /**
         * Adjust the padding.
         * When using this setting it's best to be consistent throughout all similar usages
         */
    paddingSize: PropTypes.any,

    /**
         * Adds a bottom border to separate it from the content after
         */
    bottomBorder: PropTypes.bool
  }),

  /**
     * Gets passed along to the #OuiPageBody component
     */
  pageBodyProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1000px`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired]),

    /**
         * Sets the HTML element for `OuiPageBody`.
         */
    component: PropTypes.any,

    /**
         * Uses an OuiPanel as the main component instead of a plain div
         */
    panelled: PropTypes.bool,

    /**
         * Extends any extra OuiPanel props if `panelled=true`
         */
    panelProps: PropTypes.any,

    /**
         * Adjusts the padding
         */
    paddingSize: PropTypes.any
  }),

  /**
     * Gets passed along to the #OuiPageContent component
     */
  pageContentProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Adds a medium shadow to the panel;
       * Only works when `color="plain"`
       */

    /**
       * Adds a medium shadow to the panel;
       * Only works when `color="plain"`
       */
    hasShadow: PropTypes.bool,

    /**
       * Adds a slight 1px border on all edges.
       * Only works when `color="plain | transparent"`
       * Default is `undefined` and will default to that theme's panel style
       */

    /**
       * Adds a slight 1px border on all edges.
       * Only works when `color="plain | transparent"`
       * Default is `undefined` and will default to that theme's panel style
       */
    hasBorder: PropTypes.bool,

    /**
       * Padding for all four sides
       */

    /**
       * Padding for all four sides
       */
    paddingSize: PropTypes.any,

    /**
       * Corner border radius
       */

    /**
       * Corner border radius
       */
    borderRadius: PropTypes.any,

    /**
       * When true the panel will grow in height to match `OuiFlexItem`
       */

    /**
       * When true the panel will grow in height to match `OuiFlexItem`
       */
    grow: PropTypes.bool,
    panelRef: PropTypes.any,

    /**
       * Background color of the panel;
       * Usually a lightened form of the brand colors
       */

    /**
       * Background color of the panel;
       * Usually a lightened form of the brand colors
       */
    color: PropTypes.any,
    element: PropTypes.oneOf(["div"]),

    /**
         * **DEPRECATED: use `paddingSize` instead.**
         */
    panelPaddingSize: PropTypes.any,
    verticalPosition: PropTypes.oneOf(["center"]),
    horizontalPosition: PropTypes.oneOf(["center"]),

    /**
         * There should only be one OuiPageContent per page and should contain the main contents.
         * If this is untrue, set role = `null`, or change it to match your needed aria role
         */
    role: PropTypes.oneOfType([PropTypes.any.isRequired, PropTypes.oneOf([null])])
  }),

  /**
     * Gets passed along to the #OuiPageContentBody component
     */
  pageContentBodyProps: PropTypes.shape({
    /**
       * Adjust the padding.
       * When using this setting it's best to be consistent throughout all similar usages
       */
    paddingSize: PropTypes.any,
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
       * Sets the max-width of the page,
       * set to `true` to use the default size of `1000px`,
       * set to `false` to not restrict the width,
       * set to a number for a custom width in px,
       * set to a string for a custom width in custom measurement.
       */
    restrictWidth: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.number.isRequired, PropTypes.string.isRequired])
  }),

  /**
     * Adds contents inside of an OuiBottomBar.
     * Only works when `template = 'default'`
     */
  bottomBar: PropTypes.any,

  /**
     * Gets passed along to the #OuiBottomBar component if `bottomBar` has contents
     */
  bottomBarProps: PropTypes.shape({
    className: PropTypes.string,
    "aria-label": PropTypes.string,
    "data-test-subj": PropTypes.string,

    /**
         * How to position the bottom bar against its parent.
         */
    position: PropTypes.oneOfType([PropTypes.oneOf(["fixed"]), PropTypes.oneOf(["static", "sticky"]).isRequired]),

    /**
         * Whether to wrap in an OuiPortal which appends the component to the body element.
         * Only works if `position` is `fixed`.
         */
    usePortal: PropTypes.bool,

    /**
         * Whether the component should apply padding on the document body element to afford for its own displacement height.
         * Only works if `usePortal` is true and `position` is `fixed`.
         */
    affordForDisplacement: PropTypes.bool,

    /**
         * Padding applied to the bar. Default is 'm'.
         */
    paddingSize: PropTypes.oneOf(["none", "s", "m", "l"]),

    /**
         * Optional class applied to the body element on mount.
         */
    bodyClassName: PropTypes.string,

    /**
         * Customize the screen reader heading that helps users find this control. Default is 'Page level controls'.
         */
    landmarkHeading: PropTypes.string,

    /**
         * Starting vertical position when `fixed` position.
         * Offset from the top of the window when `sticky` position.
         * Has no affect on `static` positions.
         */
    top: PropTypes.any,

    /**
         * Ending horizontal position when `fixed` position.
         * Has no affect on `static` or `sticky` positions.
         */
    right: PropTypes.any,

    /**
         * Starting vertical position when `fixed` position.
         * Offset from the bottom of the window when `sticky` position.
         * Has no affect on `static` positions.
         */
    bottom: PropTypes.any,

    /**
         * Starting horizontal position when `fixed` position.
         * Has no affect on `static` or `sticky` positions.
         */
    left: PropTypes.any
  }),

  /**
     * Stretches or restricts the height to 100% of the parent;
     * `true`: scrolls the OuiPageContentBody;
     * `noscroll`: removes all scroll ability;
     * Only works when `template = 'default | empty'` and breakpoint is `m` and above
     */
  fullHeight: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.oneOf(["noscroll"])]),

  /**
     * Minimum height in which to enforce scrolling
     */
  minHeight: PropTypes.any
};

/* OUI -> EUI Aliases: Build-Time */
export { EuiPageTemplate } from '../../eui_components/page/page_template';