/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.ArrayOutputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DataInputUtil;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.ErrorObjectInput;
import org.apache.derby.iapi.services.io.FormatIdInputStream;
import org.apache.derby.iapi.services.io.FormatIdOutputStream;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.PageTimeStamp;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.ByteHolder;
import org.apache.derby.impl.store.raw.data.CachedPage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.impl.store.raw.data.LongColumnException;
import org.apache.derby.impl.store.raw.data.MemByteHolder;
import org.apache.derby.impl.store.raw.data.NoSpaceOnPage;
import org.apache.derby.impl.store.raw.data.OverflowInputStream;
import org.apache.derby.impl.store.raw.data.PageCreationArgs;
import org.apache.derby.impl.store.raw.data.PageVersion;
import org.apache.derby.impl.store.raw.data.RawField;
import org.apache.derby.impl.store.raw.data.ReclaimSpace;
import org.apache.derby.impl.store.raw.data.RememberBytesInputStream;
import org.apache.derby.impl.store.raw.data.StoredFieldHeader;
import org.apache.derby.impl.store.raw.data.StoredRecordHeader;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.sanity.SanityManager;

public class StoredPage
extends CachedPage {
    public static final int FORMAT_NUMBER = 117;
    protected static final int PAGE_HEADER_OFFSET = 4;
    protected static final int PAGE_HEADER_SIZE = 56;
    protected static final int RECORD_SPACE_OFFSET = 60;
    protected static final int PAGE_VERSION_OFFSET = 6;
    protected static final int SMALL_SLOT_SIZE = 2;
    protected static final int LARGE_SLOT_SIZE = 4;
    protected static final int CHECKSUM_SIZE = 8;
    protected static final int OVERFLOW_POINTER_SIZE = 12;
    protected static final int OVERFLOW_PTR_FIELD_SIZE = 14;
    ByteHolder bh = null;
    protected static final int COLUMN_NONE = 0;
    protected static final int COLUMN_FIRST = 1;
    protected static final int COLUMN_LONG = 2;
    protected static final int COLUMN_CREATE_NULL = 3;
    private int maxFieldSize;
    private boolean isOverflowPage;
    private int slotsInUse;
    private int nextId;
    private int generation;
    private int prevGeneration;
    private long bipLocation;
    private int deletedRowCount;
    private boolean headerOutOfDate;
    private CRC32 checksum;
    protected int minimumRecordSize;
    private int userRowSize;
    private int slotFieldSize;
    private int slotEntrySize;
    private int slotTableOffsetToFirstEntry;
    private int slotTableOffsetToFirstRecordLengthField;
    private int slotTableOffsetToFirstReservedSpaceField;
    protected int totalSpace;
    protected int freeSpace = Integer.MIN_VALUE;
    private int firstFreeByte = Integer.MIN_VALUE;
    protected int spareSpace;
    private StoredRecordHeader overflowRecordHeader;
    protected ArrayInputStream rawDataIn;
    protected ArrayOutputStream rawDataOut;
    protected FormatIdOutputStream logicalDataOut;

    @Override
    public int getTypeFormatId() {
        return 117;
    }

    private StoredRecordHeader getOverFlowRecordHeader() throws StandardException {
        return this.overflowRecordHeader != null ? this.overflowRecordHeader : (this.overflowRecordHeader = new StoredRecordHeader());
    }

    @Override
    protected void initialize() {
        super.initialize();
        if (this.rawDataIn == null) {
            this.rawDataIn = new ArrayInputStream();
            this.checksum = new CRC32();
        }
        if (this.pageData != null) {
            this.rawDataIn.setData(this.pageData);
        }
    }

    private void createOutStreams() {
        this.rawDataOut = new ArrayOutputStream();
        this.rawDataOut.setData(this.pageData);
        this.logicalDataOut = new FormatIdOutputStream(this.rawDataOut);
    }

    private void setOutputStream(OutputStream out) {
        if (this.rawDataOut == null) {
            this.createOutStreams();
        }
        this.logicalDataOut.setOutput(out);
    }

    private void resetOutputStream() {
        this.logicalDataOut.setOutput(this.rawDataOut);
    }

    @Override
    protected void usePageBuffer(byte[] pageBuffer) {
        this.pageData = pageBuffer;
        int pageSize = this.pageData.length;
        if (this.rawDataIn != null) {
            this.rawDataIn.setData(this.pageData);
        }
        this.slotFieldSize = this.calculateSlotFieldSize(pageSize);
        this.slotEntrySize = 3 * this.slotFieldSize;
        this.initSpace();
        this.slotTableOffsetToFirstEntry = pageSize - 8 - this.slotEntrySize;
        this.slotTableOffsetToFirstRecordLengthField = this.slotTableOffsetToFirstEntry + this.slotFieldSize;
        this.slotTableOffsetToFirstReservedSpaceField = this.slotTableOffsetToFirstEntry + 2 * this.slotFieldSize;
        if (this.rawDataOut != null) {
            this.rawDataOut.setData(this.pageData);
        }
    }

    private int calculateSlotFieldSize(int pageSize) {
        if (pageSize < 65536) {
            return 2;
        }
        return 4;
    }

    @Override
    protected void createPage(PageKey newIdentity, PageCreationArgs args) throws StandardException {
        this.spareSpace = args.spareSpace;
        this.minimumRecordSize = args.minimumRecordSize;
        this.setPageArray(args.pageSize);
        this.cleanPage();
        this.setPageVersion(0L);
        this.nextId = 6;
        this.generation = 0;
        this.prevGeneration = 0;
        this.bipLocation = 0L;
        this.createOutStreams();
    }

    @Override
    protected void initFromData(FileContainer myContainer, PageKey newIdentity) throws StandardException {
        if (myContainer != null) {
            this.spareSpace = myContainer.getSpareSpace();
            this.minimumRecordSize = myContainer.getMinimumRecordSize();
        }
        try {
            this.validateChecksum(newIdentity);
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("XSDG2.D")) {
                int pagesize = this.getPageSize();
                byte[] corruptPage = this.pageData;
                this.pageData = null;
                this.setPageArray(pagesize);
                try {
                    myContainer.readPage(newIdentity.getPageNumber(), this.pageData);
                }
                catch (IOException ioe) {
                    throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{newIdentity}));
                }
                SanityManager.DEBUG_CLEAR((String)"TEST_BAD_CHECKSUM");
                try {
                    this.validateChecksum(newIdentity);
                }
                catch (StandardException sse) {
                    throw this.dataFactory.markCorrupt(se);
                }
                String firstImage = StoredPage.pagedataToHexDump(corruptPage);
                String secondImage = this.toString();
                throw StandardException.newException((String)"XSDFD.S", (Throwable)se, (Object[])new Object[]{newIdentity, firstImage, secondImage});
            }
            throw se;
        }
        try {
            this.readPageHeader();
            this.initSlotTable(newIdentity);
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{newIdentity}));
        }
    }

    protected void validateChecksum(PageKey id) throws StandardException {
        long onDiskChecksum;
        try {
            this.rawDataIn.setPosition(this.getPageSize() - 8);
            onDiskChecksum = this.rawDataIn.readLong();
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{id}));
        }
        this.checksum.reset();
        this.checksum.update(this.pageData, 0, this.getPageSize() - 8);
        if (SanityManager.DEBUG_ON((String)"TEST_BAD_CHECKSUM")) {
            onDiskChecksum = 123456789L;
        }
        if (onDiskChecksum != this.checksum.getValue()) {
            CRC32 newChecksum = new CRC32();
            newChecksum.reset();
            newChecksum.update(this.pageData, 0, this.getPageSize() - 8);
            if (onDiskChecksum != newChecksum.getValue()) {
                throw StandardException.newException((String)"XSDG2.D", (Object[])new Object[]{id, this.checksum.getValue(), onDiskChecksum, StoredPage.pagedataToHexDump(this.pageData)});
            }
            SanityManager.THROWASSERT((String)"old checksum gets wrong value");
            this.checksum = newChecksum;
        }
    }

    protected void updateChecksum() throws IOException {
        this.checksum.reset();
        this.checksum.update(this.pageData, 0, this.getPageSize() - 8);
        this.rawDataOut.setPosition(this.getPageSize() - 8);
        this.logicalDataOut.writeLong(this.checksum.getValue());
    }

    @Override
    protected void writePage(PageKey identity) throws StandardException {
        if (this.freeSpace < 0 || this.firstFreeByte + this.freeSpace != this.getSlotOffset(this.slotsInUse - 1)) {
            SanityManager.THROWASSERT((String)("writePage detected problem in freespace and used space.slotsInUse = " + this.slotsInUse + ", firstFreeByte = " + this.firstFreeByte + ", freeSpace = " + this.freeSpace + ", slotOffset = " + this.getSlotOffset(this.slotsInUse - 1) + ", page = " + this));
        }
        if (this.slotsInUse == 0 && this.firstFreeByte != this.getPageSize() - this.totalSpace - 8) {
            SanityManager.THROWASSERT((String)("slotsInUse = " + this.slotsInUse + ", firstFreeByte = " + this.firstFreeByte + ", freeSpace = " + this.freeSpace + ", slotOffset = " + this.getSlotOffset(this.slotsInUse - 1) + ", page = " + this));
        }
        try {
            if (this.headerOutOfDate) {
                this.updatePageHeader();
            } else {
                this.updatePageVersion();
            }
            this.updateChecksum();
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{identity}));
        }
    }

    @Override
    protected void writeFormatId(PageKey identity) throws StandardException {
        try {
            if (this.rawDataOut == null) {
                this.createOutStreams();
            }
            this.rawDataOut.setPosition(0);
            FormatIdUtil.writeFormatIdInteger(this.logicalDataOut, this.getTypeFormatId());
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{identity}));
        }
    }

    @Override
    protected void releaseExclusive() {
        super.releaseExclusive();
        this.pageCache.release(this);
    }

    @Override
    public int getTotalSpace(int slot) throws StandardException {
        try {
            if (this.getRecordOffset(slot) <= 0) {
                SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("getTotalSpace failed with getRecordOffset(" + slot + ") = " + this.getRecordOffset(slot) + " must be greater than 0.page dump = \n" + this.toUncheckedString()));
                SanityManager.THROWASSERT((String)"bad record offset found in getTotalSpace()");
            }
            this.rawDataIn.setPosition(this.getSlotOffset(slot) + this.slotFieldSize);
            return this.slotFieldSize == 2 ? this.rawDataIn.readUnsignedShort() + this.rawDataIn.readUnsignedShort() : this.rawDataIn.readInt() + this.rawDataIn.readInt();
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{this.getPageId()}));
        }
    }

    @Override
    public boolean spaceForInsert() throws StandardException {
        if (this.slotsInUse == 0) {
            return true;
        }
        if (!this.allowInsert()) {
            return false;
        }
        int usedSpace = this.totalSpace - this.freeSpace;
        int bytesPerRow = usedSpace / this.slotsInUse;
        return bytesPerRow <= this.freeSpace;
    }

    @Override
    public boolean spaceForInsert(Object[] row, FormatableBitSet validColumns, int overflowThreshold) throws StandardException {
        if (this.slotsInUse == 0) {
            return true;
        }
        if (!this.allowInsert()) {
            return false;
        }
        DynamicByteArrayOutputStream out = new DynamicByteArrayOutputStream();
        try {
            this.logRow(0, true, this.nextId, row, validColumns, out, 0, (byte)1, -1, -1, overflowThreshold);
        }
        catch (NoSpaceOnPage nsop) {
            return false;
        }
        catch (IOException ioe) {
            throw StandardException.newException((String)"XSDA4.S", (Throwable)ioe, (Object[])new Object[0]);
        }
        return true;
    }

    private boolean spaceForInsert(Object[] row, FormatableBitSet validColumns, int spaceNeeded, int startColumn, int overflowThreshold) throws StandardException {
        if (!this.spaceForInsert() || this.freeSpace < spaceNeeded) {
            return false;
        }
        DynamicByteArrayOutputStream out = new DynamicByteArrayOutputStream();
        try {
            this.logRow(0, true, this.nextId, row, validColumns, out, startColumn, (byte)1, -1, -1, overflowThreshold);
        }
        catch (NoSpaceOnPage nsop) {
            return false;
        }
        catch (IOException ioe) {
            throw StandardException.newException((String)"XSDA4.S", (Throwable)ioe, (Object[])new Object[0]);
        }
        return true;
    }

    @Override
    public boolean unfilled() {
        return this.allowInsert() && this.freeSpace > this.getPageSize() / 2;
    }

    @Override
    public boolean allowInsert() {
        if (this.slotsInUse == 0) {
            return true;
        }
        int spaceAvailable = this.freeSpace;
        if ((spaceAvailable -= this.slotEntrySize) < this.minimumRecordSize || spaceAvailable < 17) {
            return false;
        }
        return spaceAvailable * 100 / this.totalSpace >= this.spareSpace;
    }

    @Override
    public boolean spaceForCopy(int num_rows, int[] spaceNeeded) {
        int bytesNeeded = this.slotEntrySize * num_rows;
        for (int i = 0; i < num_rows; ++i) {
            if (spaceNeeded[i] <= 0) continue;
            bytesNeeded += spaceNeeded[i] >= this.minimumRecordSize ? spaceNeeded[i] : this.minimumRecordSize;
        }
        return this.freeSpace - bytesNeeded >= 0;
    }

    protected boolean spaceForCopy(int spaceNeeded, int source_id) {
        int bytesNeeded = this.slotEntrySize + ((spaceNeeded = spaceNeeded - StoredRecordHeader.getStoredSizeRecordId(source_id) + StoredRecordHeader.getStoredSizeRecordId(this.nextId)) >= this.minimumRecordSize ? spaceNeeded : this.minimumRecordSize);
        return this.freeSpace - bytesNeeded >= 0;
    }

    @Override
    protected boolean restoreRecordFromSlot(int slot, Object[] row, FetchDescriptor fetchDesc, RecordHandle recordToLock, StoredRecordHeader recordHeader, boolean isHeadRow) throws StandardException {
        try {
            int offset_to_row_data = this.getRecordOffset(slot) + recordHeader.size();
            if (this.getRecordOffset(slot) < 60) {
                SanityManager.THROWASSERT((String)("Incorrect offset.  offset = " + this.getRecordOffset(slot) + ", offset should be < (PAGE_HEADER_OFFSET + PAGE_HEADER_SIZE) = 60, current slot = " + slot + ", total slotsInUse = " + this.slotsInUse));
            }
            SanityManager.ASSERT((boolean)isHeadRow, (String)"restoreRecordFromSlot called on a non-headrow");
            SanityManager.ASSERT((!this.isOverflowPage() ? 1 : 0) != 0, (String)"restoreRecordFromSlot called on an overflow page.");
            ArrayInputStream lrdi = this.rawDataIn;
            lrdi.setPosition(offset_to_row_data);
            if (!recordHeader.hasOverflow()) {
                if (isHeadRow && fetchDesc != null && fetchDesc.getQualifierList() != null) {
                    fetchDesc.reset();
                    if (!this.qualifyRecordFromSlot(row, offset_to_row_data, fetchDesc, recordHeader, recordToLock)) {
                        return false;
                    }
                    lrdi.setPosition(offset_to_row_data);
                }
                if (fetchDesc != null) {
                    this.readRecordFromArray(row, fetchDesc.getValidColumns() == null ? row.length - 1 : fetchDesc.getMaxFetchColumnId(), fetchDesc.getValidColumnsArray(), fetchDesc.getMaterializedColumns(), lrdi, recordHeader, recordToLock);
                } else {
                    this.readRecordFromArray(row, row.length - 1, null, null, lrdi, recordHeader, recordToLock);
                }
                return true;
            }
            if (fetchDesc != null) {
                if (fetchDesc.getQualifierList() != null) {
                    fetchDesc.reset();
                }
                this.readRecordFromArray(row, fetchDesc.getValidColumns() == null ? row.length - 1 : fetchDesc.getMaxFetchColumnId(), fetchDesc.getValidColumnsArray(), fetchDesc.getMaterializedColumns(), lrdi, recordHeader, recordToLock);
            } else {
                this.readRecordFromArray(row, row.length - 1, null, null, lrdi, recordHeader, recordToLock);
            }
            while (recordHeader != null) {
                StoredPage overflowPage = this.getOverflowPage(recordHeader.getOverflowPage());
                if (overflowPage == null) {
                    SanityManager.THROWASSERT((String)"cannot get overflow page");
                }
                recordHeader = overflowPage.restoreLongRecordFromSlot(row, fetchDesc, recordToLock, recordHeader);
                overflowPage.unlatch();
                overflowPage = null;
            }
            return fetchDesc == null || fetchDesc.getQualifierList() == null || this.qualifyRecordFromRow(row, fetchDesc.getQualifierList());
        }
        catch (IOException ioe) {
            if (this.pageData == null) {
                SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("caught an IOException in restoreRecordFromSlot " + (PageKey)this.getIdentity() + " slot " + slot + ", pageData is null"));
            } else {
                SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("caught an IOException in reestoreRecordFromSlot, " + (PageKey)this.getIdentity() + " slot " + slot + ", pageData.length = " + this.pageData.length + " pageSize = " + this.getPageSize()));
                SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("Hex dump of pageData \n --------------------------------------------------\n" + StoredPage.pagedataToHexDump(this.pageData) + "--------------------------------------------------\n"));
                SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("Attempt to dump page " + this.toString()));
            }
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{this.getPageId()}));
        }
    }

    private StoredRecordHeader restoreLongRecordFromSlot(Object[] row, FetchDescriptor fetchDesc, RecordHandle recordToLock, StoredRecordHeader parent_recordHeader) throws StandardException {
        int slot = this.findRecordById(parent_recordHeader.getOverflowId(), 0);
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        try {
            int offset_to_row_data = this.getRecordOffset(slot) + recordHeader.size();
            if (this.getRecordOffset(slot) < 60) {
                SanityManager.THROWASSERT((String)("Incorrect offset.  offset = " + this.getRecordOffset(slot) + ", offset should be < (PAGE_HEADER_OFFSET + PAGE_HEADER_SIZE) = 60, current slot = " + slot + ", total slotsInUse = " + this.slotsInUse));
            }
            ArrayInputStream lrdi = this.rawDataIn;
            lrdi.setPosition(offset_to_row_data);
            if (fetchDesc != null) {
                if (fetchDesc.getQualifierList() != null) {
                    fetchDesc.reset();
                }
                this.readRecordFromArray(row, fetchDesc.getValidColumns() == null ? row.length - 1 : fetchDesc.getMaxFetchColumnId(), fetchDesc.getValidColumnsArray(), fetchDesc.getMaterializedColumns(), lrdi, recordHeader, recordToLock);
            } else {
                this.readRecordFromArray(row, row.length - 1, null, null, lrdi, recordHeader, recordToLock);
            }
            return recordHeader.hasOverflow() ? recordHeader : null;
        }
        catch (IOException ioe) {
            if (this.pageData == null) {
                SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("caught an IOException in restoreRecordFromSlot " + (PageKey)this.getIdentity() + " slot " + slot + ", pageData is null"));
            } else {
                SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("caught an IOException in reestoreRecordFromSlot, " + (PageKey)this.getIdentity() + " slot " + slot + ", pageData.length = " + this.pageData.length + " pageSize = " + this.getPageSize()));
                SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("Hex dump of pageData \n --------------------------------------------------\n" + StoredPage.pagedataToHexDump(this.pageData) + "--------------------------------------------------\n"));
                SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("Attempt to dump page " + this.toString()));
            }
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{this.getPageId()}));
        }
    }

    @Override
    public int newRecordId() {
        return this.nextId;
    }

    @Override
    public int newRecordIdAndBump() {
        this.headerOutOfDate = true;
        return this.nextId++;
    }

    @Override
    protected int newRecordId(int recordId) {
        SanityManager.ASSERT((recordId >= this.nextId ? 1 : 0) != 0, (String)"should not create a record Id that is already given out");
        return recordId + 1;
    }

    @Override
    public boolean isOverflowPage() {
        return this.isOverflowPage;
    }

    public final int getPageSize() {
        return this.pageData.length;
    }

    protected final void clearSection(int offset, int length) {
        Arrays.fill(this.pageData, offset, offset + length, (byte)0);
    }

    protected int getMaxFreeSpace() {
        return this.getPageSize() - 60 - 8;
    }

    protected int getCurrentFreeSpace() {
        return this.freeSpace;
    }

    private void readPageHeader() throws IOException {
        ArrayInputStream lrdi = this.rawDataIn;
        lrdi.setPosition(4);
        this.isOverflowPage = lrdi.readBoolean();
        this.setPageStatus(lrdi.readByte());
        this.setPageVersion(lrdi.readLong());
        this.slotsInUse = lrdi.readUnsignedShort();
        this.nextId = lrdi.readInt();
        this.generation = lrdi.readInt();
        this.prevGeneration = lrdi.readInt();
        this.bipLocation = lrdi.readLong();
        this.deletedRowCount = lrdi.readUnsignedShort() - 1;
        long spare = lrdi.readUnsignedShort();
        spare = lrdi.readInt();
        spare = lrdi.readLong();
        spare = lrdi.readLong();
    }

    private void updatePageHeader() throws IOException {
        this.rawDataOut.setPosition(4);
        this.logicalDataOut.writeBoolean(this.isOverflowPage);
        this.logicalDataOut.writeByte(this.getPageStatus());
        this.logicalDataOut.writeLong(this.getPageVersion());
        this.logicalDataOut.writeShort(this.slotsInUse);
        this.logicalDataOut.writeInt(this.nextId);
        this.logicalDataOut.writeInt(this.generation);
        this.logicalDataOut.writeInt(this.prevGeneration);
        this.logicalDataOut.writeLong(this.bipLocation);
        this.logicalDataOut.writeShort(this.deletedRowCount + 1);
        this.logicalDataOut.writeShort(0);
        this.logicalDataOut.writeInt(this.dataFactory.random());
        this.logicalDataOut.writeLong(0L);
        this.logicalDataOut.writeLong(0L);
        this.headerOutOfDate = false;
    }

    private void updatePageVersion() throws IOException {
        this.rawDataOut.setPosition(6);
        this.logicalDataOut.writeLong(this.getPageVersion());
    }

    private int getSlotOffset(int slot) {
        return this.slotTableOffsetToFirstEntry - slot * this.slotEntrySize;
    }

    private int getRecordOffset(int slot) {
        byte[] data = this.pageData;
        int offset = this.slotTableOffsetToFirstEntry - slot * this.slotEntrySize;
        return this.slotFieldSize == 2 ? (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF : (data[offset++] & 0xFF) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset] & 0xFF;
    }

    private void setRecordOffset(int slot, int recordOffset) throws IOException {
        this.rawDataOut.setPosition(this.getSlotOffset(slot));
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(recordOffset);
        } else {
            this.logicalDataOut.writeInt(recordOffset);
        }
    }

    protected int getRecordPortionLength(int slot) throws IOException {
        if (this.getRecordOffset(slot) <= 0) {
            SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("getRecordPortionLength failed with getRecordOffset(" + slot + ") = " + this.getRecordOffset(slot) + " must be greater than 0.page dump = \n" + this.toUncheckedString()));
            SanityManager.THROWASSERT((String)"bad record offset found in getRecordPortionLength()");
        }
        ArrayInputStream lrdi = this.rawDataIn;
        lrdi.setPosition(this.slotTableOffsetToFirstRecordLengthField - slot * this.slotEntrySize);
        return this.slotFieldSize == 2 ? lrdi.readUnsignedShort() : lrdi.readInt();
    }

    @Override
    public int getReservedCount(int slot) throws IOException {
        if (this.getRecordOffset(slot) <= 0) {
            SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("getReservedCount failed with getRecordOffset(" + slot + ") = " + this.getRecordOffset(slot) + " must be greater than 0.page dump = \n" + this.toUncheckedString()));
            SanityManager.THROWASSERT((String)"bad record offset found in getReservedCount");
        }
        ArrayInputStream lrdi = this.rawDataIn;
        lrdi.setPosition(this.slotTableOffsetToFirstReservedSpaceField - slot * this.slotEntrySize);
        return this.slotFieldSize == 2 ? lrdi.readUnsignedShort() : lrdi.readInt();
    }

    private void updateRecordPortionLength(int slot, int delta, int reservedDelta) throws IOException {
        SanityManager.ASSERT((this.getRecordOffset(slot) != 0 ? 1 : 0) != 0);
        if (delta + reservedDelta < 0) {
            SanityManager.THROWASSERT((String)("total space of record is not allowed to shrink, delta == " + delta + " reservedDelta = " + reservedDelta));
        }
        if (this.getRecordPortionLength(slot) + delta < 0) {
            SanityManager.THROWASSERT((String)("record portion length cannot be < 0.recordPortionLength = " + this.getRecordPortionLength(slot) + " delta = " + delta));
        }
        if (this.getReservedCount(slot) + reservedDelta < 0) {
            SanityManager.THROWASSERT((String)("reserved space for record cannot be < 0.  reservedCount = " + this.getReservedCount(slot) + " reservedDelta = " + reservedDelta));
        }
        this.rawDataOut.setPosition(this.slotTableOffsetToFirstRecordLengthField - slot * this.slotEntrySize);
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(this.getRecordPortionLength(slot) + delta);
        } else {
            this.logicalDataOut.writeInt(this.getRecordPortionLength(slot) + delta);
        }
        if (reservedDelta != 0) {
            if (this.slotFieldSize == 2) {
                this.logicalDataOut.writeShort(this.getReservedCount(slot) + reservedDelta);
            } else {
                this.logicalDataOut.writeInt(this.getReservedCount(slot) + reservedDelta);
            }
        }
    }

    private void initSlotTable(PageKey newIdentity) throws StandardException {
        int localSlotsInUse = this.slotsInUse;
        this.initializeHeaders(localSlotsInUse);
        this.clearAllSpace();
        this.freeSpace -= localSlotsInUse * this.slotEntrySize;
        int lastSlotOnPage = -1;
        int lastRecordOffset = -1;
        try {
            for (int slot = 0; slot < localSlotsInUse; ++slot) {
                int recordOffset;
                int total_space = this.getTotalSpace(slot);
                if (!this.isOverflowPage() && this.minimumRecordSize > total_space || this.isOverflowPage() && 17 > total_space) {
                    SanityManager.THROWASSERT((String)("initSlotTable consistency check failed:  slot " + slot + " minimumRecordSize = " + this.minimumRecordSize + " totalSpace = " + total_space + " recordPortionLength = " + this.getRecordPortionLength(slot) + " reservedCount = " + this.getReservedCount(slot)));
                }
                if ((recordOffset = this.getRecordOffset(slot)) < 60 || recordOffset >= this.getPageSize() - 8) {
                    throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Object[])new Object[]{newIdentity}));
                }
                if (recordOffset <= lastRecordOffset) continue;
                lastRecordOffset = recordOffset;
                lastSlotOnPage = slot;
            }
            this.bumpRecordCount(localSlotsInUse);
            if (lastSlotOnPage != -1) {
                this.firstFreeByte = lastRecordOffset + this.getTotalSpace(lastSlotOnPage);
                this.freeSpace -= this.firstFreeByte - 60;
            }
            if (this.freeSpace < 0 || this.firstFreeByte > this.getSlotOffset(this.slotsInUse - 1) || this.firstFreeByte + this.freeSpace != this.getSlotOffset(this.slotsInUse - 1)) {
                SanityManager.THROWASSERT((String)("firstFreeByte = " + this.firstFreeByte + ", freeSpace = " + this.freeSpace + ", slotOffset = " + this.getSlotOffset(this.slotsInUse - 1) + ", slotsInUse = " + localSlotsInUse));
            }
            if (localSlotsInUse == 0) {
                SanityManager.ASSERT((this.firstFreeByte == this.getPageSize() - this.totalSpace - 8 ? 1 : 0) != 0);
            }
            if (this.deletedRowCount == -1) {
                int count = 0;
                int maxSlot = this.slotsInUse;
                for (int slot = 0; slot < maxSlot; ++slot) {
                    if (!this.isDeletedOnPage(slot)) continue;
                    ++count;
                }
                this.deletedRowCount = count;
            }
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{newIdentity}));
        }
    }

    private void setSlotEntry(int slot, int recordOffset, int recordPortionLength, int reservedSpace) throws IOException {
        this.rawDataOut.setPosition(this.getSlotOffset(slot));
        if (recordPortionLength < 0 || reservedSpace < 0 || recordPortionLength >= this.getPageSize() || reservedSpace >= this.getPageSize()) {
            SanityManager.THROWASSERT((String)("recordPortionLength and reservedSpace must be > 0, and < page size.  slot = " + slot + ", in use = " + this.slotsInUse + ", recordOffset = " + recordOffset + ", recordPortionLength = " + recordPortionLength + ", reservedSpace = " + reservedSpace));
        }
        if (recordOffset < 60) {
            SanityManager.THROWASSERT((String)("Record offset must be after the page header.  slot = " + slot + ", in use = " + this.slotsInUse + ", recordOffset = " + recordOffset + ", recordPortionLength = " + recordPortionLength + ", reservedSpace = " + reservedSpace));
        }
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(recordOffset);
            this.logicalDataOut.writeShort(recordPortionLength);
            this.logicalDataOut.writeShort(reservedSpace);
        } else {
            this.logicalDataOut.writeInt(recordOffset);
            this.logicalDataOut.writeInt(recordPortionLength);
            this.logicalDataOut.writeInt(reservedSpace);
        }
    }

    private void addSlotEntry(int slot, int recordOffset, int recordPortionLength, int reservedSpace) throws IOException {
        if (slot < 0 || slot > this.slotsInUse) {
            SanityManager.THROWASSERT((String)("invalid slot " + slot));
        }
        if (recordPortionLength < 0 || reservedSpace < 0) {
            SanityManager.THROWASSERT((String)("recordPortionLength and reservedSpace must be > 0.recordPortionLength = " + recordPortionLength + " reservedSpace = " + reservedSpace));
        }
        if (recordOffset < 60) {
            SanityManager.THROWASSERT((String)("Record offset must be after the page header.  slot = " + slot + ", in use = " + this.slotsInUse + ", recordOffset = " + recordOffset + ", recordPortionLength = " + recordPortionLength + ", reservedSpace = " + reservedSpace));
        }
        if (slot < this.slotsInUse) {
            int startOffset = this.getSlotOffset(this.slotsInUse - 1);
            int length = this.getSlotOffset(slot) + this.slotEntrySize - startOffset;
            int newSlotOffset = this.getSlotOffset(this.slotsInUse);
            System.arraycopy(this.pageData, startOffset, this.pageData, newSlotOffset, length);
        } else {
            int newSlotOffset = this.getSlotOffset(slot);
        }
        this.freeSpace -= this.slotEntrySize;
        ++this.slotsInUse;
        this.headerOutOfDate = true;
        this.setSlotEntry(slot, recordOffset, recordPortionLength, reservedSpace);
    }

    private void removeSlotEntry(int slot) throws IOException {
        if (slot < 0 || slot >= this.slotsInUse) {
            SanityManager.THROWASSERT((String)("invalid slot " + slot));
        }
        int oldEndOffset = this.getSlotOffset(this.slotsInUse - 1);
        int newEndOffset = this.getSlotOffset(this.slotsInUse - 2);
        if (slot != this.slotsInUse - 1) {
            int length = this.getSlotOffset(slot) - oldEndOffset;
            System.arraycopy(this.pageData, oldEndOffset, this.pageData, newEndOffset, length);
        }
        this.clearSection(oldEndOffset, this.slotEntrySize);
        this.freeSpace += this.slotEntrySize;
        --this.slotsInUse;
        this.headerOutOfDate = true;
    }

    @Override
    public StoredRecordHeader recordHeaderOnDemand(int slot) {
        StoredRecordHeader recordHeader = new StoredRecordHeader(this.pageData, this.getRecordOffset(slot));
        this.setHeaderAtSlot(slot, recordHeader);
        return recordHeader;
    }

    @Override
    public boolean entireRecordOnPage(int slot) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        if (recordHeader.hasOverflow()) {
            return false;
        }
        try {
            int offset = this.getRecordOffset(slot);
            if (offset < 60) {
                SanityManager.THROWASSERT((String)("Incorrect offset.  offset = " + offset + ", offset should be < (PAGE_HEADER_OFFSET + PAGE_HEADER_SIZE) = 60, current slot = " + slot + ", total slotsInUse = " + this.slotsInUse));
            }
            if (recordHeader.getFirstField() != 0) {
                SanityManager.THROWASSERT((String)("Head row piece should start at field 0 but is not,, current slot = " + slot + ", total slotsInUse = " + this.slotsInUse + "page = " + this));
            }
            int numberFields = recordHeader.getNumberFields();
            ArrayInputStream lrdi = this.rawDataIn;
            lrdi.setPosition(offset + recordHeader.size());
            for (int i = 0; i < numberFields; ++i) {
                int fieldStatus = StoredFieldHeader.readStatus(lrdi);
                if (StoredFieldHeader.isOverflow(fieldStatus)) {
                    return false;
                }
                int fieldLength = StoredFieldHeader.readFieldDataLength(lrdi, fieldStatus, this.slotFieldSize);
                if (fieldLength == 0) continue;
                lrdi.setPosition(lrdi.getPosition() + fieldLength);
            }
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{this.getPageId()}));
        }
        return true;
    }

    protected void purgeOverflowAtSlot(int slot, RecordHandle headRowHandle, boolean needDataLogged) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        SanityManager.ASSERT((boolean)this.isOverflowPage());
        if (slot < 0 || slot >= this.slotsInUse) {
            throw StandardException.newException((String)"XSDA1.S", (Object[])new Object[0]);
        }
        RawTransaction t = this.owner.getTransaction();
        int[] recordId = new int[]{this.getHeaderAtSlot(slot).getId()};
        this.owner.getActionSet().actionPurge(t, this, slot, 1, recordId, needDataLogged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOneColumnChain(long overflowPageId, int overflowRecordId) throws StandardException {
        StoredPage pageOnColumnChain = null;
        boolean removePageHappened = false;
        try {
            while (overflowPageId != -1L) {
                pageOnColumnChain = this.getOverflowPage(overflowPageId);
                removePageHappened = false;
                if (pageOnColumnChain == null) {
                    SanityManager.THROWASSERT((String)("got null page following long column chain.  Head column piece at " + this.getIdentity() + " null page at " + overflowPageId));
                    break;
                }
                int overflowSlotId = 0;
                int checkSlot = pageOnColumnChain.findRecordById(overflowRecordId, 0);
                if (overflowSlotId != checkSlot) {
                    SanityManager.THROWASSERT((String)("Long column is not at the expected 0 slot, instead at slot " + checkSlot));
                }
                SanityManager.ASSERT((pageOnColumnChain.recordCount() == 1 ? 1 : 0) != 0, (String)"long column page has > 1 record");
                RecordHandle nextColumnPiece = pageOnColumnChain.getNextColumnPiece(overflowSlotId);
                if (pageOnColumnChain.recordCount() == 1) {
                    removePageHappened = true;
                    this.owner.removePage(pageOnColumnChain);
                } else {
                    SanityManager.THROWASSERT((String)("page on column chain has more then one record" + pageOnColumnChain.toString()));
                    pageOnColumnChain.unlatch();
                    pageOnColumnChain = null;
                }
                if (nextColumnPiece != null) {
                    overflowPageId = nextColumnPiece.getPageNumber();
                    overflowRecordId = nextColumnPiece.getId();
                    continue;
                }
                overflowPageId = -1L;
            }
        }
        finally {
            if (!removePageHappened && pageOnColumnChain != null) {
                pageOnColumnChain.unlatch();
                pageOnColumnChain = null;
            }
        }
    }

    private void purgeColumnChains(RawTransaction t, int slot, RecordHandle headRowHandle) throws StandardException {
        try {
            StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
            int numberFields = recordHeader.getNumberFields();
            ArrayInputStream lrdi = this.rawDataIn;
            int offset = this.getRecordOffset(slot) + recordHeader.size();
            lrdi.setPosition(offset);
            for (int i = 0; i < numberFields; ++i) {
                int fieldStatus = StoredFieldHeader.readStatus(lrdi);
                int fieldLength = StoredFieldHeader.readFieldDataLength(lrdi, fieldStatus, this.slotFieldSize);
                if (!StoredFieldHeader.isOverflow(fieldStatus)) {
                    if (fieldLength == 0) continue;
                    lrdi.setPosition(lrdi.getPosition() + fieldLength);
                    continue;
                }
                long overflowPageId = CompressedNumber.readLong(lrdi);
                int overflowRecordId = CompressedNumber.readInt(lrdi);
                this.purgeOneColumnChain(overflowPageId, overflowRecordId);
            }
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{this.getPageId()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void purgeRowPieces(RawTransaction t, int slot, RecordHandle headRowHandle, boolean needDataLogged) throws StandardException {
        SanityManager.ASSERT((!this.isOverflowPage() ? 1 : 0) != 0, (String)"not expected to call purgeRowPieces on a overflow page");
        this.purgeColumnChains(t, slot, headRowHandle);
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        while (recordHeader.hasOverflow()) {
            StoredPage nextPageInRowChain = this.getOverflowPage(recordHeader.getOverflowPage());
            if (nextPageInRowChain == null) {
                SanityManager.THROWASSERT((String)("got null page following long row chain.  Head row piece at " + this.getIdentity() + " slot " + slot + " headRecord " + headRowHandle + ".  Broken row chain at " + recordHeader.getOverflowPage() + ", " + recordHeader.getOverflowId()));
                break;
            }
            try {
                int nextPageSlot = StoredPage.getOverflowSlot(nextPageInRowChain, recordHeader);
                nextPageInRowChain.purgeColumnChains(t, nextPageSlot, headRowHandle);
                recordHeader = nextPageInRowChain.getHeaderAtSlot(nextPageSlot);
                if (nextPageSlot == 0 && nextPageInRowChain.recordCount() == 1) {
                    try {
                        this.owner.removePage(nextPageInRowChain);
                        continue;
                    }
                    finally {
                        nextPageInRowChain = null;
                        continue;
                    }
                }
                nextPageInRowChain.purgeOverflowAtSlot(nextPageSlot, headRowHandle, needDataLogged);
                nextPageInRowChain.unlatch();
                nextPageInRowChain = null;
            }
            finally {
                if (nextPageInRowChain == null) continue;
                nextPageInRowChain.unlatch();
                nextPageInRowChain = null;
            }
        }
    }

    void removeOrphanedColumnChain(ReclaimSpace work, ContainerHandle containerHdl) throws StandardException {
        StoredPage headOfChain = (StoredPage)containerHdl.getPageNoWait(work.getColumnPageId());
        if (headOfChain == null) {
            return;
        }
        boolean pageUnchanged = headOfChain.equalTimeStamp(work.getPageTimeStamp());
        headOfChain.unlatch();
        if (!pageUnchanged) {
            return;
        }
        RecordHandle headRowHandle = work.getHeadRowHandle();
        SanityManager.ASSERT((boolean)this.isLatched());
        SanityManager.ASSERT((headRowHandle.getPageNumber() == this.getPageNumber() ? 1 : 0) != 0, (String)"got wrong head page");
        int slot = this.findRecordById(headRowHandle.getId(), headRowHandle.getSlotNumberHint());
        if (slot >= 0) {
            if (this.isOverflowPage()) {
                SanityManager.THROWASSERT((String)("Page " + this.getPageNumber() + " is overflow \nwork = " + work + "\nhead = " + headOfChain + "\nthis = " + this));
            }
            StoredPage pageInRowChain = this;
            try {
                int columnId = work.getColumnId();
                StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
                SanityManager.ASSERT((recordHeader.getFirstField() == 0 ? 1 : 0) != 0, (String)"Head row piece should start at field 0 but is not");
                while (recordHeader.getNumberFields() + recordHeader.getFirstField() <= columnId) {
                    if (pageInRowChain != this) {
                        pageInRowChain.unlatch();
                        pageInRowChain = null;
                    }
                    if (!recordHeader.hasOverflow()) break;
                    pageInRowChain = this.getOverflowPage(recordHeader.getOverflowPage());
                    recordHeader = pageInRowChain.getHeaderAtSlot(StoredPage.getOverflowSlot(pageInRowChain, recordHeader));
                }
                if (recordHeader.getNumberFields() + recordHeader.getFirstField() > columnId && !pageInRowChain.isColumnOrphaned(recordHeader, columnId, work.getColumnPageId(), work.getColumnRecordId())) {
                    if (pageInRowChain != this) {
                        pageInRowChain.unlatch();
                        pageInRowChain = null;
                    }
                    return;
                }
            }
            catch (IOException ioe) {
                throw StandardException.newException((String)"XSDA4.S", (Throwable)ioe, (Object[])new Object[0]);
            }
            finally {
                if (pageInRowChain != this && pageInRowChain != null) {
                    pageInRowChain.unlatch();
                }
            }
        }
        long nextPageId = work.getColumnPageId();
        int nextRecordId = work.getColumnRecordId();
        this.purgeOneColumnChain(nextPageId, nextRecordId);
    }

    private boolean isColumnOrphaned(StoredRecordHeader recordHeader, int columnId, long oldPageId, long oldRecordId) throws StandardException, IOException {
        int slot = this.findRecordById(recordHeader.getId(), 0);
        SanityManager.ASSERT((slot >= 0 ? 1 : 0) != 0, (String)"overflow row chain truncated");
        SanityManager.ASSERT((columnId >= recordHeader.getFirstField() ? 1 : 0) != 0, (String)"first column on page > expected");
        ArrayInputStream lrdi = this.rawDataIn;
        int offset = this.getRecordOffset(slot);
        lrdi.setPosition(offset + recordHeader.size());
        for (int i = recordHeader.getFirstField(); i < columnId; ++i) {
            this.skipField(lrdi);
        }
        int fieldStatus = StoredFieldHeader.readStatus(lrdi);
        int fieldLength = StoredFieldHeader.readFieldDataLength(lrdi, fieldStatus, this.slotFieldSize);
        if (StoredFieldHeader.isOverflow(fieldStatus)) {
            long ovflowPage = CompressedNumber.readLong(lrdi);
            int ovflowRid = CompressedNumber.readInt(lrdi);
            if (ovflowPage == oldPageId && (long)ovflowRid == oldRecordId) {
                return false;
            }
        }
        return true;
    }

    private RecordHandle getNextColumnPiece(int slot) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched());
        SanityManager.ASSERT((boolean)this.isOverflowPage(), (String)"not expected to call getNextColumnPiece on non-overflow page");
        if (this.recordCount() != 1) {
            SanityManager.THROWASSERT((String)("getNextColumnPiece called on a page with " + this.recordCount() + " rows"));
        }
        try {
            StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
            int numberFields = recordHeader.getNumberFields();
            if (numberFields > 2 || numberFields < 1) {
                SanityManager.THROWASSERT((String)("longColumn record header must have 1 or 2 fields. numberFields = " + numberFields));
            }
            if (numberFields != 2) {
                return null;
            }
            ArrayInputStream lrdi = this.rawDataIn;
            int offset = this.getRecordOffset(slot) + recordHeader.size();
            lrdi.setPosition(offset);
            this.skipField(lrdi);
            int fieldStatus = StoredFieldHeader.readStatus(lrdi);
            int fieldLength = StoredFieldHeader.readFieldDataLength(lrdi, fieldStatus, this.slotFieldSize);
            long ovflowPage = CompressedNumber.readLong(lrdi);
            int ovflowRid = CompressedNumber.readInt(lrdi);
            if (!StoredFieldHeader.isOverflow(fieldStatus)) {
                lrdi.setPosition(offset);
                fieldStatus = StoredFieldHeader.readStatus(lrdi);
                SanityManager.ASSERT((boolean)StoredFieldHeader.isOverflow(fieldStatus));
            }
            return this.owner.makeRecordHandle(ovflowPage, ovflowRid);
        }
        catch (IOException ioe) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{this.getPageId()}));
        }
    }

    private void initSpace() {
        this.totalSpace = this.getMaxFreeSpace();
        this.maxFieldSize = this.totalSpace - this.slotEntrySize - 16 - 12;
        SanityManager.ASSERT((this.maxFieldSize >= 0 ? 1 : 0) != 0);
        int expectedFieldSize = this.calculateSlotFieldSize(this.pageData.length);
        SanityManager.ASSERT((this.slotFieldSize == expectedFieldSize ? 1 : 0) != 0, (String)"slotFieldSize uninitialized");
        SanityManager.ASSERT((this.slotEntrySize == 3 * expectedFieldSize ? 1 : 0) != 0, (String)"slotEntrySize uninitialized");
    }

    private void clearAllSpace() {
        this.freeSpace = this.totalSpace;
        this.firstFreeByte = this.getPageSize() - this.totalSpace - 8;
    }

    private void compressPage(int startByte, int endByte) throws IOException {
        if (endByte + 1 > this.firstFreeByte || startByte > this.firstFreeByte) {
            SanityManager.THROWASSERT((String)("startByte = " + startByte + " endByte = " + endByte + " firstFreeByte = " + this.firstFreeByte));
        }
        int lengthToClear = endByte + 1 - startByte;
        if (endByte + 1 != this.firstFreeByte) {
            int moveLength = this.firstFreeByte - endByte - 1;
            System.arraycopy(this.pageData, endByte + 1, this.pageData, startByte, moveLength);
            for (int slot = 0; slot < this.slotsInUse; ++slot) {
                int offset = this.getRecordOffset(slot);
                if (offset < endByte + 1) continue;
                this.setRecordOffset(slot, offset -= lengthToClear);
            }
        }
        this.freeSpace += lengthToClear;
        this.firstFreeByte -= lengthToClear;
        this.clearSection(this.firstFreeByte, lengthToClear);
    }

    protected void expandPage(int startOffset, int requiredBytes) throws IOException {
        SanityManager.ASSERT((requiredBytes <= this.freeSpace ? 1 : 0) != 0);
        SanityManager.ASSERT((startOffset <= this.firstFreeByte ? 1 : 0) != 0);
        int totalLength = this.firstFreeByte - startOffset;
        if (totalLength > 0) {
            System.arraycopy(this.pageData, startOffset, this.pageData, startOffset + requiredBytes, totalLength);
            for (int slot = 0; slot < this.slotsInUse; ++slot) {
                int offset = this.getRecordOffset(slot);
                if (offset < startOffset) continue;
                this.setRecordOffset(slot, offset += requiredBytes);
            }
        }
        this.freeSpace -= requiredBytes;
        this.firstFreeByte += requiredBytes;
    }

    private void shrinkPage(int startOffset, int shrinkBytes) throws IOException {
        int totalLength = this.firstFreeByte - startOffset;
        SanityManager.DEBUG((String)"shrinkPage", (String)("page " + this.getIdentity() + " shrinking " + shrinkBytes + " from offset " + startOffset + " to offset " + (startOffset - shrinkBytes) + " moving " + totalLength + " bytes.  FirstFreeByte at " + this.firstFreeByte));
        SanityManager.ASSERT((totalLength >= 0 ? 1 : 0) != 0, (String)"firstFreeByte - startOffset <= 0");
        SanityManager.ASSERT((startOffset - shrinkBytes > 60 ? 1 : 0) != 0, (String)"shrinking too much ");
        if (startOffset != this.firstFreeByte) {
            boolean foundslot = false;
            for (int slot = 0; slot < this.slotsInUse; ++slot) {
                if (this.getRecordOffset(slot) != startOffset) continue;
                foundslot = true;
                break;
            }
            if (!foundslot) {
                SanityManager.THROWASSERT((String)("startOffset " + startOffset + " not at the beginning of a record"));
            }
        }
        if (totalLength > 0) {
            System.arraycopy(this.pageData, startOffset, this.pageData, startOffset - shrinkBytes, totalLength);
            for (int slot = 0; slot < this.slotsInUse; ++slot) {
                int offset = this.getRecordOffset(slot);
                if (offset < startOffset) continue;
                this.setRecordOffset(slot, offset -= shrinkBytes);
            }
        }
        this.freeSpace += shrinkBytes;
        this.firstFreeByte -= shrinkBytes;
    }

    @Override
    public int getRecordLength(int slot) throws IOException {
        return this.getRecordPortionLength(slot);
    }

    protected boolean getIsOverflow(int slot) throws IOException {
        return this.getHeaderAtSlot(slot).hasOverflow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int logRow(int slot, boolean forInsert, int recordId, Object[] row, FormatableBitSet validColumns, DynamicByteArrayOutputStream out, int startColumn, byte insertFlag, int realStartColumn, int realSpaceOnPage, int overflowThreshold) throws StandardException, IOException {
        if (!forInsert && realStartColumn != -1 && realSpaceOnPage == -1) {
            return realStartColumn;
        }
        int spaceAvailable = this.freeSpace;
        this.setOutputStream(out);
        int beginPosition = out.getPosition();
        this.userRowSize = 0;
        boolean calcMinimumRecordSize = false;
        if (realStartColumn != -1) {
            spaceAvailable = realSpaceOnPage;
            beginPosition = out.getBeginPosition();
        } else {
            if (!forInsert) {
                spaceAvailable += this.getTotalSpace(slot);
            } else {
                spaceAvailable -= this.slotEntrySize;
                if (startColumn == 0) {
                    calcMinimumRecordSize = true;
                }
            }
            if (spaceAvailable <= 0) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
        }
        try {
            int validColumnsSize;
            StoredRecordHeader recordHeader;
            if (row == null) {
                int n = this.logOverflowRecord(slot, spaceAvailable, out);
                return n;
            }
            int numberFields = 0;
            if (forInsert) {
                recordHeader = new StoredRecordHeader();
            } else {
                recordHeader = new StoredRecordHeader(this.getHeaderAtSlot(slot));
                startColumn = recordHeader.getFirstField();
            }
            if (validColumns == null) {
                numberFields = row.length - startColumn;
            } else {
                for (int i = validColumns.getLength() - 1; i >= startColumn; --i) {
                    if (!validColumns.isSet(i)) continue;
                    numberFields = i + 1 - startColumn;
                    break;
                }
            }
            int onPageNumberFields = -1;
            if (forInsert) {
                recordHeader.setId(recordId);
                recordHeader.setNumberFields(numberFields);
            } else {
                onPageNumberFields = recordHeader.getNumberFields();
                if (numberFields > onPageNumberFields) {
                    if (recordHeader.hasOverflow()) {
                        numberFields = onPageNumberFields;
                    } else {
                        recordHeader.setNumberFields(numberFields);
                    }
                } else if (numberFields < onPageNumberFields) {
                    if (validColumns == null) {
                        recordHeader.setNumberFields(numberFields);
                    } else {
                        numberFields = onPageNumberFields;
                    }
                }
            }
            int endFieldExclusive = startColumn + numberFields;
            if (realStartColumn >= endFieldExclusive) {
                int n = -1;
                return n;
            }
            if ((insertFlag & 1) != 1) {
                recordHeader.setFirstField(startColumn);
            }
            int firstColumn = realStartColumn;
            if (realStartColumn == -1) {
                int recordHeaderLength = recordHeader.write(this.logicalDataOut);
                if ((spaceAvailable -= recordHeaderLength) < 0) {
                    throw new NoSpaceOnPage(this.isOverflowPage());
                }
                firstColumn = startColumn;
            }
            boolean monitoringOldFields = false;
            int n = validColumnsSize = validColumns == null ? 0 : validColumns.getLength();
            if (validColumns != null && !forInsert && validColumns != null && firstColumn < startColumn + onPageNumberFields) {
                this.rawDataIn.setPosition(this.getFieldOffset(slot, firstColumn));
                monitoringOldFields = true;
            }
            int lastSpaceAvailable = spaceAvailable;
            int recordSize = 0;
            int lastColumnPositionAllowOverflow = out.getPosition();
            int lastColumnAllowOverflow = startColumn;
            if (spaceAvailable > 12) {
                lastColumnPositionAllowOverflow = -1;
            }
            int columnFlag = 1;
            for (int i = firstColumn; i < endFieldExclusive; ++i) {
                int nextColumn;
                boolean recordIsLong;
                block65: {
                    Object ref = null;
                    boolean ignoreColumn = false;
                    if (validColumns == null || validColumnsSize > i && validColumns.isSet(i)) {
                        if (i < row.length) {
                            ref = row[i];
                        }
                    } else if (!forInsert) {
                        ignoreColumn = true;
                    }
                    if (spaceAvailable > 12) {
                        lastColumnPositionAllowOverflow = out.getPosition();
                        lastColumnAllowOverflow = i;
                    }
                    lastSpaceAvailable = spaceAvailable;
                    if (ignoreColumn) {
                        SanityManager.ASSERT((ref == null ? 1 : 0) != 0, (String)"ref should be null for an ignored column");
                        SanityManager.ASSERT((validColumns != null ? 1 : 0) != 0, (String)"validColumns should be non-null for ignored col");
                        if (i < startColumn + onPageNumberFields) {
                            SanityManager.ASSERT((boolean)monitoringOldFields, (String)"monitoringOldFields must be true");
                            int oldOffset = this.rawDataIn.getPosition();
                            this.skipField(this.rawDataIn);
                            int oldFieldLength = this.rawDataIn.getPosition() - oldOffset;
                            if (oldFieldLength <= spaceAvailable) {
                                this.logColumn(null, 0, out, Integer.MAX_VALUE, 0, overflowThreshold);
                                spaceAvailable -= oldFieldLength;
                            }
                        } else {
                            spaceAvailable = this.logColumn(null, 0, out, spaceAvailable, 3, overflowThreshold);
                        }
                    } else {
                        if (monitoringOldFields && i < startColumn + onPageNumberFields) {
                            this.skipField(this.rawDataIn);
                        }
                        try {
                            spaceAvailable = ref == null ? this.logColumn(null, 0, out, spaceAvailable, columnFlag, overflowThreshold) : this.logColumn(row, i, out, spaceAvailable, columnFlag, overflowThreshold);
                        }
                        catch (LongColumnException lce) {
                            if ((insertFlag & 1) == 1) {
                                if (lce.getColumn() instanceof InputStream && row[i] instanceof StreamStorable && (row[i] instanceof InputStream || ((StreamStorable)row[i]).returnStream() != null)) {
                                    ((StreamStorable)row[i]).setStream((InputStream)lce.getColumn());
                                }
                                throw new NoSpaceOnPage(this.isOverflowPage());
                            }
                            if ((spaceAvailable < 14 || i != endFieldExclusive - 1) && (spaceAvailable < 28 || i >= endFieldExclusive - 1)) break block65;
                            out.setBeginPosition(beginPosition);
                            lce.setExceptionInfo(out, i, spaceAvailable);
                            throw lce;
                        }
                    }
                }
                boolean bl = recordIsLong = overflowThreshold == 100 ? false : this.isLong(recordSize += lastSpaceAvailable - spaceAvailable, overflowThreshold);
                if (lastSpaceAvailable == spaceAvailable || recordIsLong) {
                    if ((insertFlag & 1) == 1) {
                        throw new NoSpaceOnPage(this.isOverflowPage());
                    }
                    if (recordIsLong) {
                        out.setPosition(out.getPosition() - recordSize);
                    }
                    nextColumn = i;
                } else {
                    nextColumn = endFieldExclusive;
                }
                if ((lastSpaceAvailable == spaceAvailable || (insertFlag & 0x10) == 16) && spaceAvailable < 12) {
                    if (i == startColumn || lastColumnPositionAllowOverflow < 0) {
                        if (!forInsert) {
                            SanityManager.THROWASSERT((String)("no space to update a field on page. i = " + i + "; startColumn = " + startColumn + "; lastColumnPositionAllowOverflow = " + lastColumnPositionAllowOverflow + "; spaceAvailable = " + spaceAvailable + "; lastSpaceAvailable = " + lastSpaceAvailable + "; insertFlag = " + insertFlag + "; Page.INSERT_FOR_SPLIT = 16; isOverflowPage() = " + this.isOverflowPage() + "; OVERFLOW_POINTER_SIZE = 12\npage = \n" + this));
                        }
                        throw new NoSpaceOnPage(this.isOverflowPage());
                    }
                    out.setPosition(lastColumnPositionAllowOverflow);
                    nextColumn = lastColumnAllowOverflow;
                }
                if (nextColumn < endFieldExclusive) {
                    int actualNumberFields = nextColumn - startColumn;
                    int oldSize = recordHeader.size();
                    recordHeader.setNumberFields(actualNumberFields);
                    int newSize = recordHeader.size();
                    int endPosition = out.getPosition();
                    if (oldSize > newSize) {
                        int delta = oldSize - newSize;
                        out.setBeginPosition(beginPosition + delta);
                        out.setPosition(beginPosition + delta);
                    } else if (newSize > oldSize) {
                        out.setPosition(beginPosition);
                    } else {
                        out.setBeginPosition(beginPosition);
                        out.setPosition(beginPosition);
                    }
                    int realLen = recordHeader.write(this.logicalDataOut);
                    if (realLen + (oldSize - newSize) != oldSize) {
                        SanityManager.THROWASSERT((String)("recordHeader size incorrect.  realLen = " + realLen + ", delta = " + (oldSize - newSize) + ", oldSize = " + oldSize));
                    }
                    out.setPosition(endPosition);
                    if (!forInsert && validColumns != null) {
                        this.handleIncompleteLogRow(slot, nextColumn, validColumns, out);
                    }
                    int n2 = nextColumn;
                    return n2;
                }
                columnFlag = 0;
            }
            out.setBeginPosition(beginPosition);
            startColumn = -1;
            if (calcMinimumRecordSize && spaceAvailable < this.minimumRecordSize - this.userRowSize) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
        }
        finally {
            this.resetOutputStream();
        }
        return startColumn;
    }

    private void handleIncompleteLogRow(int slot, int startColumn, FormatableBitSet columnList, DynamicByteArrayOutputStream out) throws StandardException {
        SanityManager.ASSERT((columnList != null ? 1 : 0) != 0);
        StoredRecordHeader rh = this.getHeaderAtSlot(slot);
        int endFieldExclusive = rh.getFirstField() + rh.getNumberFields();
        boolean needSave = false;
        int columnListSize = columnList.size();
        for (int i = startColumn; i < endFieldExclusive; ++i) {
            if (columnListSize > i && columnList.get(i)) continue;
            needSave = true;
            break;
        }
        if (!needSave) {
            return;
        }
        Object[] savedFields = new Object[endFieldExclusive - startColumn];
        ByteArrayOutputStream fieldStream = null;
        for (int i = startColumn; i < endFieldExclusive; ++i) {
            if (columnListSize > i && columnList.get(i)) continue;
            try {
                if (fieldStream == null) {
                    fieldStream = new ByteArrayOutputStream();
                } else {
                    fieldStream.reset();
                }
                this.logField(slot, i, fieldStream);
                savedFields[i - startColumn] = new RawField(fieldStream.toByteArray());
                continue;
            }
            catch (IOException ioe) {
                throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Throwable)ioe, (Object[])new Object[]{this.getPageId()}));
            }
        }
        LongColumnException lce = new LongColumnException();
        lce.setExceptionInfo(out, startColumn, -1);
        lce.setColumn(savedFields);
        throw lce;
    }

    @Override
    public void restoreRecordFromStream(LimitObjectInput in, Object[] row) throws StandardException, IOException {
        StoredRecordHeader recordHeader = new StoredRecordHeader();
        recordHeader.read(in);
        this.readRecordFromStream(row, row.length - 1, null, null, in, recordHeader, null);
    }

    private boolean qualifyRecordFromRow(Object[] row, Qualifier[][] qual_list) throws StandardException {
        boolean row_qualifies = true;
        SanityManager.ASSERT((row != null ? 1 : 0) != 0);
        SanityManager.ASSERT((qual_list != null ? 1 : 0) != 0);
        SanityManager.ASSERT((qual_list.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < qual_list[0].length; ++i) {
            row_qualifies = false;
            Qualifier q = qual_list[0][i];
            DataValueDescriptor columnValue = (DataValueDescriptor)row[q.getColumnId()];
            row_qualifies = columnValue.compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
            if (q.negateCompareResult()) {
                boolean bl = row_qualifies = !row_qualifies;
            }
            if (row_qualifies) continue;
            return false;
        }
        for (int and_idx = 1; and_idx < qual_list.length; ++and_idx) {
            row_qualifies = false;
            SanityManager.ASSERT((qual_list[and_idx].length > 0 ? 1 : 0) != 0);
            for (int or_idx = 0; or_idx < qual_list[and_idx].length; ++or_idx) {
                Qualifier q = qual_list[and_idx][or_idx];
                int col_id = q.getColumnId();
                SanityManager.ASSERT((col_id < row.length ? 1 : 0) != 0, (String)"Qualifier is referencing a column not in the row.");
                DataValueDescriptor columnValue = (DataValueDescriptor)row[q.getColumnId()];
                if (columnValue == null) {
                    SanityManager.THROWASSERT((String)("1:row = " + RowUtil.toString(row) + "row.length = " + row.length + ";q.getColumnId() = " + q.getColumnId()));
                }
                row_qualifies = columnValue.compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
                if (q.negateCompareResult()) {
                    boolean bl = row_qualifies = !row_qualifies;
                }
                if (row_qualifies) break;
            }
            if (!row_qualifies) break;
        }
        return row_qualifies;
    }

    private final void readOneColumnFromPage(Object[] row, int colid, int offset_to_field_data, StoredRecordHeader recordHeader, RecordHandle recordToLock) throws StandardException, IOException {
        ErrorObjectInput inUserCode = null;
        ArrayInputStream lrdi = this.rawDataIn;
        try {
            if (colid >= row.length) {
                SanityManager.THROWASSERT((String)("colid = " + colid + ";row length = " + row.length));
            }
            if (recordHeader.getFirstField() != 0) {
                SanityManager.THROWASSERT((String)("recordHeader.getFirstField() = " + recordHeader.getFirstField()));
            }
            Object column = row[colid];
            if (colid <= recordHeader.getNumberFields() - 1) {
                for (int columnId = colid; columnId > 0; --columnId) {
                    offset_to_field_data += StoredFieldHeader.readTotalFieldLength(this.pageData, offset_to_field_data);
                }
                int fieldStatus = StoredFieldHeader.readStatus(this.pageData, offset_to_field_data);
                int fieldDataLength = StoredFieldHeader.readFieldLengthAndSetStreamPosition(this.pageData, offset_to_field_data + 1, fieldStatus, this.slotFieldSize, lrdi);
                SanityManager.ASSERT((!StoredFieldHeader.isExtensible(fieldStatus) ? 1 : 0) != 0, (String)"extensible fields not supported yet");
                if (!StoredFieldHeader.isNonexistent(fieldStatus)) {
                    boolean isOverflow = StoredFieldHeader.isOverflow(fieldStatus);
                    OverflowInputStream overflowIn = null;
                    if (isOverflow) {
                        long overflowPage = CompressedNumber.readLong(lrdi);
                        int overflowId = CompressedNumber.readInt(lrdi);
                        MemByteHolder byteHolder = new MemByteHolder(this.pageData.length);
                        overflowIn = new OverflowInputStream(byteHolder, this.owner, overflowPage, overflowId, recordToLock);
                    }
                    if (column instanceof DataValueDescriptor) {
                        DataValueDescriptor sColumn = (DataValueDescriptor)column;
                        if (StoredFieldHeader.isNull(fieldStatus)) {
                            sColumn.restoreToNull();
                        } else if (!isOverflow) {
                            lrdi.setLimit(fieldDataLength);
                            inUserCode = lrdi;
                            sColumn.readExternalFromArray(lrdi);
                            inUserCode = null;
                            int unread = lrdi.clearLimit();
                            if (unread != 0) {
                                DataInputUtil.skipFully(lrdi, unread);
                            }
                        } else {
                            FormatIdInputStream newIn = new FormatIdInputStream(overflowIn);
                            if (sColumn instanceof StreamStorable) {
                                ((StreamStorable)((Object)sColumn)).setStream(newIn);
                            } else {
                                inUserCode = newIn;
                                sColumn.readExternal(newIn);
                                inUserCode = null;
                            }
                        }
                    } else {
                        if (StoredFieldHeader.isNull(fieldStatus)) {
                            throw StandardException.newException((String)"XSDA6.S", (Object[])new Object[]{Integer.toString(colid)});
                        }
                        lrdi.setLimit(fieldDataLength);
                        inUserCode = lrdi;
                        row[colid] = lrdi.readObject();
                        inUserCode = null;
                        int unread = lrdi.clearLimit();
                        if (unread != 0) {
                            DataInputUtil.skipFully(lrdi, unread);
                        }
                    }
                } else if (column instanceof DataValueDescriptor) {
                    ((DataValueDescriptor)column).restoreToNull();
                } else {
                    row[colid] = null;
                }
            } else if (column instanceof DataValueDescriptor) {
                ((DataValueDescriptor)column).restoreToNull();
            } else {
                row[colid] = null;
            }
        }
        catch (IOException ioe) {
            if (inUserCode != null) {
                lrdi.clearLimit();
                if (ioe instanceof EOFException) {
                    SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("StoredPage.readOneColumnFromPage - EOF while restoring record: " + recordHeader + "Page dump = " + this));
                    SanityManager.showTrace((Throwable)ioe);
                    throw StandardException.newException((String)"XSDA7.S", (Throwable)ioe, (Object[])new Object[]{inUserCode.getErrorInfo()});
                }
                Exception ne = inUserCode.getNestedException();
                if (ne != null) {
                    if (ne instanceof InstantiationException) {
                        throw StandardException.newException((String)"XSDAM.S", (Throwable)ne, (Object[])new Object[]{inUserCode.getErrorInfo()});
                    }
                    if (ne instanceof IllegalAccessException) {
                        throw StandardException.newException((String)"XSDAN.S", (Throwable)ne, (Object[])new Object[]{inUserCode.getErrorInfo()});
                    }
                    if (ne instanceof StandardException) {
                        throw (StandardException)((Object)ne);
                    }
                }
                throw StandardException.newException((String)"XSDA8.S", (Throwable)ioe, (Object[])new Object[]{inUserCode.getErrorInfo()});
            }
            throw ioe;
        }
        catch (ClassNotFoundException cnfe) {
            lrdi.clearLimit();
            throw StandardException.newException((String)"XSDA9.S", (Throwable)cnfe, (Object[])new Object[]{inUserCode.getErrorInfo()});
        }
        catch (LinkageError le) {
            if (inUserCode != null) {
                lrdi.clearLimit();
                throw StandardException.newException((String)"XSDA8.S", (Throwable)le, (Object[])new Object[]{inUserCode.getErrorInfo()});
            }
            throw le;
        }
    }

    private final boolean qualifyRecordFromSlot(Object[] row, int offset_to_row_data, FetchDescriptor fetchDesc, StoredRecordHeader recordHeader, RecordHandle recordToLock) throws StandardException, IOException {
        boolean row_qualifies = true;
        Qualifier[][] qual_list = fetchDesc.getQualifierList();
        int[] materializedCols = fetchDesc.getMaterializedColumns();
        SanityManager.ASSERT((qual_list != null ? 1 : 0) != 0, (String)"Not coded yet!");
        SanityManager.ASSERT((row != null ? 1 : 0) != 0);
        for (int i = 0; i < qual_list[0].length; ++i) {
            row_qualifies = false;
            Qualifier q = qual_list[0][i];
            int col_id = q.getColumnId();
            SanityManager.ASSERT((col_id < row.length ? 1 : 0) != 0, (String)"Qualifier is referencing a column not in the row.");
            if (materializedCols[col_id] == 0) {
                this.readOneColumnFromPage(row, col_id, offset_to_row_data, recordHeader, recordToLock);
                materializedCols[col_id] = offset_to_row_data;
            }
            if (row[col_id] == null) {
                SanityManager.THROWASSERT((String)("1:row = " + RowUtil.toString(row) + "row.length = " + row.length + ";q.getColumnId() = " + q.getColumnId()));
            }
            row_qualifies = ((DataValueDescriptor)row[col_id]).compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
            if (q.negateCompareResult()) {
                boolean bl = row_qualifies = !row_qualifies;
            }
            if (row_qualifies) continue;
            return false;
        }
        for (int and_idx = 1; and_idx < qual_list.length; ++and_idx) {
            row_qualifies = false;
            for (int or_idx = 0; or_idx < qual_list[and_idx].length; ++or_idx) {
                Qualifier q = qual_list[and_idx][or_idx];
                int col_id = q.getColumnId();
                SanityManager.ASSERT((col_id < row.length ? 1 : 0) != 0, (String)"Qualifier is referencing a column not in the row.");
                if (materializedCols[col_id] == 0) {
                    this.readOneColumnFromPage(row, col_id, offset_to_row_data, recordHeader, recordToLock);
                    materializedCols[col_id] = offset_to_row_data;
                }
                if (row[col_id] == null) {
                    SanityManager.THROWASSERT((String)("1:row = " + RowUtil.toString(row) + "row.length = " + row.length + ";q.getColumnId() = " + q.getColumnId()));
                }
                row_qualifies = ((DataValueDescriptor)row[col_id]).compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
                if (q.negateCompareResult()) {
                    boolean bl = row_qualifies = !row_qualifies;
                }
                if (row_qualifies) break;
            }
            if (!row_qualifies) break;
        }
        return row_qualifies;
    }

    private final boolean readRecordFromStream(Object[] row, int max_colid, int[] vCols, int[] mCols, LimitObjectInput dataIn, StoredRecordHeader recordHeader, RecordHandle recordToLock) throws StandardException, IOException {
        ErrorObjectInput inUserCode = null;
        try {
            int numberFields = recordHeader.getNumberFields();
            int startColumn = recordHeader.getFirstField();
            if (startColumn > max_colid) {
                return true;
            }
            int highestColumnOnPage = numberFields + startColumn;
            int vColsSize = vCols == null ? 0 : vCols.length;
            for (int columnId = startColumn; columnId <= max_colid; ++columnId) {
                if (vCols != null && (vColsSize <= columnId || vCols[columnId] == 0) || mCols != null && mCols[columnId] != 0) {
                    if (columnId >= highestColumnOnPage) continue;
                    this.skipField(dataIn);
                    continue;
                }
                if (columnId >= highestColumnOnPage) {
                    Object column = row[columnId];
                    if (column instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)column).restoreToNull();
                        continue;
                    }
                    row[columnId] = null;
                    continue;
                }
                int fieldStatus = StoredFieldHeader.readStatus(dataIn);
                int fieldDataLength = StoredFieldHeader.readFieldDataLength(dataIn, fieldStatus, this.slotFieldSize);
                SanityManager.ASSERT((!StoredFieldHeader.isExtensible(fieldStatus) ? 1 : 0) != 0, (String)"extensible fields not supported yet");
                Object column = row[columnId];
                OverflowInputStream overflowIn = null;
                if (StoredFieldHeader.isNonexistent(fieldStatus)) {
                    if (column instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)column).restoreToNull();
                        continue;
                    }
                    row[columnId] = null;
                    continue;
                }
                boolean isOverflow = StoredFieldHeader.isOverflow(fieldStatus);
                if (isOverflow) {
                    long overflowPage = CompressedNumber.readLong((InputStream)((Object)dataIn));
                    int overflowId = CompressedNumber.readInt((InputStream)((Object)dataIn));
                    MemByteHolder byteHolder = new MemByteHolder(this.pageData.length);
                    overflowIn = new OverflowInputStream(byteHolder, this.owner, overflowPage, overflowId, recordToLock);
                }
                if (column instanceof DataValueDescriptor) {
                    DataValueDescriptor sColumn = (DataValueDescriptor)column;
                    if (StoredFieldHeader.isNull(fieldStatus)) {
                        sColumn.restoreToNull();
                        continue;
                    }
                    if (!isOverflow) {
                        dataIn.setLimit(fieldDataLength);
                        inUserCode = dataIn;
                        sColumn.readExternal(dataIn);
                        inUserCode = null;
                        int unread = dataIn.clearLimit();
                        if (unread == 0) continue;
                        DataInputUtil.skipFully(dataIn, unread);
                        continue;
                    }
                    FormatIdInputStream newIn = new FormatIdInputStream(overflowIn);
                    boolean fetchStream = true;
                    if (!(sColumn instanceof StreamStorable)) {
                        fetchStream = false;
                    }
                    if (fetchStream) {
                        ((StreamStorable)((Object)sColumn)).setStream(newIn);
                        continue;
                    }
                    inUserCode = newIn;
                    sColumn.readExternal(newIn);
                    inUserCode = null;
                    continue;
                }
                if (StoredFieldHeader.isNull(fieldStatus)) {
                    throw StandardException.newException((String)"XSDA6.S", (Object[])new Object[]{Integer.toString(columnId)});
                }
                dataIn.setLimit(fieldDataLength);
                inUserCode = dataIn;
                row[columnId] = dataIn.readObject();
                inUserCode = null;
                int unread = dataIn.clearLimit();
                if (unread == 0) continue;
                DataInputUtil.skipFully(dataIn, unread);
            }
            return numberFields + startColumn > max_colid;
        }
        catch (IOException ioe) {
            if (inUserCode != null) {
                dataIn.clearLimit();
                if (ioe instanceof EOFException) {
                    SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("StoredPage - EOF while restoring record: " + recordHeader + "Page dump = " + this));
                    throw StandardException.newException((String)"XSDA7.S", (Throwable)ioe, (Object[])new Object[]{inUserCode.getErrorInfo()});
                }
                Exception ne = inUserCode.getNestedException();
                if (ne != null) {
                    if (ne instanceof InstantiationException) {
                        throw StandardException.newException((String)"XSDAM.S", (Throwable)ne, (Object[])new Object[]{inUserCode.getErrorInfo()});
                    }
                    if (ne instanceof IllegalAccessException) {
                        throw StandardException.newException((String)"XSDAN.S", (Throwable)ne, (Object[])new Object[]{inUserCode.getErrorInfo()});
                    }
                    if (ne instanceof StandardException) {
                        throw (StandardException)((Object)ne);
                    }
                }
                throw StandardException.newException((String)"XSDA8.S", (Throwable)ioe, (Object[])new Object[]{inUserCode.getErrorInfo()});
            }
            throw ioe;
        }
        catch (ClassNotFoundException cnfe) {
            dataIn.clearLimit();
            throw StandardException.newException((String)"XSDA9.S", (Throwable)cnfe, (Object[])new Object[]{inUserCode.getErrorInfo()});
        }
        catch (LinkageError le) {
            if (inUserCode != null) {
                dataIn.clearLimit();
                throw StandardException.newException((String)"XSDA8.S", (Throwable)le, (Object[])new Object[]{inUserCode.getErrorInfo()});
            }
            throw le;
        }
    }

    private final boolean readRecordFromArray(Object[] row, int max_colid, int[] vCols, int[] mCols, ArrayInputStream dataIn, StoredRecordHeader recordHeader, RecordHandle recordToLock) throws StandardException, IOException {
        ErrorObjectInput inUserCode = null;
        try {
            int numberFields = recordHeader.getNumberFields();
            int startColumn = recordHeader.getFirstField();
            if (startColumn > max_colid) {
                return true;
            }
            int highestColumnOnPage = numberFields + startColumn;
            int vColsSize = vCols == null ? 0 : vCols.length;
            int offset_to_field_data = dataIn.getPosition();
            for (int columnId = startColumn; columnId <= max_colid; ++columnId) {
                if (vCols != null && (vColsSize <= columnId || vCols[columnId] == 0) || mCols != null && mCols[columnId] != 0) {
                    if (columnId >= highestColumnOnPage) continue;
                    offset_to_field_data += StoredFieldHeader.readTotalFieldLength(this.pageData, offset_to_field_data);
                    continue;
                }
                if (columnId < highestColumnOnPage) {
                    int fieldStatus = StoredFieldHeader.readStatus(this.pageData, offset_to_field_data);
                    int fieldDataLength = StoredFieldHeader.readFieldLengthAndSetStreamPosition(this.pageData, offset_to_field_data + 1, fieldStatus, this.slotFieldSize, dataIn);
                    SanityManager.ASSERT((!StoredFieldHeader.isExtensible(fieldStatus) ? 1 : 0) != 0, (String)"extensible fields not supported yet");
                    Object column = row[columnId];
                    OverflowInputStream overflowIn = null;
                    if ((fieldStatus & 5) != 5) {
                        boolean isOverflow;
                        boolean bl = isOverflow = (fieldStatus & 2) != 0;
                        if (isOverflow) {
                            long overflowPage = CompressedNumber.readLong(dataIn);
                            int overflowId = CompressedNumber.readInt(dataIn);
                            MemByteHolder byteHolder = new MemByteHolder(this.pageData.length);
                            overflowIn = new OverflowInputStream(byteHolder, this.owner, overflowPage, overflowId, recordToLock);
                        }
                        if (column instanceof DataValueDescriptor) {
                            DataValueDescriptor sColumn = (DataValueDescriptor)column;
                            if ((fieldStatus & 1) == 0) {
                                if (!isOverflow) {
                                    dataIn.setLimit(fieldDataLength);
                                    inUserCode = dataIn;
                                    sColumn.readExternalFromArray(dataIn);
                                    inUserCode = null;
                                    int unread = dataIn.clearLimit();
                                    if (unread != 0) {
                                        DataInputUtil.skipFully(dataIn, unread);
                                    }
                                } else {
                                    FormatIdInputStream newIn = new FormatIdInputStream(overflowIn);
                                    boolean fetchStream = true;
                                    if (!(sColumn instanceof StreamStorable)) {
                                        fetchStream = false;
                                    }
                                    if (fetchStream) {
                                        ((StreamStorable)((Object)sColumn)).setStream(newIn);
                                    } else {
                                        inUserCode = newIn;
                                        sColumn.readExternal(newIn);
                                        inUserCode = null;
                                    }
                                }
                            } else {
                                sColumn.restoreToNull();
                            }
                        } else {
                            if (StoredFieldHeader.isNull(fieldStatus)) {
                                throw StandardException.newException((String)"XSDA6.S", (Object[])new Object[]{Integer.toString(columnId)});
                            }
                            dataIn.setLimit(fieldDataLength);
                            inUserCode = dataIn;
                            row[columnId] = dataIn.readObject();
                            inUserCode = null;
                            int unread = dataIn.clearLimit();
                            if (unread != 0) {
                                DataInputUtil.skipFully(dataIn, unread);
                            }
                        }
                    } else if (column instanceof DataValueDescriptor) {
                        ((DataValueDescriptor)column).restoreToNull();
                    } else {
                        row[columnId] = null;
                    }
                    offset_to_field_data = dataIn.getPosition();
                    continue;
                }
                Object column = row[columnId];
                if (column instanceof DataValueDescriptor) {
                    ((DataValueDescriptor)column).restoreToNull();
                    continue;
                }
                row[columnId] = null;
            }
            return numberFields + startColumn > max_colid;
        }
        catch (IOException ioe) {
            if (inUserCode != null) {
                dataIn.clearLimit();
                if (ioe instanceof EOFException) {
                    SanityManager.DEBUG_PRINT((String)"DEBUG_TRACE", (String)("StoredPage - EOF while restoring record: " + recordHeader + "Page dump = " + this));
                    throw StandardException.newException((String)"XSDA7.S", (Throwable)ioe, (Object[])new Object[]{inUserCode.getErrorInfo()});
                }
                Exception ne = inUserCode.getNestedException();
                if (ne != null) {
                    if (ne instanceof InstantiationException) {
                        throw StandardException.newException((String)"XSDAM.S", (Throwable)ne, (Object[])new Object[]{inUserCode.getErrorInfo()});
                    }
                    if (ne instanceof IllegalAccessException) {
                        throw StandardException.newException((String)"XSDAN.S", (Throwable)ne, (Object[])new Object[]{inUserCode.getErrorInfo()});
                    }
                    if (ne instanceof StandardException) {
                        throw (StandardException)((Object)ne);
                    }
                }
                throw StandardException.newException((String)"XSDA8.S", (Throwable)ioe, (Object[])new Object[]{inUserCode.getErrorInfo()});
            }
            throw ioe;
        }
        catch (ClassNotFoundException cnfe) {
            dataIn.clearLimit();
            throw StandardException.newException((String)"XSDA9.S", (Throwable)cnfe, (Object[])new Object[]{inUserCode.getErrorInfo()});
        }
        catch (LinkageError le) {
            if (inUserCode != null) {
                dataIn.clearLimit();
                throw StandardException.newException((String)"XSDA8.S", (Throwable)le, (Object[])new Object[]{inUserCode.getErrorInfo()});
            }
            throw le;
        }
    }

    @Override
    public void restorePortionLongColumn(OverflowInputStream fetchStream) throws StandardException, IOException {
        int slot = this.findRecordById(fetchStream.getOverflowId(), 0);
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        int offset = this.getRecordOffset(slot);
        int numberFields = recordHeader.getNumberFields();
        if (numberFields > 2 || numberFields < 1) {
            SanityManager.THROWASSERT((String)("longColumn record header must have 1 or 2 fields.numberFields = " + numberFields));
        }
        this.rawDataIn.setPosition(offset + recordHeader.size());
        int fieldStatus = StoredFieldHeader.readStatus(this.rawDataIn);
        int fieldDataLength = StoredFieldHeader.readFieldDataLength(this.rawDataIn, fieldStatus, this.slotFieldSize);
        ByteHolder bh = fetchStream.getByteHolder();
        bh.write(this.rawDataIn, fieldDataLength);
        fetchStream.setByteHolder(bh);
        if (numberFields == 1) {
            fetchStream.setOverflowPage(-1L);
            fetchStream.setOverflowId(-1);
        } else {
            int firstFieldStatus = fieldStatus;
            fieldStatus = StoredFieldHeader.readStatus(this.rawDataIn);
            fieldDataLength = StoredFieldHeader.readFieldDataLength(this.rawDataIn, fieldStatus, this.slotFieldSize);
            if (!StoredFieldHeader.isOverflow(fieldStatus)) {
                SanityManager.ASSERT((boolean)StoredFieldHeader.isOverflow(firstFieldStatus));
            }
            long overflowPage = CompressedNumber.readLong(this.rawDataIn);
            int overflowId = CompressedNumber.readInt(this.rawDataIn);
            fetchStream.setOverflowPage(overflowPage);
            fetchStream.setOverflowId(overflowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logColumn(int slot, int fieldId, Object column, DynamicByteArrayOutputStream out, int overflowThreshold) throws StandardException, IOException {
        int bytesAvailable = this.freeSpace;
        int beginPosition = -1;
        bytesAvailable += this.getReservedCount(slot);
        this.rawDataIn.setPosition(this.getFieldOffset(slot, fieldId));
        int fieldStatus = StoredFieldHeader.readStatus(this.rawDataIn);
        int fieldDataLength = StoredFieldHeader.readFieldDataLength(this.rawDataIn, fieldStatus, this.slotFieldSize);
        bytesAvailable += StoredFieldHeader.size(fieldStatus, fieldDataLength, this.slotFieldSize) + fieldDataLength;
        try {
            this.setOutputStream(out);
            beginPosition = this.rawDataOut.getPosition();
            Object[] row = new Object[]{column};
            if (bytesAvailable == this.logColumn(row, 0, out, bytesAvailable, 0, overflowThreshold)) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
        }
        finally {
            this.rawDataOut.setPosition(beginPosition);
            this.resetOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int logLongColumn(int slot, int recordId, Object column, DynamicByteArrayOutputStream out) throws StandardException, IOException {
        int spaceAvailable = this.freeSpace;
        if ((spaceAvailable -= this.slotEntrySize) <= 0) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        this.setOutputStream(out);
        int beginPosition = out.getPosition();
        try {
            int numberFields = 1;
            StoredRecordHeader recordHeader = new StoredRecordHeader(recordId, numberFields);
            int recordHeaderLength = recordHeader.write(this.logicalDataOut);
            if ((spaceAvailable -= recordHeaderLength) < 0) {
                throw new NoSpaceOnPage(this.isOverflowPage());
            }
            Object[] row = new Object[]{column};
            int n = this.logColumn(row, 0, out, spaceAvailable, 2, 100);
            return n;
        }
        finally {
            this.resetOutputStream();
        }
    }

    private int logColumn(Object[] row, int arrayPosition, DynamicByteArrayOutputStream out, int spaceAvailable, int columnFlag, int overflowThreshold) throws StandardException, IOException {
        int headerLength;
        StreamStorable stream_storable_column;
        Object column;
        Object object = column = row != null ? row[arrayPosition] : null;
        if (column instanceof RawField) {
            byte[] data = ((RawField)column).getData();
            if (data.length <= spaceAvailable) {
                out.write(data);
                spaceAvailable -= data.length;
            }
            return spaceAvailable;
        }
        boolean longColumnDone = true;
        int fieldStatus = StoredFieldHeader.setFixed(StoredFieldHeader.setInitial(), true);
        int beginPosition = out.getPosition();
        int columnBeginPosition = 0;
        int fieldDataLength = 0;
        if (column instanceof StreamStorable && (stream_storable_column = (StreamStorable)column).returnStream() != null) {
            column = stream_storable_column.returnStream();
        }
        if (column == null && columnFlag != 3) {
            fieldStatus = StoredFieldHeader.setNonexistent(fieldStatus);
            headerLength = StoredFieldHeader.write(this.logicalDataOut, fieldStatus, fieldDataLength, this.slotFieldSize);
        } else if (column instanceof InputStream) {
            RememberBytesInputStream bufferedIn = null;
            int bufferLen = 0;
            int estimatedMaxDataSize = this.getMaxDataLength(spaceAvailable, overflowThreshold);
            if (column instanceof RememberBytesInputStream) {
                bufferedIn = (RememberBytesInputStream)column;
                bufferLen = bufferedIn.numBytesSaved();
            } else {
                bufferedIn = new RememberBytesInputStream((InputStream)column, new MemByteHolder(this.maxFieldSize + 1));
                if (row[arrayPosition] instanceof StreamStorable) {
                    ((StreamStorable)row[arrayPosition]).setStream(bufferedIn);
                }
                column = bufferedIn;
            }
            if (bufferLen < estimatedMaxDataSize + 1) {
                bufferLen = (int)((long)bufferLen + bufferedIn.fillBuf(estimatedMaxDataSize + 1 - bufferLen));
            }
            if (bufferLen <= estimatedMaxDataSize) {
                fieldDataLength = bufferLen;
                fieldStatus = StoredFieldHeader.setFixed(fieldStatus, true);
                headerLength = StoredFieldHeader.write(this.logicalDataOut, fieldStatus, fieldDataLength, this.slotFieldSize);
                bufferedIn.putBuf(this.logicalDataOut, fieldDataLength);
            } else if (columnFlag == 2) {
                longColumnDone = false;
                fieldDataLength = estimatedMaxDataSize - 12 - 2;
                fieldStatus = StoredFieldHeader.setFixed(fieldStatus, true);
                headerLength = StoredFieldHeader.write(this.logicalDataOut, fieldStatus, fieldDataLength, this.slotFieldSize);
                bufferedIn.putBuf(this.logicalDataOut, fieldDataLength);
                int remainingBytes = bufferedIn.available();
                int n = bufferedIn.shiftToFront();
            } else {
                int delta = this.maxFieldSize - bufferLen + 1;
                if (delta > 0) {
                    bufferLen = (int)((long)bufferLen + bufferedIn.fillBuf(delta));
                }
                fieldDataLength = bufferLen;
                column = bufferedIn;
            }
        } else if (columnFlag == 3) {
            fieldStatus = StoredFieldHeader.setNull(fieldStatus, true);
            headerLength = StoredFieldHeader.write(this.logicalDataOut, fieldStatus, fieldDataLength, this.slotFieldSize);
        } else if (column instanceof DataValueDescriptor) {
            boolean isNull;
            DataValueDescriptor sColumn = (DataValueDescriptor)column;
            boolean bl = isNull = columnFlag == 3 || sColumn.isNull();
            if (isNull) {
                fieldStatus = StoredFieldHeader.setNull(fieldStatus, true);
            }
            headerLength = StoredFieldHeader.write(this.logicalDataOut, fieldStatus, fieldDataLength, this.slotFieldSize);
            if (!isNull) {
                try {
                    columnBeginPosition = out.getPosition();
                    sColumn.writeExternal(this.logicalDataOut);
                }
                catch (IOException ioe) {
                    Exception ne;
                    if (this.logicalDataOut != null && (ne = this.logicalDataOut.getNestedException()) != null && ne instanceof StandardException) {
                        throw (StandardException)((Object)ne);
                    }
                    throw StandardException.newException((String)"XSDAJ.S", (Throwable)ioe, (Object[])new Object[0]);
                }
                fieldDataLength = out.getPosition() - beginPosition - headerLength;
            }
        } else if (column instanceof RecordHandle) {
            RecordHandle overflowHandle = (RecordHandle)column;
            fieldStatus = StoredFieldHeader.setOverflow(fieldStatus, true);
            headerLength = StoredFieldHeader.write(this.logicalDataOut, fieldStatus, fieldDataLength, this.slotFieldSize);
            fieldDataLength += CompressedNumber.writeLong(out, overflowHandle.getPageNumber());
            fieldDataLength += CompressedNumber.writeInt(out, overflowHandle.getId());
        } else {
            headerLength = StoredFieldHeader.write(this.logicalDataOut, fieldStatus, fieldDataLength, this.slotFieldSize);
            this.logicalDataOut.writeObject(column);
            fieldDataLength = out.getPosition() - beginPosition - headerLength;
        }
        fieldStatus = StoredFieldHeader.setFixed(fieldStatus, false);
        int fieldSizeOnPage = StoredFieldHeader.size(fieldStatus, fieldDataLength, this.slotFieldSize) + fieldDataLength;
        this.userRowSize += fieldDataLength;
        boolean fieldIsLong = this.isLong(fieldSizeOnPage, overflowThreshold);
        if ((spaceAvailable < fieldSizeOnPage || fieldIsLong) && columnFlag != 2) {
            if (fieldIsLong) {
                if (!(column instanceof InputStream)) {
                    ByteArray fieldData = new ByteArray(out.getByteArray(), columnBeginPosition, fieldDataLength);
                    ByteArrayInputStream columnIn = new ByteArrayInputStream(fieldData.getArray(), columnBeginPosition, fieldDataLength);
                    MemByteHolder byteHolder = new MemByteHolder(fieldDataLength + 1);
                    RememberBytesInputStream bufferedIn = new RememberBytesInputStream(columnIn, byteHolder);
                    column = bufferedIn;
                }
                out.setPosition(beginPosition);
                LongColumnException lce = new LongColumnException();
                lce.setColumn(column);
                throw lce;
            }
            out.setPosition(beginPosition);
            return spaceAvailable;
        }
        out.setPosition(beginPosition);
        fieldStatus = StoredFieldHeader.setFixed(fieldStatus, true);
        headerLength = StoredFieldHeader.write(out, fieldStatus, fieldDataLength, this.slotFieldSize);
        out.setPosition(beginPosition + fieldDataLength + headerLength);
        spaceAvailable -= fieldSizeOnPage;
        if (columnFlag == 2) {
            if (longColumnDone) {
                return -1;
            }
            return 1;
        }
        return spaceAvailable;
    }

    private int logOverflowRecord(int slot, int spaceAvailable, DynamicByteArrayOutputStream out) throws StandardException, IOException {
        int delta;
        this.setOutputStream(out);
        StoredRecordHeader pageRecordHeader = this.getHeaderAtSlot(slot);
        StoredRecordHeader overflow_rh = this.getOverFlowRecordHeader();
        overflow_rh.setOverflowFields(pageRecordHeader);
        SanityManager.ASSERT((overflow_rh.getOverflowPage() != 0L ? 1 : 0) != 0);
        int oldSize = pageRecordHeader.size();
        int newSize = overflow_rh.size();
        if (oldSize < newSize && spaceAvailable < (delta = newSize - oldSize)) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        overflow_rh.write(this.logicalDataOut);
        this.logRecordDataPortion(slot, 0, pageRecordHeader, null, this.logicalDataOut, null);
        return -1;
    }

    private int logOverflowField(DynamicByteArrayOutputStream out, int spaceAvailable, long overflowPage, int overflowId) throws StandardException, IOException {
        int fieldSizeOnPage;
        int fieldDataLength;
        int fieldStatus = StoredFieldHeader.setOverflow(StoredFieldHeader.setInitial(), true);
        if ((spaceAvailable -= (fieldSizeOnPage += StoredFieldHeader.size(fieldStatus, fieldDataLength = (fieldSizeOnPage = CompressedNumber.sizeLong(overflowPage) + CompressedNumber.sizeInt(overflowId)), this.slotFieldSize))) < 0) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        StoredFieldHeader.write(this.logicalDataOut, fieldStatus, fieldDataLength, this.slotFieldSize);
        CompressedNumber.writeLong(out, overflowPage);
        CompressedNumber.writeInt(out, overflowId);
        return spaceAvailable;
    }

    @Override
    public void logRecord(int slot, int flag, int recordId, FormatableBitSet validColumns, OutputStream out, RecordHandle headRowHandle) throws StandardException, IOException {
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        if (recordId != recordHeader.getId()) {
            StoredRecordHeader newRecordHeader = new StoredRecordHeader(recordHeader);
            newRecordHeader.setId(recordId);
            newRecordHeader.write(out);
            newRecordHeader = null;
        } else {
            recordHeader.write(out);
        }
        this.logRecordDataPortion(slot, flag, recordHeader, validColumns, out, headRowHandle);
    }

    private void logRecordDataPortion(int slot, int flag, StoredRecordHeader recordHeader, FormatableBitSet validColumns, OutputStream out, RecordHandle headRowHandle) throws StandardException, IOException {
        int offset = this.getRecordOffset(slot);
        int oldHeaderLength = recordHeader.size();
        offset += oldHeaderLength;
        int startField = recordHeader.getFirstField();
        int endField = startField + recordHeader.getNumberFields();
        int validColumnsSize = validColumns == null ? 0 : validColumns.getLength();
        for (int fieldId = startField; fieldId < endField; ++fieldId) {
            this.rawDataIn.setPosition(offset);
            int fieldStatus = StoredFieldHeader.readStatus(this.rawDataIn);
            int fieldDataLength = StoredFieldHeader.readFieldDataLength(this.rawDataIn, fieldStatus, this.slotFieldSize);
            if (validColumns != null && (validColumnsSize <= fieldId || !validColumns.isSet(fieldId)) || (flag & 2) != 0 && !StoredFieldHeader.isOverflow(fieldStatus)) {
                offset += StoredFieldHeader.size(fieldStatus, fieldDataLength, this.slotFieldSize);
                offset += fieldDataLength;
                fieldStatus = StoredFieldHeader.setInitial();
                fieldStatus = StoredFieldHeader.setNonexistent(fieldStatus);
                StoredFieldHeader.write(out, fieldStatus, 0, this.slotFieldSize);
                continue;
            }
            if ((flag & 1) != 0 && headRowHandle != null && StoredFieldHeader.isOverflow(fieldStatus) && !this.owner.isTemporaryContainer()) {
                int saveOffset = this.rawDataIn.getPosition();
                long overflowPage = CompressedNumber.readLong(this.rawDataIn);
                int overflowId = CompressedNumber.readInt(this.rawDataIn);
                StoredPage firstPageOnColumnChain = this.getOverflowPage(overflowPage);
                PageTimeStamp ts = firstPageOnColumnChain.currentTimeStamp();
                firstPageOnColumnChain.unlatch();
                RawTransaction rxact = this.owner.getTransaction();
                ReclaimSpace work = new ReclaimSpace(4, headRowHandle, fieldId, overflowPage, overflowId, ts, rxact.getDataFactory(), true);
                rxact.addPostCommitWork(work);
                this.rawDataIn.setPosition(saveOffset);
            }
            offset += StoredFieldHeader.write(out, fieldStatus, fieldDataLength, this.slotFieldSize);
            if (fieldDataLength == 0) continue;
            out.write(this.pageData, offset, fieldDataLength);
            offset += fieldDataLength;
        }
    }

    @Override
    public void logField(int slot, int fieldNumber, OutputStream out) throws StandardException, IOException {
        int offset = this.getFieldOffset(slot, fieldNumber);
        ArrayInputStream lrdi = this.rawDataIn;
        lrdi.setPosition(offset);
        int fieldStatus = StoredFieldHeader.readStatus(lrdi);
        int fieldDataLength = StoredFieldHeader.readFieldDataLength(lrdi, fieldStatus, this.slotFieldSize);
        StoredFieldHeader.write(out, fieldStatus, fieldDataLength, this.slotFieldSize);
        if (fieldDataLength != 0) {
            out.write(this.pageData, lrdi.getPosition(), fieldDataLength);
        }
    }

    @Override
    public RecordHandle insertAtSlot(int slot, Object[] row, FormatableBitSet validColumns, LogicalUndo undo, byte insertFlag, int overflowThreshold) throws StandardException {
        try {
            return super.insertAtSlot(slot, row, validColumns, undo, insertFlag, overflowThreshold);
        }
        catch (NoSpaceOnPage nsop) {
            return null;
        }
    }

    @Override
    public RecordHandle updateFieldAtSlot(int slot, int fieldId, Object newValue, LogicalUndo undo) throws StandardException {
        try {
            return super.updateFieldAtSlot(slot, fieldId, newValue, undo);
        }
        catch (NoSpaceOnPage nsop) {
            if (this.slotsInUse == 1) {
                throw StandardException.newException((String)"XSDA3.S", (Object[])new Object[0]);
            }
            throw StandardException.newException((String)"XSDA3.S", (Object[])new Object[0]);
        }
    }

    @Override
    public int fetchNumFieldsAtSlot(int slot) throws StandardException {
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        if (!recordHeader.hasOverflow()) {
            return super.fetchNumFieldsAtSlot(slot);
        }
        StoredPage overflowPage = this.getOverflowPage(recordHeader.getOverflowPage());
        int count = ((BasePage)overflowPage).fetchNumFieldsAtSlot(StoredPage.getOverflowSlot(overflowPage, recordHeader));
        ((BasePage)overflowPage).unlatch();
        return count;
    }

    @Override
    public int moveRecordForCompressAtSlot(int slot, Object[] row, RecordHandle[] old_handle, RecordHandle[] new_handle) throws StandardException {
        long src_pageno = this.getPageNumber();
        try {
            this.fetchFromSlot(null, slot, row, null, false);
            int row_size = this.getRecordPortionLength(slot);
            int record_id = this.getHeaderAtSlot(slot).getId();
            StoredPage dest_page = (StoredPage)this.owner.getPageForCompress(0, src_pageno);
            if (!(dest_page == null || dest_page.getPageNumber() < this.getPageNumber() && dest_page.spaceForCopy(row_size, record_id))) {
                dest_page.unlatch();
                dest_page = null;
            }
            if (!(dest_page != null || (dest_page = (StoredPage)this.owner.getPageForCompress(1, src_pageno)) == null || dest_page.getPageNumber() < this.getPageNumber() && dest_page.spaceForCopy(row_size, record_id))) {
                dest_page.unlatch();
                dest_page = null;
            }
            if (!(dest_page != null || (dest_page = (StoredPage)this.owner.addPage()).getPageNumber() < this.getPageNumber() && dest_page.spaceForCopy(row_size, record_id))) {
                this.owner.removePage(dest_page);
                dest_page = null;
            }
            if (dest_page != null) {
                int dest_slot = dest_page.recordCount();
                old_handle[0] = this.getRecordHandleAtSlot(slot);
                this.copyAndPurge(dest_page, slot, 1, dest_slot);
                new_handle[0] = dest_page.getRecordHandleAtSlot(dest_slot);
                dest_page.unlatch();
                return 1;
            }
            return 0;
        }
        catch (IOException ioe) {
            throw StandardException.newException((String)"XSDA4.S", (Throwable)ioe, (Object[])new Object[0]);
        }
    }

    public void logAction(LogInstant instant) throws StandardException {
        SanityManager.ASSERT((boolean)this.isLatched(), (String)"logAction() executed on an unlatched page.");
        if (this.rawDataOut == null) {
            this.createOutStreams();
        }
        if (!this.isActuallyDirty()) {
            this.initialRowCount = !this.isOverflowPage() && (this.getPageStatus() & 1) != 0 ? this.internalNonDeletedRecordCount() : 0;
        }
        this.setDirty();
        this.bumpPageVersion();
        this.updateLastLogInstant(instant);
    }

    private void cleanPage() {
        this.setDirty();
        this.clearSection(0, this.getPageSize());
        this.slotsInUse = 0;
        this.deletedRowCount = 0;
        this.headerOutOfDate = true;
        this.clearAllSpace();
    }

    @Override
    public void initPage(LogInstant instant, byte status, int recordId, boolean overflow, boolean reuse) throws StandardException {
        this.logAction(instant);
        if (reuse) {
            this.cleanPage();
            super.cleanPageForReuse();
        }
        this.headerOutOfDate = true;
        this.setPageStatus(status);
        this.isOverflowPage = overflow;
        this.nextId = recordId;
    }

    @Override
    public void setPageStatus(LogInstant instant, byte status) throws StandardException {
        this.logAction(instant);
        this.headerOutOfDate = true;
        this.setPageStatus(status);
    }

    @Override
    public void setReservedSpace(LogInstant instant, int slot, int value) throws StandardException, IOException {
        this.logAction(instant);
        this.headerOutOfDate = true;
        int delta = value - this.getReservedCount(slot);
        SanityManager.ASSERT((delta <= this.freeSpace ? 1 : 0) != 0, (String)"Cannot grow reserved space because there is not enough free space on the page");
        SanityManager.ASSERT((delta != 0 ? 1 : 0) != 0, (String)"Set Reserved Space called to set identical value");
        if (value < 0) {
            SanityManager.THROWASSERT((String)("Cannot set reserved space to value " + value));
        }
        int nextRecordOffset = this.getRecordOffset(slot) + this.getTotalSpace(slot);
        if (delta > 0) {
            this.expandPage(nextRecordOffset, delta);
        } else {
            this.shrinkPage(nextRecordOffset, -delta);
        }
        this.rawDataOut.setPosition(this.getSlotOffset(slot) + 2 * this.slotFieldSize);
        if (this.slotFieldSize == 2) {
            this.logicalDataOut.writeShort(value);
        } else {
            this.logicalDataOut.writeInt(value);
        }
    }

    @Override
    public void storeRecord(LogInstant instant, int slot, boolean insert, ObjectInput in) throws StandardException, IOException {
        this.logAction(instant);
        if (insert) {
            this.storeRecordForInsert(slot, in);
        } else {
            this.storeRecordForUpdate(slot, in);
        }
    }

    private void storeRecordForInsert(int slot, ObjectInput in) throws StandardException, IOException {
        int additional_space_needed;
        int recordOffset;
        StoredRecordHeader recordHeader = this.shiftUp(slot);
        if (recordHeader == null) {
            recordHeader = new StoredRecordHeader();
            this.setHeaderAtSlot(slot, recordHeader);
        }
        this.bumpRecordCount(1);
        recordHeader.read(in);
        if (recordHeader.isDeleted()) {
            ++this.deletedRowCount;
            this.headerOutOfDate = true;
        }
        if (this.nextId <= recordHeader.getId()) {
            this.nextId = recordHeader.getId() + 1;
        }
        int offset = recordOffset = this.firstFreeByte;
        int numberFields = recordHeader.getNumberFields();
        this.rawDataOut.setPosition(offset);
        offset += recordHeader.write(this.rawDataOut);
        int userData = 0;
        for (int i = 0; i < numberFields; ++i) {
            int newFieldStatus = StoredFieldHeader.readStatus(in);
            int newFieldDataLength = StoredFieldHeader.readFieldDataLength(in, newFieldStatus, this.slotFieldSize);
            newFieldStatus = StoredFieldHeader.setFixed(newFieldStatus, false);
            this.rawDataOut.setPosition(offset);
            offset += StoredFieldHeader.write(this.rawDataOut, newFieldStatus, newFieldDataLength, this.slotFieldSize);
            if (newFieldDataLength == 0) continue;
            in.readFully(this.pageData, offset, newFieldDataLength);
            offset += newFieldDataLength;
            userData += newFieldDataLength;
        }
        int dataWritten = offset - this.firstFreeByte;
        this.freeSpace -= dataWritten;
        this.firstFreeByte += dataWritten;
        int reservedSpace = 0;
        if (this.minimumRecordSize > 0 && userData < this.minimumRecordSize) {
            reservedSpace = this.minimumRecordSize - userData;
            this.freeSpace -= reservedSpace;
            this.firstFreeByte += reservedSpace;
        }
        if (this.isOverflowPage() && (additional_space_needed = 17 - (dataWritten + reservedSpace)) > 0) {
            this.freeSpace -= additional_space_needed;
            this.firstFreeByte += additional_space_needed;
            reservedSpace += additional_space_needed;
        }
        this.addSlotEntry(slot, recordOffset, dataWritten, reservedSpace);
        if (this.freeSpace < 0 || this.firstFreeByte > this.getSlotOffset(this.slotsInUse - 1) || this.firstFreeByte + this.freeSpace != this.getSlotOffset(this.slotsInUse - 1)) {
            SanityManager.THROWASSERT((String)(" inconsistency in space management during insert:  slot = " + slot + " getSlotOffset(slot) = " + this.getSlotOffset(slot) + " dataWritten = " + dataWritten + " freeSpace = " + this.freeSpace + " firstFreeByte = " + this.firstFreeByte + " page = " + this));
        }
        if (this.firstFreeByte > this.getSlotOffset(slot) || this.freeSpace < 0) {
            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Object[])new Object[]{this.getPageId()}));
        }
    }

    private void storeRecordForUpdate(int slot, ObjectInput in) throws StandardException, IOException {
        int reservedDelta;
        int startingOffset;
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        StoredRecordHeader newRecorderHeader = new StoredRecordHeader();
        newRecorderHeader.read(in);
        int oldFieldCount = recordHeader.getNumberFields();
        int newFieldCount = newRecorderHeader.getNumberFields();
        int startField = recordHeader.getFirstField();
        if (startField != newRecorderHeader.getFirstField()) {
            SanityManager.THROWASSERT((String)("First field changed from " + startField + " to " + newRecorderHeader.getFirstField()));
        }
        if (newFieldCount < oldFieldCount) {
            int oldDataStartingOffset = this.getFieldOffset(slot, startField + newFieldCount);
            int deleteLength = this.getRecordOffset(slot) + this.getRecordPortionLength(slot) - oldDataStartingOffset;
            this.updateRecordPortionLength(slot, -deleteLength, deleteLength);
        }
        int newOffset = startingOffset = this.getRecordOffset(slot);
        int oldOffset = startingOffset;
        int reservedSpaceFieldId = newFieldCount < oldFieldCount ? newFieldCount - 1 : oldFieldCount - 1;
        reservedSpaceFieldId += startField;
        DynamicByteArrayOutputStream newDataToWrite = null;
        this.rawDataOut.setPosition(newOffset);
        int oldLength = recordHeader.size();
        int newLength = newRecorderHeader.size();
        int unusedSpace = oldLength;
        if (reservedSpaceFieldId < startField) {
            unusedSpace += this.getReservedCount(slot);
        }
        if (unusedSpace >= newLength) {
            newRecorderHeader.write(this.rawDataOut);
            newOffset += newLength;
            unusedSpace -= newLength;
        } else {
            newDataToWrite = new DynamicByteArrayOutputStream(this.getPageSize());
            newRecorderHeader.write(newDataToWrite);
        }
        oldOffset += oldLength;
        int recordDelta = newLength - oldLength;
        int oldFieldStatus = 0;
        int oldFieldDataLength = 0;
        int newFieldStatus = 0;
        int newFieldDataLength = 0;
        int oldEndFieldExclusive = startField + oldFieldCount;
        int newEndFieldExclusive = startField + newFieldCount;
        for (int fieldId = startField; fieldId < newEndFieldExclusive; ++fieldId) {
            int oldFieldLength = 0;
            if (fieldId < oldEndFieldExclusive) {
                this.rawDataIn.setPosition(oldOffset);
                oldFieldStatus = StoredFieldHeader.readStatus(this.rawDataIn);
                oldFieldDataLength = StoredFieldHeader.readFieldDataLength(this.rawDataIn, oldFieldStatus, this.slotFieldSize);
                oldFieldLength = StoredFieldHeader.size(oldFieldStatus, oldFieldDataLength, this.slotFieldSize) + oldFieldDataLength;
            }
            newFieldStatus = StoredFieldHeader.readStatus(in);
            newFieldDataLength = StoredFieldHeader.readFieldDataLength(in, newFieldStatus, this.slotFieldSize);
            if (StoredFieldHeader.isNonexistent(newFieldStatus) && fieldId < oldEndFieldExclusive) {
                if (newDataToWrite == null || newDataToWrite.getUsed() == 0) {
                    if (newOffset == oldOffset) {
                        if (unusedSpace != 0) {
                            SanityManager.THROWASSERT((String)("Unused space is out of sync, expect 0 got " + unusedSpace));
                        }
                    } else {
                        if (unusedSpace != oldOffset - newOffset) {
                            SanityManager.THROWASSERT((String)("Unused space is out of sync expected " + (oldOffset - newOffset) + " got " + unusedSpace));
                        }
                        System.arraycopy(this.pageData, oldOffset, this.pageData, newOffset, oldFieldLength);
                    }
                    newOffset += oldFieldLength;
                    if (fieldId == reservedSpaceFieldId) {
                        unusedSpace += this.getReservedCount(slot);
                    }
                } else {
                    int position = newDataToWrite.getPosition();
                    newDataToWrite.setPosition(position + oldFieldLength);
                    System.arraycopy(this.pageData, oldOffset, newDataToWrite.getByteArray(), position, oldFieldLength);
                    unusedSpace += oldFieldLength;
                    if (fieldId == reservedSpaceFieldId) {
                        unusedSpace += this.getReservedCount(slot);
                    }
                    int copyLength = this.moveSavedDataToPage(newDataToWrite, unusedSpace, newOffset);
                    newOffset += copyLength;
                    unusedSpace -= copyLength;
                }
                oldOffset += oldFieldLength;
                continue;
            }
            newFieldStatus = StoredFieldHeader.setFixed(newFieldStatus, false);
            int newFieldHeaderLength = StoredFieldHeader.size(newFieldStatus, newFieldDataLength, this.slotFieldSize);
            int newFieldLength = newFieldHeaderLength + newFieldDataLength;
            recordDelta += newFieldLength - oldFieldLength;
            unusedSpace += oldFieldLength;
            oldOffset += oldFieldLength;
            if (fieldId == reservedSpaceFieldId) {
                unusedSpace += this.getReservedCount(slot);
            }
            if (newDataToWrite != null && newDataToWrite.getUsed() != 0) {
                int copyLength = this.moveSavedDataToPage(newDataToWrite, unusedSpace, newOffset);
                newOffset += copyLength;
                unusedSpace -= copyLength;
            }
            if ((newDataToWrite == null || newDataToWrite.getUsed() == 0) && unusedSpace >= newFieldHeaderLength) {
                int fieldCopy;
                this.rawDataOut.setPosition(newOffset);
                newOffset += StoredFieldHeader.write(this.rawDataOut, newFieldStatus, newFieldDataLength, this.slotFieldSize);
                unusedSpace -= newFieldHeaderLength;
                if (newFieldDataLength == 0) continue;
                int n = fieldCopy = unusedSpace >= newFieldDataLength ? newFieldDataLength : unusedSpace;
                if (fieldCopy != 0) {
                    in.readFully(this.pageData, newOffset, fieldCopy);
                    newOffset += fieldCopy;
                    unusedSpace -= fieldCopy;
                }
                if ((fieldCopy = newFieldDataLength - fieldCopy) == 0) continue;
                if (newDataToWrite == null) {
                    newDataToWrite = new DynamicByteArrayOutputStream(newFieldLength * 2);
                }
                int position = newDataToWrite.getPosition();
                newDataToWrite.setPosition(position + fieldCopy);
                in.readFully(newDataToWrite.getByteArray(), position, fieldCopy);
                continue;
            }
            if (newDataToWrite == null) {
                newDataToWrite = new DynamicByteArrayOutputStream(newFieldLength * 2);
            }
            StoredFieldHeader.write(newDataToWrite, newFieldStatus, newFieldDataLength, this.slotFieldSize);
            if (newFieldDataLength == 0) continue;
            int position = newDataToWrite.getPosition();
            newDataToWrite.setPosition(position + newFieldDataLength);
            in.readFully(newDataToWrite.getByteArray(), position, newFieldDataLength);
        }
        if (newDataToWrite != null && newDataToWrite.getUsed() != 0) {
            int nextRecordOffset = startingOffset + this.getTotalSpace(slot);
            int spaceRequiredFromFreeSpace = newDataToWrite.getUsed() - (nextRecordOffset - newOffset);
            if (newOffset > nextRecordOffset) {
                SanityManager.THROWASSERT((String)("data has overwritten next record - offset " + newOffset + " next record " + nextRecordOffset));
            }
            if (spaceRequiredFromFreeSpace <= 0 || spaceRequiredFromFreeSpace > this.freeSpace) {
                SanityManager.THROWASSERT((String)("invalid space required " + spaceRequiredFromFreeSpace + " newDataToWrite.getUsed() " + newDataToWrite.getUsed() + " nextRecordOffset " + nextRecordOffset + " newOffset " + newOffset + " reservedSpaceFieldId " + reservedSpaceFieldId + " startField " + startField + " newEndFieldExclusive " + newEndFieldExclusive + " newFieldCount " + newFieldCount + " oldFieldCount " + oldFieldCount + " slot " + slot + " freeSpace " + this.freeSpace + " unusedSpace " + unusedSpace + " page " + this.getPageId()));
            }
            if (this.getReservedCount(slot) + spaceRequiredFromFreeSpace != recordDelta) {
                SanityManager.THROWASSERT((String)("mismatch on count: reserved " + this.getReservedCount(slot) + "free space take " + spaceRequiredFromFreeSpace + "record delta " + recordDelta));
            }
            if (spaceRequiredFromFreeSpace > this.freeSpace) {
                throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDB0.D", (Object[])new Object[]{this.getPageId()}));
            }
            this.expandPage(nextRecordOffset, spaceRequiredFromFreeSpace);
            this.moveSavedDataToPage(newDataToWrite, unusedSpace += spaceRequiredFromFreeSpace, newOffset);
            reservedDelta = -1 * this.getReservedCount(slot);
            if (newDataToWrite.getUsed() != 0) {
                SanityManager.THROWASSERT((String)("data is left in save buffer ... " + newDataToWrite.getUsed()));
            }
        } else {
            reservedDelta = -1 * recordDelta;
        }
        this.updateRecordPortionLength(slot, recordDelta, reservedDelta);
        this.setHeaderAtSlot(slot, newRecorderHeader);
    }

    private int moveSavedDataToPage(DynamicByteArrayOutputStream savedData, int unusedSpace, int pageOffset) {
        if (unusedSpace > savedData.getUsed() / 2) {
            int copyLength = unusedSpace <= savedData.getUsed() ? unusedSpace : savedData.getUsed();
            System.arraycopy(savedData.getByteArray(), 0, this.pageData, pageOffset, copyLength);
            savedData.discardLeft(copyLength);
            return copyLength;
        }
        return 0;
    }

    private void createSpaceForUpdate(int slot, int offset, int oldLength, int newLength) throws StandardException, IOException {
        if (newLength <= oldLength) {
            int diffLength = oldLength - newLength;
            if (diffLength == 0) {
                return;
            }
            int remainingLength = this.shiftRemainingData(slot, offset, oldLength, newLength);
            this.clearSection(offset + newLength + remainingLength, diffLength);
            if (this.getRecordPortionLength(slot) - diffLength != offset - this.getRecordOffset(slot) + newLength + remainingLength) {
                SanityManager.THROWASSERT((String)(" Slot table trying to update record length " + (this.getRecordPortionLength(slot) - diffLength) + " that is not the same as what it actully is"));
            }
            this.updateRecordPortionLength(slot, -diffLength, diffLength);
            return;
        }
        int extraLength = newLength - oldLength;
        SanityManager.ASSERT((extraLength > 0 ? 1 : 0) != 0);
        int recordReservedSpace = this.getReservedCount(slot);
        int reservedDelta = 0;
        int spaceRequiredFromFreeSpace = extraLength - recordReservedSpace;
        if (spaceRequiredFromFreeSpace > this.freeSpace) {
            SanityManager.THROWASSERT((String)("spaceRequiredFromFreeSpace = " + spaceRequiredFromFreeSpace + ";freeSpace = " + this.freeSpace + ";newLength = " + newLength + ";oldLength = " + oldLength + ";\npage= " + this));
        }
        if (spaceRequiredFromFreeSpace > 0) {
            int nextRecordOffset = this.getRecordOffset(slot) + this.getTotalSpace(slot);
            this.expandPage(nextRecordOffset, spaceRequiredFromFreeSpace);
            reservedDelta = -recordReservedSpace;
        } else {
            reservedDelta = -extraLength;
        }
        int remainingLength = this.shiftRemainingData(slot, offset, oldLength, newLength);
        if (extraLength + reservedDelta < 0) {
            SanityManager.THROWASSERT((String)("total space the record occupies cannot shrink, extraLength = " + extraLength + " reservedDelta = " + reservedDelta + " spacerequired = " + spaceRequiredFromFreeSpace + " recordReservedSpace = " + recordReservedSpace));
        }
        this.updateRecordPortionLength(slot, extraLength, reservedDelta);
    }

    @Override
    public void storeField(LogInstant instant, int slot, int fieldNumber, ObjectInput in) throws StandardException, IOException {
        this.logAction(instant);
        int offset = this.getFieldOffset(slot, fieldNumber);
        ArrayInputStream lrdi = this.rawDataIn;
        lrdi.setPosition(offset);
        int oldFieldStatus = StoredFieldHeader.readStatus(lrdi);
        int oldFieldDataLength = StoredFieldHeader.readFieldDataLength(lrdi, oldFieldStatus, this.slotFieldSize);
        int newFieldStatus = StoredFieldHeader.readStatus(in);
        int newFieldDataLength = StoredFieldHeader.readFieldDataLength(in, newFieldStatus, this.slotFieldSize);
        newFieldStatus = StoredFieldHeader.setFixed(newFieldStatus, false);
        int oldFieldLength = StoredFieldHeader.size(oldFieldStatus, oldFieldDataLength, this.slotFieldSize) + oldFieldDataLength;
        int newFieldLength = StoredFieldHeader.size(newFieldStatus, newFieldDataLength, this.slotFieldSize) + newFieldDataLength;
        this.createSpaceForUpdate(slot, offset, oldFieldLength, newFieldLength);
        this.rawDataOut.setPosition(offset);
        offset += StoredFieldHeader.write(this.rawDataOut, newFieldStatus, newFieldDataLength, this.slotFieldSize);
        if (newFieldDataLength != 0) {
            in.readFully(this.pageData, offset, newFieldDataLength);
        }
    }

    @Override
    public void reserveSpaceForSlot(LogInstant instant, int slot, int spaceToReserve) throws StandardException, IOException {
        this.logAction(instant);
        int extraSpace = spaceToReserve - this.getReservedCount(slot);
        if (extraSpace <= 0) {
            return;
        }
        if (this.freeSpace < extraSpace) {
            throw new NoSpaceOnPage(this.isOverflowPage());
        }
        int startingOffset = this.getRecordOffset(slot);
        int nextRecordOffset = startingOffset + this.getTotalSpace(slot);
        this.expandPage(nextRecordOffset, extraSpace);
        this.setSlotEntry(slot, startingOffset, this.getRecordPortionLength(slot), spaceToReserve);
    }

    @Override
    public void skipField(ObjectInput in) throws IOException {
        int fieldStatus = StoredFieldHeader.readStatus(in);
        int fieldDataLength = StoredFieldHeader.readFieldDataLength(in, fieldStatus, this.slotFieldSize);
        if (fieldDataLength != 0) {
            DataInputUtil.skipFully(in, fieldDataLength);
        }
    }

    @Override
    public void skipRecord(ObjectInput in) throws IOException {
        StoredRecordHeader recordHeader = new StoredRecordHeader();
        recordHeader.read(in);
        for (int i = recordHeader.getNumberFields(); i > 0; --i) {
            this.skipField(in);
        }
    }

    private int shiftRemainingData(int slot, int offset, int oldLength, int newLength) throws IOException {
        int remainingLength = this.getRecordOffset(slot) + this.getRecordPortionLength(slot) - (offset + oldLength);
        if (remainingLength < 0 || this.getRecordPortionLength(slot) < oldLength) {
            SanityManager.THROWASSERT((String)("oldLength = " + oldLength + " newLength = " + newLength + "remainingLength = " + remainingLength + " offset = " + offset + " getRecordOffset(" + slot + ") = " + this.getRecordOffset(slot) + " getRecordPortionLength(" + slot + ") = " + this.getRecordPortionLength(slot)));
        }
        if (remainingLength != 0) {
            System.arraycopy(this.pageData, offset + oldLength, this.pageData, offset + newLength, remainingLength);
        }
        return remainingLength;
    }

    @Override
    public void setDeleteStatus(LogInstant instant, int slot, boolean delete) throws StandardException, IOException {
        this.logAction(instant);
        this.deletedRowCount += super.setDeleteStatus(slot, delete);
        this.headerOutOfDate = true;
        int offset = this.getRecordOffset(slot);
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        this.rawDataOut.setPosition(offset);
        recordHeader.write(this.logicalDataOut);
    }

    @Override
    protected int internalDeletedRecordCount() {
        return this.deletedRowCount;
    }

    @Override
    public void purgeRecord(LogInstant instant, int slot, int recordId) throws StandardException, IOException {
        this.logAction(instant);
        if (this.getHeaderAtSlot(slot).isDeleted()) {
            --this.deletedRowCount;
        }
        int startByte = this.getRecordOffset(slot);
        int endByte = startByte + this.getTotalSpace(slot) - 1;
        this.compressPage(startByte, endByte);
        this.removeSlotEntry(slot);
        this.removeAndShiftDown(slot);
    }

    private int getFieldOffset(int slot, int fieldNumber) throws IOException {
        int offset = this.getRecordOffset(slot);
        StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
        int startField = recordHeader.getFirstField();
        int numberFields = recordHeader.getNumberFields();
        if (fieldNumber < startField || fieldNumber >= startField + numberFields) {
            SanityManager.THROWASSERT((String)("fieldNumber: " + fieldNumber + " start field: " + startField + " number of fields " + numberFields));
        }
        ArrayInputStream lrdi = this.rawDataIn;
        lrdi.setPosition(offset + recordHeader.size());
        for (int i = startField; i < fieldNumber; ++i) {
            this.skipField(lrdi);
        }
        return this.rawDataIn.getPosition();
    }

    @Override
    public PageTimeStamp currentTimeStamp() {
        return new PageVersion(this.getPageNumber(), this.getPageVersion());
    }

    @Override
    public void setTimeStamp(PageTimeStamp ts) throws StandardException {
        if (ts == null) {
            throw StandardException.newException((String)"XSDAB.S", (Object[])new Object[0]);
        }
        if (!(ts instanceof PageVersion)) {
            throw StandardException.newException((String)"XSDAA.S", (Object[])new Object[]{ts});
        }
        PageVersion pv = (PageVersion)ts;
        pv.setPageNumber(this.getPageNumber());
        pv.setPageVersion(this.getPageVersion());
    }

    @Override
    public boolean equalTimeStamp(PageTimeStamp ts) throws StandardException {
        if (ts == null) {
            return false;
        }
        if (!(ts instanceof PageVersion)) {
            throw StandardException.newException((String)"XSDAA.S", (Object[])new Object[]{ts});
        }
        PageVersion pv = (PageVersion)ts;
        if (pv.getPageNumber() != this.getPageNumber()) {
            throw StandardException.newException((String)"XSDAA.S", (Object[])new Object[]{ts});
        }
        return pv.getPageVersion() == this.getPageVersion();
    }

    public String toString() {
        if (SanityManager.DEBUG_ON((String)"DeadlockTrace") || SanityManager.DEBUG_ON((String)"userLockStackTrace")) {
            return "page = " + this.getIdentity();
        }
        Object str = "---------------------------------------------------\n";
        str = (String)str + this.pageHeaderToString();
        for (int s = 0; s < this.slotsInUse; ++s) {
            str = (String)str + this.recordToString(s);
        }
        str = (String)str + "---------------------------------------------------\n";
        str = (String)str + StoredPage.pagedataToHexDump(this.pageData);
        str = (String)str + "---------------------------------------------------\n";
        return str;
    }

    public String toUncheckedString() {
        Object str = "---------------------------------------------------\n";
        str = (String)str + this.pageHeaderToString();
        str = (String)str + "---------------------------------------------------\n";
        str = (String)str + StoredPage.pagedataToHexDump(this.pageData);
        str = (String)str + "---------------------------------------------------\n";
        return str;
    }

    private static String pagedataToHexDump(byte[] data) {
        return StringUtil.hexDump(data);
    }

    private String pageHeaderToString() {
        return "page id: " + this.getIdentity() + " Overflow: " + this.isOverflowPage + " PageVersion: " + this.getPageVersion() + " SlotsInUse: " + this.slotsInUse + " DeletedRowCount: " + this.deletedRowCount + " PageStatus: " + this.getPageStatus() + " NextId: " + this.nextId + " firstFreeByte: " + this.firstFreeByte + " freeSpace: " + this.freeSpace + " totalSpace: " + this.totalSpace + " spareSpace: " + this.spareSpace + "% minimumRecordSize : " + this.minimumRecordSize + " PageSize: " + this.getPageSize() + "\n";
    }

    String getPageDumpString() {
        return MessageService.getTextMessage((String)"D016", (Object[])new Object[]{this.getIdentity(), this.isOverflowPage, this.getPageVersion(), this.slotsInUse, this.deletedRowCount, this.getPageStatus(), this.nextId, this.firstFreeByte, this.freeSpace, this.totalSpace, this.spareSpace, this.minimumRecordSize, this.getPageSize(), StoredPage.pagedataToHexDump(this.pageData)});
    }

    private String recordToString(int slot) {
        Object str = "";
        try {
            StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
            int offset = this.getRecordOffset(slot);
            int numberFields = recordHeader.getNumberFields();
            str = "\nslot " + slot + " offset " + offset + "  recordlen " + this.getTotalSpace(slot) + " (" + this.getRecordPortionLength(slot) + "," + this.getReservedCount(slot) + ")" + recordHeader.toString();
            this.rawDataIn.setPosition(offset += recordHeader.size());
            for (int i = 0; i < numberFields; ++i) {
                int fieldStatus = StoredFieldHeader.readStatus(this.rawDataIn);
                int fieldDataLength = StoredFieldHeader.readFieldDataLength(this.rawDataIn, fieldStatus, this.slotFieldSize);
                if (fieldDataLength < 0) {
                    str = (String)str + "\n\tField " + i + ": offset=" + offset + " null " + StoredFieldHeader.toDebugString(fieldStatus);
                    continue;
                }
                str = (String)str + "\n\tField " + i + ": offset=" + offset + " len=" + fieldDataLength + " " + StoredFieldHeader.toDebugString(fieldStatus);
                if (StoredFieldHeader.isOverflow(fieldStatus)) {
                    int overflowId;
                    long overflowPage;
                    if (i == 0 && fieldDataLength != 3) {
                        offset = this.rawDataIn.getPosition() + fieldDataLength;
                        overflowPage = CompressedNumber.readLong(this.rawDataIn);
                        overflowId = CompressedNumber.readInt(this.rawDataIn);
                        str = (String)str + "Questionable long column at (" + overflowPage + "," + overflowId + ")";
                        this.rawDataIn.setPosition(offset);
                        continue;
                    }
                    overflowPage = CompressedNumber.readLong(this.rawDataIn);
                    overflowId = CompressedNumber.readInt(this.rawDataIn);
                    str = (String)str + "long column at (" + overflowPage + "," + overflowId + ")";
                    continue;
                }
                offset = this.rawDataIn.getPosition() + fieldDataLength;
                this.rawDataIn.setPosition(offset);
            }
            str = (String)str + "\n";
        }
        catch (IOException ioe) {
            str = (String)str + "\n =======      ERROR IOException  =============\n";
            str = (String)str + ioe.toString();
        }
        catch (StandardException se) {
            str = (String)str + "\n =======      ERROR StandardException  =============\n";
            str = (String)str + se.toString();
        }
        return str;
    }

    protected StoredPage getOverflowPage(long pageNumber) throws StandardException {
        StoredPage overflowPage = (StoredPage)this.owner.getPage(pageNumber);
        if (overflowPage == null) {
            // empty if block
        }
        return overflowPage;
    }

    @Override
    protected BasePage getNewOverflowPage() throws StandardException {
        FileContainer myContainer = (FileContainer)this.containerCache.find(this.identity.getContainerId());
        try {
            BasePage basePage = (BasePage)myContainer.addPage(this.owner, true);
            return basePage;
        }
        finally {
            this.containerCache.release(myContainer);
        }
    }

    protected static int getOverflowSlot(BasePage overflowPage, StoredRecordHeader recordHeader) throws StandardException {
        int slot = overflowPage.findRecordById(recordHeader.getOverflowId(), 0);
        if (slot < 0) {
            throw StandardException.newException((String)"XSDA1.S", (Object[])new Object[0]);
        }
        return slot;
    }

    public BasePage getOverflowPageForInsert(int currentSlot, Object[] row, FormatableBitSet validColumns) throws StandardException {
        return this.getOverflowPageForInsert(currentSlot, row, validColumns, 0);
    }

    @Override
    public BasePage getOverflowPageForInsert(int currentSlot, Object[] row, FormatableBitSet validColumns, int startColumn) throws StandardException {
        long[] pageList = new long[5];
        int pageCount = 0;
        long currentOverflowPageNumber = 0L;
        block2: for (int slot = 0; slot < this.slotsInUse && pageCount < pageList.length; ++slot) {
            StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
            if (!recordHeader.hasOverflow()) continue;
            long overflowPageNumber = recordHeader.getOverflowPage();
            if (slot == currentSlot) {
                currentOverflowPageNumber = overflowPageNumber;
                continue;
            }
            for (int i = 0; i < pageCount; ++i) {
                if (pageList[i] == overflowPageNumber) continue block2;
            }
            pageList[pageCount++] = overflowPageNumber;
        }
        for (int i = 0; i < pageCount; ++i) {
            long pageNumber = pageList[i];
            if (pageNumber == currentOverflowPageNumber) continue;
            StoredPage overflowPage = null;
            int spaceNeeded = 0;
            try {
                overflowPage = this.getOverflowPage(pageNumber);
                if (overflowPage.spaceForInsert(row, validColumns, spaceNeeded, startColumn, 100)) {
                    return overflowPage;
                }
                spaceNeeded = overflowPage.getCurrentFreeSpace();
                overflowPage.unlatch();
                overflowPage = null;
                continue;
            }
            catch (StandardException se) {
                if (overflowPage == null) continue;
                overflowPage.unlatch();
                overflowPage = null;
            }
        }
        return this.getNewOverflowPage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateOverflowed(RawTransaction t, int slot, Object[] row, FormatableBitSet validColumns, StoredRecordHeader recordHeader) throws StandardException {
        StoredPage overflowPage = this.getOverflowPage(recordHeader.getOverflowPage());
        try {
            int overflowSlot = StoredPage.getOverflowSlot(overflowPage, recordHeader);
            ((BasePage)overflowPage).doUpdateAtSlot(t, overflowSlot, recordHeader.getOverflowId(), row, validColumns);
            ((BasePage)overflowPage).unlatch();
            overflowPage = null;
            return;
        }
        finally {
            if (overflowPage != null) {
                ((BasePage)overflowPage).unlatch();
                overflowPage = null;
            }
        }
    }

    @Override
    public void updateOverflowDetails(RecordHandle handle, RecordHandle overflowHandle) throws StandardException {
        long handlePageNumber = handle.getPageNumber();
        if (handlePageNumber == this.getPageNumber()) {
            this.updateOverflowDetails(this, handle, overflowHandle);
            return;
        }
        StoredPage handlePage = (StoredPage)this.owner.getPage(handlePageNumber);
        this.updateOverflowDetails(handlePage, handle, overflowHandle);
        handlePage.unlatch();
    }

    private void updateOverflowDetails(StoredPage handlePage, RecordHandle handle, RecordHandle overflowHandle) throws StandardException {
        handlePage.getOverFlowRecordHeader().setOverflowDetails(overflowHandle);
        int slot = handlePage.getSlotNumber(handle);
        handlePage.doUpdateAtSlot(this.owner.getTransaction(), slot, handle.getId(), null, null);
    }

    @Override
    public void updateFieldOverflowDetails(RecordHandle handle, RecordHandle overflowHandle) throws StandardException {
        Object[] row = new Object[2];
        row[1] = overflowHandle;
        FormatableBitSet validColumns = new FormatableBitSet(2);
        validColumns.set(1);
        int slot = this.getSlotNumber(handle);
        this.doUpdateAtSlot(this.owner.getTransaction(), slot, handle.getId(), row, validColumns);
    }

    @Override
    public int appendOverflowFieldHeader(DynamicByteArrayOutputStream logBuffer, RecordHandle overflowHandle) throws StandardException, IOException {
        int fieldStatus = StoredFieldHeader.setInitial();
        fieldStatus = StoredFieldHeader.setOverflow(fieldStatus, true);
        long overflowPage = overflowHandle.getPageNumber();
        int overflowId = overflowHandle.getId();
        int fieldDataLength = CompressedNumber.sizeLong(overflowPage) + CompressedNumber.sizeInt(overflowId);
        int lenWritten = StoredFieldHeader.write(logBuffer, fieldStatus, fieldDataLength, this.slotFieldSize);
        lenWritten += CompressedNumber.writeLong(logBuffer, overflowPage);
        return lenWritten += CompressedNumber.writeInt(logBuffer, overflowId);
    }

    protected int getSlotsInUse() {
        return this.slotsInUse;
    }

    private int getMaxDataLength(int spaceAvailable, int overflowThreshold) {
        if (overflowThreshold == 0) {
            SanityManager.THROWASSERT((String)"overflowThreshold cannot be 0");
        }
        int maxThresholdSpace = this.totalSpace * overflowThreshold / 100;
        int maxAvailable = 0;
        maxAvailable = spaceAvailable < 62 ? spaceAvailable - 2 : (spaceAvailable < 16380 ? spaceAvailable - 3 : spaceAvailable - 5);
        return maxAvailable > maxThresholdSpace ? maxThresholdSpace : maxAvailable;
    }

    private boolean isLong(int fieldSize, int overflowThreshold) {
        int maxThresholdSize;
        if (overflowThreshold == 0) {
            SanityManager.THROWASSERT((String)"overflowThreshold cannot be 0");
        }
        return fieldSize > (maxThresholdSize = this.maxFieldSize * overflowThreshold / 100);
    }

    @Override
    public void doUpdateAtSlot(RawTransaction t, int slot, int id, Object[] row, FormatableBitSet validColumns) throws StandardException {
        RecordHandle headRowHandle;
        RecordHandle recordHandle = headRowHandle = this.isOverflowPage() ? null : this.getRecordHandleAtSlot(slot);
        if (row == null) {
            this.owner.getActionSet().actionUpdate(t, this, slot, id, row, validColumns, -1, null, -1, headRowHandle);
            return;
        }
        int startColumn = RowUtil.nextColumn(row, validColumns, 0);
        if (startColumn == -1) {
            return;
        }
        if (!this.isOverflowPage() && validColumns != null && RowUtil.getNumberOfColumns(-1, validColumns) > row.length) {
            SanityManager.THROWASSERT((String)("updating slot " + slot + " on page " + this.getIdentity() + " " + RowUtil.getNumberOfColumns(-1, validColumns) + " bits are set in validColumns but only " + row.length + " columns in row[]"));
        }
        boolean rowHasReservedSpace = false;
        StoredPage curPage = this;
        while (true) {
            StoredRecordHeader rh = curPage.getHeaderAtSlot(slot);
            int startField = rh.getFirstField();
            int endFieldExclusive = startField + rh.getNumberFields();
            long nextPage = -1L;
            int realStartColumn = -1;
            int realSpaceOnPage = -1;
            if (!rh.hasOverflow() || startColumn >= startField && startColumn < endFieldExclusive) {
                int validColumnsSize;
                boolean hitLongColumn;
                int nextColumn = -1;
                Object[] savedFields = null;
                DynamicByteArrayOutputStream logBuffer = null;
                do {
                    try {
                        nextColumn = this.owner.getActionSet().actionUpdate(t, curPage, slot, id, row, validColumns, realStartColumn, logBuffer, realSpaceOnPage, headRowHandle);
                        hitLongColumn = false;
                    }
                    catch (LongColumnException lce) {
                        if (lce.getRealSpaceOnPage() == -1) {
                            logBuffer = lce.getLogBuffer();
                            savedFields = (Object[])lce.getColumn();
                            realStartColumn = lce.getNextColumn();
                            realSpaceOnPage = -1;
                            hitLongColumn = true;
                            continue;
                        }
                        logBuffer = new DynamicByteArrayOutputStream(lce.getLogBuffer());
                        RecordHandle longColumnHandle = this.insertLongColumn(curPage, lce, (byte)2);
                        int overflowFieldLen = 0;
                        try {
                        }
                        catch (IOException ioe) {
                            throw StandardException.newException((String)"XSDA4.S", (Throwable)ioe, (Object[])new Object[0]);
                        }
                        realStartColumn = lce.getNextColumn() + 1;
                        realSpaceOnPage = lce.getRealSpaceOnPage() - (overflowFieldLen += this.appendOverflowFieldHeader(logBuffer, longColumnHandle));
                        hitLongColumn = true;
                    }
                    catch (NoSpaceOnPage nsop) {
                        throw StandardException.newException((String)"XSDAP.S", (Throwable)((Object)nsop), (Object[])new Object[]{((PageKey)curPage.getIdentity()).toString(), this.getPageDumpString(), slot, id, validColumns.toString(), realStartColumn, 0, headRowHandle});
                    }
                } while (hitLongColumn);
                int n = validColumnsSize = validColumns == null ? 0 : validColumns.getLength();
                if (nextColumn != -1) {
                    RecordHandle portionHandle;
                    if (nextColumn < startField || rh.hasOverflow() && nextColumn >= endFieldExclusive) {
                        SanityManager.THROWASSERT((String)("nextColumn out of range = " + nextColumn + " expected between " + startField + " and " + endFieldExclusive));
                    }
                    int possibleLastFieldExclusive = endFieldExclusive;
                    if (!rh.hasOverflow()) {
                        if (validColumns == null) {
                            if (row.length > possibleLastFieldExclusive) {
                                possibleLastFieldExclusive = row.length;
                            }
                        } else if (validColumnsSize > possibleLastFieldExclusive) {
                            possibleLastFieldExclusive = validColumnsSize;
                        }
                    }
                    Object[] newRow = new Object[possibleLastFieldExclusive];
                    FormatableBitSet newColumnList = new FormatableBitSet(possibleLastFieldExclusive);
                    Object fieldStream = null;
                    for (int i = nextColumn; i < possibleLastFieldExclusive; ++i) {
                        if (validColumns == null || validColumnsSize > i && validColumns.isSet(i)) {
                            newColumnList.set(i);
                            newRow[i] = RowUtil.getColumn(row, validColumns, i);
                            continue;
                        }
                        if (i >= endFieldExclusive) continue;
                        newColumnList.set(i);
                        newRow[i] = savedFields[i - nextColumn];
                    }
                    RecordHandle handle = curPage.getRecordHandleAtSlot(slot);
                    if (rh.hasOverflow()) {
                        nextPage = rh.getOverflowPage();
                        id = rh.getOverflowId();
                        startColumn = RowUtil.nextColumn(row, validColumns, endFieldExclusive);
                    } else {
                        startColumn = -1;
                        nextPage = 0L;
                    }
                    if (!rowHasReservedSpace && headRowHandle != null && curPage != null && !this.owner.isTemporaryContainer()) {
                        rowHasReservedSpace = curPage.checkRowReservedSpace(slot);
                    }
                    BasePage op = curPage.getOverflowPageForInsert(slot, newRow, newColumnList, nextColumn);
                    if (curPage != this) {
                        curPage.unlatch();
                        curPage = null;
                    }
                    byte mode = 8;
                    if (nextPage != 0L) {
                        mode = (byte)(mode | 0x10);
                    }
                    RecordHandle nextPortionHandle = nextPage == 0L ? null : this.owner.makeRecordHandle(nextPage, id);
                    try {
                        portionHandle = op.insertAllowOverflow(0, newRow, newColumnList, nextColumn, mode, 100, nextPortionHandle);
                    }
                    catch (NoSpaceOnPage nsop) {
                        throw StandardException.newException((String)"XSDAP.S", (Throwable)((Object)nsop), (Object[])new Object[]{((PageKey)op.getIdentity()).toString(), this.getPageDumpString(), slot, id, newColumnList.toString(), nextColumn, mode, nextPortionHandle});
                    }
                    if (curPage == this) {
                        this.updateOverflowDetails(this, handle, portionHandle);
                    } else {
                        this.updateOverflowDetails(handle, portionHandle);
                    }
                    op.unlatch();
                } else {
                    if (!rowHasReservedSpace && headRowHandle != null && curPage != null && !this.owner.isTemporaryContainer()) {
                        rowHasReservedSpace = curPage.checkRowReservedSpace(slot);
                    }
                    int n2 = startColumn = rh.hasOverflow() ? RowUtil.nextColumn(row, validColumns, endFieldExclusive) : -1;
                }
                if (startColumn == -1) {
                    if (curPage == this || curPage == null) break;
                    curPage.unlatch();
                    break;
                }
            }
            if (nextPage == -1L) {
                SanityManager.ASSERT((curPage != null ? 1 : 0) != 0, (String)"Current page is null be no overflow information has been obtained");
                nextPage = rh.getOverflowPage();
                id = rh.getOverflowId();
            }
            if (curPage != this && curPage != null) {
                curPage.unlatch();
            }
            curPage = (StoredPage)this.owner.getPage(nextPage);
            SanityManager.ASSERT((boolean)curPage.isOverflowPage(), (String)"following row chain gets a non-overflow page");
            slot = curPage.findRecordById(id, 0);
        }
        if (rowHasReservedSpace) {
            RawTransaction rxact = this.owner.getTransaction();
            ReclaimSpace work = new ReclaimSpace(3, headRowHandle, rxact.getDataFactory(), true);
            rxact.addPostCommitWork(work);
        }
    }

    private boolean checkRowReservedSpace(int slot) throws StandardException {
        boolean rowHasReservedSpace = false;
        try {
            int shrinkage = this.getReservedCount(slot);
            int reclaimThreshold = 12;
            if (shrinkage > reclaimThreshold) {
                int totalSpace = this.getRecordPortionLength(slot) + shrinkage;
                if (this.isOverflowPage()) {
                    if (totalSpace > 17 + reclaimThreshold) {
                        rowHasReservedSpace = true;
                    }
                } else if (totalSpace > this.minimumRecordSize + reclaimThreshold) {
                    rowHasReservedSpace = true;
                }
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException((String)"XSDA4.S", (Throwable)ioe, (Object[])new Object[0]);
        }
        return rowHasReservedSpace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compactRecord(RawTransaction t, int slot, int id) throws StandardException {
        if (!this.isOverflowPage()) {
            StoredRecordHeader recordHeader = this.getHeaderAtSlot(slot);
            while (recordHeader.hasOverflow()) {
                StoredPage nextPageInRowChain = this.getOverflowPage(recordHeader.getOverflowPage());
                SanityManager.ASSERT((nextPageInRowChain != null ? 1 : 0) != 0);
                try {
                    int nextId = recordHeader.getOverflowId();
                    int nextSlot = StoredPage.getOverflowSlot(nextPageInRowChain, recordHeader);
                    nextPageInRowChain.compactRecord(t, nextSlot, nextId);
                    recordHeader = nextPageInRowChain.getHeaderAtSlot(nextSlot);
                }
                finally {
                    nextPageInRowChain.unlatch();
                }
            }
        }
        int reclaimThreshold = 12;
        try {
            int reserve = this.getReservedCount(slot);
            if (reserve > reclaimThreshold) {
                int recordLength = this.getRecordPortionLength(slot);
                int correctReservedSpace = reserve;
                int totalSpace = recordLength + reserve;
                if (this.isOverflowPage()) {
                    if (totalSpace > 17 + reclaimThreshold) {
                        correctReservedSpace = recordLength >= 17 ? 0 : 17 - recordLength;
                    }
                } else if (totalSpace > this.minimumRecordSize + reclaimThreshold) {
                    correctReservedSpace = recordLength >= this.minimumRecordSize ? 0 : this.minimumRecordSize - recordLength;
                }
                SanityManager.ASSERT((correctReservedSpace <= reserve ? 1 : 0) != 0, (String)"correct reserve > reserve");
                if (correctReservedSpace < reserve) {
                    this.owner.getActionSet().actionShrinkReservedSpace(t, this, slot, id, correctReservedSpace, reserve);
                }
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException((String)"XSDA4.S", (Throwable)ioe, (Object[])new Object[0]);
        }
    }
}

