/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.services.compiler.ClassBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

public abstract class GClass
implements ClassBuilder {
    protected ByteArray bytecode;
    protected final ClassFactory cf;
    protected final String qualifiedName;

    public GClass(ClassFactory cf, String qualifiedName) {
        this.cf = cf;
        this.qualifiedName = qualifiedName;
    }

    @Override
    public String getFullName() {
        return this.qualifiedName;
    }

    @Override
    public GeneratedClass getGeneratedClass() throws StandardException {
        return this.cf.loadGeneratedClass(this.qualifiedName, this.getClassBytecode());
    }

    protected void writeClassFile(String dir, boolean logMessage, Throwable t) throws StandardException {
        if (this.bytecode == null) {
            this.getClassBytecode();
        }
        if (dir == null) {
            dir = "";
        }
        Object filename = this.getName();
        filename = (String)filename + ".class";
        final File classFile = new File(dir, (String)filename);
        FileOutputStream fos = null;
        try {
            try {
                fos = AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                    @Override
                    public FileOutputStream run() throws FileNotFoundException {
                        return new FileOutputStream(classFile);
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw (FileNotFoundException)pae.getCause();
            }
            fos.write(this.bytecode.getArray(), this.bytecode.getOffset(), this.bytecode.getLength());
            fos.flush();
            if (logMessage) {
                HeaderPrintWriter errorStream = Monitor.getStream();
                errorStream.printlnWithHeader("Wrote class " + this.getFullName() + " to file " + classFile.toString() + ". Please provide support with the file and the following exception message: " + t);
            }
            fos.close();
        }
        catch (IOException e) {
            SanityManager.THROWASSERT((String)"Unable to write .class file", (Throwable)e);
        }
    }

    final void validateType(String typeName1) {
        SanityManager.ASSERT((typeName1 != null ? 1 : 0) != 0);
        String typeName = typeName1.trim();
        if ("void".equals(typeName)) {
            return;
        }
        while (typeName.endsWith("[]")) {
            typeName = typeName.substring(0, typeName.length() - 2);
        }
        SanityManager.ASSERT((typeName.length() > 0 ? 1 : 0) != 0);
        if ("boolean".equals(typeName)) {
            return;
        }
        if ("byte".equals(typeName)) {
            return;
        }
        if ("char".equals(typeName)) {
            return;
        }
        if ("double".equals(typeName)) {
            return;
        }
        if ("float".equals(typeName)) {
            return;
        }
        if ("int".equals(typeName)) {
            return;
        }
        if ("long".equals(typeName)) {
            return;
        }
        if ("short".equals(typeName)) {
            return;
        }
        try {
            if (this.cf == null) {
                Class.forName(typeName);
            } else {
                this.cf.loadApplicationClass(typeName);
            }
        }
        catch (ClassNotFoundException cnfe) {
            SanityManager.THROWASSERT((String)("Class " + typeName + " not found"), (Throwable)cnfe);
        }
    }
}

