/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.util.LimitOutputStream;

public class DechunkedOutputStream
extends LimitOutputStream {
    private final boolean _strip;
    private State _state = State.LEN;
    private int _remaining;
    private static final byte[] CRLF = DataHelper.getASCII("\r\n");

    public DechunkedOutputStream(OutputStream raw, LimitOutputStream.DoneCallback callback, boolean strip) {
        super(raw, callback);
        this._strip = strip;
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        if (len <= 0) {
            return;
        }
        block10: for (int i = 0; i < len; ++i) {
            switch (this._state) {
                case LEN: {
                    int c = buf[off + i] & 0xFF;
                    if (c >= 48 && c <= 57) {
                        if (this._remaining >= 0x8000000) {
                            throw new IOException("Chunk length too big");
                        }
                        this._remaining <<= 4;
                        this._remaining |= c - 48;
                    } else if (c >= 97 && c <= 102) {
                        if (this._remaining >= 0x800000) {
                            throw new IOException("Chunk length too big");
                        }
                        this._remaining <<= 4;
                        this._remaining |= 10 + c - 97;
                    } else if (c >= 65 && c <= 70) {
                        if (this._remaining >= 0x800000) {
                            throw new IOException("Chunk length too big");
                        }
                        this._remaining <<= 4;
                        this._remaining |= 10 + c - 65;
                    } else if (c == 59) {
                        this._state = State.CR;
                    } else if (c == 13) {
                        this._state = State.LF;
                    } else if (c == 10) {
                        this._state = this._remaining > 0 ? State.DATA : State.TRAILER;
                    } else {
                        throw new IOException("Unexpected length char 0x" + Integer.toHexString(c));
                    }
                    if (this._strip) continue block10;
                    this.out.write(buf, off + i, 1);
                    continue block10;
                }
                case CR: {
                    int c = buf[off + i] & 0xFF;
                    if (c == 13) {
                        this._state = State.LF;
                    } else if (c == 10) {
                        this._state = this._remaining > 0 ? State.DATA : State.TRAILER;
                    }
                    if (this._strip) continue block10;
                    this.out.write(buf, off + i, 1);
                    continue block10;
                }
                case LF: {
                    int c = buf[off + i] & 0xFF;
                    if (c == 10) {
                        this._state = this._remaining > 0 ? State.DATA : State.TRAILER;
                    } else {
                        throw new IOException("no LF after CR");
                    }
                    if (this._strip) continue block10;
                    this.out.write(buf, off + i, 1);
                    continue block10;
                }
                case DATA: {
                    int towrite = Math.min(this._remaining, len - i);
                    this.out.write(buf, off + i, towrite);
                    i += towrite - 1;
                    this._remaining -= towrite;
                    if (this._remaining > 0) continue block10;
                    this._state = State.DATACR;
                    continue block10;
                }
                case DATACR: {
                    int c = buf[off + i] & 0xFF;
                    if (c == 13) {
                        this._state = State.DATALF;
                    } else if (c == 10) {
                        this._state = State.LEN;
                    }
                    if (this._strip) continue block10;
                    this.out.write(buf, off + i, 1);
                    continue block10;
                }
                case DATALF: {
                    int c = buf[off + i] & 0xFF;
                    if (c == 10) {
                        this._state = State.LEN;
                    }
                    if (this._strip) continue block10;
                    this.out.write(buf, off + i, 1);
                    continue block10;
                }
                case TRAILER: {
                    int c = buf[off + i] & 0xFF;
                    if (c != 13) {
                        if (c == 10) {
                            if (this._remaining <= 0) {
                                if (!this._strip) {
                                    this.out.write(buf, off + i, 1);
                                }
                                this._state = State.DONE;
                                this.setDone();
                                return;
                            }
                            this._remaining = 0;
                        } else {
                            ++this._remaining;
                        }
                    }
                    if (this._strip) continue block10;
                    this.out.write(buf, off + i, 1);
                    continue block10;
                }
                case DONE: {
                    throw new EOFException(len - i + " extra bytes written after chunking done");
                }
            }
        }
    }

    private static enum State {
        LEN,
        CR,
        LF,
        DATA,
        DATACR,
        DATALF,
        TRAILER,
        DONE;

    }
}

