/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stats;

import org.parosproxy.paros.common.AbstractParam;

public class StatsParam
extends AbstractParam {
    private static final String STATS_BASE_KEY = "stats";
    private static final String IN_MEMORY_STATS_KEY = "stats.inmemory";
    private static final String STATSD_HOST_KEY = "stats.statsd.host";
    private static final String STATSD_PORT_KEY = "stats.statsd.port";
    private static final String STATSD_PREFIX_KEY = "stats.statsd.prefix";
    private static final int DEFAULT_STATSD_PORT = 8125;
    private static final String DEFAULT_STATSD_PREFIX = "zap";
    private boolean inMemory = true;
    private String statsdHost = "";
    private int statsdPort = 8125;
    private String statsdPrefix = "zap";

    public boolean isInMemoryEnabled() {
        return this.inMemory;
    }

    public void setInMemoryEnabled(boolean inMemory) {
        this.inMemory = inMemory;
        this.getConfig().setProperty(IN_MEMORY_STATS_KEY, inMemory);
    }

    public boolean isStatsdEnabled() {
        return this.statsdHost != null && this.statsdHost.length() > 0;
    }

    public String getStatsdHost() {
        return this.statsdHost;
    }

    public void setStatsdHost(String statsdHost) {
        this.statsdHost = statsdHost;
        this.getConfig().setProperty(STATSD_HOST_KEY, statsdHost);
    }

    public int getStatsdPort() {
        return this.statsdPort;
    }

    public void setStatsdPort(int statsdPort) {
        this.statsdPort = statsdPort;
        this.getConfig().setProperty(STATSD_PORT_KEY, statsdPort);
    }

    public String getStatsdPrefix() {
        return this.statsdPrefix;
    }

    public void setStatsdPrefix(String statsdPrefix) {
        this.statsdPrefix = statsdPrefix;
        this.getConfig().setProperty(STATSD_PREFIX_KEY, statsdPrefix);
    }

    @Override
    protected void parse() {
        this.inMemory = this.getBoolean(IN_MEMORY_STATS_KEY, true);
        this.statsdHost = this.getString(STATSD_HOST_KEY, "");
        this.statsdPort = this.getInt(STATSD_PORT_KEY, 8125);
        this.statsdPrefix = this.getString(STATSD_PREFIX_KEY, DEFAULT_STATSD_PREFIX);
    }
}

