/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.option;

import ch.csnc.extension.httpclient.SSLContextManager;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.SSLConnector;

public class OptionsParamCertificate
extends AbstractParam {
    private static final Logger logger = LogManager.getLogger(OptionsParamCertificate.class);
    private static final String CERTIFICATE_BASE_KEY = "certificate";
    private static final String USE_CLIENT_CERT = "certificate.use";
    private static final String PERSIST_CLIENT_CERT = "certificate.persist";
    private static final String CLIENT_CERT_LOCATION = "certificate.pkcs12.path";
    private static final String CLIENT_CERT_PASSWORD = "certificate.pkcs12.password";
    private static final String CLIENT_CERT_INDEX = "certificate.pkcs12.index";
    private static final String ALLOW_UNSAFE_SSL_RENEGOTIATION = "certificate.allowUnsafeSslRenegotiation";
    private boolean useClientCert = false;
    private String clientCertLocation = "";
    private String clientCertPassword = "";
    private int clientCertIndex = 0;
    private boolean allowUnsafeSslRenegotiation = false;

    @Override
    protected void parse() {
        this.clientCertCheck();
        this.saveClientCertSettings();
        this.allowUnsafeSslRenegotiation = this.getBoolean(ALLOW_UNSAFE_SSL_RENEGOTIATION, false);
        OptionsParamCertificate.setAllowUnsafeSslRenegotiationSystemProperty(this.allowUnsafeSslRenegotiation);
    }

    private void saveClientCertSettings() {
        if (this.getBoolean(PERSIST_CLIENT_CERT, false)) {
            logger.warn("Saving Client Certificate settings: password will be found in config");
            this.setUseClientCert(this.getBoolean(USE_CLIENT_CERT, false));
            this.setClientCertLocation(this.getString(CLIENT_CERT_LOCATION, ""));
            this.setClientCertPassword(this.getString(CLIENT_CERT_PASSWORD, ""));
            this.setClientCertIndex(this.getInt(CLIENT_CERT_INDEX, 0));
        } else {
            this.setUseClientCert(false);
            this.setClientCertLocation("");
            this.setClientCertPassword("");
            this.setClientCertIndex(0);
        }
    }

    private void clientCertCheck() {
        boolean enableClientCert = this.getBoolean(USE_CLIENT_CERT, false);
        String certPath = this.getString(CLIENT_CERT_LOCATION, "");
        String certPass = this.getString(CLIENT_CERT_PASSWORD, "");
        int certIndex = this.getInt(CLIENT_CERT_INDEX, 0);
        if (enableClientCert && !certPath.isEmpty() && !certPass.isEmpty()) {
            try {
                SSLContextManager contextManager = this.getSSLContextManager();
                int ksIndex = contextManager.loadPKCS12Certificate(certPath, certPass);
                contextManager.unlockKey(ksIndex, certIndex, certPass);
                contextManager.setDefaultKey(ksIndex, certIndex);
                this.setActiveCertificate();
                this.setEnableCertificate(true);
                logger.info("Client Certificate enabled from CLI");
                logger.info("Use -config certificate.persist=true to save settings");
            }
            catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException ex) {
                logger.error("The certificate could not be enabled due to an error", (Throwable)ex);
            }
        }
    }

    public String getClientCertPassword() {
        return this.clientCertPassword;
    }

    public void setClientCertPassword(String clientCertPassword) {
        this.clientCertPassword = clientCertPassword;
        this.getConfig().setProperty(CLIENT_CERT_PASSWORD, clientCertPassword);
    }

    public String getClientCertLocation() {
        return this.clientCertLocation;
    }

    public void setClientCertLocation(String clientCertLocation) {
        if (clientCertLocation != null && !clientCertLocation.equals("")) {
            File file = new File(clientCertLocation);
            if (!file.exists()) {
                this.setUseClientCert(false);
                return;
            }
        } else {
            this.setUseClientCert(false);
        }
        this.clientCertLocation = clientCertLocation;
        this.getConfig().setProperty(CLIENT_CERT_LOCATION, clientCertLocation);
    }

    public int getClientCertIndex() {
        return this.clientCertIndex;
    }

    public void setClientCertIndex(int clientCertIdx) {
        this.clientCertIndex = clientCertIdx;
        this.getConfig().setProperty(CLIENT_CERT_INDEX, Integer.toString(this.clientCertIndex));
    }

    public boolean isUseClientCert() {
        return this.useClientCert;
    }

    private void setUseClientCert(boolean isUse) {
        this.useClientCert = isUse;
        this.getConfig().setProperty(USE_CLIENT_CERT, Boolean.toString(this.useClientCert));
    }

    public void setEnableCertificate(boolean enabled) {
        ProtocolSocketFactory sslFactory = Protocol.getProtocol("https").getSocketFactory();
        if (sslFactory instanceof SSLConnector) {
            SSLConnector ssl = (SSLConnector)sslFactory;
            ssl.setEnableClientCert(enabled);
            this.setUseClientCert(enabled);
        }
    }

    public void setActiveCertificate() {
        ProtocolSocketFactory sslFactory = Protocol.getProtocol("https").getSocketFactory();
        if (sslFactory instanceof SSLConnector) {
            SSLConnector ssl = (SSLConnector)sslFactory;
            ssl.setActiveCertificate();
        }
    }

    public SSLContextManager getSSLContextManager() {
        ProtocolSocketFactory sslFactory = Protocol.getProtocol("https").getSocketFactory();
        if (sslFactory instanceof SSLConnector) {
            SSLConnector ssl = (SSLConnector)sslFactory;
            return ssl.getSSLContextManager();
        }
        return null;
    }

    public boolean isAllowUnsafeSslRenegotiation() {
        return this.allowUnsafeSslRenegotiation;
    }

    public void setAllowUnsafeSslRenegotiation(boolean allow) {
        if (this.allowUnsafeSslRenegotiation != allow) {
            this.allowUnsafeSslRenegotiation = allow;
            OptionsParamCertificate.setAllowUnsafeSslRenegotiationSystemProperty(this.allowUnsafeSslRenegotiation);
            this.getConfig().setProperty(ALLOW_UNSAFE_SSL_RENEGOTIATION, this.allowUnsafeSslRenegotiation);
        }
    }

    private static void setAllowUnsafeSslRenegotiationSystemProperty(boolean allow) {
        String ibmSystemPropertyValue;
        if (allow) {
            logger.info("Unsafe SSL renegotiation enabled.");
            ibmSystemPropertyValue = "ALL";
        } else {
            logger.info("Unsafe SSL renegotiation disabled.");
            ibmSystemPropertyValue = "NONE";
        }
        System.setProperty("com.ibm.jsse2.renegotiate", ibmSystemPropertyValue);
        System.setProperty("sun.security.ssl.allowUnsafeRenegotiation", String.valueOf(allow));
    }
}

