/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.internal;

import java.util.Dictionary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptEngineFactory;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyMarkerFilter;
import org.openhab.core.service.ReadyService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true)
public class ScriptEngineFactoryBundleTracker
extends BundleTracker<Bundle>
implements ReadyService.ReadyTracker {
    private static final int STATE_MASK = 63;
    public static final ReadyMarker READY_MARKER = new ReadyMarker("automation", "scriptEngineFactories");
    private final Logger logger = LoggerFactory.getLogger(ScriptEngineFactoryBundleTracker.class);
    private final ReadyService readyService;
    private final Map<String, Integer> bundles = new ConcurrentHashMap<String, Integer>();
    private boolean startLevel = false;
    private boolean ready = false;

    @Activate
    public ScriptEngineFactoryBundleTracker(@Reference ReadyService readyService, BundleContext bc) {
        super(bc, 63, null);
        this.readyService = readyService;
        this.open();
        readyService.registerTracker((ReadyService.ReadyTracker)this, new ReadyMarkerFilter().withType("startlevel").withIdentifier(Integer.toString(20)));
    }

    @Deactivate
    public void deactivate() throws Exception {
        this.close();
        this.ready = false;
    }

    private boolean allBundlesActive() {
        return this.bundles.values().stream().allMatch(i -> i == 32);
    }

    public Bundle addingBundle(@NonNullByDefault(value={}) Bundle bundle, @Nullable BundleEvent event) {
        String bsn = bundle.getSymbolicName();
        int state = bundle.getState();
        if (this.isScriptingBundle(bundle)) {
            this.logger.debug("Added {}: {} ", (Object)bsn, (Object)this.stateToString(state));
            this.bundles.put(bsn, state);
            this.checkReady();
        }
        return bundle;
    }

    public void modifiedBundle(@NonNullByDefault(value={}) Bundle bundle, @Nullable BundleEvent event, @NonNullByDefault(value={}) Bundle object) {
        String bsn = bundle.getSymbolicName();
        int state = bundle.getState();
        if (this.isScriptingBundle(bundle)) {
            this.logger.debug("Modified {}: {}", (Object)bsn, (Object)this.stateToString(state));
            this.bundles.put(bsn, state);
            this.checkReady();
        }
    }

    public void removedBundle(@NonNullByDefault(value={}) Bundle bundle, @Nullable BundleEvent event, @NonNullByDefault(value={}) Bundle object) {
        String bsn = bundle.getSymbolicName();
        if (this.isScriptingBundle(bundle)) {
            this.logger.debug("Removed {}", (Object)bsn);
            this.bundles.remove(bsn);
            this.checkReady();
        }
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        this.logger.debug("Readymarker {} added", (Object)readyMarker);
        this.startLevel = true;
        this.checkReady();
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        this.logger.debug("Readymarker {} removed", (Object)readyMarker);
        this.startLevel = false;
        this.ready = false;
        this.readyService.unmarkReady(READY_MARKER);
    }

    private synchronized void checkReady() {
        boolean allBundlesActive = this.allBundlesActive();
        this.logger.trace("ready: {}, startlevel: {}, allActive: {}", new Object[]{this.ready, this.startLevel, allBundlesActive});
        if (!this.ready && this.startLevel && allBundlesActive) {
            this.logger.debug("Adding ready marker: All automation bundles ready ({})", this.bundles);
            this.readyService.markReady(READY_MARKER);
            this.ready = true;
        } else if (this.ready && !allBundlesActive) {
            this.logger.debug("Removing ready marker: Not all automation bundles ready ({})", this.bundles);
            this.readyService.unmarkReady(READY_MARKER);
            this.ready = false;
        }
    }

    private String stateToString(int state) {
        return switch (state) {
            case 1 -> "UNINSTALLED";
            case 2 -> "INSTALLED";
            case 4 -> "RESOLVED";
            case 8 -> "STARTING";
            case 16 -> "STOPPING";
            case 32 -> "ACTIVE";
            default -> "UNKNOWN";
        };
    }

    private boolean isScriptingBundle(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String provideCapability = (String)headers.get("Provide-Capability");
        return provideCapability != null && provideCapability.contains(ScriptEngineFactory.class.getName());
    }
}

