/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.reportbuilder;

import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XHierarchicalNameContainer;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDispatch;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.report.XReportDefinition;
import com.sun.star.sdb.XSubDocument;
import com.sun.star.sdb.application.XDatabaseDocumentUI;
import com.sun.star.ucb.Command;
import com.sun.star.ucb.XCommandProcessor;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.URL;
import com.sun.star.util.XModeSelector;
import com.sun.star.util.XModifiable;
import com.sun.star.util.XURLTransformer;
import com.sun.star.wizards.common.FileAccess;
import com.sun.star.wizards.common.NamedValueCollection;
import com.sun.star.wizards.common.NoValidPathException;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.db.FieldColumn;
import com.sun.star.wizards.db.RecordParser;
import com.sun.star.wizards.report.IReportBuilderLayouter;
import com.sun.star.wizards.report.IReportDefinitionReadAccess;
import com.sun.star.wizards.report.IReportDocument;
import com.sun.star.wizards.report.ReportImplementationHelper;
import com.sun.star.wizards.report.ReportWizard;
import com.sun.star.wizards.reportbuilder.layout.ColumnarSingleColumn;
import com.sun.star.wizards.reportbuilder.layout.ColumnarThreeColumns;
import com.sun.star.wizards.reportbuilder.layout.ColumnarTwoColumns;
import com.sun.star.wizards.reportbuilder.layout.InBlocksLabelsAbove;
import com.sun.star.wizards.reportbuilder.layout.InBlocksLabelsLeft;
import com.sun.star.wizards.reportbuilder.layout.ReportBuilderLayouter;
import com.sun.star.wizards.reportbuilder.layout.Tabular;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReportBuilderImplementation
extends ReportImplementationHelper
implements IReportDocument,
IReportDefinitionReadAccess {
    private Resource m_resource;
    private XDatabaseDocumentUI m_documentUI;
    private static final int MAXIMUM_GROUPCOUNT = 4;
    private String[] groupNames = null;
    private XFrame m_xFrame = null;
    private String m_sReportBuilderLayoutName = PropertyNames.EMPTY_STRING;
    private Object m_aReportDocument;
    private XPropertySet m_documentDefinition;
    private XReportDefinition m_reportDocument;
    private ArrayList<String> m_aReportPath;
    private LinkedHashMap<String, IReportBuilderLayouter> m_aLayoutMap = null;
    private String m_sDefaultHeaderLayoutPath;

    private ReportBuilderImplementation(XMultiServiceFactory xMultiServiceFactory) {
        super(xMultiServiceFactory, 30);
    }

    public static IReportDocument create(XMultiServiceFactory xMultiServiceFactory) {
        return new ReportBuilderImplementation(xMultiServiceFactory);
    }

    @Override
    public void initialize(XDatabaseDocumentUI xDatabaseDocumentUI, Resource resource) {
        this.m_documentUI = xDatabaseDocumentUI;
        this.m_resource = resource;
    }

    @Override
    public void clearDocument() {
    }

    @Override
    public XWindowPeer getWizardParent() {
        return (XWindowPeer)UnoRuntime.queryInterface(XWindowPeer.class, (Object)this.getFrame().getComponentWindow());
    }

    private IReportBuilderLayouter getReportBuilderLayouter() {
        return this.getLayoutMap().get(this.m_sReportBuilderLayoutName);
    }

    private void initialize(Object object) {
        this.m_aReportDocument = object;
        try {
            NamedValueCollection namedValueCollection = new NamedValueCollection();
            namedValueCollection.put("DocumentServiceName", "com.sun.star.report.ReportDefinition");
            namedValueCollection.put("Mode", "remote");
            XComponent[] xComponentArray = new XComponent[]{null};
            XComponent xComponent = this.m_documentUI.createComponentWithArguments(3, namedValueCollection.getPropertyValues(), xComponentArray);
            this.m_documentDefinition = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xComponentArray[0]);
            this.m_reportDocument = (XReportDefinition)UnoRuntime.queryInterface(XReportDefinition.class, (Object)xComponent);
        }
        catch (com.sun.star.uno.Exception exception) {
            ReportWizard.getLogger().log(1000, "Problems with initialize the ReportDefinition" + exception.getMessage());
        }
        this.switchOffPropertyBrowser();
        this.switchOffAddFieldWindow();
        this.setPageOrientation(this.m_nDefaultPageOrientation, false);
    }

    private XModeSelector getModeSelector() {
        XController xController = this.getReportDefinition().getCurrentController();
        return (XModeSelector)UnoRuntime.queryInterface(XModeSelector.class, (Object)xController);
    }

    private void switchOffAddFieldWindow() {
        try {
            this.getModeSelector().setMode("remote");
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    private void switchOnAddFieldWindow() {
        try {
            this.getModeSelector().setMode("normal");
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    private void switchOffPropertyBrowser() {
        try {
            XController xController = this.getReportDefinition().getCurrentController();
            XDispatchProvider xDispatchProvider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xController);
            Object object = this.getMSF().createInstance("com.sun.star.util.URLTransformer");
            XURLTransformer xURLTransformer = (XURLTransformer)UnoRuntime.queryInterface(XURLTransformer.class, (Object)object);
            URL[] uRLArray = new URL[]{new URL()};
            uRLArray[0].Complete = ".uno:ControlProperties";
            xURLTransformer.parseStrict(uRLArray);
            XDispatch xDispatch = xDispatchProvider.queryDispatch(uRLArray[0], "_self", 0);
            PropertyValue[] propertyValueArray = new PropertyValue[]{};
            xDispatch.dispatch(uRLArray[0], propertyValueArray);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
    }

    private void switchOnPropertyBrowser() {
        this.switchOffPropertyBrowser();
    }

    @Override
    public XFrame getFrame() {
        if (this.m_xFrame == null) {
            this.initialize(this.getRecordParser().getReportDocuments());
            this.m_xFrame = this.getReportDefinition().getCurrentController().getFrame();
            this.setPageOrientation(this.m_nDefaultPageOrientation, true);
        }
        return this.m_xFrame;
    }

    @Override
    public boolean reconnectToDatabase(XMultiServiceFactory xMultiServiceFactory, PropertyValue[] propertyValueArray) {
        return false;
    }

    @Override
    public void insertDatabaseDatatoReportDocument(XMultiServiceFactory xMultiServiceFactory) {
    }

    @Override
    public void StopProcess() {
    }

    @Override
    public void store(String string, int n) throws com.sun.star.uno.Exception {
        if (n == 1) {
            return;
        }
        XCommandProcessor xCommandProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)this.m_documentDefinition);
        Command command = new Command();
        command.Name = "store";
        xCommandProcessor.execute(command, xCommandProcessor.createCommandIdentifier(), null);
        XHierarchicalNameContainer xHierarchicalNameContainer = (XHierarchicalNameContainer)UnoRuntime.queryInterface(XHierarchicalNameContainer.class, (Object)this.m_aReportDocument);
        xHierarchicalNameContainer.insertByHierarchicalName(string, (Object)this.m_documentDefinition);
    }

    @Override
    public boolean liveupdate_addGroupNametoDocument(String[] stringArray, String string, ArrayList<String> arrayList, ArrayList<String> arrayList2, int n) {
        int n2 = arrayList.size();
        if (n2 < 4) {
            FieldColumn fieldColumn = this.getRecordParser().getFieldColumnByTitle(string);
            arrayList.add(fieldColumn.getFieldName());
        }
        return true;
    }

    @Override
    public void refreshGroupFields(String[] stringArray) {
    }

    @Override
    public void liveupdate_removeGroupName(String[] stringArray, String string, ArrayList<String> arrayList) {
        FieldColumn fieldColumn = this.getRecordParser().getFieldColumnByTitle(string);
        arrayList.remove(fieldColumn.getFieldName());
    }

    private void setPageOrientation(int n, boolean bl) {
        this.getReportBuilderLayouter().setPageOrientation(n);
        if (bl) {
            this.getReportBuilderLayouter().layout();
        }
    }

    @Override
    public void setPageOrientation(int n) {
        this.setPageOrientation(n, true);
    }

    @Override
    public void liveupdate_changeLayoutTemplate(String string) {
        IReportBuilderLayouter iReportBuilderLayouter = this.getReportBuilderLayouter();
        iReportBuilderLayouter.loadAndSetBackgroundTemplate(string);
        iReportBuilderLayouter.layout();
    }

    public void setReportBuilderLayouterName(String string) {
        IReportBuilderLayouter iReportBuilderLayouter = this.getReportBuilderLayouter();
        IReportBuilderLayouter iReportBuilderLayouter2 = this.m_aLayoutMap.get(string);
        if (iReportBuilderLayouter2 != null) {
            this.m_sReportBuilderLayoutName = string;
            iReportBuilderLayouter2.initializeData(iReportBuilderLayouter);
            iReportBuilderLayouter2.layout();
        }
    }

    @Override
    public void liveupdate_changeContentTemplate(String string) {
        this.setReportBuilderLayouterName(string);
    }

    @Override
    public void layout_setupRecordSection(String string) {
    }

    @Override
    public void removeTextTableAndTextSection() {
    }

    @Override
    public void layout_selectFirstPage() {
    }

    private void closeReportDefinition() {
        try {
            if (this.m_documentDefinition != null) {
                XModifiable xModifiable = (XModifiable)UnoRuntime.queryInterface(XModifiable.class, (Object)this.m_reportDocument);
                xModifiable.setModified(false);
                XSubDocument xSubDocument = (XSubDocument)UnoRuntime.queryInterface(XSubDocument.class, (Object)this.m_documentDefinition);
                xSubDocument.close();
            }
        }
        catch (Exception exception) {
            Logger.getLogger(ReportBuilderImplementation.class.getName()).log(Level.SEVERE, null, exception);
        }
        this.m_documentDefinition = null;
        this.m_reportDocument = null;
    }

    @Override
    public void dispose() {
        this.getReportBuilderLayouter().dispose();
        this.closeReportDefinition();
    }

    @Override
    public XComponent getComponent() {
        return null;
    }

    @Override
    public void liveupdate_changeUserFieldContent(String string, String string2) {
    }

    @Override
    public void liveupdate_updateReportTitle(String string) {
    }

    @Override
    public void addReportToDBView() {
    }

    private XComponent loadReport(String string) {
        try {
            return this.m_documentUI.loadComponent(3, string, false);
        }
        catch (Exception exception) {
            Logger.getLogger(ReportBuilderImplementation.class.getName()).log(Level.SEVERE, null, exception);
            return null;
        }
    }

    private XComponent loadReportFromDocumentDefinition() {
        XCommandProcessor xCommandProcessor = (XCommandProcessor)UnoRuntime.queryInterface(XCommandProcessor.class, (Object)this.m_documentDefinition);
        Command command = new Command();
        command.Name = "open";
        try {
            Object object = xCommandProcessor.execute(command, xCommandProcessor.createCommandIdentifier(), null);
            return (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)object);
        }
        catch (Exception exception) {
            Logger.getLogger(ReportBuilderImplementation.class.getName()).log(Level.SEVERE, null, exception);
            return null;
        }
    }

    @Override
    public void createAndOpenReportDocument(String string, boolean bl, boolean bl2) {
        if (bl2) {
            this.switchOnAddFieldWindow();
            this.switchOnPropertyBrowser();
            return;
        }
        if (bl) {
            this.closeReportDefinition();
            this.loadReport(string);
        } else {
            XComponent xComponent = this.loadReportFromDocumentDefinition();
            this.closeReportDefinition();
            if (this.getRecordParser().storeDatabaseDocumentToTempPath(xComponent, string)) {
                this.getRecordParser().addReportDocument(xComponent, false);
            }
        }
        this.dispose();
    }

    @Override
    public void initializeFieldColumns(int n, String string, String[] stringArray) {
        this.getRecordParser().initializeFieldColumns(stringArray, string);
        RecordParser recordParser = this.getRecordParser();
        int[] nArray = new int[stringArray.length];
        int[] nArray2 = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = recordParser.FieldColumns[i].getFieldType();
            nArray2[i] = recordParser.FieldColumns[i].getFieldWidth();
        }
        this.getReportBuilderLayouter().setTableName(n, string);
        this.getReportBuilderLayouter().insertFieldNames(stringArray);
        this.getReportBuilderLayouter().insertFieldTypes(nArray);
        this.getReportBuilderLayouter().insertFieldWidths(nArray2);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public void setFieldTitles(String[] stringArray) {
        this.getRecordParser().setFieldTitles(stringArray);
        this.getReportBuilderLayouter().insertFieldTitles(stringArray);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public void setSorting(String[][] stringArray) {
        this.getRecordParser().setSortFieldNames(stringArray);
        if (this.groupNames != null) {
            this.getRecordParser().prependSortFieldNames(this.groupNames);
        }
        this.getReportBuilderLayouter().insertSortingNames(stringArray);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public void setGrouping(String[] stringArray) {
        this.groupNames = stringArray;
        this.getRecordParser().prependSortFieldNames(stringArray);
        this.getReportBuilderLayouter().insertGroupNames(stringArray);
        this.getReportBuilderLayouter().layout();
    }

    @Override
    public String getLayoutPath() {
        return "default";
    }

    @Override
    public ArrayList<String> getReportPath() {
        if (this.m_aReportPath == null) {
            this.m_aReportPath = FileAccess.getOfficePaths(this.getMSF(), "Template");
            FileAccess.combinePaths(this.getMSF(), this.m_aReportPath, "/wizard/report");
        }
        return this.m_aReportPath;
    }

    @Override
    public String getContentPath() {
        return PropertyNames.EMPTY_STRING;
    }

    @Override
    public int getDefaultPageOrientation() {
        return this.m_nDefaultPageOrientation;
    }

    private void insertIntoLayoutMap(IReportBuilderLayouter iReportBuilderLayouter) {
        this.insertIntoLayoutMap(iReportBuilderLayouter, false);
    }

    private void insertIntoLayoutMap(IReportBuilderLayouter iReportBuilderLayouter, boolean bl) {
        if (iReportBuilderLayouter != null) {
            String string = iReportBuilderLayouter.getName();
            if (bl) {
                this.m_sReportBuilderLayoutName = string;
            }
            this.m_aLayoutMap.put(string, iReportBuilderLayouter);
        }
    }

    private LinkedHashMap<String, IReportBuilderLayouter> getLayoutMap() {
        if (this.m_aLayoutMap == null) {
            this.m_aLayoutMap = new LinkedHashMap();
            ReportBuilderLayouter reportBuilderLayouter = new Tabular(this, this.m_resource);
            this.insertIntoLayoutMap(reportBuilderLayouter, true);
            reportBuilderLayouter = new ColumnarSingleColumn(this, this.m_resource);
            this.insertIntoLayoutMap(reportBuilderLayouter);
            reportBuilderLayouter = new ColumnarTwoColumns(this, this.m_resource);
            this.insertIntoLayoutMap(reportBuilderLayouter);
            reportBuilderLayouter = new ColumnarThreeColumns(this, this.m_resource);
            this.insertIntoLayoutMap(reportBuilderLayouter);
            reportBuilderLayouter = new InBlocksLabelsAbove(this, this.m_resource);
            this.insertIntoLayoutMap(reportBuilderLayouter);
            reportBuilderLayouter = new InBlocksLabelsLeft(this, this.m_resource);
            this.insertIntoLayoutMap(reportBuilderLayouter);
        }
        return this.m_aLayoutMap;
    }

    @Override
    public String[][] getDataLayout() {
        String[][] stringArray = new String[2][];
        String[] stringArray2 = new String[this.getLayoutMap().size()];
        String[] stringArray3 = new String[this.getLayoutMap().size()];
        Set<String> set = this.getLayoutMap().keySet();
        Iterator<String> iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string;
            stringArray2[n] = string = iterator.next();
            IReportBuilderLayouter iReportBuilderLayouter = this.m_aLayoutMap.get(string);
            stringArray3[n++] = iReportBuilderLayouter.getLocalizedName();
        }
        stringArray[1] = stringArray2;
        stringArray[0] = stringArray3;
        return stringArray;
    }

    @Override
    public String[][] getHeaderLayout() {
        String[][] stringArray;
        try {
            ArrayList<String> arrayList = FileAccess.getOfficePaths(this.getMSF(), "Template");
            FileAccess.combinePaths(this.getMSF(), arrayList, "/wizard/report");
            stringArray = FileAccess.getFolderTitles(this.getMSF(), null, arrayList, ".otr");
        }
        catch (NoValidPathException noValidPathException) {
            stringArray = new String[2][];
            String[] stringArray2 = new String[]{"DefaultLayoutOfHeaders"};
            String[] stringArray3 = new String[]{"default"};
            stringArray[1] = stringArray2;
            stringArray[0] = stringArray3;
        }
        for (int i = 0; i < stringArray[0].length; ++i) {
            if (!stringArray[0][i].equals("default")) continue;
            this.m_sDefaultHeaderLayoutPath = stringArray[1][i];
            break;
        }
        this.exchangeLayoutTitlesWithLocalisedOnes(stringArray);
        return stringArray;
    }

    private void exchangeLayoutTitlesWithLocalisedOnes(String[][] stringArray) {
        for (int i = 0; i < stringArray[0].length && stringArray[0][i] != null; ++i) {
            if (!stringArray[0][i].equals("default")) continue;
            stringArray[0][i] = this.m_resource.getResText("RID_REPORT_100");
        }
    }

    @Override
    public XReportDefinition getReportDefinition() {
        if (this.m_reportDocument == null) {
            throw new NullPointerException("Report Definition is not already initialized, check if you too early access the report definition.");
        }
        return this.m_reportDocument;
    }

    @Override
    public XMultiServiceFactory getGlobalMSF() {
        return this.getMSF();
    }

    @Override
    public void importReportData(ReportWizard reportWizard) {
    }

    @Override
    public String getDefaultHeaderLayout() {
        return this.m_sDefaultHeaderLayoutPath;
    }

    @Override
    public void setCommand(String string) {
        this.getRecordParser().Command = string;
        this.getReportDefinition().setCommand(string);
    }

    @Override
    public void setCommandType(int n) {
        this.getReportDefinition().setCommandType(n);
    }

    @Override
    public void checkInvariants() throws Exception {
        String string = this.getDefaultHeaderLayout();
        if (string == null) {
            throw new IOException("default.otr");
        }
        FileAccess fileAccess = new FileAccess(this.getGlobalMSF());
        if (!fileAccess.exists(string, true)) {
            throw new IOException("default.otr");
        }
    }
}

