/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.url;

import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.url.HostnameV2Provider;
import org.keycloak.urls.HostnameProvider;
import org.keycloak.urls.HostnameProviderFactory;

public class HostnameV2ProviderFactory
implements HostnameProviderFactory,
EnvironmentDependentProviderFactory {
    private static final String INVALID_HOSTNAME = "Provided hostname is neither a plain hostname nor a valid URL";
    private String hostname;
    private URI hostnameUrl;
    private URI adminUrl;
    private Boolean backchannelDynamic;

    public void init(Config.Scope config) {
        Boolean strictMode = config.getBoolean("hostname-strict", Boolean.valueOf(false));
        String hostnameRaw = config.get("hostname");
        if (strictMode.booleanValue() && hostnameRaw == null) {
            throw new IllegalArgumentException("hostname is not configured; either configure hostname, or set hostname-strict to false");
        }
        if (hostnameRaw == null || !strictMode.booleanValue()) {
            // empty if block
        }
        if (hostnameRaw != null) {
            if (!hostnameRaw.startsWith("http://") && !hostnameRaw.startsWith("https://")) {
                this.validateAndSetHostname(hostnameRaw);
            } else {
                this.hostnameUrl = this.validateAndCreateUri(hostnameRaw, INVALID_HOSTNAME);
            }
        }
        Optional.ofNullable(config.get("hostname-admin")).ifPresent(h -> {
            this.adminUrl = this.validateAndCreateUri((String)h, "Provided hostname-admin is not a valid URL");
        });
        this.backchannelDynamic = config.getBoolean("hostname-backchannel-dynamic", Boolean.valueOf(false));
        if (this.hostname == null && this.hostnameUrl == null && this.backchannelDynamic.booleanValue()) {
            throw new IllegalArgumentException("hostname-backchannel-dynamic must be set to false when no hostname is provided");
        }
        if (this.backchannelDynamic.booleanValue() && this.hostnameUrl == null) {
            throw new IllegalArgumentException("hostname-backchannel-dynamic must be set to false if hostname is not provided as full URL");
        }
    }

    private void validateAndSetHostname(String hostname) {
        URI result;
        try {
            result = URI.create("http://" + hostname);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(INVALID_HOSTNAME, e);
        }
        if (result.getHost() == null || !result.getHost().equals(hostname)) {
            throw new IllegalArgumentException(INVALID_HOSTNAME);
        }
        this.hostname = hostname;
    }

    private URI validateAndCreateUri(String uri, String validationFailedMessage) {
        URI result;
        try {
            result = URI.create(uri);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(validationFailedMessage, e);
        }
        if (!Arrays.asList("http", "https").contains(result.getScheme())) {
            throw new IllegalArgumentException(validationFailedMessage);
        }
        if (result.getRawUserInfo() != null || result.getRawQuery() != null || result.getRawFragment() != null) {
            throw new IllegalArgumentException(validationFailedMessage);
        }
        return result;
    }

    public HostnameProvider create(KeycloakSession session) {
        return new HostnameV2Provider(session, this.hostname, this.hostnameUrl, this.adminUrl, this.backchannelDynamic);
    }

    public String getId() {
        return "v2";
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.HOSTNAME_V2);
    }
}

