/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.UniAndGroupIterable;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.tuples.Functions;
import io.smallrye.mutiny.tuples.Tuple4;
import io.smallrye.mutiny.tuples.Tuples;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class UniAndGroup4<T1, T2, T3, T4>
extends UniAndGroupIterable<T1> {
    public UniAndGroup4(Uni<? extends T1> source, Uni<? extends T2> o1, Uni<? extends T3> o2, Uni<? extends T4> o3) {
        super(source, Arrays.asList(o1, o2, o3));
    }

    @CheckReturnValue
    public UniAndGroup4<T1, T2, T3, T4> collectFailures() {
        super.collectFailures();
        return this;
    }

    @CheckReturnValue
    public Uni<Tuple4<T1, T2, T3, T4>> asTuple() {
        return this.combine(Tuple4::of);
    }

    @Deprecated
    @CheckReturnValue
    public <O> Uni<O> combinedWith(Functions.Function4<T1, T2, T3, T4, O> combinator) {
        return this.with(combinator);
    }

    @CheckReturnValue
    public <O> Uni<O> with(Functions.Function4<T1, T2, T3, T4, O> combinator) {
        Functions.Function4<T1, T2, T3, T4, O> actual = Infrastructure.decorate(ParameterValidation.nonNull(combinator, "combinator"));
        return this.combine(actual);
    }

    private <O> Uni<O> combine(Functions.Function4<T1, T2, T3, T4, O> combinator) {
        Function<List, Object> function = list -> {
            Tuples.ensureArity(list, 4);
            Object item1 = list.get(0);
            Object item2 = list.get(1);
            Object item3 = list.get(2);
            Object item4 = list.get(3);
            return combinator.apply(item1, item2, item3, item4);
        };
        return super.with(function);
    }

    @CheckReturnValue
    public <O> Uni<O> withUni(Functions.Function4<T1, T2, T3, T4, Uni<O>> combinator) {
        Functions.Function4<T1, T2, T3, T4, Uni<O>> actual = Infrastructure.decorate(ParameterValidation.nonNull(combinator, "combinator"));
        return this.combineUni(actual);
    }

    private <O> Uni<O> combineUni(Functions.Function4<T1, T2, T3, T4, Uni<O>> combinator) {
        Function<List, Uni> function = list -> {
            Tuples.ensureArity(list, 4);
            Object item1 = list.get(0);
            Object item2 = list.get(1);
            Object item3 = list.get(2);
            Object item4 = list.get(3);
            return (Uni)combinator.apply(item1, item2, item3, item4);
        };
        return super.with(function).flatMap(Function.identity());
    }
}

