/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.GenericEntity;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import org.jboss.resteasy.reactive.common.NotImplementedYet;
import org.jboss.resteasy.reactive.common.core.AbstractResteasyReactiveContext;
import org.jboss.resteasy.reactive.common.util.Encode;
import org.jboss.resteasy.reactive.common.util.PathSegmentImpl;
import org.jboss.resteasy.reactive.server.core.CurrentRequestManager;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.LazyResponse;
import org.jboss.resteasy.reactive.server.core.UriMatch;
import org.jboss.resteasy.reactive.server.core.multipart.FormData;
import org.jboss.resteasy.reactive.server.core.serialization.EntityWriter;
import org.jboss.resteasy.reactive.server.injection.ResteasyReactiveInjectionContext;
import org.jboss.resteasy.reactive.server.jaxrs.AsyncResponseImpl;
import org.jboss.resteasy.reactive.server.jaxrs.ContainerRequestContextImpl;
import org.jboss.resteasy.reactive.server.jaxrs.ContainerResponseContextImpl;
import org.jboss.resteasy.reactive.server.jaxrs.HttpHeadersImpl;
import org.jboss.resteasy.reactive.server.jaxrs.ProvidersImpl;
import org.jboss.resteasy.reactive.server.jaxrs.RequestImpl;
import org.jboss.resteasy.reactive.server.jaxrs.SseEventSinkImpl;
import org.jboss.resteasy.reactive.server.jaxrs.UriInfoImpl;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.multipart.FormValue;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerHttpRequest;
import org.jboss.resteasy.reactive.server.spi.ServerHttpResponse;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.RestHandler;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public abstract class ResteasyReactiveRequestContext
extends AbstractResteasyReactiveContext<ResteasyReactiveRequestContext, ServerRestHandler>
implements Closeable,
ResteasyReactiveInjectionContext,
ServerRequestContext {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    protected final Deployment deployment;
    private Object[] parameters;
    private RuntimeResource target;
    private Object pathParamValues;
    private UriInfo uriInfo;
    private Object endpointInstance;
    private Object result;
    private LazyResponse response;
    private HttpHeadersImpl httpHeaders;
    private Object requestEntity;
    private Request request;
    private EntityWriter entityWriter;
    private ContainerRequestContextImpl containerRequestContext;
    private ContainerResponseContextImpl containerResponseContext;
    private String method;
    private String originalMethod;
    private String path;
    private String absoluteUri;
    private String scheme;
    private String authority;
    private String remaining;
    private EncodedMediaType responseContentType;
    private Annotation[] methodAnnotations;
    private Annotation[] additionalAnnotations;
    private Annotation[] allAnnotations;
    private Type genericReturnType;
    private InputStream inputStream;
    private List<UriMatch> matchedURIs;
    private ReaderInterceptor[] readerInterceptors;
    private WriterInterceptor[] writerInterceptors;
    private SecurityContext securityContext;
    private OutputStream outputStream;
    private OutputStream underlyingOutputStream;
    private FormData formData;
    private boolean producesChecked;
    private static final String ASYNC_RESPONSE_PROPERTY_KEY = "$RR$AsyncResponse";
    private static final String SSE_EVENT_SINK_PROPERTY_KEY = "$RR$SSEEventSink";
    private static final String PATH_SEGMENTS__PROPERTY_KEY = "$RR$PathSegments";

    public ResteasyReactiveRequestContext(Deployment deployment, ThreadSetupAction requestContext, ServerRestHandler[] handlerChain, ServerRestHandler[] abortHandlerChain) {
        super((RestHandler[])handlerChain, (RestHandler[])abortHandlerChain, requestContext);
        this.deployment = deployment;
        this.parameters = EMPTY_ARRAY;
    }

    public abstract ServerHttpRequest serverRequest();

    @Override
    public abstract ServerHttpResponse serverResponse();

    @Override
    public HttpHeaders getRequestHeaders() {
        return this.getHttpHeaders();
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public ProvidersImpl getProviders() {
        return new ProvidersImpl(this.deployment);
    }

    public void restart(RuntimeResource target) {
        this.restart(target, false);
    }

    public void restart(RuntimeResource target, boolean setLocatorTarget) {
        this.handlers = target.getHandlerChain();
        this.position = 0;
        Object[] objectArray = this.parameters = target.getParameterTypes().length == 0 ? EMPTY_ARRAY : new Object[target.getParameterTypes().length];
        if (setLocatorTarget) {
            this.setProperty("$RR$PreviousResource", new PreviousResource(this.target, this.pathParamValues, (PreviousResource)this.getProperty("$RR$PreviousResource")));
        }
        this.target = target;
    }

    @Override
    public void abortWith(Response response) {
        this.setResult(response);
        this.setAbortHandlerChainStarted(true);
        this.restart((ServerRestHandler[])this.getAbortHandlerChain());
        if (this.isSuspended()) {
            this.resume();
        }
    }

    public void resetBuildTimeSerialization() {
        this.entityWriter = this.deployment.getDynamicEntityWriter();
    }

    public UriInfo getUriInfo() {
        if (this.uriInfo == null) {
            this.uriInfo = new UriInfoImpl(this);
        }
        return this.uriInfo;
    }

    public HttpHeadersImpl getHttpHeaders() {
        if (this.httpHeaders == null) {
            this.httpHeaders = new HttpHeadersImpl(this.serverRequest().getAllRequestHeaders());
        }
        return this.httpHeaders;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setMaxPathParams(int maxPathParams) {
        this.pathParamValues = maxPathParams > 1 ? new String[maxPathParams] : null;
    }

    public String getPathParam(int index, boolean encoded) {
        return this.doGetPathParam(index, this.pathParamValues, encoded);
    }

    private String doGetPathParam(int index, Object pathParamValues, boolean encoded) {
        if (pathParamValues instanceof String[]) {
            String pathParam = ((String[])pathParamValues)[index];
            return encoded ? pathParam : Encode.decodePath((String)pathParam);
        }
        if (index > 1) {
            throw new IndexOutOfBoundsException();
        }
        String pathParam = (String)pathParamValues;
        return encoded ? pathParam : Encode.decodePath((String)pathParam);
    }

    public ResteasyReactiveRequestContext setPathParamValue(int index, String value) {
        if (this.pathParamValues instanceof String[]) {
            ((String[])this.pathParamValues)[index] = value;
        } else {
            if (index > 1) {
                throw new IndexOutOfBoundsException();
            }
            this.pathParamValues = value;
        }
        return this;
    }

    public void setUriInfo(UriInfo uriInfo) {
        this.uriInfo = uriInfo;
    }

    public Object getRequestEntity() {
        return this.requestEntity;
    }

    public ResteasyReactiveRequestContext setRequestEntity(Object requestEntity) {
        this.requestEntity = requestEntity;
        return this;
    }

    public EntityWriter getEntityWriter() {
        return this.entityWriter;
    }

    public ResteasyReactiveRequestContext setEntityWriter(EntityWriter entityWriter) {
        this.entityWriter = entityWriter;
        return this;
    }

    public Object getEndpointInstance() {
        return this.endpointInstance;
    }

    public ResteasyReactiveRequestContext setEndpointInstance(Object endpointInstance) {
        this.endpointInstance = endpointInstance;
        return this;
    }

    public Object getResult() {
        return this.result;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public Object getResponseEntity() {
        Object result = this.responseEntity();
        if (result instanceof GenericEntity) {
            return ((GenericEntity)result).getEntity();
        }
        return result;
    }

    private Object responseEntity() {
        if (this.response != null && this.response.isCreated()) {
            return this.response.get().getEntity();
        }
        return this.result;
    }

    public ResteasyReactiveRequestContext setResult(Object result) {
        this.result = result;
        if (result instanceof Response) {
            this.response = new LazyResponse.Existing((Response)result);
        } else if (result instanceof GenericEntity) {
            this.setGenericReturnType(((GenericEntity)result).getType());
        }
        return this;
    }

    public boolean handlesUnmappedException() {
        return true;
    }

    public void handleUnmappedException(Throwable throwable) {
        this.setResult(Response.serverError().build());
    }

    public RuntimeResource getTarget() {
        return this.target;
    }

    public void mapExceptionIfPresent() {
        if (this.throwable != null) {
            this.responseContentType = null;
            this.deployment.getExceptionMapper().mapException(this.throwable, this);
        }
    }

    private void sendInternalError(Throwable throwable) {
        log.error((Object)"Request failed", throwable);
        this.serverResponse().setStatusCode(500).end();
        this.close();
    }

    @Override
    public void close() {
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            log.debug((Object)"Failed to close stream", (Throwable)e);
        }
        try {
            if (this.underlyingOutputStream != null) {
                this.underlyingOutputStream.close();
            }
        }
        catch (IOException e) {
            log.debug((Object)"Failed to close stream", (Throwable)e);
        }
        super.close();
    }

    public LazyResponse getResponse() {
        return this.response;
    }

    public ResteasyReactiveRequestContext setResponse(LazyResponse response) {
        this.response = response;
        return this;
    }

    public Request getRequest() {
        if (this.request == null) {
            this.request = new RequestImpl(this);
        }
        return this.request;
    }

    public ContainerRequestContextImpl getContainerRequestContext() {
        if (this.containerRequestContext == null) {
            this.containerRequestContext = new ContainerRequestContextImpl(this);
        }
        return this.containerRequestContext;
    }

    public ContainerResponseContextImpl getContainerResponseContext() {
        if (this.containerResponseContext == null) {
            this.containerResponseContext = new ContainerResponseContextImpl(this);
        }
        return this.containerResponseContext;
    }

    public String getMethod() {
        if (this.method == null) {
            if (this.originalMethod != null) {
                return this.originalMethod;
            }
            this.originalMethod = this.serverRequest().getRequestMethod();
            return this.originalMethod;
        }
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setRemaining(String remaining) {
        this.remaining = remaining;
    }

    public String getRemaining() {
        return this.remaining;
    }

    public String getPathWithoutPrefix() {
        String prefix;
        String path = this.getPath();
        if (path != null && !(prefix = this.deployment.getPrefix()).isEmpty() && path.startsWith(prefix)) {
            if (path.length() == prefix.length()) {
                return "/";
            }
            return path.substring(prefix.length());
        }
        return path;
    }

    public String getPath() {
        if (this.path == null) {
            return this.serverRequest().getRequestNormalisedPath();
        }
        return this.path;
    }

    public String getAbsoluteURI() {
        if (this.path == null) {
            return this.serverRequest().getRequestAbsoluteUri();
        }
        if (this.absoluteUri == null) {
            try {
                this.absoluteUri = new URI(this.scheme, this.authority, this.path, null, null).toASCIIString();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return this.absoluteUri;
    }

    public String getScheme() {
        if (this.scheme == null) {
            return this.serverRequest().getRequestScheme();
        }
        return this.scheme;
    }

    public String getAuthority() {
        if (this.authority == null) {
            return this.serverRequest().getRequestHost();
        }
        return this.authority;
    }

    public ResteasyReactiveRequestContext setRequestUri(URI requestURI) {
        this.path = requestURI.getPath();
        this.authority = requestURI.getRawAuthority();
        this.scheme = requestURI.getScheme();
        this.setQueryParamsFrom(requestURI.toString());
        this.uriInfo = null;
        this.absoluteUri = null;
        return this;
    }

    protected void setQueryParamsFrom(String uri) {
        throw new NotImplementedYet();
    }

    @Override
    public EncodedMediaType getResponseContentType() {
        MediaType mediaType;
        if (this.response != null && this.response.isCreated() && (mediaType = this.response.get().getMediaType()) != null) {
            return new EncodedMediaType(mediaType);
        }
        return this.responseContentType;
    }

    @Override
    public MediaType getResponseMediaType() {
        EncodedMediaType resp = this.getResponseContentType();
        if (resp == null) {
            return null;
        }
        return resp.mediaType;
    }

    public ResteasyReactiveRequestContext setResponseContentType(EncodedMediaType responseContentType) {
        this.responseContentType = responseContentType;
        return this;
    }

    public ResteasyReactiveRequestContext setResponseContentType(MediaType responseContentType) {
        this.responseContentType = responseContentType == null ? null : new EncodedMediaType(responseContentType);
        return this;
    }

    public Annotation[] getAllAnnotations() {
        if (this.allAnnotations == null) {
            Annotation[] methodAnnotations = this.getMethodAnnotations();
            if (this.additionalAnnotations == null || this.additionalAnnotations.length == 0) {
                this.allAnnotations = methodAnnotations;
            } else {
                ArrayList<Annotation> list = new ArrayList<Annotation>(methodAnnotations.length + this.additionalAnnotations.length);
                list.addAll(Arrays.asList(methodAnnotations));
                list.addAll(Arrays.asList(this.additionalAnnotations));
                this.allAnnotations = list.toArray(new Annotation[0]);
            }
        }
        return this.allAnnotations;
    }

    public void setAllAnnotations(Annotation[] annotations) {
        this.allAnnotations = annotations;
    }

    public Annotation[] getMethodAnnotations() {
        if (this.methodAnnotations == null) {
            if (this.target == null) {
                return null;
            }
            return this.target.getLazyMethod().getAnnotations();
        }
        return this.methodAnnotations;
    }

    public ResteasyReactiveRequestContext setMethodAnnotations(Annotation[] methodAnnotations) {
        this.methodAnnotations = methodAnnotations;
        return this;
    }

    public Annotation[] getAdditionalAnnotations() {
        return this.additionalAnnotations;
    }

    public void setAdditionalAnnotations(Annotation[] additionalAnnotations) {
        this.additionalAnnotations = additionalAnnotations;
    }

    public boolean hasGenericReturnType() {
        return this.genericReturnType != null;
    }

    public Type getGenericReturnType() {
        if (this.genericReturnType == null) {
            if (this.target == null) {
                return null;
            }
            return this.target.getLazyMethod().getGenericReturnType();
        }
        return this.genericReturnType;
    }

    public ResteasyReactiveRequestContext setGenericReturnType(Type genericReturnType) {
        this.genericReturnType = genericReturnType;
        return this;
    }

    public AsyncResponseImpl getAsyncResponse() {
        return (AsyncResponseImpl)this.getProperty(ASYNC_RESPONSE_PROPERTY_KEY);
    }

    public ResteasyReactiveRequestContext setAsyncResponse(AsyncResponseImpl asyncResponse) {
        if (this.getAsyncResponse() != null) {
            throw new RuntimeException("Async can only be started once");
        }
        this.setProperty(ASYNC_RESPONSE_PROPERTY_KEY, asyncResponse);
        return this;
    }

    public ReaderInterceptor[] getReaderInterceptors() {
        return this.readerInterceptors;
    }

    public ResteasyReactiveRequestContext setReaderInterceptors(ReaderInterceptor[] readerInterceptors) {
        this.readerInterceptors = readerInterceptors;
        return this;
    }

    public WriterInterceptor[] getWriterInterceptors() {
        return this.writerInterceptors;
    }

    public ResteasyReactiveRequestContext setWriterInterceptors(WriterInterceptor[] writerInterceptors) {
        this.writerInterceptors = writerInterceptors;
        return this;
    }

    protected void handleUnrecoverableError(Throwable throwable) {
        log.error((Object)"Request failed", throwable);
        this.endResponse();
    }

    protected void endResponse() {
        if (this.serverResponse().headWritten()) {
            if (!this.serverResponse().closed()) {
                this.serverRequest().closeConnection();
            }
        } else {
            this.serverResponse().setStatusCode(500).end();
        }
        this.close();
    }

    protected void handleRequestScopeActivation() {
        CurrentRequestManager.set(this);
    }

    protected void requestScopeDeactivated() {
        CurrentRequestManager.set(null);
    }

    protected void restarted(boolean keepTarget) {
        this.parameters = EMPTY_ARRAY;
        if (!keepTarget) {
            this.target = null;
        }
    }

    public void saveUriMatchState() {
        String path;
        URITemplate classPath;
        if (this.matchedURIs == null) {
            this.matchedURIs = new LinkedList<UriMatch>();
        } else if (this.matchedURIs.get((int)0).resource == this.target) {
            return;
        }
        if (this.target != null && (classPath = this.target.getClassPath()) != null) {
            int pos = classPath.stem.length();
            String path2 = this.getPathWithoutPrefix();
            block0: for (int i = 1; i < classPath.components.length; ++i) {
                URITemplate.TemplateComponent segment = classPath.components[i];
                if (segment.type == URITemplate.Type.LITERAL) {
                    pos += segment.literalText.length();
                    continue;
                }
                if (segment.type == URITemplate.Type.DEFAULT_REGEX) {
                    while (pos < path2.length()) {
                        if (path2.charAt(pos) == '/') {
                            --pos;
                            continue block0;
                        }
                        ++pos;
                    }
                    continue;
                }
                Matcher matcher = segment.pattern.matcher(path2);
                if (!matcher.find(pos) || matcher.start() != pos) continue;
                pos = matcher.end();
            }
            this.matchedURIs.add(new UriMatch(path2.substring(1, pos), null, null));
        }
        if ((path = this.serverRequest().getRequestPath()).equals(this.remaining)) {
            this.matchedURIs.add(0, new UriMatch(path.substring(1), this.target, this.endpointInstance));
        } else {
            this.matchedURIs.add(0, new UriMatch(path.substring(1, path.length() - (this.remaining == null ? 0 : this.remaining.length())), this.target, this.endpointInstance));
        }
    }

    public List<UriMatch> getMatchedURIs() {
        this.saveUriMatchState();
        return this.matchedURIs;
    }

    public boolean hasInputStream() {
        return this.inputStream != null;
    }

    @Override
    public InputStream getInputStream() {
        if (this.inputStream == null) {
            this.inputStream = this.serverRequest().createInputStream();
        }
        return this.inputStream;
    }

    public ResteasyReactiveRequestContext setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        return this;
    }

    public SseEventSinkImpl getSseEventSink() {
        return (SseEventSinkImpl)this.getProperty(SSE_EVENT_SINK_PROPERTY_KEY);
    }

    public void setSseEventSink(SseEventSinkImpl sseEventSink) {
        this.setProperty(SSE_EVENT_SINK_PROPERTY_KEY, sseEventSink);
    }

    public List<PathSegment> getPathSegments() {
        if (this.getPathSegments0() == null) {
            this.initPathSegments();
        }
        return this.getPathSegments0();
    }

    private List<PathSegment> getPathSegments0() {
        return (List)this.getProperty(PATH_SEGMENTS__PROPERTY_KEY);
    }

    /*
     * WARNING - void declaration
     */
    public void initPathSegments() {
        void var7_9;
        if (this.getPathSegments0() != null) {
            return;
        }
        String path = this.getPath();
        String[] parts = path.split("/");
        ArrayList<PathSegmentImpl> pathSegments = new ArrayList<PathSegmentImpl>();
        this.setProperty(PATH_SEGMENTS__PROPERTY_KEY, pathSegments);
        boolean hasMatrix = false;
        String[] stringArray = parts;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String i = stringArray[var7_9];
            if (!i.isEmpty()) {
                PathSegmentImpl ps = new PathSegmentImpl(i, true);
                hasMatrix = ps.hasMatrixParams() || hasMatrix;
                pathSegments.add(ps);
            }
            ++var7_9;
        }
        if (hasMatrix) {
            String newPath;
            StringBuilder sb = new StringBuilder();
            for (PathSegment pathSegment : pathSegments) {
                sb.append("/");
                sb.append(pathSegment.getPath());
            }
            if (path.endsWith("/")) {
                sb.append("/");
            }
            this.path = newPath = sb.toString();
            if (this.remaining != null) {
                this.remaining = newPath.substring(this.getPathWithoutPrefix().length() - this.remaining.length());
            }
        }
    }

    public void setProducesChecked(boolean checked) {
        this.producesChecked = checked;
    }

    public boolean isProducesChecked() {
        return this.producesChecked;
    }

    @Override
    public Object getHeader(String name, boolean single) {
        if (this.httpHeaders == null) {
            if (single) {
                return this.serverRequest().getRequestHeader(name);
            }
            return this.serverRequest().getAllRequestHeaders(name);
        }
        if (single) {
            return this.httpHeaders.getMutableHeaders().getFirst((Object)name);
        }
        List list = (List)this.httpHeaders.getMutableHeaders().get((Object)name);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public Object getQueryParameter(String name, boolean single, boolean encoded) {
        return this.getQueryParameter(name, single, encoded, null);
    }

    @Override
    public Object getQueryParameter(String name, boolean single, boolean encoded, String separator) {
        if (single) {
            String val = this.serverRequest().getQueryParam(name);
            if (encoded && val != null) {
                val = Encode.encodeQueryParam((String)val);
            }
            return val;
        }
        List<String> strings = this.serverRequest().getAllQueryParams(name);
        if (encoded) {
            ArrayList<String> newStrings = new ArrayList<String>();
            for (String i : strings) {
                newStrings.add(Encode.encodeQueryParam((String)i));
            }
            strings = newStrings;
        }
        if (separator != null) {
            ArrayList<String> result = new ArrayList<String>(strings.size());
            for (int i = 0; i < strings.size(); ++i) {
                String[] parts = strings.get(i).split(separator);
                result.addAll(Arrays.asList(parts));
            }
            return result;
        }
        return strings;
    }

    @Override
    public Object getMatrixParameter(String name, boolean single, boolean encoded) {
        if (single) {
            for (PathSegment i : this.getPathSegments()) {
                String res = (String)i.getMatrixParameters().getFirst((Object)name);
                if (res == null) continue;
                if (encoded) {
                    return Encode.encodeQueryParam((String)res);
                }
                return res;
            }
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (PathSegment i : this.getPathSegments()) {
            List res = (List)i.getMatrixParameters().get((Object)name);
            if (res == null) continue;
            if (encoded) {
                for (String j : res) {
                    ret.add(Encode.encodeQueryParam((String)j));
                }
                continue;
            }
            ret.addAll(res);
        }
        return ret;
    }

    @Override
    public String getCookieParameter(String name) {
        Cookie cookie = this.getHttpHeaders().getCookies().get(name);
        return cookie != null ? cookie.getValue() : null;
    }

    @Override
    public Object getFormParameter(String name, boolean single, boolean encoded) {
        if (this.formData == null) {
            return null;
        }
        if (single) {
            FormValue val = this.formData.getFirst(name);
            if (val == null || val.isFileItem()) {
                return null;
            }
            if (encoded) {
                return Encode.encodeQueryParam((String)val.getValue());
            }
            return val.getValue();
        }
        Deque<FormValue> val = this.formData.get(name);
        ArrayList<String> strings = new ArrayList<String>();
        if (val != null) {
            for (FormValue i : val) {
                if (encoded) {
                    strings.add(Encode.encodeQueryParam((String)i.getValue()));
                    continue;
                }
                strings.add(i.getValue());
            }
        }
        return strings;
    }

    @Override
    public String getPathParameter(String name, boolean encoded) {
        Integer index = this.target.getPathParameterIndexes().get(name);
        if (index != null) {
            return this.getPathParam(index, encoded);
        }
        return this.getResourceLocatorPathParam(name, encoded);
    }

    @Override
    public <T> T unwrap(Class<T> type) {
        return this.serverRequest().unwrap(type);
    }

    public SecurityContext getSecurityContext() {
        if (this.securityContext == null) {
            this.securityContext = this.createSecurityContext();
        }
        return this.securityContext;
    }

    public boolean isSecurityContextSet() {
        return this.securityContext != null;
    }

    protected SecurityContext createSecurityContext() {
        throw new UnsupportedOperationException();
    }

    public ResteasyReactiveRequestContext setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        this.securityContextUpdated(securityContext);
        return this;
    }

    protected void securityContextUpdated(SecurityContext securityContext) {
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public OutputStream getOrCreateOutputStream() {
        if (this.outputStream == null) {
            this.outputStream = this.underlyingOutputStream = this.serverResponse().createResponseOutputStream();
            return this.underlyingOutputStream;
        }
        return this.outputStream;
    }

    @Override
    public ResteasyReactiveResourceInfo getResteasyReactiveResourceInfo() {
        return this.target == null ? null : this.target.getLazyMethod();
    }

    protected abstract Executor getEventLoop();

    public abstract Runnable registerTimer(long var1, Runnable var3);

    public String getResourceLocatorPathParam(String name, boolean encoded) {
        return this.getResourceLocatorPathParam(name, (PreviousResource)this.getProperty("$RR$PreviousResource"), encoded);
    }

    public FormData getFormData() {
        return this.formData;
    }

    public ResteasyReactiveRequestContext setFormData(FormData formData) {
        this.formData = formData;
        return this;
    }

    private String getResourceLocatorPathParam(String name, PreviousResource previousResource, boolean encoded) {
        if (previousResource == null) {
            return null;
        }
        int index = 0;
        URITemplate classPath = previousResource.locatorTarget.getClassPath();
        if (classPath != null) {
            for (URITemplate.TemplateComponent component : classPath.components) {
                if (component.name != null) {
                    if (component.name.equals(name)) {
                        return this.doGetPathParam(index, previousResource.locatorPathParamValues, encoded);
                    }
                    ++index;
                    continue;
                }
                if (component.names == null) continue;
                for (String nm : component.names) {
                    if (!nm.equals(name)) continue;
                    return this.doGetPathParam(index, previousResource.locatorPathParamValues, encoded);
                }
                ++index;
            }
        }
        for (URITemplate.TemplateComponent component : previousResource.locatorTarget.getPath().components) {
            if (component.name != null) {
                if (component.name.equals(name)) {
                    return this.doGetPathParam(index, previousResource.locatorPathParamValues, encoded);
                }
                ++index;
                continue;
            }
            if (component.names == null) continue;
            for (String nm : component.names) {
                if (!nm.equals(name)) continue;
                return this.doGetPathParam(index, previousResource.locatorPathParamValues, encoded);
            }
            ++index;
        }
        return this.getResourceLocatorPathParam(name, previousResource.prev, encoded);
    }

    public abstract boolean resumeExternalProcessing();

    static class PreviousResource {
        private static final String PROPERTY_KEY = "$RR$PreviousResource";
        private final RuntimeResource locatorTarget;
        private final Object locatorPathParamValues;
        private final PreviousResource prev;

        public PreviousResource(RuntimeResource locatorTarget, Object locatorPathParamValues, PreviousResource prev) {
            this.locatorTarget = locatorTarget;
            this.locatorPathParamValues = locatorPathParamValues;
            this.prev = prev;
        }
    }
}

