/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import io.quarkus.bootstrap.runner.QuarkusEntryPoint;
import io.quarkus.bootstrap.runner.RunnerClassLoader;
import io.quarkus.runtime.configuration.ProfileManager;
import io.smallrye.config.ConfigValue;
import java.util.List;
import java.util.Optional;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.cli.command.AbstractCommand;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.configuration.ConfigArgsConfigSource;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import picocli.CommandLine;

@CommandLine.Command(name="build", header={"Creates a new and optimized server image."}, description={"%nCreates a new and optimized server image based on the configuration options passed to this command. Once created, the configuration will be persisted and read during startup without having to pass them over again.", "", "Consider running this command before running the server in production for an optimal runtime."}, footerHeading="Examples:", footer={"  Change the database vendor:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --db=postgres%n%n  Enable a feature:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --features=<feature_name>%n%n  Or alternatively, enable all tech preview features:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --features=preview%n%n  Enable health endpoints:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --health-enabled=true%n%n  Enable metrics endpoints:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --metrics-enabled=true%n%n  Change the relative path:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} --http-relative-path=/auth%n"})
public final class Build
extends AbstractCommand
implements Runnable {
    public static final String NAME = "build";
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;

    @Override
    public void run() {
        this.exitWithErrorIfDevProfileIsSetAndNotStartDev();
        System.setProperty("quarkus.launch.rebuild", "true");
        this.validateConfig();
        Picocli.println(this.spec.commandLine(), "Updating the configuration and installing your custom providers, if any. Please wait.");
        try {
            Build.configureBuildClassLoader();
            this.beforeReaugmentationOnWindows();
            QuarkusEntryPoint.main((String[])new String[0]);
            if (!Environment.isDevProfile()) {
                Picocli.println(this.spec.commandLine(), "Server configuration updated and persisted. Run the following command to review the configuration:\n");
                Picocli.println(this.spec.commandLine(), "\t" + Environment.getCommand() + " show-config\n");
            }
        }
        catch (Throwable throwable) {
            this.executionError(this.spec.commandLine(), "Failed to update server configuration.", throwable);
        }
        finally {
            this.cleanTempResources();
        }
    }

    private static void configureBuildClassLoader() {
        Optional.ofNullable(Configuration.getCurrentBuiltTimeProperty("quarkus.class-loading.removed-artifacts")).map(ConfigValue::getValue).ifPresent(s -> System.setProperty("quarkus.class-loading.removed-artifacts", s));
    }

    @Override
    public boolean includeBuildTime() {
        return true;
    }

    @Override
    public List<OptionCategory> getOptionCategories() {
        return super.getOptionCategories();
    }

    private void exitWithErrorIfDevProfileIsSetAndNotStartDev() {
        if (Environment.isDevProfile() && !ConfigArgsConfigSource.getAllCliArgs().contains("start-dev")) {
            this.executionError(this.spec.commandLine(), Messages.devProfileNotAllowedError(NAME));
        }
    }

    private void beforeReaugmentationOnWindows() {
        ClassLoader classLoader;
        if (Environment.isWindows() && (classLoader = Thread.currentThread().getContextClassLoader()) instanceof RunnerClassLoader) {
            ((RunnerClassLoader)classLoader).resetInternalCaches();
        }
    }

    private void cleanTempResources() {
        if (!ProfileManager.getLaunchMode().isDevOrTest()) {
            Environment.getHomePath().resolve("quarkus-artifact.properties").toFile().delete();
        }
    }

    @Override
    public String getName() {
        return NAME;
    }
}

