/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.List;
import java.util.stream.Collectors;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.command.AbstractStartCommand;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.cli.command.OptimizedMixin;
import picocli.CommandLine;

public abstract class AbstractExportImportCommand
extends AbstractStartCommand
implements Runnable {
    private final String action;
    @CommandLine.Mixin
    OptimizedMixin optimizedMixin;
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;

    protected AbstractExportImportCommand(String action) {
        this.action = action;
    }

    @Override
    public void run() {
        System.setProperty("keycloak.migration.action", this.action);
        Environment.setProfile("import_export");
        super.run();
    }

    @Override
    public List<OptionCategory> getOptionCategories() {
        return super.getOptionCategories().stream().filter(optionCategory -> optionCategory != OptionCategory.HTTP && optionCategory != OptionCategory.PROXY && optionCategory != OptionCategory.HOSTNAME_V1 && optionCategory != OptionCategory.HOSTNAME_V2 && optionCategory != OptionCategory.METRICS && optionCategory != OptionCategory.SECURITY && optionCategory != OptionCategory.CACHE && optionCategory != OptionCategory.HEALTH).collect(Collectors.toList());
    }

    @Override
    public boolean includeRuntime() {
        return true;
    }
}

