/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.customized;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.Arc;
import jakarta.json.bind.Jsonb;
import java.lang.annotation.Annotation;
import org.hibernate.type.format.FormatMapper;
import org.hibernate.type.format.jackson.JacksonJsonFormatMapper;
import org.hibernate.type.format.jakartajson.JsonBJsonFormatMapper;
import org.hibernate.type.format.jaxb.JaxbXmlFormatMapper;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FormatMapperKind {
    JACKSON{

        @Override
        public FormatMapper create() {
            return new JacksonJsonFormatMapper((ObjectMapper)Arc.container().instance(ObjectMapper.class, new Annotation[0]).get());
        }
    }
    ,
    JSONB{

        @Override
        public FormatMapper create() {
            return new JsonBJsonFormatMapper((Jsonb)Arc.container().instance(Jsonb.class, new Annotation[0]).get());
        }
    }
    ,
    JAXB{

        @Override
        public FormatMapper create() {
            return new JaxbXmlFormatMapper();
        }
    };


    public abstract FormatMapper create();
}

