/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import io.micrometer.core.instrument.util.TimeUtils;
import io.prometheus.client.exemplars.Exemplar;
import io.prometheus.client.exemplars.HistogramExemplarSampler;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;

class PrometheusHistogram
extends TimeWindowFixedBoundaryHistogram {
    @Nullable
    private final double[] buckets;
    @Nullable
    private final AtomicReferenceArray<Exemplar> exemplars;
    @Nullable
    private final AtomicReference<Exemplar> lastExemplar;
    @Nullable
    private final HistogramExemplarSampler exemplarSampler;

    PrometheusHistogram(Clock clock, DistributionStatisticConfig config, @Nullable HistogramExemplarSampler exemplarSampler) {
        super(clock, DistributionStatisticConfig.builder().expiry(Duration.ofDays(1825L)).bufferLength(Integer.valueOf(1)).build().merge(config), true);
        this.exemplarSampler = exemplarSampler;
        if (this.isExemplarsEnabled()) {
            double[] originalBuckets = this.getBuckets();
            if (originalBuckets[originalBuckets.length - 1] != Double.POSITIVE_INFINITY) {
                this.buckets = Arrays.copyOf(originalBuckets, originalBuckets.length + 1);
                this.buckets[this.buckets.length - 1] = Double.POSITIVE_INFINITY;
            } else {
                this.buckets = originalBuckets;
            }
            this.exemplars = new AtomicReferenceArray(this.buckets.length);
            this.lastExemplar = new AtomicReference();
        } else {
            this.buckets = null;
            this.exemplars = null;
            this.lastExemplar = null;
        }
    }

    boolean isExemplarsEnabled() {
        return this.exemplarSampler != null;
    }

    public void recordDouble(double value) {
        super.recordDouble(value);
        if (this.isExemplarsEnabled()) {
            this.updateExemplar(value, null, null);
        }
    }

    public void recordLong(long value) {
        super.recordLong(value);
        if (this.isExemplarsEnabled()) {
            this.updateExemplar(value, TimeUnit.NANOSECONDS, TimeUnit.SECONDS);
        }
    }

    private void updateExemplar(double value, @Nullable TimeUnit sourceUnit, @Nullable TimeUnit destinationUnit) {
        int index = this.leastLessThanOrEqualTo(value);
        index = index == -1 ? this.exemplars.length() - 1 : index;
        this.updateExemplar(value, sourceUnit, destinationUnit, index);
    }

    private void updateExemplar(double value, @Nullable TimeUnit sourceUnit, @Nullable TimeUnit destinationUnit, int index) {
        Exemplar previousLastExemplar;
        Exemplar previusBucketExemplar;
        Exemplar nextExemplar;
        double bucketFrom = index == 0 ? Double.NEGATIVE_INFINITY : this.buckets[index - 1];
        double bucketTo = this.buckets[index];
        double exemplarValue = sourceUnit != null && destinationUnit != null ? TimeUtils.convert((double)value, (TimeUnit)sourceUnit, (TimeUnit)destinationUnit) : value;
        do {
            previusBucketExemplar = this.exemplars.get(index);
            previousLastExemplar = this.lastExemplar.get();
        } while ((nextExemplar = this.exemplarSampler.sample(exemplarValue, bucketFrom, bucketTo, previusBucketExemplar)) != null && nextExemplar != previusBucketExemplar && (!this.exemplars.compareAndSet(index, previusBucketExemplar, nextExemplar) || !this.lastExemplar.compareAndSet(previousLastExemplar, nextExemplar)));
    }

    @Nullable
    Exemplar[] exemplars() {
        if (this.isExemplarsEnabled()) {
            Exemplar[] exemplarsArray = new Exemplar[this.exemplars.length()];
            for (int i = 0; i < this.exemplars.length(); ++i) {
                exemplarsArray[i] = this.exemplars.get(i);
            }
            return exemplarsArray;
        }
        return null;
    }

    @Nullable
    Exemplar lastExemplar() {
        return this.lastExemplar.get();
    }

    private int leastLessThanOrEqualTo(double key) {
        int low = 0;
        int high = this.buckets.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (this.buckets[mid] < key) {
                low = mid + 1;
                continue;
            }
            if (this.buckets[mid] > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low < this.buckets.length ? low : -1;
    }
}

